/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.opengl.shader;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL43C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.opengl.shader.ShaderException;
import rs117.hd.opengl.shader.Template;
import rs117.hd.utils.Props;
import rs117.hd.utils.ResourcePath;

public class Shader {
    private static final Logger log = LoggerFactory.getLogger(Shader.class);
    @VisibleForTesting
    final List<Unit> units = new ArrayList<Unit>();

    public Shader add(int type, String name) {
        this.units.add(new Unit(type, name));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(Template template) throws ShaderException, IOException {
        int program;
        block12: {
            program = GL43C.glCreateProgram();
            int[] shaders = new int[this.units.size()];
            int i = 0;
            boolean ok = false;
            try {
                while (i < shaders.length) {
                    Unit unit = this.units.get(i);
                    int shader = GL43C.glCreateShader((int)unit.type);
                    if (shader == 0) {
                        throw new ShaderException("Unable to create shader of type " + unit.type);
                    }
                    String source = template.load(unit.filename);
                    GL43C.glShaderSource((int)shader, (CharSequence)source);
                    GL43C.glCompileShader((int)shader);
                    if (GL43C.glGetShaderi((int)shader, (int)35713) != 1) {
                        String err = GL43C.glGetShaderInfoLog((int)shader);
                        GL43C.glDeleteShader((int)shader);
                        throw ShaderException.compileError(err, template, unit);
                    }
                    GL43C.glAttachShader((int)program, (int)shader);
                    shaders[i++] = shader;
                }
                GL43C.glLinkProgram((int)program);
                if (GL43C.glGetProgrami((int)program, (int)35714) == 0) {
                    String err = GL43C.glGetProgramInfoLog((int)program);
                    throw ShaderException.compileError(err, template, this.units.toArray(new Unit[0]));
                }
                ok = true;
                if (!Props.has("rlhd.dump-shaders")) break block12;
                int[] numFormats = new int[]{0};
                GL43C.glGetIntegerv((int)34814, (int[])numFormats);
                if (numFormats[0] < 1) {
                    log.error("OpenGL driver does not support any binary formats");
                    break block12;
                }
                int[] size = new int[]{0};
                GL43C.glGetProgramiv((int)program, (int)34625, (int[])size);
                int[] format = new int[]{0};
                ByteBuffer binary = BufferUtils.createByteBuffer((int)size[0]);
                GL43C.glGetProgramBinary((int)program, (int[])size, (int[])format, (ByteBuffer)binary);
                try {
                    String shaderName = this.units.stream().map(Unit::getFilename).collect(Collectors.joining(" + ")) + ".bin";
                    ResourcePath.path("shader-dumps", shaderName).mkdirs().writeByteBuffer(binary);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            finally {
                while (i > 0) {
                    int shader = shaders[--i];
                    GL43C.glDetachShader((int)program, (int)shader);
                    GL43C.glDeleteShader((int)shader);
                }
                if (!ok) {
                    GL43C.glDeleteProgram((int)program);
                }
            }
        }
        return program;
    }

    @VisibleForTesting
    static class Unit {
        public final int type;
        public final String filename;

        public Unit(int type, String filename) {
            this.type = type;
            this.filename = filename;
        }

        public int getType() {
            return this.type;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

