/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.model;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.kit.KitType;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.data.WaterType;
import rs117.hd.data.materials.Material;
import rs117.hd.data.materials.Overlay;
import rs117.hd.data.materials.Underlay;
import rs117.hd.data.materials.UvType;
import rs117.hd.model.ModelCache;
import rs117.hd.model.ModelHasher;
import rs117.hd.overlays.FrameTimer;
import rs117.hd.overlays.Timer;
import rs117.hd.scene.ProceduralGenerator;
import rs117.hd.scene.SceneContext;
import rs117.hd.scene.SceneUploader;
import rs117.hd.scene.TextureManager;
import rs117.hd.scene.model_overrides.InheritTileColorType;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.scene.model_overrides.ObjectType;
import rs117.hd.scene.model_overrides.TzHaarRecolorType;
import rs117.hd.utils.HDUtils;
import rs117.hd.utils.ModelHash;
import rs117.hd.utils.PopupUtils;

@Singleton
public class ModelPusher {
    private static final Logger log = LoggerFactory.getLogger(ModelPusher.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private TextureManager textureManager;
    @Inject
    private ModelHasher modelHasher;
    @Inject
    private FrameTimer frameTimer;
    public static final int DATUM_PER_FACE = 12;
    public static final int MAX_MATERIAL_COUNT = 4095;
    private static final int[] ZEROED_INTS = new int[12];
    private ModelCache modelCache;

    public void startUp() {
        if (Material.values().length - 1 >= 4095) {
            throw new IllegalStateException("Too many materials (" + Material.values().length + ") to fit into packed material data.");
        }
        if (this.config.modelCaching() && !this.plugin.useLowMemoryMode) {
            int size = this.config.modelCacheSizeMiB();
            try {
                this.modelCache = new ModelCache(size, () -> {
                    this.shutDown();
                    this.plugin.stopPlugin();
                });
            }
            catch (Throwable err) {
                log.error("Error while initializing model cache. Stopping the plugin...", err);
                if (err instanceof OutOfMemoryError) {
                    PopupUtils.displayPopupMessage(this.client, "117 HD Error", "117 HD ran out of memory while trying to allocate the model cache.<br><br>" + (String)(HDUtils.is32Bit() ? "You are currently using 32-bit RuneLite, which heavily restricts<br>the amount of memory RuneLite is allowed to use.<br>Please install the 64-bit launcher from <a href=\"https://runelite.net\">RuneLite's website</a> and try again.<br>" : (String)(size <= 512 ? "" : "Your cache size of " + size + " MiB is " + (size >= 4000 ? "very large. We would recommend reducing it.<br>" : "bigger than the default size. Try reducing it.<br>")) + "Normally, a cache size above 512 MiB is unnecessary, and the game should<br>run acceptably even at 128 MiB. If you have to reduce the size by a lot,<br>you may be better off disabling model caching entirely.<br>") + "<br>You can also try closing some other programs on your PC to free up memory.<br><br>If you need further assistance, please join our <a href=\"https://discord.gg/U4p6ChjgSE\">Discord</a> server, and click the <br>\"Open logs folder\" button below, find the file named \"client\" or \"client.log\",<br>then drag and drop that file into one of our support channels.", new String[]{"Open logs folder", "Ok, let me try that..."}, i -> {
                        if (i == 0) {
                            LinkBrowser.open((String)RuneLite.LOGS_DIR.toString());
                            return false;
                        }
                        return true;
                    });
                }
                this.clientThread.invoke(this.plugin::stopPlugin);
            }
        }
    }

    public void shutDown() {
        if (this.modelCache != null) {
            this.modelCache.destroy();
            this.modelCache = null;
        }
    }

    public void clearModelCache() {
        if (this.modelCache != null) {
            this.modelCache.clear();
        }
    }

    public void pushModel(SceneContext sceneContext, @Nullable Tile tile, long hash, Model model, ModelOverride modelOverride, ObjectType objectType, int preOrientation, boolean shouldCache) {
        int face;
        if (this.modelCache == null) {
            shouldCache = false;
        }
        int faceCount = Math.min(model.getFaceCount(), 6144);
        int bufferSize = faceCount * 12;
        int texturedFaceCount = 0;
        short[] faceTextures = model.getFaceTextures();
        byte[] textureFaces = model.getTextureFaces();
        boolean isVanillaTextured = faceTextures != null;
        boolean isVanillaUVMapped = isVanillaTextured && model.getTexIndices1() != null && model.getTexIndices2() != null && model.getTexIndices3() != null && model.getTextureFaces() != null;
        Material baseMaterial = modelOverride.baseMaterial;
        Material textureMaterial = modelOverride.textureMaterial;
        if (!this.plugin.configModelTextures && !modelOverride.forceMaterialChanges) {
            if (baseMaterial.hasTexture) {
                baseMaterial = Material.NONE;
            }
            if (textureMaterial.hasTexture) {
                textureMaterial = Material.NONE;
            }
        }
        boolean skipUVs = !isVanillaTextured && this.packMaterialData(baseMaterial, -1, modelOverride, UvType.GEOMETRY, false) == 0;
        sceneContext.stagingBufferVertices.ensureCapacity(bufferSize);
        sceneContext.stagingBufferNormals.ensureCapacity(bufferSize);
        if (!skipUVs) {
            sceneContext.stagingBufferUvs.ensureCapacity(bufferSize);
        }
        boolean foundCachedVertexData = false;
        boolean foundCachedNormalData = false;
        boolean foundCachedUvData = skipUVs;
        long vertexHash = 0L;
        long normalHash = 0L;
        long uvHash = 0L;
        if (shouldCache) {
            FloatBuffer normalData;
            assert (this.client.isClientThread()) : "Model caching isn't thread-safe";
            vertexHash = this.modelHasher.calculateVertexCacheHash(modelOverride);
            IntBuffer vertexData = this.modelCache.getIntBuffer(vertexHash);
            boolean bl = foundCachedVertexData = vertexData != null && vertexData.remaining() == bufferSize;
            if (foundCachedVertexData) {
                sceneContext.stagingBufferVertices.put(vertexData);
                vertexData.rewind();
            }
            boolean bl2 = foundCachedNormalData = (normalData = this.modelCache.getFloatBuffer(normalHash = this.modelHasher.calculateNormalCacheHash())) != null && normalData.remaining() == bufferSize;
            if (foundCachedNormalData) {
                sceneContext.stagingBufferNormals.put(normalData);
                normalData.rewind();
            }
            if (!foundCachedUvData) {
                uvHash = this.modelHasher.calculateUvCacheHash(preOrientation, modelOverride);
                FloatBuffer uvData = this.modelCache.getFloatBuffer(uvHash);
                boolean bl3 = foundCachedUvData = uvData != null && uvData.remaining() == bufferSize;
                if (foundCachedUvData) {
                    texturedFaceCount = faceCount;
                    sceneContext.stagingBufferUvs.put(uvData);
                    uvData.rewind();
                }
            }
            if (foundCachedVertexData && foundCachedNormalData && foundCachedUvData) {
                sceneContext.modelPusherResults[0] = faceCount;
                sceneContext.modelPusherResults[1] = texturedFaceCount;
                return;
            }
        }
        IntBuffer fullVertexData = null;
        FloatBuffer fullNormalData = null;
        FloatBuffer fullUvData = null;
        boolean shouldCacheVertexData = false;
        boolean shouldCacheNormalData = false;
        boolean shouldCacheUvData = false;
        if (shouldCache) {
            shouldCacheVertexData = !foundCachedVertexData;
            shouldCacheNormalData = !foundCachedNormalData;
            boolean bl = shouldCacheUvData = !foundCachedUvData;
            if (shouldCacheVertexData && (fullVertexData = this.modelCache.reserveIntBuffer(vertexHash, bufferSize)) == null) {
                log.error("failed to reserve vertex buffer");
                shouldCacheVertexData = false;
            }
            if (shouldCacheNormalData && (fullNormalData = this.modelCache.reserveFloatBuffer(normalHash, bufferSize)) == null) {
                log.error("failed to reserve normal buffer");
                shouldCacheNormalData = false;
            }
            if (shouldCacheUvData && (fullUvData = this.modelCache.reserveFloatBuffer(uvHash, bufferSize)) == null) {
                log.error("failed to reserve uv buffer");
                shouldCacheUvData = false;
            }
        }
        if (!foundCachedVertexData) {
            if (this.plugin.enableDetailedTimers) {
                this.frameTimer.begin(Timer.MODEL_PUSHING_VERTEX);
            }
            modelOverride.applyRotation(model);
            for (face = 0; face < faceCount; ++face) {
                int[] data = this.getFaceVertices(sceneContext, tile, hash, model, modelOverride, objectType, face);
                sceneContext.stagingBufferVertices.put(data);
                if (!shouldCacheVertexData) continue;
                fullVertexData.put(data);
            }
            modelOverride.revertRotation(model);
            if (this.plugin.enableDetailedTimers) {
                this.frameTimer.end(Timer.MODEL_PUSHING_VERTEX);
            }
        }
        if (!foundCachedNormalData) {
            if (this.plugin.enableDetailedTimers) {
                this.frameTimer.begin(Timer.MODEL_PUSHING_NORMAL);
            }
            for (face = 0; face < faceCount; ++face) {
                this.getNormalDataForFace(sceneContext, model, modelOverride, face);
                sceneContext.stagingBufferNormals.put(sceneContext.modelFaceNormals);
                if (!shouldCacheNormalData) continue;
                fullNormalData.put(sceneContext.modelFaceNormals);
            }
            if (this.plugin.enableDetailedTimers) {
                this.frameTimer.end(Timer.MODEL_PUSHING_NORMAL);
            }
        }
        if (!foundCachedUvData) {
            if (this.plugin.enableDetailedTimers) {
                this.frameTimer.begin(Timer.MODEL_PUSHING_UV);
            }
            for (face = 0; face < faceCount; ++face) {
                ModelOverride override;
                int textureId;
                UvType uvType = UvType.GEOMETRY;
                Material material = baseMaterial;
                int n = textureId = isVanillaTextured ? faceTextures[face] : -1;
                if (textureId != -1) {
                    uvType = UvType.VANILLA;
                    material = textureMaterial;
                    if (material == Material.NONE) {
                        material = Material.fromVanillaTexture(textureId);
                    }
                }
                ModelOverride materialOverride = modelOverride;
                if (modelOverride.materialOverrides != null && (override = modelOverride.materialOverrides.get((Object)material)) != null) {
                    materialOverride = override;
                    material = materialOverride.textureMaterial;
                }
                if (material != Material.NONE && ((uvType = materialOverride.uvType) == UvType.VANILLA || textureId != -1 && materialOverride.retainVanillaUvs)) {
                    uvType = isVanillaUVMapped && textureFaces[face] != -1 ? UvType.VANILLA : UvType.GEOMETRY;
                }
                int materialData = this.packMaterialData(material, textureId, materialOverride, uvType, false);
                float[] uvData = sceneContext.modelFaceNormals;
                if (materialData == 0) {
                    Arrays.fill(uvData, 0.0f);
                } else {
                    materialOverride.fillUvsForFace(uvData, model, preOrientation, uvType, face);
                    uvData[7] = uvData[11] = (float)materialData;
                    uvData[3] = uvData[11];
                }
                sceneContext.stagingBufferUvs.put(uvData);
                if (shouldCacheUvData) {
                    fullUvData.put(uvData);
                }
                ++texturedFaceCount;
            }
            if (this.plugin.enableDetailedTimers) {
                this.frameTimer.end(Timer.MODEL_PUSHING_UV);
            }
        }
        if (shouldCacheVertexData) {
            fullVertexData.flip();
        }
        if (shouldCacheNormalData) {
            fullNormalData.flip();
        }
        if (shouldCacheUvData) {
            fullUvData.flip();
        }
        sceneContext.modelPusherResults[0] = faceCount;
        sceneContext.modelPusherResults[1] = texturedFaceCount;
    }

    private void getNormalDataForFace(SceneContext sceneContext, Model model, @NonNull ModelOverride modelOverride, int face) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        assert (SceneUploader.packTerrainData(false, 0, WaterType.NONE, 0) == 0);
        if (modelOverride.flatNormals || !this.plugin.configPreserveVanillaNormals && model.getFaceColors3()[face] == -1) {
            Arrays.fill(sceneContext.modelFaceNormals, 0.0f);
            return;
        }
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        int[] xVertexNormals = model.getVertexNormalsX();
        int[] yVertexNormals = model.getVertexNormalsY();
        int[] zVertexNormals = model.getVertexNormalsZ();
        if (xVertexNormals == null || yVertexNormals == null || zVertexNormals == null) {
            Arrays.fill(sceneContext.modelFaceNormals, 0.0f);
            return;
        }
        float terrainData = 8388608.0f;
        sceneContext.modelFaceNormals[0] = xVertexNormals[triA];
        sceneContext.modelFaceNormals[1] = yVertexNormals[triA];
        sceneContext.modelFaceNormals[2] = zVertexNormals[triA];
        sceneContext.modelFaceNormals[3] = terrainData;
        sceneContext.modelFaceNormals[4] = xVertexNormals[triB];
        sceneContext.modelFaceNormals[5] = yVertexNormals[triB];
        sceneContext.modelFaceNormals[6] = zVertexNormals[triB];
        sceneContext.modelFaceNormals[7] = terrainData;
        sceneContext.modelFaceNormals[8] = xVertexNormals[triC];
        sceneContext.modelFaceNormals[9] = yVertexNormals[triC];
        sceneContext.modelFaceNormals[10] = zVertexNormals[triC];
        sceneContext.modelFaceNormals[11] = terrainData;
    }

    public int packMaterialData(@Nonnull Material material, int vanillaTexture, @Nonnull ModelOverride modelOverride, UvType uvType, boolean isOverlay) {
        int materialIndex = this.textureManager.getMaterialIndex(material, vanillaTexture);
        assert (materialIndex <= 4095);
        int materialData = (materialIndex & 0xFFF) << 12 | ((int)(modelOverride.shadowOpacityThreshold * 63.0f) & 0x3F) << 6 | (!modelOverride.receiveShadows ? 1 : 0) << 5 | (modelOverride.upwardsNormals ? 1 : 0) << 4 | (modelOverride.flatNormals ? 1 : 0) << 3 | (uvType.worldUvs ? 1 : 0) << 2 | (uvType == UvType.VANILLA ? 1 : 0) << 1 | (isOverlay ? 1 : 0);
        assert ((materialData & 0xFF000000) == 0) : "Only the lower 24 bits are usable, since we pass this into shaders as a float";
        return materialData;
    }

    private boolean isBakedGroundShading(Model model, int face) {
        byte[] faceTransparencies = model.getFaceTransparencies();
        if (faceTransparencies == null || (faceTransparencies[face] & 0xFF) <= 100) {
            return false;
        }
        short[] faceTextures = model.getFaceTextures();
        if (faceTextures != null && faceTextures[face] != -1) {
            return false;
        }
        int[] yVertices = model.getVerticesY();
        int heightA = yVertices[model.getFaceIndices1()[face]];
        if (heightA < -8) {
            return false;
        }
        int heightB = yVertices[model.getFaceIndices2()[face]];
        int heightC = yVertices[model.getFaceIndices3()[face]];
        return heightA == heightB && heightA == heightC;
    }

    private int[] getFaceVertices(SceneContext sceneContext, Tile tile, long hash, Model model, @NonNull ModelOverride modelOverride, ObjectType objectType, int face) {
        boolean isTextured;
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        if (model.getFaceColors3()[face] == -2) {
            return ZEROED_INTS;
        }
        if (this.plugin.configHideFakeShadows && this.isBakedGroundShading(model, face)) {
            if (modelOverride.removeBakedLighting) {
                return ZEROED_INTS;
            }
            if (ModelHash.getType(hash) == 0) {
                Player player;
                int index = ModelHash.getIdOrIndex(hash);
                Player[] players = this.client.getCachedPlayers();
                Player player2 = player = index >= 0 && index < players.length ? players[index] : null;
                if (player != null && player.getPlayerComposition().getEquipmentId(KitType.WEAPON) == 5614) {
                    return ZEROED_INTS;
                }
            }
        }
        int color1 = model.getFaceColors1()[face];
        int color2 = model.getFaceColors2()[face];
        int color3 = model.getFaceColors3()[face];
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        int[] xVertices = model.getVerticesX();
        int[] yVertices = model.getVerticesY();
        int[] zVertices = model.getVerticesZ();
        short[] faceTextures = model.getFaceTextures();
        byte[] faceTransparencies = model.getFaceTransparencies();
        byte[] facePriorities = model.getFaceRenderPriorities();
        boolean bl = isTextured = faceTextures != null && faceTextures[face] != -1;
        if (color3 == -1) {
            color2 = color3 = color1;
        }
        int packedAlphaPriorityFlags = 0;
        if (faceTransparencies != null && !isTextured) {
            packedAlphaPriorityFlags |= (faceTransparencies[face] & 0xFF) << 24;
        }
        if (facePriorities != null) {
            packedAlphaPriorityFlags |= (facePriorities[face] & 0xF) << 16;
        }
        if (isTextured) {
            color3 = 90;
            color2 = 90;
            color1 = 90;
            packedAlphaPriorityFlags |= 0x100000;
        } else {
            int overrideAmount = model.getOverrideAmount() & 0xFF;
            if (overrideAmount > 0) {
                byte overrideHue = model.getOverrideHue();
                byte overrideSat = model.getOverrideSaturation();
                byte overrideLum = model.getOverrideLuminance();
                if (overrideHue != -1) {
                    color1 += overrideAmount * (overrideHue - (color1 >> 10 & 0x3F)) >> 7 << 10;
                    color2 += overrideAmount * (overrideHue - (color2 >> 10 & 0x3F)) >> 7 << 10;
                    color3 += overrideAmount * (overrideHue - (color3 >> 10 & 0x3F)) >> 7 << 10;
                }
                if (overrideSat != -1) {
                    color1 += overrideAmount * (overrideSat - (color1 >> 7 & 7)) >> 7 << 7;
                    color2 += overrideAmount * (overrideSat - (color2 >> 7 & 7)) >> 7 << 7;
                    color3 += overrideAmount * (overrideSat - (color3 >> 7 & 7)) >> 7 << 7;
                }
                if (overrideLum != -1) {
                    color1 += overrideAmount * (overrideLum - (color1 & 0x7F)) >> 7;
                    color2 += overrideAmount * (overrideLum - (color2 & 0x7F)) >> 7;
                    color3 += overrideAmount * (overrideLum - (color3 & 0x7F)) >> 7;
                }
            }
            if (tile != null) {
                if (modelOverride.inheritTileColorType != InheritTileColorType.NONE) {
                    Scene scene = sceneContext.scene;
                    SceneTileModel tileModel = tile.getSceneTileModel();
                    SceneTilePaint tilePaint = tile.getSceneTilePaint();
                    if (tilePaint != null || tileModel != null) {
                        if (tilePaint != null && tilePaint.getTexture() == -1 && tilePaint.getRBG() != 0 && tilePaint.getNeColor() != 12345678) {
                            int averageColor = (tilePaint.getSwColor() + tilePaint.getNwColor() + tilePaint.getNeColor() + tilePaint.getSeColor()) / 4;
                            Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                            if (overlay != Overlay.NONE) {
                                averageColor = overlay.modifyColor(averageColor);
                            } else {
                                Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                                averageColor = underlay.modifyColor(averageColor);
                            }
                            color2 = color3 = averageColor;
                            color1 = color3;
                            packedAlphaPriorityFlags |= 0x100000;
                        } else if (tileModel != null && tileModel.getTriangleTextureId() == null) {
                            int color;
                            int faceColorIndex = -1;
                            for (int i = 0; i < tileModel.getTriangleColorA().length; ++i) {
                                boolean isOverlayFace = ProceduralGenerator.isOverlayFace(tile, i);
                                if (modelOverride.inheritTileColorType == InheritTileColorType.UNDERLAY || tileModel.getModelOverlay() == 0) {
                                    if (isOverlayFace) continue;
                                    faceColorIndex = i;
                                    break;
                                }
                                if (modelOverride.inheritTileColorType != InheritTileColorType.OVERLAY || !isOverlayFace) continue;
                                faceColorIndex = i;
                                break;
                            }
                            if (faceColorIndex != -1 && (color = tileModel.getTriangleColorA()[faceColorIndex]) != 12345678) {
                                Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                                color2 = color3 = (color = underlay.modifyColor(color));
                                color1 = color3;
                                packedAlphaPriorityFlags |= 0x100000;
                            }
                        }
                    }
                }
                if (this.plugin.configTzhaarHD && modelOverride.tzHaarRecolorType != TzHaarRecolorType.NONE) {
                    int[] tzHaarRecolored = ProceduralGenerator.recolorTzHaar(modelOverride, model, face, packedAlphaPriorityFlags, objectType, color1, color2, color3);
                    color1 = tzHaarRecolored[0];
                    color2 = tzHaarRecolored[1];
                    color3 = tzHaarRecolored[2];
                    packedAlphaPriorityFlags = tzHaarRecolored[3];
                }
            }
        }
        color1 |= packedAlphaPriorityFlags;
        color2 |= packedAlphaPriorityFlags;
        color3 |= packedAlphaPriorityFlags;
        int[] data = sceneContext.modelFaceVertices;
        data[0] = xVertices[triA];
        data[1] = yVertices[triA];
        data[2] = zVertices[triA];
        data[3] = color1;
        data[4] = xVertices[triB];
        data[5] = yVertices[triB];
        data[6] = zVertices[triB];
        data[7] = color2;
        data[8] = xVertices[triC];
        data[9] = yVertices[triC];
        data[10] = zVertices[triC];
        data[11] = color3;
        return data;
    }
}

