/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.model;

import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Model;
import rs117.hd.HdPlugin;
import rs117.hd.data.materials.UvType;
import rs117.hd.scene.model_overrides.ModelOverride;

@Singleton
public class ModelHasher {
    @Inject
    private HdPlugin plugin;
    private Model model;
    private int faceCount;
    private long faceColorsOneHash;
    private long faceColorsTwoHash;
    private long faceColorsThreeHash;
    private long faceTransparenciesHash;
    private long faceTexturesHash;
    private long xVerticesHash;
    private long yVerticesHash;
    private long zVerticesHash;
    private long faceIndicesOneHash;
    private long faceIndicesTwoHash;
    private long faceIndicesThreeHash;
    private long textureTrianglesHash;

    public void setModel(Model model) {
        this.model = model;
        this.faceCount = model.getFaceCount();
        if (this.plugin.configUseFasterModelHashing) {
            this.faceColorsOneHash = ModelHasher.fastHash(model.getFaceColors1());
            this.faceColorsTwoHash = 0L;
            this.faceColorsThreeHash = 0L;
            this.faceTransparenciesHash = ModelHasher.fastByteHash(model.getFaceTransparencies());
            this.faceTexturesHash = ModelHasher.fastShortHash(model.getFaceTextures());
            this.xVerticesHash = ModelHasher.fastHash(model.getVerticesX(), model.getVerticesCount());
            this.yVerticesHash = ModelHasher.fastHash(model.getVerticesY(), model.getVerticesCount());
            this.zVerticesHash = ModelHasher.fastHash(model.getVerticesZ(), model.getVerticesCount());
            this.faceIndicesOneHash = ModelHasher.fastHash(model.getFaceIndices1());
            this.faceIndicesTwoHash = 0L;
            this.faceIndicesThreeHash = 0L;
            this.textureTrianglesHash = 0L;
            byte[] textureFaces = model.getTextureFaces();
            if (textureFaces != null) {
                boolean hasVanillaTexturedFaces = false;
                for (byte textureId : textureFaces) {
                    if (textureId == -1) continue;
                    hasVanillaTexturedFaces = true;
                    break;
                }
                if (hasVanillaTexturedFaces) {
                    int[] nArray = model.getTexIndices1();
                    int[] texIndices2 = model.getTexIndices2();
                    int[] texIndices3 = model.getTexIndices3();
                    int[] vertexX = model.getVerticesX();
                    int[] vertexY = model.getVerticesY();
                    int[] vertexZ = model.getVerticesZ();
                    long h = 0L;
                    for (int i = 0; i < model.getFaceCount(); ++i) {
                        int texFace = textureFaces[i];
                        if (texFace == -1) continue;
                        int texA = nArray[texFace &= 0xFF];
                        int texB = texIndices2[texFace];
                        int texC = texIndices3[texFace];
                        h = h * 31L + (long)vertexX[texA];
                        h = h * 31L + (long)vertexY[texA];
                        h = h * 31L + (long)vertexZ[texA];
                        h = h * 31L + (long)vertexX[texB];
                        h = h * 31L + (long)vertexY[texB];
                        h = h * 31L + (long)vertexZ[texB];
                        h = h * 31L + (long)vertexX[texC];
                        h = h * 31L + (long)vertexY[texC];
                        h = h * 31L + (long)vertexZ[texC];
                    }
                    this.textureTrianglesHash = h;
                }
            }
        } else {
            this.faceColorsOneHash = ModelHasher.fastHash(model.getFaceColors1());
            this.faceColorsTwoHash = ModelHasher.fastHash(model.getFaceColors2());
            this.faceColorsThreeHash = ModelHasher.fastHash(model.getFaceColors3());
            this.faceTransparenciesHash = ModelHasher.fastByteHash(model.getFaceTransparencies());
            this.faceTexturesHash = ModelHasher.fastShortHash(model.getFaceTextures());
            this.xVerticesHash = ModelHasher.fastHash(model.getVerticesX(), model.getVerticesCount());
            this.yVerticesHash = ModelHasher.fastHash(model.getVerticesY(), model.getVerticesCount());
            this.zVerticesHash = ModelHasher.fastHash(model.getVerticesZ(), model.getVerticesCount());
            this.faceIndicesOneHash = ModelHasher.fastHash(model.getFaceIndices1());
            this.faceIndicesTwoHash = ModelHasher.fastHash(model.getFaceIndices2());
            this.faceIndicesThreeHash = ModelHasher.fastHash(model.getFaceIndices3());
            this.textureTrianglesHash = 0L;
            byte[] textureFaces = model.getTextureFaces();
            if (textureFaces != null) {
                boolean hasVanillaTexturedFaces = false;
                for (byte textureId : textureFaces) {
                    if (textureId == -1) continue;
                    hasVanillaTexturedFaces = true;
                    break;
                }
                if (hasVanillaTexturedFaces) {
                    int[] nArray = model.getTexIndices1();
                    int[] texIndices2 = model.getTexIndices2();
                    int[] texIndices3 = model.getTexIndices3();
                    int[] vertexX = model.getVerticesX();
                    int[] vertexY = model.getVerticesY();
                    int[] vertexZ = model.getVerticesZ();
                    long h = 0L;
                    for (int i = 0; i < model.getFaceCount(); ++i) {
                        int texFace = textureFaces[i];
                        if (texFace == -1) continue;
                        int texA = nArray[texFace &= 0xFF];
                        int texB = texIndices2[texFace];
                        int texC = texIndices3[texFace];
                        h = h * 31L + (long)vertexX[texA];
                        h = h * 31L + (long)vertexY[texA];
                        h = h * 31L + (long)vertexZ[texA];
                        h = h * 31L + (long)vertexX[texB];
                        h = h * 31L + (long)vertexY[texB];
                        h = h * 31L + (long)vertexZ[texB];
                        h = h * 31L + (long)vertexX[texC];
                        h = h * 31L + (long)vertexY[texC];
                        h = h * 31L + (long)vertexZ[texC];
                    }
                    this.textureTrianglesHash = h;
                }
            }
        }
    }

    public long calculateVertexCacheHash(@NonNull ModelOverride modelOverride) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        long h = this.faceCount;
        h = h * 31L + this.faceColorsOneHash;
        h = h * 31L + this.faceColorsTwoHash;
        h = h * 31L + this.faceColorsThreeHash;
        h = h * 31L + this.faceTransparenciesHash;
        h = h * 31L + this.faceTexturesHash;
        h = h * 31L + this.xVerticesHash;
        h = h * 31L + this.yVerticesHash;
        h = h * 31L + this.zVerticesHash;
        h = h * 31L + this.faceIndicesOneHash;
        h = h * 31L + this.faceIndicesTwoHash;
        h = h * 31L + this.faceIndicesThreeHash;
        h = h * 31L + this.textureTrianglesHash;
        h = h * 31L + (long)this.model.getOverrideAmount();
        h = h * 31L + (long)this.model.getOverrideHue();
        h = h * 31L + (long)this.model.getOverrideSaturation();
        h = h * 31L + (long)this.model.getOverrideLuminance();
        h = h * 31L + (long)modelOverride.rotate;
        return h;
    }

    public long calculateNormalCacheHash() {
        long h = this.faceCount;
        h = h * 31L + this.faceIndicesOneHash;
        h = h * 31L + this.faceIndicesTwoHash;
        h = h * 31L + this.faceIndicesThreeHash;
        h = h * 31L + ModelHasher.fastHash(this.model.getVertexNormalsX());
        h = h * 31L + ModelHasher.fastHash(this.model.getVertexNormalsY());
        h = h * 31L + ModelHasher.fastHash(this.model.getVertexNormalsZ());
        return h;
    }

    public long calculateUvCacheHash(int orientation, @NonNull ModelOverride modelOverride) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        long h = this.faceCount;
        h = h * 31L + (modelOverride.uvType == UvType.VANILLA || modelOverride.retainVanillaUvs ? this.textureTrianglesHash : 0L);
        h = h * 31L + (long)(modelOverride.uvType.orientationDependent ? orientation : 0);
        h = h * 31L + (long)modelOverride.hashCode();
        h = h * 31L + this.faceTexturesHash;
        return h;
    }

    public static long fastHash(int[] a) {
        if (a == null) {
            return 0L;
        }
        int i = 0;
        long r = 1L;
        int length = a.length;
        while (i + 5 < length) {
            r = 887503681L * r + 28629151L * (long)a[i] + 923521L * (long)a[i + 1] + 29791L * (long)a[i + 2] + 961L * (long)a[i + 3] + 31L * (long)a[i + 4] + (long)a[i + 5];
            i += 6;
        }
        while (i < length) {
            r = 31L * r + (long)a[i];
            ++i;
        }
        return r;
    }

    public static long fastHash(int[] a, int length) {
        if (a == null) {
            return 0L;
        }
        int i = 0;
        long r = 1L;
        while (i + 5 < length) {
            r = 887503681L * r + 28629151L * (long)a[i] + 923521L * (long)a[i + 1] + 29791L * (long)a[i + 2] + 961L * (long)a[i + 3] + 31L * (long)a[i + 4] + (long)a[i + 5];
            i += 6;
        }
        while (i < length) {
            r = 31L * r + (long)a[i];
            ++i;
        }
        return r;
    }

    public static int fastIntHash(int[] a, int actualLength) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        int length = a.length;
        if (actualLength != -1) {
            length = actualLength;
        }
        while (i + 5 < length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastByteHash(byte[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastShortHash(short[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * a[i] + 923521 * a[i + 1] + 29791 * a[i + 2] + 961 * a[i + 3] + 31 * a[i + 4] + a[i + 5];
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + a[i];
            ++i;
        }
        return r;
    }

    public static int fastFloatHash(float[] a) {
        if (a == null) {
            return 0;
        }
        int i = 0;
        int r = 1;
        while (i + 5 < a.length) {
            r = 887503681 * r + 28629151 * Float.floatToIntBits(a[i]) + 923521 * Float.floatToIntBits(a[i + 1]) + 29791 * Float.floatToIntBits(a[i + 2]) + 961 * Float.floatToIntBits(a[i + 3]) + 31 * Float.floatToIntBits(a[i + 4]) + Float.floatToIntBits(a[i + 5]);
            i += 6;
        }
        while (i < a.length) {
            r = 31 * r + Float.floatToIntBits(a[i]);
            ++i;
        }
        return r;
    }
}

