/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.model;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCache {
    private static final Logger log = LoggerFactory.getLogger(ModelCache.class);
    private final Runnable terminationHook;
    private final HashMap<Long, Buffer> cache = new HashMap();
    private final ArrayDeque<Buffer> buffers = new ArrayDeque();
    private final Allocation[] allocations;
    private Allocation currentAllocation;
    private int currentAllocationIndex;

    public ModelCache(int modelCacheSizeMiB, Runnable terminationHook) {
        this.terminationHook = terminationHook;
        if (modelCacheSizeMiB > 128 && !"64".equals(System.getProperty("sun.arch.data.model"))) {
            log.warn("Defaulting model cache to 128 MiB due to non 64-bit client");
            modelCacheSizeMiB = 128;
        }
        try {
            int totalPhysicalMemoryMiB = (int)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 0x100000L);
            if (modelCacheSizeMiB > totalPhysicalMemoryMiB / 2) {
                log.warn("Limiting cache size to {} since the selected amount ({}) exceeds half of the total system memory ({} / 2)", new Object[]{totalPhysicalMemoryMiB / 2, modelCacheSizeMiB, totalPhysicalMemoryMiB});
                modelCacheSizeMiB = totalPhysicalMemoryMiB / 2;
            }
        }
        catch (Throwable e) {
            log.warn("Unable to check physical memory size: " + e);
        }
        long byteCapacity = (long)modelCacheSizeMiB * 0x100000L;
        log.debug("Allocating {} MiB model cache", (Object)modelCacheSizeMiB);
        Allocation[] allocations = new Allocation[1];
        try {
            allocations[0] = new Allocation(byteCapacity);
        }
        catch (Throwable err) {
            log.warn("Unable to allocate {} MiB as a single chunk", (Object)modelCacheSizeMiB, (Object)err);
            try {
                int numChunks = (int)Math.ceil((double)byteCapacity / 1.073741824E9);
                allocations = new Allocation[numChunks];
                for (int i = 0; i < numChunks; ++i) {
                    allocations[i] = new Allocation(Math.min(byteCapacity - (long)i * 0x40000000L, 0x40000000L));
                }
            }
            catch (Throwable err2) {
                this.destroy();
                log.error("Unable to allocate {} MiB in chunks of up to 1 GiB each", (Object)modelCacheSizeMiB, (Object)err2);
                throw err2;
            }
        }
        this.allocations = allocations;
        this.currentAllocation = allocations[0];
    }

    public void destroy() {
        this.cache.clear();
        this.buffers.clear();
        this.currentAllocation = null;
        for (int i = 0; i < this.allocations.length; ++i) {
            if (this.allocations[i] == null) continue;
            this.allocations[i].destroy();
            this.allocations[i] = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        this.cache.clear();
        this.buffers.clear();
        for (Allocation allocation : this.allocations) {
            if (allocation == null) continue;
            allocation.cursor = 0L;
            allocation.freeBytesAhead = allocation.byteCapacity;
        }
    }

    private Buffer get(long hash) {
        return this.cache.get(hash);
    }

    private void nextAllocation() {
        this.currentAllocation.cursor = 0L;
        this.currentAllocation.freeBytesAhead = 0L;
        ++this.currentAllocationIndex;
        this.currentAllocationIndex %= this.allocations.length;
        this.currentAllocation = this.allocations[this.currentAllocationIndex];
    }

    private long reserve(long numBytes) {
        assert (this.currentAllocation != null) : "model cache used after destruction";
        if (this.currentAllocation.bytesFromEnd() < numBytes) {
            while (this.currentAllocation.bytesFromEnd() != this.currentAllocation.freeBytesAhead) {
                assert (this.currentAllocation.bytesFromEnd() > this.currentAllocation.freeBytesAhead);
                Buffer buffer = this.buffers.pollFirst();
                if (buffer == null) {
                    log.error("No more cache entries left to free, yet the allocation is still in use ({} != {})", (Object)this.currentAllocation.bytesFromEnd(), (Object)this.currentAllocation.freeBytesAhead);
                    this.terminationHook.run();
                    return 0L;
                }
                if (buffer.endMarker) {
                    this.currentAllocation.freeBytesAhead += buffer.byteCapacity;
                    assert (this.currentAllocation.cursor + this.currentAllocation.freeBytesAhead <= this.currentAllocation.byteCapacity);
                    continue;
                }
                this.buffers.addLast(buffer);
                this.currentAllocation.cursor += buffer.byteCapacity;
            }
            this.buffers.addLast(new Buffer(this.currentAllocation.freeBytesAhead));
            this.nextAllocation();
            if (this.currentAllocation.bytesFromEnd() < numBytes) {
                log.error("Failed to reserve space for {} bytes. Too large to fit in allocation {} of size {}", new Object[]{numBytes, this.currentAllocationIndex, this.currentAllocation.byteCapacity});
                this.terminationHook.run();
                return 0L;
            }
        }
        while (this.currentAllocation.freeBytesAhead < numBytes) {
            if (this.removeOldestCacheEntry() != null) continue;
            log.error("No more cache entries left to free, yet there aren't enough free bytes ({} < {})", (Object)this.currentAllocation.freeBytesAhead, (Object)numBytes);
            this.terminationHook.run();
            return 0L;
        }
        return this.currentAllocation.reserve(numBytes);
    }

    private Buffer removeOldestCacheEntry() {
        Buffer buffer = this.buffers.pollFirst();
        if (buffer != null) {
            if (!buffer.endMarker) {
                this.cache.remove(buffer.hash, buffer);
                assert (this.currentAllocation.address + this.currentAllocation.cursor + this.currentAllocation.freeBytesAhead <= MemoryUtil.memAddress0((java.nio.Buffer)(buffer.intBuffer == null ? buffer.floatBuffer : buffer.intBuffer)));
            }
            this.currentAllocation.freeBytesAhead += buffer.byteCapacity;
            assert (this.currentAllocation.cursor + this.currentAllocation.freeBytesAhead <= this.currentAllocation.byteCapacity);
        }
        return buffer;
    }

    public IntBuffer getIntBuffer(long hash) {
        Buffer buffer = this.get(hash);
        if (buffer == null) {
            return null;
        }
        return buffer.intBuffer;
    }

    public FloatBuffer getFloatBuffer(long hash) {
        Buffer buffer = this.get(hash);
        if (buffer == null) {
            return null;
        }
        return buffer.floatBuffer;
    }

    public IntBuffer reserveIntBuffer(long hash, int capacity) {
        long address = this.reserve((long)capacity * 4L);
        if (address == 0L) {
            return null;
        }
        Buffer buffer = new Buffer(hash, MemoryUtil.memIntBuffer((long)address, (int)capacity));
        this.cache.put(hash, buffer);
        this.buffers.addLast(buffer);
        return buffer.intBuffer;
    }

    public FloatBuffer reserveFloatBuffer(long hash, int capacity) {
        long address = this.reserve((long)capacity * 4L);
        if (address == 0L) {
            return null;
        }
        Buffer buffer = new Buffer(hash, MemoryUtil.memFloatBuffer((long)address, (int)capacity));
        this.cache.put(hash, buffer);
        this.buffers.addLast(buffer);
        return buffer.floatBuffer;
    }

    private static class Allocation {
        long address;
        long byteCapacity;
        long cursor;
        long freeBytesAhead;

        Allocation(long byteCapacity) {
            assert (byteCapacity > 0L);
            this.address = MemoryUtil.nmemAllocChecked((long)byteCapacity);
            this.byteCapacity = byteCapacity;
            this.cursor = 0L;
            this.freeBytesAhead = byteCapacity;
        }

        void destroy() {
            if (this.address != 0L) {
                MemoryUtil.nmemFree((long)this.address);
                this.address = 0L;
                this.byteCapacity = 0L;
                this.cursor = 0L;
                this.freeBytesAhead = 0L;
            }
        }

        long reserve(long numBytes) {
            assert (numBytes > 0L);
            assert (numBytes <= this.freeBytesAhead);
            assert (numBytes <= this.byteCapacity - this.cursor);
            long address = this.address + this.cursor;
            this.cursor += numBytes;
            this.freeBytesAhead -= numBytes;
            return address;
        }

        long bytesFromEnd() {
            return this.byteCapacity - this.cursor;
        }
    }

    private static class Buffer {
        final boolean endMarker;
        final long hash;
        final long byteCapacity;
        final IntBuffer intBuffer;
        final FloatBuffer floatBuffer;

        public Buffer(long byteCapacity) {
            this.endMarker = true;
            this.hash = 0L;
            this.byteCapacity = byteCapacity;
            this.intBuffer = null;
            this.floatBuffer = null;
        }

        public Buffer(long hash, IntBuffer buffer) {
            this.endMarker = false;
            this.hash = hash;
            this.byteCapacity = (long)buffer.capacity() * 4L;
            this.intBuffer = buffer;
            this.floatBuffer = null;
        }

        public Buffer(long hash, FloatBuffer buffer) {
            this.endMarker = false;
            this.hash = hash;
            this.byteCapacity = (long)buffer.capacity() * 4L;
            this.intBuffer = null;
            this.floatBuffer = buffer;
        }
    }
}

