/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data.materials;

public final class UvType
extends Enum<UvType> {
    public static final /* enum */ UvType VANILLA = new UvType();
    public static final /* enum */ UvType GEOMETRY = new UvType();
    public static final /* enum */ UvType MODEL_XY = new UvType(true, (uvw, i, x, y, z) -> {
        uvw[i] = x;
        uvw[i + 1] = y;
        uvw[i + 2] = z;
    });
    public static final /* enum */ UvType MODEL_XY_MIRROR_A = new UvType(MODEL_XY, UvType::mirrorDiagonally);
    public static final /* enum */ UvType MODEL_XY_MIRROR_B = new UvType(MODEL_XY, (uvw, i) -> {
        uvw[i + 1] = 1.0f - uvw[i + 1];
        UvType.mirrorDiagonally(uvw, i);
    });
    public static final /* enum */ UvType MODEL_XZ = new UvType(true, (uvw, i, x, y, z) -> {
        uvw[i] = x;
        uvw[i + 1] = z;
        uvw[i + 2] = y;
    });
    public static final /* enum */ UvType MODEL_XZ_MIRROR_A = new UvType(MODEL_XZ, UvType::mirrorDiagonally);
    public static final /* enum */ UvType MODEL_XZ_MIRROR_B = new UvType(MODEL_XZ, (uvw, i) -> {
        uvw[i + 1] = 1.0f - uvw[i + 1];
        UvType.mirrorDiagonally(uvw, i);
    });
    public static final /* enum */ UvType MODEL_YZ = new UvType(true, (uvw, i, x, y, z) -> {
        uvw[i] = y;
        uvw[i + 1] = z;
        uvw[i + 2] = x;
    });
    public static final /* enum */ UvType MODEL_YZ_MIRROR_A = new UvType(MODEL_YZ, UvType::mirrorDiagonally);
    public static final /* enum */ UvType MODEL_YZ_MIRROR_B = new UvType(MODEL_YZ, (uvw, i) -> {
        uvw[i + 1] = 1.0f - uvw[i + 1];
        UvType.mirrorDiagonally(uvw, i);
    });
    public static final /* enum */ UvType WORLD_XY = new UvType(new float[]{0.0f, 0.0f, -1.0f});
    public static final /* enum */ UvType WORLD_XZ = new UvType(new float[]{0.0f, -1.0f, 0.0f});
    public static final /* enum */ UvType WORLD_YZ = new UvType(new float[]{-1.0f, 0.0f, 0.0f});
    public static final /* enum */ UvType BOX = new UvType();
    public final boolean worldUvs;
    public final boolean orientationDependent;
    private final UvGenerator generator;
    private static final /* synthetic */ UvType[] $VALUES;

    public static UvType[] values() {
        return (UvType[])$VALUES.clone();
    }

    public static UvType valueOf(String name) {
        return Enum.valueOf(UvType.class, name);
    }

    private UvType() {
        this.worldUvs = false;
        this.orientationDependent = false;
        this.generator = null;
    }

    private UvType(boolean orientationDependent, UvGenerator generator) {
        this.worldUvs = false;
        this.orientationDependent = orientationDependent;
        this.generator = generator;
    }

    private UvType(UvType inherit, UvProcessor processor) {
        this.worldUvs = inherit.worldUvs;
        this.orientationDependent = inherit.orientationDependent;
        this.generator = (uvw, i, x, y, z) -> {
            inherit.generator.computeUvw(uvw, i, x, y, z);
            processor.processUvw(uvw, i);
        };
    }

    private UvType(float[] normal) {
        this.worldUvs = true;
        this.orientationDependent = false;
        this.generator = (uvw, i, scale, _1, _2) -> {
            uvw[i] = scale * normal[0];
            uvw[i + 1] = scale * normal[1];
            uvw[i + 2] = scale * normal[2];
        };
    }

    public void computeModelUvw(float[] out, int offset, float x, float y, float z) {
        assert (this.generator != null) : this + " does not support computing UVs";
        this.generator.computeUvw(out, offset, x, y, z);
    }

    public void computeWorldUvw(float[] out, int offset, float scale) {
        assert (this.generator != null) : this + " does not support computing UVs";
        this.generator.computeUvw(out, offset, scale, 0.0f, 0.0f);
    }

    private static void mirrorDiagonally(float[] uv, int i) {
        if (uv[i] < uv[i + 1]) {
            float temp = uv[i];
            uv[i] = uv[i + 1];
            uv[i + 1] = temp;
        }
    }

    private static /* synthetic */ UvType[] $values() {
        return new UvType[]{VANILLA, GEOMETRY, MODEL_XY, MODEL_XY_MIRROR_A, MODEL_XY_MIRROR_B, MODEL_XZ, MODEL_XZ_MIRROR_A, MODEL_XZ_MIRROR_B, MODEL_YZ, MODEL_YZ_MIRROR_A, MODEL_YZ_MIRROR_B, WORLD_XY, WORLD_XZ, WORLD_YZ, BOX};
    }

    static {
        $VALUES = UvType.$values();
    }

    @FunctionalInterface
    public static interface UvGenerator {
        public void computeUvw(float[] var1, int var2, float var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface UvProcessor {
        public void processUvw(float[] var1, int var2);
    }
}

