/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data.materials;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.config.SeasonalTheme;
import rs117.hd.data.WaterType;
import rs117.hd.data.environments.Area;
import rs117.hd.data.materials.GroundMaterial;
import rs117.hd.data.materials.TileOverrideBuilder;
import rs117.hd.data.materials.TileOverrideResolver;
import rs117.hd.utils.HDUtils;

public enum Underlay {
    WINTER_GRASS(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.SNOW_1).hue(0).saturation(0).shiftLightness(40).blended(true)),
    WINTER_DIRT(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.SNOW_2).hue(0).saturation(0).shiftLightness(40).blended(true)),
    WINTER_GRUNGE(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.SNOW_2).hue(0).saturation(0).shiftLightness(40).blended(true)),
    WINTER_EDGEVILLE_PATH(p -> p.ids(new Integer[0]).blendedAsOpposite(true).hue(0).shiftLightness(8).saturation(0).groundMaterial(GroundMaterial.WINTER_JAGGED_STONE_TILE_LIGHT)),
    DEFAULT_SAND(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.SAND)),
    DEFAULT_GRASS(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.OVERWORLD_GRASS_1)),
    DEFAULT_DIRT(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.DIRT)),
    DEFAULT_SNOW_1(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.SNOW_1)),
    DEFAULT_GRUNGE(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.GRUNGE)),
    DEFAULT_ROCKY_GROUND(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.ROCKY_CAVE_FLOOR)),
    LUMBRIDGE_CASTLE_TILE(56, Area.LUMBRIDGE_CASTLE_BASEMENT, GroundMaterial.MARBLE_2_SEMIGLOSS, p -> p.blended(false)),
    DRAYNOR_SEWERS(63, Area.DRAYNOR_SEWERS, GroundMaterial.DIRT),
    DRAYNOR_72(p -> p.ids(72).area(Area.DRAYNOR).groundMaterial(GroundMaterial.OVERWORLD_GRASS_1).seasonalReplacement(SeasonalTheme.WINTER, WINTER_GRASS)),
    WIZARD_TOWER_BASEMENT_DIRT(p -> p.ids(63, 66).area(Area.WIZARD_TOWER_BASEMENT).groundMaterial(GroundMaterial.DIRT)),
    COMPLEX_TILES_IMCANDO_PENINSULA(p -> p.ids(55, 61, 62, 63, 68).area(Area.IMCANDO_PENINSULA).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        if (hsl[1] == 0 || hsl[0] <= 10 && hsl[1] < 2) {
            switch (plugin.configSeasonalTheme) {
                case WINTER: {
                    return WINTER_GRUNGE;
                }
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRUNGE;
                }
            }
        }
        if (hsl[0] >= 11 && hsl[1] == 1 || hsl[0] == 9 && hsl[1] == 2 || hsl[0] == 9 && hsl[1] == 3 && hsl[2] >= 49 || hsl[0] >= 9 && hsl[1] >= 4 || hsl[0] >= 10 && hsl[1] >= 2) {
            switch (plugin.configSeasonalTheme) {
                case WINTER: {
                    return WINTER_GRASS;
                }
                case SUMMER: {
                    return DEFAULT_GRASS;
                }
            }
        }
        if (hsl[0] <= 8 && hsl[1] >= 4 && hsl[2] <= 71) {
            switch (plugin.configSeasonalTheme) {
                case WINTER: {
                    return WINTER_DIRT;
                }
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
            }
        }
        return DEFAULT_SAND;
    })),
    EDGEVILLE_PATH_OVERLAY_48(Area.EDGEVILLE_PATH_OVERLAY, GroundMaterial.VARROCK_PATHS, p -> p.blendedAsOpposite(true).hue(0).shiftLightness(8).saturation(0).ids(48, 50, 64).replacementResolver((plugin, scene, tile, override) -> {
        if (!plugin.configGroundBlending) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        } else if (plugin.configSeasonalTheme == SeasonalTheme.WINTER) {
            return WINTER_EDGEVILLE_PATH;
        }
        return override;
    })),
    VARROCK_JULIETS_HOUSE_UPSTAIRS(8, Area.VARROCK_JULIETS_HOUSE, GroundMaterial.NONE, p -> p.blended(false)),
    STRONGHOLD_OF_SECURITY_OOZE(Area.STRONGHOLD_OF_SECURITY_PESTILENCE, GroundMaterial.OOZE_FLOOR, p -> p.ids(48, 49, 61, 93)),
    STRONGHOLD_OF_SECURITY_GRASS(Area.STRONGHOLD_OF_SECURITY, GroundMaterial.GRASS_1, p -> p.ids(48, 49, 58, 59, 124)),
    STRONGHOLD_OF_SECURITY_WAR_GRAVEL(Area.STRONGHOLD_OF_SECURITY, GroundMaterial.GRAVEL, p -> p.ids(148)),
    STRONGHOLD_OF_SECURITY_FAMINE_DIRT(Area.STRONGHOLD_OF_SECURITY_FAMINE, GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.ids(72, 118, 126)),
    STRONGHOLD_OF_SECURITY_WAR_DIRT(Area.STRONGHOLD_OF_SECURITY_WAR, GroundMaterial.GRAVEL, p -> p.ids(72, 118, 126)),
    TOLNA_DUNGEON_ANGER_FLOOR(Area.TOLNA_DUNGEON_ANGER, GroundMaterial.DIRT, p -> p.ids(58, 58)),
    WARRIORS_GUILD_FLOOR_1(Area.WARRIORS_GUILD, GroundMaterial.VARROCK_PATHS, p -> p.ids(55, 56)),
    TROLLHEIM_DIRT(p -> p.ids(63, 67).area(Area.TROLLHEIM).groundMaterial(GroundMaterial.DIRT)),
    WEISS_UNDERGROUND_DIRT(94, Area.WEISS_UNDERGROUND, GroundMaterial.EARTHEN_CAVE_FLOOR),
    WEISS_SALTMINE_GROUND(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.ids(157, 158).area(Area.WEISS_SALT_MINE)),
    CATHERBY_BEACH_SAND(p -> p.ids(62).area(Area.CATHERBY).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        LocalPoint localLocation = tile.getLocalLocation();
        short overlayId = scene.getOverlayIds()[tile.getRenderLevel()][localLocation.getSceneX()][localLocation.getSceneY()];
        if (hsl[0] >= 9) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        if (hsl[0] == 8 && hsl[1] > 5 && overlayId != 6) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        if (hsl[0] < 8 && hsl[1] > 4 && hsl[2] < 45 && overlayId != 6) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        return DEFAULT_SAND;
    })),
    MAGE_TRAINING_ARENA_FLOOR_PATTERN(56, Area.MAGE_TRAINING_ARENA, GroundMaterial.TILES_2X2_2_GLOSS, p -> p.blended(false)),
    PVP_ARENA_PITFLOOR_SAND_REMOVAL(GroundMaterial.DIRT, p -> p.area(Area.PVP_ARENA).ids(66, 68)),
    DESERT_TREASURE_INTERIOR_FLOOR(GroundMaterial.SANDY_STONE_FLOOR, p -> p.area(Area.DESERT_TREASURE_PYRAMID).ids(61, 64)),
    RIVER_ELID_WATERFALL(p -> p.area(Area.RIVER_ELID_WATERFALL).waterType(WaterType.WATER).blended(false)),
    SOPHANEM_TRAPDOOR(Area.SOPHANEM_TRAPDOOR, GroundMaterial.NONE, p -> {}),
    KHARID_SAND_1(Area.KHARID_DESERT_REGION, GroundMaterial.SAND, p -> p.saturation(3).hue(6).ids(-127, 45, 49, 50, 58, 61, 62, 63, 64, 67, 68, 69, 126)),
    NECROPOLIS_SAND(Area.NECROPOLIS, GroundMaterial.DIRT, p -> p.ids(124)),
    SMOKE_DUNGEON(Area.SMOKE_DUNGEON, GroundMaterial.ROCKY_CAVE_FLOOR, p -> p.ids(56)),
    GAMES_ROOM_INNER_FLOOR(64, Area.GAMES_ROOM_INNER, GroundMaterial.CARPET, p -> p.blended(false)),
    GAMES_ROOM_FLOOR(64, Area.GAMES_ROOM, GroundMaterial.WOOD_PLANKS_1, p -> p.blended(false)),
    KARAMJA_VOCALNO_ROCK(p -> p.ids(55, 63, 72).area(Area.KARAMJA_VOLCANO).groundMaterial(GroundMaterial.EARTHEN_CAVE_FLOOR)),
    COMPLEX_TILES_KARAMJA(p -> p.ids(50, 55, 61, 62, 63, 68).area(Area.KARAMJA).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        LocalPoint localLocation = tile.getLocalLocation();
        short overlayId = scene.getOverlayIds()[tile.getRenderLevel()][localLocation.getSceneX()][localLocation.getSceneY()];
        if (hsl[0] >= 13 || hsl[0] >= 10 && hsl[1] >= 3 || hsl[0] == 9 && hsl[1] >= 4 || hsl[0] == 9 && hsl[1] == 3 && hsl[2] <= 45 || hsl[0] == 8 && hsl[1] > 5 && hsl[2] >= 30 && overlayId != 6) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        if (hsl[0] <= 8 && hsl[1] >= 4 && hsl[2] <= 71 || hsl[0] == 9 && hsl[1] == 2 && hsl[2] <= 44 || hsl[0] == 8 && hsl[1] == 3 && hsl[2] <= 34) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        if (hsl[0] < 13 && hsl[1] <= 2 && hsl[2] <= 40) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRUNGE;
                }
                case WINTER: {
                    return WINTER_GRUNGE;
                }
            }
        }
        return DEFAULT_SAND;
    })),
    CRANDOR_SAND(-110, Area.CRANDOR, GroundMaterial.SAND, p -> p.saturation(3).hue(6)),
    GOD_WARS_DUNGEON_SNOW_1(Area.GOD_WARS_DUNGEON, GroundMaterial.SNOW_1, p -> p.ids(58, 59)),
    INFERNO_1(Area.THE_INFERNO, GroundMaterial.VARIED_DIRT, p -> p.ids(-118, 61, -115, -111, -110, 1, 61, 62, 72, 118, 122)),
    TZHAAR(72, Area.TZHAAR, GroundMaterial.VARIED_DIRT_SHINY, p -> p.shiftLightness(2)),
    VER_SINHAZA_WATER_FIX(p -> p.ids(54).area(Area.VER_SINHAZA_WATER_FIX).waterType(WaterType.WATER).blended(false)),
    MEIYERDITCH_MINES(111, Area.MEIYERDITCH_MINES, GroundMaterial.ROCKY_CAVE_FLOOR),
    BARROWS_DIRT(GroundMaterial.DIRT, p -> p.ids(96).area(Area.BARROWS).seasonalReplacement(SeasonalTheme.WINTER, WINTER_DIRT)),
    BARROWS_CRYPT_FLOOR(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.ids(96, 103).area(Area.BARROWS_CRYPTS)),
    BARROWS_TUNNELS_FLOOR(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.ids(96, 103).area(Area.BARROWS_TUNNELS)),
    TEMPLE_TREKKING_GROUND_COMPLEX(p -> p.ids(48, 53, 54, 64, 103).area(Area.TEMPLE_TREKKING_INSTANCES).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        if (hsl[0] <= 8 && hsl[1] <= 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        if (hsl[0] >= 9 && hsl[1] >= 3) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        return DEFAULT_DIRT;
    })),
    COMPLEX_TILES_ISLE_OF_STONE(p -> p.ids(58, 97, 112).area(Area.ISLAND_OF_STONE).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        if (hsl[0] == 7 && hsl[1] >= 1 && hsl[2] <= 71) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        if (hsl[0] < 13 && hsl[1] == 0 && hsl[2] <= 40) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_ROCKY_GROUND;
                }
                case WINTER: {
                    return WINTER_GRUNGE;
                }
            }
        }
        return DEFAULT_SNOW_1;
    })),
    FREMENNIK_SLAYER_DUNGEON(p -> p.ids(48, 63, 92).area(Area.FREMENNIK_SLAYER_DUNGEON).groundMaterial(GroundMaterial.EARTHEN_CAVE_FLOOR)),
    SHADOW_DUNGEON_FLOOR(63, Area.SHADOW_DUNGEON, GroundMaterial.EARTHEN_CAVE_FLOOR),
    WITCHAVEN_DIRT(p -> p.ids(50).area(Area.WITCHAVEN).groundMaterial(GroundMaterial.VARIED_DIRT).seasonalReplacement(SeasonalTheme.WINTER, WINTER_DIRT)),
    WITCHAVEN_COMPLEX(p -> p.area(Area.WITCHAVEN).ids(94, 129).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        if (hsl[1] == 0 || hsl[0] <= 10 && hsl[1] < 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRUNGE;
                }
                case WINTER: {
                    return WINTER_GRUNGE;
                }
            }
        }
        if (hsl[0] == 8 && hsl[1] == 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_SAND;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        if (hsl[0] >= 10 && hsl[1] >= 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        if (hsl[0] == 8 && hsl[1] == 3 || hsl[0] == 8 && hsl[1] == 4 || hsl[0] == 9 && hsl[1] == 2 || hsl[0] == 9 && hsl[1] <= 4) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        return DEFAULT_DIRT;
    })),
    CENTER_SARADOMIN_SIDE_DIRT_1(98, Area.CASTLE_WARS_ARENA_SARADOMIN_SIDE, GroundMaterial.DIRT, p -> p.hue(7).saturation(4)),
    CENTER_SARADOMIN_SIDE_DIRT_2(56, Area.CASTLE_WARS_ARENA_SARADOMIN_SIDE, GroundMaterial.DIRT, p -> p.hue(7).saturation(4).shiftLightness(3)),
    YANILLE_AGILITY_DUNGEON_ENTRANCE_FIX(63, Area.YANILLE_AGILITY_DUNGEON_ENTRANCE, GroundMaterial.NONE, p -> p.blended(false)),
    FELDIP_HILLS_COMPLEX_TILES(p -> p.area(Area.FELDIP_HILLS).ids(48, 50, 52, 62, 63, 67, 68, 69, 70, 97, 99, 100).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        if (hsl[1] == 0) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRUNGE;
                }
                case WINTER: {
                    return WINTER_GRUNGE;
                }
            }
        }
        if (hsl[0] <= 10 && hsl[1] < 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRUNGE;
                }
                case WINTER: {
                    return WINTER_GRUNGE;
                }
            }
        }
        if (hsl[0] == 8 && hsl[1] == 4 && hsl[2] >= 71 || hsl[0] == 8 && hsl[1] == 3 && hsl[2] >= 21) {
            return DEFAULT_SAND;
        }
        if (hsl[0] >= 11 && hsl[1] == 1 || hsl[0] >= 9 && hsl[1] >= 4 || hsl[0] >= 10 && hsl[1] >= 2 || hsl[0] == 8 && hsl[1] == 5 && hsl[2] >= 15 || hsl[0] == 8 && hsl[1] >= 6 && hsl[2] >= 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        if (hsl[0] == 8 && hsl[1] <= 4 && hsl[2] <= 71 || hsl[0] <= 7 && hsl[1] <= 5 && hsl[2] <= 57 || hsl[0] <= 7 && hsl[1] <= 7 && hsl[2] <= 28 || hsl[0] == 8 && hsl[1] == 5 && hsl[2] <= 15 || hsl[0] == 9 && hsl[1] >= 2 && hsl[1] <= 4) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        return DEFAULT_DIRT;
    })),
    ICEBERG_TEXTURE(p -> p.area(Area.ICEBERG).groundMaterial(GroundMaterial.SNOW_2).ids(59).shiftLightness(5)),
    ZEAH_DIRT(p -> p.area(Area.ZEAH).groundMaterial(GroundMaterial.VARIED_DIRT).ids(19, 148, 149).seasonalReplacement(SeasonalTheme.WINTER, WINTER_DIRT)),
    ZEAH_GRAVEL_HILLS(p -> p.area(Area.ZEAH).groundMaterial(GroundMaterial.GRAVEL).ids(99).seasonalReplacement(SeasonalTheme.WINTER, WINTER_GRUNGE)),
    ZEAH_ROCKY_GROUND(p -> p.area(Area.ZEAH).groundMaterial(GroundMaterial.ROCKY_CAVE_FLOOR).ids(27, 29, 129).seasonalReplacement(SeasonalTheme.WINTER, WINTER_GRUNGE)),
    STRANGLEWOOD_SNOW_DARK(p -> p.area(Area.THE_STRANGLEWOOD_EXTENDED).ids(174).groundMaterial(GroundMaterial.SNOW_1)),
    JUDGE_OF_YAMA_BOSS_WATER(p -> p.ids(72, 76).area(Area.JUDGE_OF_YAMA_BOSS).waterType(WaterType.WATER)),
    JUDGE_OF_YAMA_BOSS_BLACK_TILES(p -> p.ids(150).area(Area.JUDGE_OF_YAMA_BOSS).groundMaterial(GroundMaterial.TRANSPARENT)),
    ZANARIS_GRASS(Area.ZANARIS, GroundMaterial.GRASS_1, p -> p.ids(143, 144)),
    ZANARIS_DIRTS(Area.ZANARIS, GroundMaterial.VARIED_DIRT, p -> p.ids(66, 67)),
    COSMIC_ENTITYS_PLANE_ABYSS(Area.COSMIC_ENTITYS_PLANE, GroundMaterial.NONE, p -> p.lightness(0).blended(false).ids(2, 72)),
    ICE_QUEENS_DUNGEON_UNDERLAY(Area.ICE_QUEENS_DUNGEON, GroundMaterial.SNOW_1, p -> p.ids(58).lightness(100).hue(0).saturation(0)),
    TAVERLY_DUNGEON_DIRT(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.TAVERLEY_DUNGEON).ids(50, 63, 64, 66, 67)),
    TAVERLY_DUNGEON_BLACK_KNIGHTS_BASE(GroundMaterial.MARBLE_1_SEMIGLOSS, p -> p.area(Area.TAVERLEY_DUNGEON).ids(56, 57)),
    HEROES_GUILD_BASEMENT_CAVE(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.HEROES_GUILD_BASEMENT).ids(63)),
    HEROES_GUILD_BASEMENT_GRASS(GroundMaterial.GRASS_1, p -> p.area(Area.HEROES_GUILD_BASEMENT).ids(48, 49, 50)),
    DWARVEN_MINE_DUNGEON(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.DWARVEN_MINE_DUNGEON).ids(63, 64, 66)),
    MOTHERLODE_MINE(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.MOTHERLODE_MINE).ids(63, 64, 71)),
    GIANTS_FOUNDRY(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.GIANTS_FOUNDRY).ids(91, 101)),
    MEIYERDITCH_MYREQUE_HIDEOUT(GroundMaterial.VARIED_DIRT, p -> p.area(Area.MEIYERDITCH_MYREQUE_HIDEOUT).ids(96, 103)),
    GOBLIN_VILLAGE_TILES_BLEND_FIX(Area.GOBLIN_VILLAGE_COOKS_CHAMBER, GroundMaterial.WORN_TILES, p -> p.ids(56, 57).blended(true)),
    GOBLIN_VILLAGE_TILES(Area.GOBLIN_VILLAGE_COOKS_CHAMBER, GroundMaterial.WORN_TILES, p -> p.ids(56, 57).blended(false)),
    GOBLIN_VILLAGE_COOKS_PIT(118, Area.GOBLIN_VILLAGE_COOKS_CHAMBER, GroundMaterial.VARIED_DIRT_SHINY),
    KEEP_LE_FAYE_JAIL_FLOOR_FIX(58, Area.KEEP_LE_FAYE_JAIL, GroundMaterial.PACKED_EARTH),
    PENGUIN_BASE_FLOOR(p -> p.area(Area.PENGUIN_BASE).groundMaterial(GroundMaterial.ICE_4).ids(59)),
    DEATHS_OFFICE_TILE(-110, Area.DEATHS_OFFICE, GroundMaterial.TILES_2X2_1_SEMIGLOSS),
    COX_SNOW_1(16, Area.CHAMBERS_OF_XERIC_ICE_DEMON, GroundMaterial.SNOW_1),
    COX_SNOW_2(59, Area.CHAMBERS_OF_XERIC_ICE_DEMON, GroundMaterial.SNOW_2),
    TOA_CRONDIS_ISLAND(Area.TOA_PATH_OF_CRONDIS_BOSS, GroundMaterial.SAND, p -> p.ids(109, 117)),
    TOA_CRONDIS_WATER_GREEN(p -> p.ids(133, 134).area(Area.TOA_CRONDIS_WATER).waterType(WaterType.POISON_WASTE).blended(false)),
    TOA_CRONDIS_WATER_BLUE(p -> p.area(Area.TOA_CRONDIS_WATER).waterType(WaterType.WATER).blended(false)),
    MAGE_ARENA_BANK_FLOOR(p -> p.ids(55, 56, 57).area(Area.MAGE_ARENA_BANK).groundMaterial(GroundMaterial.STONE_CAVE_FLOOR)),
    MAGE_ARENA_STATUE_ROOM_FLOOR(p -> p.ids(55, 56, 57).area(Area.MAGE_ARENA_GOD_STATUES).groundMaterial(GroundMaterial.STONE_CAVE_FLOOR)),
    MIND_ALTAR_TILE(55, Area.MIND_ALTAR, GroundMaterial.MARBLE_1_SEMIGLOSS, p -> p.blended(false)),
    TEMPLE_OF_THE_EYE_CENTER_PLATFORM_DIRT(p -> p.ids(60).area(Area.TEMPLE_OF_THE_EYE_CENTER_PLATFORM).groundMaterial(GroundMaterial.VARIED_DIRT_SHINY).hue(4).saturation(1).lightness(64)),
    TEMPLE_OF_THE_EYE_DIRT(p -> p.ids(60).area(Area.TEMPLE_OF_THE_EYE).groundMaterial(GroundMaterial.VARIED_DIRT_SHINY)),
    TEMPLE_OF_THE_EYE_ROCK_SHADE_FIX(p -> p.ids(new Integer[0]).area(Area.TEMPLE_OF_THE_EYE_ENTRANCE_BRIGHTNESS_FIX).groundMaterial(GroundMaterial.TEMPLE_OF_THE_EYE_FLOOR).lightness(38)),
    TEMPLE_OF_THE_EYE_ROCK_SHADE_FIX_TOGGLE(p -> p.ids(87, 88).area(Area.TEMPLE_OF_THE_EYE_ENTRANCE_BRIGHTNESS_FIX).groundMaterial(GroundMaterial.TEMPLE_OF_THE_EYE_FLOOR).replaceWithIf(TEMPLE_OF_THE_EYE_ROCK_SHADE_FIX, plugin -> plugin.configGroundBlending)),
    TEMPLE_OF_THE_EYE_ROCK(p -> p.ids(87, 88, 89).area(Area.TEMPLE_OF_THE_EYE).groundMaterial(GroundMaterial.TEMPLE_OF_THE_EYE_FLOOR)),
    ARCEUUS_GROUND(Area.ARCEUUS, GroundMaterial.DIRT, p -> p.ids(2, 3, 21, 23, 24, 27).seasonalReplacement(SeasonalTheme.WINTER, WINTER_DIRT)),
    ARCEUUS_GRASS(Area.ARCEUUS, GroundMaterial.GRASSY_DIRT, p -> p.ids(17, 95).seasonalReplacement(SeasonalTheme.WINTER, WINTER_GRASS)),
    ICY_UNDERGROUND_SNOW(p -> p.area(Area.ICY_UNDERGROUND_DARK).ids(159).groundMaterial(GroundMaterial.SNOW_1)),
    LASSAR_UNDERCITY_SUNKEN_CATHEDRAL(p -> p.ids(44, 45, 104, 181, 182).area(Area.LASSAR_UNDERCITY_SUNKEN_CATHEDRAL).groundMaterial(GroundMaterial.LASSAR_UNDERCITY_TILES_SUBMERGED)),
    LASSAR_UNDERCITY_WATER(p -> p.ids(292).area(Area.LASSAR_UNDERCITY_WATER).waterType(WaterType.PLAIN_WATER).blended(false)),
    LASSAR_UNDERCITY_MARBLE(p -> p.ids(45, 104).area(Area.LASSAR_UNDERCITY).groundMaterial(GroundMaterial.MARBLE_2_SEMIGLOSS)),
    LASSAR_UNDERCITY_TILES(p -> p.ids(182).area(Area.LASSAR_UNDERCITY).groundMaterial(GroundMaterial.LASSAR_UNDERCITY_TILES).blended(false)),
    LASSAR_UNDERCITY_TILES_BLENDED(p -> p.ids(46, 150).area(Area.LASSAR_UNDERCITY).groundMaterial(GroundMaterial.LASSAR_UNDERCITY_TILES).blended(true)),
    SHIP_SAILING_WATER(p -> p.area(Area.SHIP_SAILING).ids(75).waterType(WaterType.WATER_FLAT)),
    GIANT_MOLE_LAIR_DIRT(p -> p.ids(63, 65).area(Area.GIANT_MOLE_LAIR).groundMaterial(GroundMaterial.VARIED_DIRT)),
    CANOE_CUTSCENE_GRASS(Area.CANOE_CUTSCENE, GroundMaterial.GRASS_SCROLLING, p -> p.ids(48, 50, 63)),
    TILE_NEEDS_HUE_DEFINED(Area.OVERWORLD, GroundMaterial.VARIED_DIRT, p -> p.ids(26).seasonalReplacement(SeasonalTheme.WINTER, WINTER_DIRT)),
    OVERWORLD_GRASS(Area.OVERWORLD, GroundMaterial.OVERWORLD_GRASS_1, p -> p.ids(7, 25, 33, 34, 40, 48, 49, 50, 51, 52, 53, 54, 67, 70, 71, 75, 93, 97, 99, 100, 103, 114, 115, 126).seasonalReplacement(SeasonalTheme.WINTER, WINTER_GRASS)),
    OVERWORLD_DIRT(Area.OVERWORLD, GroundMaterial.DIRT, p -> p.ids(-111, -110, 19, 56, 57, 66, 80, 111, 118, 122, 139, 149, 150).seasonalReplacement(SeasonalTheme.WINTER, WINTER_DIRT)),
    OVERWORLD_SAND(Area.OVERWORLD, GroundMaterial.SAND, p -> p.ids(-127, -118)),
    UNDERLAY_PACKED_EARTH(GroundMaterial.PACKED_EARTH, p -> p.ids(15)),
    UNDERLAY_SNOW(p -> p.ids(16, 55, 58, 59, 92).area(Area.SNOW_REGIONS).groundMaterial(GroundMaterial.SNOW_1).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        if (hsl[1] >= 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: {
                    return OVERWORLD_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        if (hsl[1] == 1) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return OVERWORLD_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        return DEFAULT_SNOW_1;
    })),
    UNDERLAY_OVERWORLD_DIRT(GroundMaterial.VARIED_DIRT, p -> p.area(Area.OVERWORLD).ids(72, 73, 98, 112, 113).seasonalReplacement(SeasonalTheme.WINTER, WINTER_DIRT)),
    UNDERLAY_DIRT(GroundMaterial.VARIED_DIRT, p -> p.ids(72, 73, 98, 112, 113)),
    UNDERLAY_OVERWORLD_GRUNGE(GroundMaterial.GRUNGE, p -> p.area(Area.OVERWORLD).ids(8, 10, 58, 60, 92).seasonalReplacement(SeasonalTheme.WINTER, WINTER_GRUNGE)),
    UNDERLAY_GRUNGE(GroundMaterial.GRUNGE, p -> p.ids(8, 10, 58, 60, 92)),
    COMPLEX_TILES(p -> p.area(Area.OVERWORLD).ids(13, 55, 61, 62, 63, 64, 65, 68, 69, 94, 96).replacementResolver((plugin, scene, tile, override) -> {
        int[] hsl = HDUtils.getSouthWesternMostTileColor(tile);
        if (hsl == null) {
            return override;
        }
        if (hsl[1] == 0) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return UNDERLAY_OVERWORLD_GRUNGE;
                }
                case WINTER: {
                    return WINTER_GRUNGE;
                }
            }
        }
        if (hsl[0] <= 10 && hsl[1] < 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return UNDERLAY_OVERWORLD_GRUNGE;
                }
                case WINTER: {
                    return WINTER_GRUNGE;
                }
            }
        }
        if (hsl[0] == 8 && hsl[1] == 4 && hsl[2] >= 71 || hsl[0] == 8 && hsl[1] == 3 && hsl[2] >= 48) {
            return DEFAULT_SAND;
        }
        if (hsl[0] >= 11 && hsl[1] == 1 || hsl[0] == 9 && hsl[1] == 2 || hsl[0] == 9 && hsl[1] == 3 && hsl[2] >= 49 || hsl[0] >= 9 && hsl[1] >= 4 || hsl[0] == 9 && hsl[1] == 3 && hsl[2] <= 38 || hsl[0] >= 10 && hsl[1] >= 2 || hsl[0] == 8 && hsl[1] == 5 && hsl[2] >= 15 || hsl[0] == 8 && hsl[1] >= 6 && hsl[2] >= 2) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_GRASS;
                }
                case WINTER: {
                    return WINTER_GRASS;
                }
            }
        }
        if (hsl[0] == 8 && hsl[1] <= 4 && hsl[2] <= 71 || hsl[0] <= 7 && hsl[1] <= 5 && hsl[2] <= 57 || hsl[0] <= 7 && hsl[1] <= 7 && hsl[2] <= 28 || hsl[0] == 8 && hsl[1] == 5 && hsl[2] <= 15) {
            switch (plugin.configSeasonalTheme) {
                case SUMMER: 
                case AUTUMN: {
                    return DEFAULT_DIRT;
                }
                case WINTER: {
                    return WINTER_DIRT;
                }
            }
        }
        return DEFAULT_DIRT;
    })),
    NONE(GroundMaterial.DIRT, p -> {});

    private static final Logger log;
    @Nullable
    public final Integer[] filterIds;
    public final Area area;
    public final GroundMaterial groundMaterial;
    public final WaterType waterType;
    public final boolean blended;
    public final boolean blendedAsOverlay;
    public final int hue;
    public final int shiftHue;
    public final int saturation;
    public final int shiftSaturation;
    public final int lightness;
    public final int shiftLightness;
    public final TileOverrideResolver<Underlay> replacementResolver;
    private static final Underlay[] ANY_MATCH;
    private static final HashMap<Integer, Underlay[]> FILTERED_MAP;

    private Underlay(int id, Area area, GroundMaterial material) {
        this(p -> p.ids(id).groundMaterial(material).area(area));
    }

    private Underlay(int id, Area area, GroundMaterial material, Consumer<TileOverrideBuilder<Underlay>> consumer) {
        this(p -> p.ids(id).groundMaterial(material).area(area).apply(consumer));
    }

    private Underlay(GroundMaterial material, Consumer<TileOverrideBuilder<Underlay>> consumer) {
        this(p -> p.groundMaterial(material).apply(consumer));
    }

    private Underlay(Area area, GroundMaterial material, Consumer<TileOverrideBuilder<Underlay>> consumer) {
        this(p -> p.groundMaterial(material).area(area).apply(consumer));
    }

    private Underlay(Consumer<TileOverrideBuilder<Underlay>> consumer) {
        TileOverrideBuilder builder = new TileOverrideBuilder();
        consumer.accept(builder);
        this.filterIds = builder.ids;
        this.area = builder.area;
        this.groundMaterial = builder.groundMaterial;
        this.waterType = builder.waterType;
        this.blended = builder.blended;
        this.blendedAsOverlay = builder.blendedAsOpposite;
        this.hue = builder.hue;
        this.shiftHue = builder.shiftHue;
        this.saturation = builder.saturation;
        this.shiftSaturation = builder.shiftSaturation;
        this.lightness = builder.lightness;
        this.shiftLightness = builder.shiftLightness;
        this.replacementResolver = builder.replacementResolver;
    }

    @NonNull
    public static Underlay getUnderlay(Scene scene, Tile tile, HdPlugin plugin) {
        return Underlay.getUnderlayBeforeReplacements(scene, tile).resolveReplacements(scene, tile, plugin);
    }

    @NonNull
    public static Underlay getUnderlayBeforeReplacements(Scene scene, Tile tile) {
        short underlayId;
        Underlay[] underlays;
        LocalPoint localLocation = tile.getLocalLocation();
        int[] worldPoint = HDUtils.localToWorld(scene, localLocation.getX(), localLocation.getY(), tile.getRenderLevel());
        Underlay match = NONE;
        for (Underlay underlay : ANY_MATCH) {
            if (!underlay.area.containsPoint(worldPoint)) continue;
            match = underlay;
            break;
        }
        if ((underlays = FILTERED_MAP.get(underlayId = scene.getUnderlayIds()[tile.getRenderLevel()][localLocation.getSceneX()][localLocation.getSceneY()])) != null) {
            for (Underlay underlay : underlays) {
                if (underlay.ordinal() >= match.ordinal()) break;
                if (!underlay.area.containsPoint(worldPoint)) continue;
                match = underlay;
                break;
            }
        }
        return match;
    }

    public Underlay resolveReplacements(Scene scene, Tile tile, HdPlugin plugin) {
        if (this.replacementResolver != null) {
            Underlay replacement = this.replacementResolver.resolve(plugin, scene, tile, this);
            if (replacement == null) {
                replacement = NONE;
            }
            return replacement;
        }
        return this;
    }

    public int modifyColor(int jagexHsl) {
        int h = this.hue != -1 ? this.hue : jagexHsl >> 10 & 0x3F;
        h += this.shiftHue;
        h = HDUtils.clamp(h, 0, 63);
        int s = this.saturation != -1 ? this.saturation : jagexHsl >> 7 & 7;
        s += this.shiftSaturation;
        s = HDUtils.clamp(s, 0, 7);
        int l = this.lightness != -1 ? this.lightness : jagexHsl & 0x7F;
        l += this.shiftLightness;
        l = HDUtils.clamp(l, 0, 127);
        return h << 10 | s << 7 | l;
    }

    static {
        log = LoggerFactory.getLogger(Underlay.class);
        FILTERED_MAP = new HashMap();
        ArrayList<Underlay> anyMatch = new ArrayList<Underlay>();
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        for (Underlay underlay : Underlay.values()) {
            if (underlay.filterIds == null) {
                anyMatch.add(underlay);
                continue;
            }
            for (Integer id : underlay.filterIds) {
                multiMap.put((Object)id, (Object)underlay);
            }
        }
        ANY_MATCH = anyMatch.toArray(new Underlay[0]);
        for (Map.Entry entry : multiMap.asMap().entrySet()) {
            FILTERED_MAP.put((Integer)entry.getKey(), ((Collection)entry.getValue()).toArray(new Underlay[0]));
        }
    }
}

