/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data.materials;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import rs117.hd.HdPlugin;
import rs117.hd.config.SeasonalTheme;
import rs117.hd.data.WaterType;
import rs117.hd.data.environments.Area;
import rs117.hd.data.materials.GroundMaterial;
import rs117.hd.data.materials.TileOverrideResolver;

class TileOverrideBuilder<T> {
    public Integer[] ids = null;
    public Area area = Area.ALL;
    public GroundMaterial groundMaterial = GroundMaterial.NONE;
    public WaterType waterType = WaterType.NONE;
    public boolean blended = true;
    public boolean blendedAsOpposite = false;
    public int hue = -1;
    public int shiftHue = 0;
    public int saturation = -1;
    public int shiftSaturation = 0;
    public int lightness = -1;
    public int shiftLightness = 0;
    public TileOverrideResolver<T> replacementResolver;

    TileOverrideBuilder() {
    }

    TileOverrideBuilder<T> apply(Consumer<TileOverrideBuilder<T>> consumer) {
        consumer.accept(this);
        return this;
    }

    TileOverrideBuilder<T> ids(Integer ... ids) {
        if (this.ids != null && this.ids.length > 0) {
            throw new IllegalStateException("Attempted to overwrite IDs " + Arrays.toString((Object[])this.ids) + " with IDs " + Arrays.toString((Object[])ids) + " in " + TileOverrideBuilder.class.getSimpleName() + ".This is likely a mistake.");
        }
        this.ids = ids;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] >= 0) continue;
            Integer[] integerArray = ids;
            int n = i;
            Integer.valueOf(integerArray[n] & 0xFF);
        }
        return this;
    }

    TileOverrideBuilder<T> waterType(WaterType waterType) {
        this.waterType = waterType;
        this.groundMaterial = GroundMaterial.NONE;
        return this;
    }

    TileOverrideBuilder<T> replaceWithIf(T replacement, @Nonnull Function<HdPlugin, Boolean> condition) {
        TileOverrideResolver previousResolver = this.replacementResolver;
        this.replacementResolver = (plugin, scene, tile, override) -> {
            if (((Boolean)condition.apply(plugin)).booleanValue()) {
                return replacement;
            }
            if (previousResolver != null) {
                return previousResolver.resolve(plugin, scene, tile, override);
            }
            return override;
        };
        return this;
    }

    TileOverrideBuilder<T> seasonalReplacement(SeasonalTheme seasonalTheme, T replacement) {
        return this.replaceWithIf(replacement, plugin -> plugin.configSeasonalTheme == seasonalTheme);
    }

    TileOverrideBuilder<T> resolver(@Nonnull TileOverrideResolver<T> resolver) {
        this.replacementResolver = resolver;
        return this;
    }

    public TileOverrideBuilder<T> area(Area area) {
        this.area = area;
        return this;
    }

    public TileOverrideBuilder<T> groundMaterial(GroundMaterial groundMaterial) {
        this.groundMaterial = groundMaterial;
        return this;
    }

    public TileOverrideBuilder<T> blended(boolean blended) {
        this.blended = blended;
        return this;
    }

    public TileOverrideBuilder<T> blendedAsOpposite(boolean blendedAsOpposite) {
        this.blendedAsOpposite = blendedAsOpposite;
        return this;
    }

    public TileOverrideBuilder<T> hue(int hue) {
        this.hue = hue;
        return this;
    }

    public TileOverrideBuilder<T> shiftHue(int shiftHue) {
        this.shiftHue = shiftHue;
        return this;
    }

    public TileOverrideBuilder<T> saturation(int saturation) {
        this.saturation = saturation;
        return this;
    }

    public TileOverrideBuilder<T> shiftSaturation(int shiftSaturation) {
        this.shiftSaturation = shiftSaturation;
        return this;
    }

    public TileOverrideBuilder<T> lightness(int lightness) {
        this.lightness = lightness;
        return this;
    }

    public TileOverrideBuilder<T> shiftLightness(int shiftLightness) {
        this.shiftLightness = shiftLightness;
        return this;
    }

    public TileOverrideBuilder<T> replacementResolver(TileOverrideResolver<T> replacementResolver) {
        this.replacementResolver = replacementResolver;
        return this;
    }
}

