/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data.materials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import net.runelite.api.Texture;
import rs117.hd.HdPlugin;
import rs117.hd.config.SeasonalTheme;
import rs117.hd.utils.ColorUtils;

public final class Material
extends Enum<Material> {
    public static final /* enum */ Material NONE = new Material();
    public static final /* enum */ Material VANILLA = new Material(NONE, p -> p.setHasTransparency(true));
    public static final /* enum */ Material UNLIT = new Material(NONE, p -> p.setUnlit(true));
    public static final /* enum */ Material TRANSPARENT = new Material();
    public static final /* enum */ Material LAVA_FLOW_MAP = new Material();
    public static final /* enum */ Material WATER_FLOW_MAP = new Material();
    public static final /* enum */ Material UNDERWATER_FLOW_MAP = new Material();
    public static final /* enum */ Material CAUSTICS_MAP = new Material();
    public static final /* enum */ Material WATER_NORMAL_MAP_1 = new Material();
    public static final /* enum */ Material WATER_NORMAL_MAP_2 = new Material();
    public static final /* enum */ Material WATER_FOAM = new Material();
    public static final /* enum */ Material WOODEN_DOOR_HANDLE = new Material(0);
    public static final /* enum */ Material WATER_FLAT = new Material(1);
    public static final /* enum */ Material BRICK = new Material(2);
    public static final /* enum */ Material WOOD_PLANKS_1 = new Material(3, p -> p.setSpecular(0.35f, 30.0f));
    public static final /* enum */ Material LARGE_DOOR = new Material(4);
    public static final /* enum */ Material DARK_WOOD = new Material(5);
    public static final /* enum */ Material ROOF_SHINGLES_1 = new Material(6, p -> p.setSpecular(0.5f, 30.0f));
    public static final /* enum */ Material WOODEN_SCREEN = new Material(7, p -> p.setHasTransparency(true));
    public static final /* enum */ Material LEAVES_SIDE = new Material(8, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f));
    public static final /* enum */ Material TREE_RINGS = new Material(9, p -> p.setHasTransparency(true));
    public static final /* enum */ Material MOSS_BRANCH = new Material(10);
    public static final /* enum */ Material CONCRETE = new Material(11);
    public static final /* enum */ Material IRON_BARS = new Material(12, p -> p.setHasTransparency(true));
    public static final /* enum */ Material PAINTING_LANDSCAPE = new Material(13);
    public static final /* enum */ Material PAINTING_KING = new Material(14);
    public static final /* enum */ Material MARBLE_DARK = new Material(15, p -> p.setSpecular(1.1f, 380.0f));
    public static final /* enum */ Material SIMPLE_GRAIN_WOOD = new Material(16);
    public static final /* enum */ Material WATER_DROPLETS = new Material(17, p -> p.setHasTransparency(true));
    public static final /* enum */ Material HAY = new Material(18);
    public static final /* enum */ Material NET = new Material(19, p -> p.setHasTransparency(true));
    public static final /* enum */ Material BOOKCASE = new Material(20);
    public static final /* enum */ Material ROOF_WOODEN_SLATE = new Material(21, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CRATE = new Material(22, p -> p.setSpecular(0.35f, 30.0f));
    public static final /* enum */ Material BRICK_BROWN = new Material(23);
    public static final /* enum */ Material WATER_FLAT_2 = new Material(24);
    public static final /* enum */ Material SWAMP_WATER_FLAT = new Material(25);
    public static final /* enum */ Material WEB = new Material(26, p -> p.setHasTransparency(true));
    public static final /* enum */ Material ROOF_SLATE = new Material(27);
    public static final /* enum */ Material MOSS = new Material(28, p -> p.setHasTransparency(true));
    public static final /* enum */ Material TROPICAL_LEAF = new Material(29, p -> p.setBrightness(0.5f).setHasTransparency(true));
    public static final /* enum */ Material WILLOW_LEAVES = new Material(30, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.0f));
    public static final /* enum */ Material LAVA = new Material(31, p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.05f, 36.0f, 22.0f).setScroll(0.0f, 0.33333334f));
    public static final /* enum */ Material TREE_DOOR_BROWN = new Material(32);
    public static final /* enum */ Material MAPLE_LEAVES = new Material(33, p -> p.setHasTransparency(true).setTextureScale(1.3f, 1.025f));
    public static final /* enum */ Material MAGIC_STARS = new Material(34, p -> p.setHasTransparency(true).setUnlit(true).setOverrideBaseColor(true));
    public static final /* enum */ Material SAND_BRICK = new Material(35);
    public static final /* enum */ Material DOOR_TEXTURE = new Material(36);
    public static final /* enum */ Material BLADE = new Material(37);
    public static final /* enum */ Material SANDSTONE = new Material(38);
    public static final /* enum */ Material PAINTING_ELF = new Material(39);
    public static final /* enum */ Material FIRE_CAPE = new Material(40, p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.05f, 12.0f, 4.0f).setScroll(0.0f, -0.33333334f));
    public static final /* enum */ Material LEAVES_DISEASED = new Material(41, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f));
    public static final /* enum */ Material MARBLE = new Material(42, p -> p.setSpecular(1.0f, 400.0f));
    public static final /* enum */ Material CLEAN_TILE = new Material(43);
    public static final /* enum */ Material ROOF_SHINGLES_2 = new Material(44);
    public static final /* enum */ Material ROOF_BRICK_TILE = new Material(45);
    public static final /* enum */ Material STONE_PATTERN = new Material(46);
    public static final /* enum */ Material TEXTURE_47 = new Material(47);
    public static final /* enum */ Material HIEROGLYPHICS = new Material(48);
    public static final /* enum */ Material TEXTURE_49 = new Material(49);
    public static final /* enum */ Material ROOF_BRICK_TILE_GREEN = new Material(50);
    public static final /* enum */ Material CLEAN_WOOD_FLOOR = new Material(51);
    public static final /* enum */ Material SNOW_FLAKES = new Material(52, p -> p.setHasTransparency(true));
    public static final /* enum */ Material FROZEN_ABYSSAL_WHIP = new Material(53);
    public static final /* enum */ Material UNUSED_UI_TEXTURE = new Material(54);
    public static final /* enum */ Material ROOF_BRICK_TILE_DARK = new Material(55);
    public static final /* enum */ Material RED_LAVA = new Material(56);
    public static final /* enum */ Material SMOKE_BATTLESTAFF = new Material(57);
    public static final /* enum */ Material UNUSED_LEAVES = new Material(58, p -> p.setHasTransparency(true));
    public static final /* enum */ Material INFERNAL_CAPE = new Material(59, p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.02f, 12.0f, 4.0f).setScroll(0.0f, 0.0f));
    public static final /* enum */ Material LEAVES_TOP = new Material(60, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_SKULL = new Material(61, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_PARTYHAT = new Material(62, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_MAGIC_ICON = new Material(63, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_MIME_HAPPY = new Material(64, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_HELMET = new Material(65, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_SWORDS = new Material(66, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_MIME_SAD = new Material(67, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_SKILLING = new Material(68, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_FARMING = new Material(69, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_ARROWS = new Material(70, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_RUNE = new Material(71, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_THIEVING = new Material(72, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_BONES = new Material(73, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_CABBAGE = new Material(74, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_CAT = new Material(75, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_COMPASS = new Material(76, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_FISH = new Material(77, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_HITPOINTS = new Material(78, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_PRAYER = new Material(79, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_HUNTER = new Material(80, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_RING = new Material(81, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_ROBINHOOD = new Material(82, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_FLOWER = new Material(83, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_DEFENCE = new Material(84, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_ZAMORAK = new Material(85, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_GROUP = new Material(86, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_GROUP_HARDCORE = new Material(87, p -> p.setHasTransparency(true));
    public static final /* enum */ Material CLAN_EMPTY = new Material(88, p -> p.setHasTransparency(true));
    public static final /* enum */ Material SHAYZIEN_LEAVES_TOP = new Material(89, p -> p.setHasTransparency(true));
    public static final /* enum */ Material SHAYZIEN_LEAVES_SIDE = new Material(90, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f));
    public static final /* enum */ Material WATER_ICE = new Material(91);
    public static final /* enum */ Material SNOW_ROOF = new Material(92);
    public static final /* enum */ Material SMALL_SNOWFLAKES = new Material(93);
    public static final /* enum */ Material COLOR_MAP = new Material(94);
    public static final /* enum */ Material CONCRETE_DARK = new Material(95);
    public static final /* enum */ Material HIEROGLYPHICS_LARGE = new Material(96, p -> p.setHasTransparency(true));
    public static final /* enum */ Material HIEROGLYPHICS_SMALL = new Material(97, p -> p.setHasTransparency(true));
    public static final /* enum */ Material FOG_STATIC = new Material(98, p -> p.setHasTransparency(true));
    public static final /* enum */ Material FOG_VERY_SLOW = new Material(FOG_STATIC, p -> p.setVanillaTextureIndex(99).setHasTransparency(true));
    public static final /* enum */ Material FOG_SLOW = new Material(FOG_STATIC, p -> p.setVanillaTextureIndex(100).setHasTransparency(true));
    public static final /* enum */ Material FOG_MEDIUM = new Material(FOG_STATIC, p -> p.setVanillaTextureIndex(101).setHasTransparency(true));
    public static final /* enum */ Material FOG_FAST = new Material(FOG_STATIC, p -> p.setVanillaTextureIndex(102).setHasTransparency(true));
    public static final /* enum */ Material FOG_VERY_FAST = new Material(FOG_STATIC, p -> p.setVanillaTextureIndex(103).setHasTransparency(true));
    public static final /* enum */ Material FOG_LIGHT_STATIC = new Material(104, p -> p.setHasTransparency(true));
    public static final /* enum */ Material FOG_LIGHT_VERY_SLOW = new Material(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(105).setHasTransparency(true));
    public static final /* enum */ Material FOG_LIGHT_SLOW = new Material(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(106).setHasTransparency(true));
    public static final /* enum */ Material FOG_LIGHT_MEDIUM = new Material(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(107).setHasTransparency(true));
    public static final /* enum */ Material FOG_LIGHT_FAST = new Material(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(108).setHasTransparency(true));
    public static final /* enum */ Material FOG_LIGHT_VERY_FAST = new Material(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(109).setHasTransparency(true));
    public static final /* enum */ Material FOG_HEAVY_STATIC = new Material(110, p -> p.setHasTransparency(true));
    public static final /* enum */ Material FOG_HEAVY_VERY_SLOW = new Material(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(111).setHasTransparency(true));
    public static final /* enum */ Material FOG_HEAVY_SLOW = new Material(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(112).setHasTransparency(true));
    public static final /* enum */ Material FOG_HEAVY_MEDIUM = new Material(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(113).setHasTransparency(true));
    public static final /* enum */ Material FOG_HEAVY_FAST = new Material(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(114).setHasTransparency(true));
    public static final /* enum */ Material FOG_HEAVY_VERY_FAST = new Material(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(115).setHasTransparency(true));
    public static final /* enum */ Material SKULLS = new Material(116);
    public static final /* enum */ Material SKULLS_FOG = new Material(117);
    public static final /* enum */ Material SKULLS_FOG_LIGHT = new Material(118);
    public static final /* enum */ Material SKULLS_FOG_DARK = new Material(119);
    public static final /* enum */ Material WHITE = new Material(NONE);
    public static final /* enum */ Material GRAY_75 = new Material(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.75f)));
    public static final /* enum */ Material GRAY_65 = new Material(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.65f)));
    public static final /* enum */ Material GRAY_50 = new Material(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.5f)));
    public static final /* enum */ Material GRAY_25 = new Material(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.25f)));
    public static final /* enum */ Material BLACK = new Material(NONE, p -> p.setBrightness(0.0f));
    public static final /* enum */ Material BLANK_GLOSS = new Material(WHITE, p -> p.setSpecular(0.9f, 280.0f));
    public static final /* enum */ Material BLANK_SEMIGLOSS = new Material(WHITE, p -> p.setSpecular(0.35f, 80.0f));
    public static final /* enum */ Material SNOW_1_N = new Material();
    public static final /* enum */ Material SNOW_1 = new Material(p -> p.setNormalMap(SNOW_1_N).setSpecular(0.4f, 20.0f));
    public static final /* enum */ Material SNOW_2_N = new Material();
    public static final /* enum */ Material SNOW_2 = new Material(p -> p.setNormalMap(SNOW_2_N).setSpecular(0.4f, 20.0f));
    public static final /* enum */ Material SNOW_2_DARK = new Material(SNOW_2, p -> p.setBrightness(0.5f));
    public static final /* enum */ Material SNOW_3_N = new Material();
    public static final /* enum */ Material SNOW_3 = new Material(p -> p.setNormalMap(SNOW_3_N).setSpecular(0.4f, 20.0f));
    public static final /* enum */ Material SNOW_4_N = new Material();
    public static final /* enum */ Material SNOW_4 = new Material(p -> p.setNormalMap(SNOW_4_N).setSpecular(0.4f, 20.0f));
    public static final /* enum */ Material GRASS_1 = new Material();
    public static final /* enum */ Material GRASS_2 = new Material();
    public static final /* enum */ Material GRASS_3 = new Material();
    public static final /* enum */ Material GRASS_SCROLLING = new Material(GRASS_1, p -> p.setScroll(0.0f, 1.4285715f));
    public static final /* enum */ Material DIRT_1_N = new Material();
    public static final /* enum */ Material DIRT_1 = new Material(p -> p.setNormalMap(DIRT_1_N).setSpecular(0.25f, 18.0f));
    public static final /* enum */ Material DIRT_1_VERT = new Material(DIRT_1, p -> p.setNormalMap(null));
    public static final /* enum */ Material DIRT_2_N = new Material();
    public static final /* enum */ Material DIRT_2 = new Material(p -> p.setNormalMap(DIRT_2_N).setSpecular(0.25f, 18.0f));
    public static final /* enum */ Material DIRT_2_VERT = new Material(DIRT_2, p -> p.setNormalMap(null));
    public static final /* enum */ Material GRAVEL_N = new Material();
    public static final /* enum */ Material GRAVEL = new Material(p -> p.setNormalMap(GRAVEL_N).setSpecular(0.4f, 130.0f));
    public static final /* enum */ Material GRAVEL_LIGHT = new Material(GRAVEL, p -> p.setBrightness(1.5f));
    public static final /* enum */ Material DIRT_1_SHINY = new Material(DIRT_1, p -> p.setSpecular(1.1f, 380.0f));
    public static final /* enum */ Material DIRT_2_SHINY = new Material(DIRT_2, p -> p.setSpecular(1.1f, 380.0f));
    public static final /* enum */ Material GRAVEL_SHINY = new Material(GRAVEL, p -> p.setSpecular(1.1f, 380.0f));
    public static final /* enum */ Material GRAVEL_SHINY_LIGHT = new Material(GRAVEL, p -> p.setSpecular(1.1f, 380.0f).setBrightness(1.55f));
    public static final /* enum */ Material SAND_1_N = new Material();
    public static final /* enum */ Material SAND_1 = new Material(p -> p.setNormalMap(SAND_1_N).setSpecular(0.2f, 10.0f));
    public static final /* enum */ Material SAND_2_N = new Material();
    public static final /* enum */ Material SAND_2 = new Material(p -> p.setNormalMap(SAND_2_N).setSpecular(0.2f, 10.0f));
    public static final /* enum */ Material SAND_3_N = new Material();
    public static final /* enum */ Material SAND_3 = new Material(p -> p.setNormalMap(SAND_3_N).setSpecular(0.2f, 10.0f));
    public static final /* enum */ Material GRUNGE_1 = new Material();
    public static final /* enum */ Material GRUNGE_1_SHINY = new Material(GRUNGE_1, p -> p.setSpecular(0.7f, 300.0f));
    public static final /* enum */ Material GRUNGE_2 = new Material();
    public static final /* enum */ Material GRUNGE_2_SHINY = new Material(GRUNGE_2, p -> p.setSpecular(0.7f, 300.0f));
    public static final /* enum */ Material GRUNGE_2_EADGARS_CAVE_FIX = new Material(GRUNGE_2, p -> p.setBrightness(0.65f));
    public static final /* enum */ Material GRUNGE_2_TROLLHEIM_WALL_FIX_1 = new Material(GRUNGE_2, p -> p.setBrightness(1.8f));
    public static final /* enum */ Material GRUNGE_2_TROLLHEIM_WALL_FIX_2 = new Material(GRUNGE_2, p -> p.setBrightness(1.2f));
    public static final /* enum */ Material SUBMERGED_GRUNGE_2 = new Material(GRUNGE_2, p -> p.setFlowMap(UNDERWATER_FLOW_MAP).setFlowMapStrength(0.075f).setFlowMapDuration(new float[]{12.0f, -12.0f}));
    public static final /* enum */ Material ROCK_1_N = new Material();
    public static final /* enum */ Material ROCK_1 = new Material(p -> p.setNormalMap(ROCK_1_N).setSpecular(0.35f, 40.0f));
    public static final /* enum */ Material ROCK_1_LIGHT = new Material(ROCK_1, p -> p.setBrightness(1.4f));
    public static final /* enum */ Material ROCK_2_N = new Material();
    public static final /* enum */ Material ROCK_2 = new Material(p -> p.setNormalMap(ROCK_2_N).setSpecular(0.35f, 60.0f).setBrightness(1.2f));
    public static final /* enum */ Material ROCK_3_D = new Material();
    public static final /* enum */ Material ROCK_3_N = new Material();
    public static final /* enum */ Material ROCK_3 = new Material(p -> p.setNormalMap(ROCK_3_N).setDisplacementMap(ROCK_3_D).setDisplacementScale(0.15f).setSpecular(0.4f, 20.0f).setBrightness(1.2f));
    public static final /* enum */ Material ROCK_3_ORE = new Material(ROCK_3, p -> p.setSpecular(1.0f, 20.0f));
    public static final /* enum */ Material ROCK_4_D = new Material();
    public static final /* enum */ Material ROCK_4_N = new Material();
    public static final /* enum */ Material ROCK_4 = new Material(p -> p.setNormalMap(ROCK_4_N).setDisplacementMap(ROCK_4_D).setDisplacementScale(0.15f).setSpecular(0.4f, 20.0f).setBrightness(1.2f));
    public static final /* enum */ Material ROCK_4_ORE = new Material(ROCK_4, p -> p.setSpecular(1.0f, 20.0f));
    public static final /* enum */ Material ROCK_5_D = new Material();
    public static final /* enum */ Material ROCK_5_N = new Material();
    public static final /* enum */ Material ROCK_5 = new Material(p -> p.setNormalMap(ROCK_5_N).setDisplacementMap(ROCK_5_D).setDisplacementScale(0.15f).setSpecular(0.4f, 20.0f).setBrightness(1.2f));
    public static final /* enum */ Material ROCK_5_ORE = new Material(ROCK_5, p -> p.setSpecular(1.0f, 20.0f));
    public static final /* enum */ Material CARPET = new Material();
    public static final /* enum */ Material FINE_CARPET = new Material(CARPET, p -> p.setBrightness(1.4f).setTextureScale(0.5f, 0.5f));
    public static final /* enum */ Material FALADOR_PATH_BRICK_N = new Material();
    public static final /* enum */ Material FALADOR_PATH_BRICK = new Material(p -> p.setNormalMap(FALADOR_PATH_BRICK_N).setSpecular(0.3f, 30.0f));
    public static final /* enum */ Material JAGGED_STONE_TILE_D = new Material();
    public static final /* enum */ Material JAGGED_STONE_TILE_N = new Material();
    public static final /* enum */ Material JAGGED_STONE_TILE = new Material(p -> p.setDisplacementMap(JAGGED_STONE_TILE_D).setNormalMap(JAGGED_STONE_TILE_N).setSpecular(0.5f, 30.0f));
    public static final /* enum */ Material POTTERY_OVEN_STONE = new Material(JAGGED_STONE_TILE, p -> p.setOverrideBaseColor(Material.JAGGED_STONE_TILE.overrideBaseColor).setBrightness(0.3f));
    public static final /* enum */ Material TILE_SMALL_1 = new Material(p -> p.setSpecular(0.8f, 70.0f));
    public static final /* enum */ Material TILES_2X2_1_N = new Material();
    public static final /* enum */ Material TILES_2X2_1 = new Material(p -> p.setNormalMap(TILES_2X2_1_N));
    public static final /* enum */ Material TILES_2X2_1_GLOSS = new Material(TILES_2X2_1, p -> p.setSpecular(1.0f, 70.0f));
    public static final /* enum */ Material TILES_2X2_1_SEMIGLOSS = new Material(TILES_2X2_1, p -> p.setSpecular(0.5f, 300.0f));
    public static final /* enum */ Material TILES_2X2_2 = new Material(p -> p.setSpecular(0.3f, 30.0f));
    public static final /* enum */ Material TILES_2X2_2_GLOSS = new Material(TILES_2X2_2, p -> p.setSpecular(1.0f, 70.0f));
    public static final /* enum */ Material TILES_2X2_2_SEMIGLOSS = new Material(TILES_2X2_2, p -> p.setSpecular(0.5f, 300.0f));
    public static final /* enum */ Material MARBLE_1 = new Material();
    public static final /* enum */ Material MARBLE_2 = new Material();
    public static final /* enum */ Material MARBLE_3 = new Material();
    public static final /* enum */ Material MARBLE_1_GLOSS = new Material(MARBLE_1, p -> p.setSpecular(0.9f, 280.0f));
    public static final /* enum */ Material MARBLE_2_GLOSS = new Material(MARBLE_2, p -> p.setSpecular(0.8f, 300.0f));
    public static final /* enum */ Material MARBLE_3_GLOSS = new Material(MARBLE_3, p -> p.setSpecular(0.7f, 320.0f));
    public static final /* enum */ Material MARBLE_1_SEMIGLOSS = new Material(MARBLE_1, p -> p.setSpecular(0.35f, 80.0f));
    public static final /* enum */ Material MARBLE_2_SEMIGLOSS = new Material(MARBLE_2, p -> p.setSpecular(0.3f, 100.0f));
    public static final /* enum */ Material MARBLE_3_SEMIGLOSS = new Material(MARBLE_3, p -> p.setSpecular(0.4f, 120.0f));
    public static final /* enum */ Material LASSAR_UNDERCITY_TILE_NORMAL = new Material();
    public static final /* enum */ Material LASSAR_UNDERCITY_TILE_DISP = new Material();
    public static final /* enum */ Material LASSAR_UNDERCITY_TILES = new Material(MARBLE_2_SEMIGLOSS, p -> p.setNormalMap(LASSAR_UNDERCITY_TILE_NORMAL).setDisplacementMap(LASSAR_UNDERCITY_TILE_DISP).setDisplacementScale(0.015f));
    public static final /* enum */ Material LASSAR_UNDERCITY_TILES_SUBMERGED = new Material(LASSAR_UNDERCITY_TILES, p -> p.setFlowMap(UNDERWATER_FLOW_MAP).setFlowMapStrength(0.025f).setFlowMapDuration(new float[]{10.0f, -10.0f}));
    public static final /* enum */ Material HD_LAVA_1 = new Material(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f));
    public static final /* enum */ Material HD_LAVA_2 = new Material(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f));
    public static final /* enum */ Material HD_MAGMA_1 = new Material(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f));
    public static final /* enum */ Material HD_MAGMA_2 = new Material(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f));
    public static final /* enum */ Material BARK_N = new Material();
    public static final /* enum */ Material BARK = new Material(p -> p.setNormalMap(BARK_N).setSpecular(0.3f, 30.0f));
    public static final /* enum */ Material LIGHT_BARK = new Material(BARK, p -> p.setBrightness(1.75f));
    public static final /* enum */ Material WOOD_GRAIN = new Material();
    public static final /* enum */ Material WOOD_GRAIN_2_N = new Material();
    public static final /* enum */ Material WOOD_GRAIN_2 = new Material(p -> p.setNormalMap(WOOD_GRAIN_2_N).setSpecular(0.3f, 30.0f));
    public static final /* enum */ Material WOOD_GRAIN_2_LIGHT = new Material(WOOD_GRAIN_2, p -> p.setBrightness(1.1f));
    public static final /* enum */ Material WOOD_GRAIN_2_WIDE = new Material(WOOD_GRAIN_2, p -> p.setTextureScale(1.5f, 0.5f));
    public static final /* enum */ Material WOOD_GRAIN_3_D = new Material();
    public static final /* enum */ Material WOOD_GRAIN_3_N = new Material();
    public static final /* enum */ Material WOOD_GRAIN_3 = new Material(p -> p.setDisplacementMap(WOOD_GRAIN_3_D).setNormalMap(WOOD_GRAIN_3_N).setSpecular(0.3f, 25.0f));
    public static final /* enum */ Material DOCK_FENCE = new Material();
    public static final /* enum */ Material DOCK_FENCE_DARK = new Material(DOCK_FENCE, p -> p.setBrightness(0.6f));
    public static final /* enum */ Material HD_INFERNAL_CAPE = new Material(p -> p.replaceIf(plugin -> plugin.config.hdInfernalTexture(), INFERNAL_CAPE).setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.02f, 12.0f, 4.0f).setScroll(0.0f, 0.33333334f));
    public static final /* enum */ Material HD_BRICK_N = new Material();
    public static final /* enum */ Material HD_BRICK_D = new Material();
    public static final /* enum */ Material HD_BRICK = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, BRICK).setNormalMap(HD_BRICK_N).setDisplacementMap(HD_BRICK_D).setDisplacementScale(0.05f).setSpecular(0.3f, 20.0f));
    public static final /* enum */ Material HD_ROOF_SHINGLES_N = new Material();
    public static final /* enum */ Material HD_ROOF_SHINGLES_1 = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, ROOF_SHINGLES_1).setSpecular(0.5f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N));
    public static final /* enum */ Material HD_MARBLE_DARK = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, MARBLE_DARK).setSpecular(1.1f, 380.0f));
    public static final /* enum */ Material HD_BRICK_BROWN_N = new Material();
    public static final /* enum */ Material HD_BRICK_BROWN_D = new Material();
    public static final /* enum */ Material HD_BRICK_BROWN = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, BRICK_BROWN).setNormalMap(HD_BRICK_BROWN_N).setDisplacementMap(HD_BRICK_BROWN_D).setDisplacementScale(0.05f).setSpecular(0.35f, 20.0f));
    public static final /* enum */ Material HD_LAVA_3 = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, LAVA).setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.05f, 36.0f, 22.0f).setScroll(0.0f, 0.33333334f));
    public static final /* enum */ Material HD_ROOF_SHINGLES_2 = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, ROOF_SHINGLES_2).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N));
    public static final /* enum */ Material HD_SIMPLE_GRAIN_WOOD_D = new Material();
    public static final /* enum */ Material HD_SIMPLE_GRAIN_WOOD_N = new Material();
    public static final /* enum */ Material HD_SIMPLE_GRAIN_WOOD = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, SIMPLE_GRAIN_WOOD).setSpecular(0.3f, 20.0f).setNormalMap(HD_SIMPLE_GRAIN_WOOD_N).setDisplacementMap(HD_SIMPLE_GRAIN_WOOD_D).setDisplacementScale(0.008f));
    public static final /* enum */ Material WORN_TILES = new Material();
    public static final /* enum */ Material STONE_N = new Material();
    public static final /* enum */ Material STONE = new Material();
    public static final /* enum */ Material STONE_NORMALED = new Material(STONE, p -> p.setNormalMap(STONE_N).setSpecular(0.3f, 30.0f));
    public static final /* enum */ Material STONE_LOWGLOSS = new Material(STONE, p -> p.setSpecular(0.3f, 30.0f));
    public static final /* enum */ Material STONE_SEMIGLOSS = new Material(STONE, p -> p.setSpecular(0.6f, 100.0f));
    public static final /* enum */ Material STONE_SCROLLING = new Material(STONE, p -> p.setScroll(0.0f, -1.4285715f));
    public static final /* enum */ Material WALL_STONE_N = new Material();
    public static final /* enum */ Material WALL_STONE = new Material(p -> p.setNormalMap(WALL_STONE_N));
    public static final /* enum */ Material METALLIC_1 = new Material(p -> p.setSpecular(0.2f, 20.0f));
    public static final /* enum */ Material METALLIC_1_SEMIGLOSS = new Material(METALLIC_1, p -> p.setSpecular(0.3f, 80.0f));
    public static final /* enum */ Material METALLIC_1_GLOSS = new Material(METALLIC_1, p -> p.setSpecular(0.7f, 80.0f));
    public static final /* enum */ Material METALLIC_1_HIGHGLOSS = new Material(METALLIC_1, p -> p.setSpecular(1.1f, 80.0f));
    public static final /* enum */ Material METALLIC_2 = new Material(METALLIC_1, p -> p.setBrightness(1.8f));
    public static final /* enum */ Material METALLIC_2_SEMIGLOSS = new Material(METALLIC_2, p -> p.setSpecular(0.3f, 80.0f));
    public static final /* enum */ Material METALLIC_2_GLOSS = new Material(METALLIC_2, p -> p.setSpecular(0.7f, 80.0f));
    public static final /* enum */ Material METALLIC_2_HIGHGLOSS = new Material(METALLIC_2, p -> p.setSpecular(1.1f, 80.0f));
    public static final /* enum */ Material METALLIC_NONE_GLOSS = new Material(NONE, p -> p.setSpecular(0.7f, 80.0f));
    public static final /* enum */ Material WATTLE_1 = new Material();
    public static final /* enum */ Material ICE_1 = new Material(SNOW_4, p -> p.replaceIf(SeasonalTheme.WINTER, WATER_FLAT_2, WATER_FLAT).setSpecular(1.1f, 200.0f));
    public static final /* enum */ Material ICE_1_HIGHGLOSS = new Material(ICE_1, p -> p.replaceIf(SeasonalTheme.WINTER, WATER_FLAT_2, WATER_FLAT).setSpecular(3.1f, 30.0f));
    public static final /* enum */ Material ICE_2 = new Material(SNOW_2, p -> p.setSpecular(1.5f, 800.0f));
    public static final /* enum */ Material ICE_3 = new Material(GRUNGE_2, p -> p.setSpecular(1.9f, 1000.0f));
    public static final /* enum */ Material ICE_4 = new Material(WHITE, p -> p.setSpecular(1.5f, 1000.0f).setNormalMap(WATER_NORMAL_MAP_2));
    public static final /* enum */ Material SLIME_GRUNGE = new Material(GRUNGE_1, p -> p.setSpecular(4.1f, 60.0f));
    public static final /* enum */ Material WATER_PUDDLE = new Material(NONE, p -> p.setSpecular(1.5f, 80.0f));
    public static final /* enum */ Material HD_WOOD_PLANKS_1_N = new Material();
    public static final /* enum */ Material HD_WOOD_PLANKS_1 = new Material(p -> p.setNormalMap(HD_WOOD_PLANKS_1_N).setSpecular(0.3f, 40.0f).setBrightness(1.2f));
    public static final /* enum */ Material HD_ROOF_BRICK_TILE_N = new Material();
    public static final /* enum */ Material HD_ROOF_BRICK_TILE = new Material(ROOF_BRICK_TILE, p -> p.replaceIf(plugin -> plugin.configModelTextures, ROOF_BRICK_TILE).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_BRICK_TILE_N));
    public static final /* enum */ Material HD_ROOF_BRICK_TILE_GREEN = new Material(ROOF_BRICK_TILE_GREEN, p -> p.replaceIf(plugin -> plugin.configModelTextures, ROOF_BRICK_TILE_GREEN).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_BRICK_TILE_N));
    public static final /* enum */ Material HD_ROOF_BRICK_TILE_DARK = new Material(ROOF_BRICK_TILE_DARK, p -> p.replaceIf(plugin -> plugin.configModelTextures, ROOF_BRICK_TILE_DARK).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_BRICK_TILE_N));
    public static final /* enum */ Material PLANT_GRUNGE_1 = new Material(GRUNGE_1, p -> p.setSpecular(0.25f, 25.0f));
    public static final /* enum */ Material PLANT_GRUNGE_2 = new Material(GRUNGE_2, p -> p.setSpecular(0.2f, 20.0f));
    public static final /* enum */ Material HD_CONCRETE_D = new Material();
    public static final /* enum */ Material HD_CONCRETE_N = new Material();
    public static final /* enum */ Material HD_CONCRETE = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, CONCRETE).setNormalMap(HD_CONCRETE_N).setDisplacementMap(HD_CONCRETE_D).setDisplacementScale(0.05f).setSpecular(0.3f, 20.0f).setBrightness(0.75f));
    public static final /* enum */ Material HD_HAY_N = new Material();
    public static final /* enum */ Material HD_HAY = new Material(p -> p.replaceIf(plugin -> plugin.configModelTextures, HAY).setSpecular(0.3f, 20.0f).setNormalMap(HD_HAY_N));
    public static final /* enum */ Material OOZE = new Material(GRAY_65, p -> p.setSpecular(1.5f, 600.0f));
    public static final /* enum */ Material LEAVES_YELLOW_SIDE = new Material(LEAVES_SIDE);
    public static final /* enum */ Material LEAVES_YELLOW_TOP = new Material(LEAVES_TOP);
    public static final /* enum */ Material LEAVES_RED_SIDE = new Material(LEAVES_SIDE);
    public static final /* enum */ Material LEAVES_RED_TOP = new Material(LEAVES_TOP);
    public static final /* enum */ Material LEAVES_ORANGE_SIDE = new Material(LEAVES_SIDE);
    public static final /* enum */ Material LEAVES_ORANGE_TOP = new Material(LEAVES_TOP);
    public static final /* enum */ Material AUTUMN_LEAVES_YELLOW_SIDE = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.AUTUMN, LEAVES_YELLOW_SIDE));
    public static final /* enum */ Material AUTUMN_LEAVES_YELLOW_TOP = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.AUTUMN, LEAVES_YELLOW_TOP));
    public static final /* enum */ Material AUTUMN_LEAVES_ORANGE_SIDE = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.AUTUMN, LEAVES_ORANGE_SIDE));
    public static final /* enum */ Material AUTUMN_LEAVES_ORANGE_TOP = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.AUTUMN, LEAVES_ORANGE_TOP));
    public static final /* enum */ Material AUTUMN_LEAVES_RED_SIDE = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.AUTUMN, LEAVES_RED_SIDE));
    public static final /* enum */ Material AUTUMN_LEAVES_RED_TOP = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.AUTUMN, LEAVES_RED_TOP));
    public static final /* enum */ Material AUTUMN_WILLOW_LEAVES = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.AUTUMN, WILLOW_LEAVES));
    public static final /* enum */ Material WINTER_WILLOW_LEAVES = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.WINTER, WILLOW_LEAVES));
    public static final /* enum */ Material WINTER_MAPLE_LEAVES = new Material(p -> p.setHasTransparency(true).setTextureScale(1.3f, 1.025f).replaceIf(SeasonalTheme.WINTER, MAPLE_LEAVES));
    public static final /* enum */ Material WINTER_LEAVES_SIDE = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.WINTER, LEAVES_SIDE, LEAVES_YELLOW_SIDE, LEAVES_ORANGE_SIDE, LEAVES_RED_SIDE));
    public static final /* enum */ Material WINTER_LEAVES_TOP = new Material(p -> p.setHasTransparency(true).replaceIf(SeasonalTheme.WINTER, LEAVES_TOP, LEAVES_YELLOW_TOP, LEAVES_ORANGE_TOP, LEAVES_RED_TOP));
    public static final /* enum */ Material WINTER_LEAVES_DISEASED = new Material(p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f).replaceIf(SeasonalTheme.WINTER, LEAVES_DISEASED));
    public static final /* enum */ Material WINTER_PAINTING_LANDSCAPE = new Material(p -> p.replaceIf(SeasonalTheme.WINTER, PAINTING_LANDSCAPE));
    public static final /* enum */ Material WINTER_PAINTING_KING = new Material(p -> p.replaceIf(SeasonalTheme.WINTER, PAINTING_KING));
    public static final /* enum */ Material WINTER_PAINTING_ELF = new Material(p -> p.replaceIf(SeasonalTheme.WINTER, PAINTING_ELF));
    public static final /* enum */ Material WINTER_HD_ROOF_SHINGLES_1 = new Material(p -> p.replaceIf(SeasonalTheme.WINTER, HD_ROOF_SHINGLES_1).setSpecular(0.5f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N));
    public static final /* enum */ Material WINTER_HD_ROOF_SHINGLES_2 = new Material(p -> p.replaceIf(SeasonalTheme.WINTER, HD_ROOF_SHINGLES_2).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N));
    public static final /* enum */ Material WINTER_HD_ROOF_BRICK_TILES = new Material(p -> p.setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_BRICK_TILE_N).replaceIf(SeasonalTheme.WINTER, HD_ROOF_BRICK_TILE, HD_ROOF_BRICK_TILE_GREEN, HD_ROOF_BRICK_TILE_DARK));
    public static final /* enum */ Material WINTER_HD_ROOF_SLATE = new Material(p -> p.setSpecular(0.5f, 30.0f).replaceIf(SeasonalTheme.WINTER, ROOF_SLATE));
    public static final /* enum */ Material WINTER_HD_ROOF_WOODEN_SLATE = new Material(p -> p.setSpecular(0.5f, 30.0f).replaceIf(SeasonalTheme.WINTER, ROOF_WOODEN_SLATE));
    public static final /* enum */ Material WINTER_JAGGED_STONE_TILE = new Material(p -> p.setDisplacementMap(JAGGED_STONE_TILE_D).setNormalMap(JAGGED_STONE_TILE_N).setSpecular(0.6f, 30.0f).setBrightness(1.4f));
    public static final /* enum */ Material WINTER_JAGGED_STONE_TILE_LIGHT = new Material(WINTER_JAGGED_STONE_TILE, p -> p.setBrightness(4.0f));
    public static final /* enum */ Material WINTER_JAGGED_STONE_TILE_LIGHTER = new Material(WINTER_JAGGED_STONE_TILE, p -> p.setBrightness(12.0f));
    public final Material parent;
    public final Material normalMap;
    public final Material displacementMap;
    public final Material roughnessMap;
    public final Material ambientOcclusionMap;
    public final Material flowMap;
    public final int vanillaTextureIndex;
    public final boolean hasTransparency;
    public final boolean overrideBaseColor;
    public final boolean unlit;
    public final boolean hasTexture;
    public final float brightness;
    public final float displacementScale;
    public final float flowMapStrength;
    public final float[] flowMapDuration;
    public final float specularStrength;
    public final float specularGloss;
    public final float[] scrollSpeed;
    public final float[] textureScale;
    public final List<Material> materialsToReplace = new ArrayList<Material>();
    public final Function<HdPlugin, Boolean> replacementCondition;
    private static Material[] VANILLA_TEXTURE_MAPPING;
    private static final Material[] REPLACEMENT_MAPPING;
    private static final /* synthetic */ Material[] $VALUES;

    public static Material[] values() {
        return (Material[])$VALUES.clone();
    }

    public static Material valueOf(String name) {
        return Enum.valueOf(Material.class, name);
    }

    private Material() {
        this((Builder p) -> {});
    }

    private Material(int vanillaTextureIndex) {
        this((Builder p) -> p.setVanillaTextureIndex(vanillaTextureIndex));
    }

    private Material(Material parent) {
        this(parent, (Builder p) -> {});
    }

    private Material(Material parent, Consumer<Builder> consumer) {
        this((Builder b) -> b.setParent(parent).apply(consumer));
    }

    private Material(int vanillaTextureIndex, Consumer<Builder> consumer) {
        this((Builder b) -> b.setVanillaTextureIndex(vanillaTextureIndex).apply(consumer));
    }

    private Material(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        this.parent = builder.parent;
        this.normalMap = builder.normalMap;
        this.displacementMap = builder.displacementMap;
        this.roughnessMap = builder.roughnessMap;
        this.ambientOcclusionMap = builder.ambientOcclusionMap;
        this.flowMap = builder.flowMap;
        this.vanillaTextureIndex = builder.vanillaTextureIndex;
        this.hasTransparency = builder.hasTransparency;
        this.overrideBaseColor = builder.overrideBaseColor;
        this.unlit = builder.unlit;
        this.brightness = builder.brightness;
        this.displacementScale = builder.displacementScale;
        this.flowMapStrength = builder.flowMapStrength;
        this.flowMapDuration = builder.flowMapDuration;
        this.specularStrength = builder.specularStrength;
        this.specularGloss = builder.specularGloss;
        this.scrollSpeed = builder.scrollSpeed;
        this.textureScale = builder.textureScale;
        this.materialsToReplace.addAll(builder.materialsToReplace);
        this.replacementCondition = builder.replacementCondition;
        Material base = this;
        while (base.parent != null) {
            base = base.parent;
        }
        this.hasTexture = base.ordinal() != 0 || this.normalMap != null || this.displacementMap != null || this.roughnessMap != null || this.ambientOcclusionMap != null || this.flowMap != null;
    }

    public static void updateMappings(Texture[] textures, HdPlugin plugin) {
        int i;
        Material[] materials = Material.values();
        for (i = 0; i < materials.length; ++i) {
            Material material = materials[i];
            if (material.replacementCondition != null && !material.replacementCondition.apply(plugin).booleanValue()) {
                material = NONE;
            } else {
                for (int j = i + 1; j < materials.length; ++j) {
                    Material replacement = materials[j];
                    if (replacement.replacementCondition == null || !replacement.replacementCondition.apply(plugin).booleanValue() || !replacement.materialsToReplace.contains((Object)material)) continue;
                    material = replacement;
                    break;
                }
            }
            Material.REPLACEMENT_MAPPING[i] = material;
        }
        VANILLA_TEXTURE_MAPPING = new Material[textures.length];
        Arrays.fill((Object[])VANILLA_TEXTURE_MAPPING, (Object)VANILLA);
        for (i = 0; i < textures.length; ++i) {
            for (Material material : materials) {
                if (material.vanillaTextureIndex != i || material.parent != null) continue;
                assert (VANILLA_TEXTURE_MAPPING[i] == VANILLA) : "Material " + material + " conflicts with vanilla ID " + material.vanillaTextureIndex + " of material " + VANILLA_TEXTURE_MAPPING[i];
                Material.VANILLA_TEXTURE_MAPPING[i] = material.resolveReplacements();
            }
        }
    }

    public static Material fromVanillaTexture(int vanillaTextureId) {
        if (vanillaTextureId < 0 || vanillaTextureId >= VANILLA_TEXTURE_MAPPING.length) {
            return NONE;
        }
        return VANILLA_TEXTURE_MAPPING[vanillaTextureId];
    }

    public Material resolveReplacements() {
        return REPLACEMENT_MAPPING[this.ordinal()];
    }

    public static Material[] getActiveMaterials() {
        return (Material[])Arrays.stream(REPLACEMENT_MAPPING).filter(m -> m != VANILLA).distinct().toArray(Material[]::new);
    }

    public static Material[] getTextureMaterials() {
        return (Material[])Arrays.stream(REPLACEMENT_MAPPING).map(Material::resolveTextureMaterial).filter(m -> m != NONE).distinct().toArray(Material[]::new);
    }

    public Material resolveTextureMaterial() {
        Material base = this.resolveReplacements();
        while (base.parent != null) {
            base = base.parent;
        }
        return base;
    }

    private static /* synthetic */ Material[] $values() {
        return new Material[]{NONE, VANILLA, UNLIT, TRANSPARENT, LAVA_FLOW_MAP, WATER_FLOW_MAP, UNDERWATER_FLOW_MAP, CAUSTICS_MAP, WATER_NORMAL_MAP_1, WATER_NORMAL_MAP_2, WATER_FOAM, WOODEN_DOOR_HANDLE, WATER_FLAT, BRICK, WOOD_PLANKS_1, LARGE_DOOR, DARK_WOOD, ROOF_SHINGLES_1, WOODEN_SCREEN, LEAVES_SIDE, TREE_RINGS, MOSS_BRANCH, CONCRETE, IRON_BARS, PAINTING_LANDSCAPE, PAINTING_KING, MARBLE_DARK, SIMPLE_GRAIN_WOOD, WATER_DROPLETS, HAY, NET, BOOKCASE, ROOF_WOODEN_SLATE, CRATE, BRICK_BROWN, WATER_FLAT_2, SWAMP_WATER_FLAT, WEB, ROOF_SLATE, MOSS, TROPICAL_LEAF, WILLOW_LEAVES, LAVA, TREE_DOOR_BROWN, MAPLE_LEAVES, MAGIC_STARS, SAND_BRICK, DOOR_TEXTURE, BLADE, SANDSTONE, PAINTING_ELF, FIRE_CAPE, LEAVES_DISEASED, MARBLE, CLEAN_TILE, ROOF_SHINGLES_2, ROOF_BRICK_TILE, STONE_PATTERN, TEXTURE_47, HIEROGLYPHICS, TEXTURE_49, ROOF_BRICK_TILE_GREEN, CLEAN_WOOD_FLOOR, SNOW_FLAKES, FROZEN_ABYSSAL_WHIP, UNUSED_UI_TEXTURE, ROOF_BRICK_TILE_DARK, RED_LAVA, SMOKE_BATTLESTAFF, UNUSED_LEAVES, INFERNAL_CAPE, LEAVES_TOP, CLAN_SKULL, CLAN_PARTYHAT, CLAN_MAGIC_ICON, CLAN_MIME_HAPPY, CLAN_HELMET, CLAN_SWORDS, CLAN_MIME_SAD, CLAN_SKILLING, CLAN_FARMING, CLAN_ARROWS, CLAN_RUNE, CLAN_THIEVING, CLAN_BONES, CLAN_CABBAGE, CLAN_CAT, CLAN_COMPASS, CLAN_FISH, CLAN_HITPOINTS, CLAN_PRAYER, CLAN_HUNTER, CLAN_RING, CLAN_ROBINHOOD, CLAN_FLOWER, CLAN_DEFENCE, CLAN_ZAMORAK, CLAN_GROUP, CLAN_GROUP_HARDCORE, CLAN_EMPTY, SHAYZIEN_LEAVES_TOP, SHAYZIEN_LEAVES_SIDE, WATER_ICE, SNOW_ROOF, SMALL_SNOWFLAKES, COLOR_MAP, CONCRETE_DARK, HIEROGLYPHICS_LARGE, HIEROGLYPHICS_SMALL, FOG_STATIC, FOG_VERY_SLOW, FOG_SLOW, FOG_MEDIUM, FOG_FAST, FOG_VERY_FAST, FOG_LIGHT_STATIC, FOG_LIGHT_VERY_SLOW, FOG_LIGHT_SLOW, FOG_LIGHT_MEDIUM, FOG_LIGHT_FAST, FOG_LIGHT_VERY_FAST, FOG_HEAVY_STATIC, FOG_HEAVY_VERY_SLOW, FOG_HEAVY_SLOW, FOG_HEAVY_MEDIUM, FOG_HEAVY_FAST, FOG_HEAVY_VERY_FAST, SKULLS, SKULLS_FOG, SKULLS_FOG_LIGHT, SKULLS_FOG_DARK, WHITE, GRAY_75, GRAY_65, GRAY_50, GRAY_25, BLACK, BLANK_GLOSS, BLANK_SEMIGLOSS, SNOW_1_N, SNOW_1, SNOW_2_N, SNOW_2, SNOW_2_DARK, SNOW_3_N, SNOW_3, SNOW_4_N, SNOW_4, GRASS_1, GRASS_2, GRASS_3, GRASS_SCROLLING, DIRT_1_N, DIRT_1, DIRT_1_VERT, DIRT_2_N, DIRT_2, DIRT_2_VERT, GRAVEL_N, GRAVEL, GRAVEL_LIGHT, DIRT_1_SHINY, DIRT_2_SHINY, GRAVEL_SHINY, GRAVEL_SHINY_LIGHT, SAND_1_N, SAND_1, SAND_2_N, SAND_2, SAND_3_N, SAND_3, GRUNGE_1, GRUNGE_1_SHINY, GRUNGE_2, GRUNGE_2_SHINY, GRUNGE_2_EADGARS_CAVE_FIX, GRUNGE_2_TROLLHEIM_WALL_FIX_1, GRUNGE_2_TROLLHEIM_WALL_FIX_2, SUBMERGED_GRUNGE_2, ROCK_1_N, ROCK_1, ROCK_1_LIGHT, ROCK_2_N, ROCK_2, ROCK_3_D, ROCK_3_N, ROCK_3, ROCK_3_ORE, ROCK_4_D, ROCK_4_N, ROCK_4, ROCK_4_ORE, ROCK_5_D, ROCK_5_N, ROCK_5, ROCK_5_ORE, CARPET, FINE_CARPET, FALADOR_PATH_BRICK_N, FALADOR_PATH_BRICK, JAGGED_STONE_TILE_D, JAGGED_STONE_TILE_N, JAGGED_STONE_TILE, POTTERY_OVEN_STONE, TILE_SMALL_1, TILES_2X2_1_N, TILES_2X2_1, TILES_2X2_1_GLOSS, TILES_2X2_1_SEMIGLOSS, TILES_2X2_2, TILES_2X2_2_GLOSS, TILES_2X2_2_SEMIGLOSS, MARBLE_1, MARBLE_2, MARBLE_3, MARBLE_1_GLOSS, MARBLE_2_GLOSS, MARBLE_3_GLOSS, MARBLE_1_SEMIGLOSS, MARBLE_2_SEMIGLOSS, MARBLE_3_SEMIGLOSS, LASSAR_UNDERCITY_TILE_NORMAL, LASSAR_UNDERCITY_TILE_DISP, LASSAR_UNDERCITY_TILES, LASSAR_UNDERCITY_TILES_SUBMERGED, HD_LAVA_1, HD_LAVA_2, HD_MAGMA_1, HD_MAGMA_2, BARK_N, BARK, LIGHT_BARK, WOOD_GRAIN, WOOD_GRAIN_2_N, WOOD_GRAIN_2, WOOD_GRAIN_2_LIGHT, WOOD_GRAIN_2_WIDE, WOOD_GRAIN_3_D, WOOD_GRAIN_3_N, WOOD_GRAIN_3, DOCK_FENCE, DOCK_FENCE_DARK, HD_INFERNAL_CAPE, HD_BRICK_N, HD_BRICK_D, HD_BRICK, HD_ROOF_SHINGLES_N, HD_ROOF_SHINGLES_1, HD_MARBLE_DARK, HD_BRICK_BROWN_N, HD_BRICK_BROWN_D, HD_BRICK_BROWN, HD_LAVA_3, HD_ROOF_SHINGLES_2, HD_SIMPLE_GRAIN_WOOD_D, HD_SIMPLE_GRAIN_WOOD_N, HD_SIMPLE_GRAIN_WOOD, WORN_TILES, STONE_N, STONE, STONE_NORMALED, STONE_LOWGLOSS, STONE_SEMIGLOSS, STONE_SCROLLING, WALL_STONE_N, WALL_STONE, METALLIC_1, METALLIC_1_SEMIGLOSS, METALLIC_1_GLOSS, METALLIC_1_HIGHGLOSS, METALLIC_2, METALLIC_2_SEMIGLOSS, METALLIC_2_GLOSS, METALLIC_2_HIGHGLOSS, METALLIC_NONE_GLOSS, WATTLE_1, ICE_1, ICE_1_HIGHGLOSS, ICE_2, ICE_3, ICE_4, SLIME_GRUNGE, WATER_PUDDLE, HD_WOOD_PLANKS_1_N, HD_WOOD_PLANKS_1, HD_ROOF_BRICK_TILE_N, HD_ROOF_BRICK_TILE, HD_ROOF_BRICK_TILE_GREEN, HD_ROOF_BRICK_TILE_DARK, PLANT_GRUNGE_1, PLANT_GRUNGE_2, HD_CONCRETE_D, HD_CONCRETE_N, HD_CONCRETE, HD_HAY_N, HD_HAY, OOZE, LEAVES_YELLOW_SIDE, LEAVES_YELLOW_TOP, LEAVES_RED_SIDE, LEAVES_RED_TOP, LEAVES_ORANGE_SIDE, LEAVES_ORANGE_TOP, AUTUMN_LEAVES_YELLOW_SIDE, AUTUMN_LEAVES_YELLOW_TOP, AUTUMN_LEAVES_ORANGE_SIDE, AUTUMN_LEAVES_ORANGE_TOP, AUTUMN_LEAVES_RED_SIDE, AUTUMN_LEAVES_RED_TOP, AUTUMN_WILLOW_LEAVES, WINTER_WILLOW_LEAVES, WINTER_MAPLE_LEAVES, WINTER_LEAVES_SIDE, WINTER_LEAVES_TOP, WINTER_LEAVES_DISEASED, WINTER_PAINTING_LANDSCAPE, WINTER_PAINTING_KING, WINTER_PAINTING_ELF, WINTER_HD_ROOF_SHINGLES_1, WINTER_HD_ROOF_SHINGLES_2, WINTER_HD_ROOF_BRICK_TILES, WINTER_HD_ROOF_SLATE, WINTER_HD_ROOF_WOODEN_SLATE, WINTER_JAGGED_STONE_TILE, WINTER_JAGGED_STONE_TILE_LIGHT, WINTER_JAGGED_STONE_TILE_LIGHTER};
    }

    static {
        $VALUES = Material.$values();
        VANILLA_TEXTURE_MAPPING = new Material[0];
        REPLACEMENT_MAPPING = new Material[Material.values().length];
    }

    private static class Builder {
        private Material parent;
        private Material normalMap;
        private Material displacementMap;
        private Material roughnessMap;
        private Material ambientOcclusionMap;
        private Material flowMap;
        private int vanillaTextureIndex = -1;
        private boolean hasTransparency = false;
        private boolean overrideBaseColor = false;
        private boolean unlit = false;
        private float brightness = 1.0f;
        private float displacementScale = 0.1f;
        private float flowMapStrength;
        private float[] flowMapDuration = new float[]{0.0f, 0.0f};
        private float specularStrength;
        private float specularGloss;
        private float[] scrollSpeed = new float[]{0.0f, 0.0f};
        private float[] textureScale = new float[]{1.0f, 1.0f};
        private List<Material> materialsToReplace = new ArrayList<Material>();
        private Function<HdPlugin, Boolean> replacementCondition;

        private Builder() {
        }

        Builder apply(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        Builder setParent(Material parent) {
            this.parent = parent;
            this.normalMap = parent.normalMap;
            this.displacementMap = parent.displacementMap;
            this.roughnessMap = parent.roughnessMap;
            this.ambientOcclusionMap = parent.ambientOcclusionMap;
            this.flowMap = parent.flowMap;
            this.vanillaTextureIndex = parent.vanillaTextureIndex;
            this.hasTransparency = parent.hasTransparency;
            this.overrideBaseColor = parent.overrideBaseColor;
            this.unlit = parent.unlit;
            this.brightness = parent.brightness;
            this.displacementScale = parent.displacementScale;
            this.flowMapStrength = parent.flowMapStrength;
            this.flowMapDuration = parent.flowMapDuration;
            this.specularStrength = parent.specularStrength;
            this.specularGloss = parent.specularGloss;
            this.scrollSpeed = parent.scrollSpeed;
            this.textureScale = parent.textureScale;
            this.materialsToReplace.addAll(parent.materialsToReplace);
            this.replacementCondition = parent.replacementCondition;
            return this;
        }

        Builder setSpecular(float specularStrength, float specularGloss) {
            this.specularStrength = specularStrength;
            this.specularGloss = specularGloss;
            return this;
        }

        Builder setFlowMap(Material flowMap, float flowMapStrength, float durationX, float durationY) {
            this.flowMap = flowMap;
            this.flowMapStrength = flowMapStrength;
            this.flowMapDuration = new float[]{durationX, durationY};
            return this;
        }

        Builder setScroll(float speedX, float speedY) {
            this.scrollSpeed = new float[]{-speedX, -speedY};
            return this;
        }

        Builder setTextureScale(float x, float y) {
            this.textureScale = new float[]{x, y};
            return this;
        }

        Builder replaceIf(@NonNull Function<HdPlugin, Boolean> condition, Material ... materialsToReplace) {
            if (condition == null) {
                throw new NullPointerException("condition is marked non-null but is null");
            }
            if (materialsToReplace == null) {
                throw new NullPointerException("materialsToReplace is marked non-null but is null");
            }
            Collections.addAll(this.materialsToReplace, materialsToReplace);
            this.replacementCondition = condition;
            return this;
        }

        Builder replaceIf(SeasonalTheme seasonalTheme, Material ... materialsToReplace) {
            if (materialsToReplace == null) {
                throw new NullPointerException("materialsToReplace is marked non-null but is null");
            }
            return this.replaceIf((HdPlugin plugin) -> plugin.configSeasonalTheme == seasonalTheme, materialsToReplace);
        }

        public Builder setNormalMap(Material normalMap) {
            this.normalMap = normalMap;
            return this;
        }

        public Builder setDisplacementMap(Material displacementMap) {
            this.displacementMap = displacementMap;
            return this;
        }

        public Builder setRoughnessMap(Material roughnessMap) {
            this.roughnessMap = roughnessMap;
            return this;
        }

        public Builder setAmbientOcclusionMap(Material ambientOcclusionMap) {
            this.ambientOcclusionMap = ambientOcclusionMap;
            return this;
        }

        public Builder setFlowMap(Material flowMap) {
            this.flowMap = flowMap;
            return this;
        }

        public Builder setVanillaTextureIndex(int vanillaTextureIndex) {
            this.vanillaTextureIndex = vanillaTextureIndex;
            return this;
        }

        public Builder setHasTransparency(boolean hasTransparency) {
            this.hasTransparency = hasTransparency;
            return this;
        }

        public Builder setOverrideBaseColor(boolean overrideBaseColor) {
            this.overrideBaseColor = overrideBaseColor;
            return this;
        }

        public Builder setUnlit(boolean unlit) {
            this.unlit = unlit;
            return this;
        }

        public Builder setBrightness(float brightness) {
            this.brightness = brightness;
            return this;
        }

        public Builder setDisplacementScale(float displacementScale) {
            this.displacementScale = displacementScale;
            return this;
        }

        public Builder setFlowMapStrength(float flowMapStrength) {
            this.flowMapStrength = flowMapStrength;
            return this;
        }

        public Builder setFlowMapDuration(float[] flowMapDuration) {
            this.flowMapDuration = flowMapDuration;
            return this;
        }

        public Builder setSpecularStrength(float specularStrength) {
            this.specularStrength = specularStrength;
            return this;
        }

        public Builder setSpecularGloss(float specularGloss) {
            this.specularGloss = specularGloss;
            return this;
        }

        public Builder setScrollSpeed(float[] scrollSpeed) {
            this.scrollSpeed = scrollSpeed;
            return this;
        }

        public Builder setTextureScale(float[] textureScale) {
            this.textureScale = textureScale;
            return this;
        }

        public Builder setMaterialsToReplace(List<Material> materialsToReplace) {
            this.materialsToReplace = materialsToReplace;
            return this;
        }

        public Builder setReplacementCondition(Function<HdPlugin, Boolean> replacementCondition) {
            this.replacementCondition = replacementCondition;
            return this;
        }
    }
}

