/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data.environments;

import rs117.hd.data.environments.Area;
import rs117.hd.utils.ColorUtils;
import rs117.hd.utils.HDUtils;

public enum Environment {
    EVIL_BOB_ISLAND(Area.EVIL_BOB_ISLAND, new Properties().setFogColor("#B8D6FF").setFogDepth(70).setAmbientColor("#C0AE94").setAmbientStrength(3.0f).setDirectionalColor("#F5BC67").setDirectionalStrength(1.0f)),
    REVENANT_CAVES(Area.REVENANT_CAVES, new Properties().setFogColor("#081F1C").setFogDepth(20).setAmbientColor("#AECFC9").setAmbientStrength(3.0f).setDirectionalColor("#AECFC9").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    BLACK_ROOMS(Area.BLACK_ROOMS, new Properties().setFogColor("#000000").setFogDepth(65).setDirectionalStrength(0.0f).setAmbientStrength(3.0f).setAllowSkyOverride(false).setLightDirection(-128.0f, 55.0f)),
    FROZEN_WASTE_PLATEAU(Area.FROZEN_WASTE_PLATEAU, new Properties().setFogColor("#252C37").setFogDepth(80).setAmbientStrength(0.4f).setAmbientColor("#3B87E4").setDirectionalStrength(2.5f).setDirectionalColor("#8A9EB6")),
    WILDERNESS_HIGH(Area.WILDERNESS_HIGH, new Properties().setFogColor("#101012").setFogDepth(30).setAmbientStrength(0.75f).setAmbientColor(215.0f, 210.0f, 210.0f).setDirectionalStrength(1.75f).setDirectionalColor("#C5B8B6").enableLightning().setGroundFog(0, -250, 0.3f)),
    WILDERNESS_LOW(Area.WILDERNESS_LOW, new Properties().setFogColor("#3E3E46").setFogDepth(20).setAmbientStrength(0.75f).setAmbientColor(215.0f, 210.0f, 210.0f).setDirectionalStrength(2.5f).setDirectionalColor(138.0f, 158.0f, 182.0f)),
    WILDERNESS(Area.WILDERNESS, new Properties().setFogColor("#25252A").setFogDepth(30).setAmbientStrength(0.75f).setAmbientColor(215.0f, 210.0f, 210.0f).setDirectionalStrength(2.0f).setDirectionalColor("#C5B8B6").setGroundFog(0, -250, 0.3f)),
    VARROCK_MUSEUM_BASEMENT(Area.VARROCK_MUSEUM_BASEMENT, new Properties().setFogColor("#131B26").setFogDepth(20).setAmbientColor("#B59B79").setAmbientStrength(2.0f).setDirectionalColor("#FFFFFF").setDirectionalStrength(0.5f).setLightDirection(260.0f, 10.0f)),
    STRONGHOLD_OF_SECURITY_WAR(Area.STRONGHOLD_OF_SECURITY_WAR, new Properties().setFogColor("#000000").setFogDepth(45).setAmbientStrength(1.5f).setAmbientColor("#AAAFB6").setDirectionalStrength(1.0f).setDirectionalColor("#FFFFFF").setLightDirection(260.0f, 10.0f)),
    STRONGHOLD_OF_SECURITY_FAMINE(Area.STRONGHOLD_OF_SECURITY_FAMINE, new Properties().setFogColor("#544222").setFogDepth(50).setAmbientStrength(1.3f).setAmbientColor("#C0AE94").setDirectionalStrength(1.0f).setDirectionalColor("#F5BC67").setLightDirection(260.0f, 10.0f)),
    STRONGHOLD_OF_SECURITY_PESTILENCE(Area.STRONGHOLD_OF_SECURITY_PESTILENCE, new Properties().setFogColor("#525e20").setFogDepth(50).setAmbientStrength(1.5f).setAmbientColor("#a2c35d").setDirectionalStrength(1.0f).setDirectionalColor("#FFFFFF").setLightDirection(260.0f, 10.0f)),
    STRONGHOLD_OF_SECURITY_DEATH(Area.STRONGHOLD_OF_SECURITY_DEATH, new Properties().setFogColor("#000000").setFogDepth(45).setAmbientStrength(1.5f).setAmbientColor("#542d22").setDirectionalStrength(1.0f).setDirectionalColor("#FFFFFF").setLightDirection(260.0f, 10.0f)),
    TOLNA_DUNGEON_ANGER(Area.TOLNA_DUNGEON_ANGER, new Properties().setFogColor("#290000").setFogDepth(40).setAmbientColor("#AE7D46").setAmbientStrength(1.3f).setDirectionalColor("#CB4848").setDirectionalStrength(1.8f).setLightDirection(260.0f, 10.0f)),
    TOLNA_DUNGEON_FEAR(Area.TOLNA_DUNGEON_FEAR, new Properties().setFogColor("#000B0F").setFogDepth(40).setAmbientColor("#77A0FF").setAmbientStrength(1.3f).setDirectionalColor("#4C78B6").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f)),
    TOLNA_DUNGEON_CONFUSION(Area.TOLNA_DUNGEON_CONFUSION, new Properties().setFogColor("#2E0C23").setFogDepth(40).setAmbientColor("#77A0FF").setAmbientStrength(1.3f).setDirectionalColor("#4E9DD0").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f)),
    DORGESHKAAN(Area.DORGESHKAAN, new Properties().setFogColor("#190D02").setFogDepth(40).setAmbientColor("#FFFFFF").setAmbientStrength(1.0f).setDirectionalColor("#A29B71").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f)),
    THE_INFERNO(Area.THE_INFERNO, new Properties().setUnderglowColor(255.0f, 0.0f, 0.0f).setUnderglowStrength(2.0f).setFogColor(23.0f, 11.0f, 7.0f).setFogDepth(20).setAmbientColor(240.0f, 184.0f, 184.0f).setAmbientStrength(1.7f).setDirectionalColor(255.0f, 246.0f, 202.0f).setDirectionalStrength(0.7f).setLightDirection(260.0f, 10.0f)),
    TZHAAR(Area.TZHAAR, new Properties().setFogColor("#1A0808").setFogDepth(15).setAmbientColor("#FFEACC").setAmbientStrength(0.8f).setDirectionalColor("#FFA400").setDirectionalStrength(1.8f).setLightDirection(260.0f, 10.0f)),
    HALLOWED_SEPULCHRE_LOBBY(Area.HALLOWED_SEPULCHRE_LOBBY, new Properties().setFogColor("#0D1012").setFogDepth(50).setAmbientStrength(0.7f).setAmbientColor("#C4D5EA").setDirectionalStrength(1.0f).setDirectionalColor("#A0BBE2").setLightDirection(260.0f, 10.0f)),
    HALLOWED_SEPULCHRE_FLOOR_1(Area.HALLOWED_SEPULCHRE_FLOOR_1, new Properties().setFogColor(17.0f, 28.0f, 26.0f).setFogDepth(50).setAmbientStrength(0.9f).setAmbientColor(155.0f, 187.0f, 177.0f).setDirectionalStrength(1.8f).setDirectionalColor(117.0f, 231.0f, 255.0f).setLightDirection(260.0f, 10.0f)),
    HALLOWED_SEPULCHRE_FLOOR_2(Area.HALLOWED_SEPULCHRE_FLOOR_2, new Properties().setFogColor(17.0f, 28.0f, 27.0f).setFogDepth(50).setAmbientStrength(0.875f).setAmbientColor(160.0f, 191.0f, 191.0f).setDirectionalStrength(1.5f).setDirectionalColor(116.0f, 214.0f, 247.0f).setLightDirection(260.0f, 10.0f)),
    HALLOWED_SEPULCHRE_FLOOR_3(Area.HALLOWED_SEPULCHRE_FLOOR_3, new Properties().setFogColor(18.0f, 28.0f, 29.0f).setFogDepth(50).setAmbientStrength(0.85f).setAmbientColor(165.0f, 195.0f, 205.0f).setDirectionalStrength(1.5f).setDirectionalColor(115.0f, 196.0f, 240.0f).setLightDirection(260.0f, 10.0f)),
    HALLOWED_SEPULCHRE_FLOOR_4(Area.HALLOWED_SEPULCHRE_FLOOR_4, new Properties().setFogColor(18.0f, 27.0f, 31.0f).setFogDepth(50).setAmbientStrength(0.825f).setAmbientColor(170.0f, 199.0f, 220.0f).setDirectionalStrength(1.5f).setDirectionalColor(114.0f, 178.0f, 233.0f).setLightDirection(260.0f, 10.0f)),
    HALLOWED_SEPULCHRE_FLOOR_5(Area.HALLOWED_SEPULCHRE_FLOOR_5, new Properties().setFogColor(19.0f, 27.0f, 33.0f).setFogDepth(50).setAmbientStrength(0.8f).setAmbientColor(175.0f, 202.0f, 234.0f).setDirectionalStrength(1.5f).setDirectionalColor(113.0f, 160.0f, 226.0f).setLightDirection(260.0f, 10.0f)),
    VER_SINHAZA(Area.VER_SINHAZA, new Properties().setFogColor("#1E314B").setFogDepth(40).setAmbientColor("#5A8CC0").setAmbientStrength(1.5f).setDirectionalColor("#67A8F8").setDirectionalStrength(5.0f).setGroundFog(-150, -350, 0.5f)),
    TOB_ROOM_VAULT(Area.TOB_ROOM_VAULT, new Properties().setFogColor("#0E081A").setFogDepth(40).setAmbientStrength(3.0f).setAmbientColor("#7575EA").setDirectionalStrength(1.0f).setDirectionalColor("#DDA6A6").setLightDirection(260.0f, 10.0f)),
    THEATRE_OF_BLOOD(Area.THEATRE_OF_BLOOD, new Properties().setFogColor("#0E0C2C").setFogDepth(40).setAmbientStrength(3.0f).setAmbientColor("#8282B0").setDirectionalStrength(5.0f).setDirectionalColor("#DFC0C0").setLightDirection(-128.0f, 55.0f)),
    TOA_LOOT_ROOM(Area.TOA_LOOT_ROOM, new Properties().setFogColor("#050505").setFogDepth(20).setAmbientStrength(1.2f).setAmbientColor("#ffffff").setDirectionalStrength(0.5f).setDirectionalColor("#ffffff").setLightDirection(-128.0f, 55.0f)),
    TOMBS_OF_AMASCUT(Area.TOMBS_OF_AMASCUT, new Properties().setFogColor("#050505").setFogDepth(20).setAmbientStrength(1.0f).setAmbientColor("#ffffff").setDirectionalStrength(0.75f).setDirectionalColor("#ffffff").setLightDirection(-128.0f, 55.0f)),
    BARROWS_CRYPTS(Area.BARROWS_CRYPTS, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(20).setAmbientColor(181.0f, 143.0f, 124.0f).setAmbientStrength(3.5f).setDirectionalColor(255.0f, 200.0f, 117.0f).setDirectionalStrength(0.0f).setLightDirection(260.0f, 10.0f)),
    BARROWS_TUNNELS(Area.BARROWS_TUNNELS, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(20).setAmbientColor(181.0f, 143.0f, 124.0f).setAmbientStrength(3.0f).setDirectionalColor(255.0f, 200.0f, 117.0f).setDirectionalStrength(0.5f).setLightDirection(260.0f, 10.0f)),
    BARROWS(Area.BARROWS, new Properties().setFogColor("#242D3A").setFogDepth(50).setAmbientColor("#5B83B3").setAmbientStrength(2.0f).setDirectionalColor("#526E8B").setDirectionalStrength(8.0f).enableLightning().setGroundFog(-300, -500, 0.5f)),
    DARKMEYER(Area.DARKMEYER, new Properties().setFogColor("#1E314B").setFogDepth(40).setAmbientColor("#8AABD5").setAmbientStrength(1.0f).setDirectionalColor("#62A3FF").setDirectionalStrength(4.0f).setGroundFog(-150, -350, 0.5f)),
    MEIYERDITCH(Area.MEIYERDITCH, new Properties().setFogColor("#1E314B").setFogDepth(40).setAmbientColor("#dad8ce").setAmbientStrength(2.0f).setDirectionalColor("#ced6da").setDirectionalStrength(1.8f).setGroundFog(-150, -350, 0.5f)),
    MEIYERDITCH_MYREQUE_HIDEOUT(Area.MEIYERDITCH_MYREQUE_HIDEOUT, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(69).setAmbientColor("#dad8ce").setAmbientStrength(1.5f).setDirectionalColor("#ced6da").setDirectionalStrength(0.5f).setLightDirection(260.0f, 10.0f)),
    MEIYERDITCH_MINES(Area.MEIYERDITCH_MINES, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(70).setAmbientColor("#dad8ce").setAmbientStrength(1.5f).setDirectionalColor("#ced6da").setDirectionalStrength(0.5f).setLightDirection(260.0f, 10.0f)),
    MORYTANIA(Area.MORYTANIA, new Properties().setFogColor("#1E314B").setFogDepth(40).setAmbientColor("#5A8CC0").setAmbientStrength(2.0f).setDirectionalColor("#F8BF68").setDirectionalStrength(2.0f).setGroundFog(-150, -350, 0.5f)),
    LUMBRIDGE_CASTLE_BASEMENT(Area.LUMBRIDGE_CASTLE_BASEMENT, new Properties().setFogColor("#070606").setFogDepth(84).setAmbientColor("#FFFFFF").setAmbientStrength(1.0f).setDirectionalColor("#A29B71").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f)),
    GOBLIN_MAZE(Area.GOBLIN_MAZE, new Properties().setFogColor("#050D02").setFogDepth(60).setAmbientColor("#FFFFFF").setAmbientStrength(0.75f).setDirectionalColor("#A29B71").setDirectionalStrength(0.75f).setLightDirection(260.0f, 10.0f)),
    LUMBRIDGE_SWAMP_CAVES(Area.LUMBRIDGE_SWAMP_CAVES, new Properties().setFogColor("#040D02").setFogDepth(50).setAmbientColor(198.0f, 201.0f, 194.0f).setAmbientStrength(0.9f).setDirectionalColor(168.0f, 171.0f, 144.0f).setDirectionalStrength(0.85f).setLightDirection(260.0f, 10.0f)),
    DRAYNOR_MANOR(Area.DRAYNOR_MANOR, new Properties().setFogColor("#0c0b0a").setFogDepth(45).setAmbientColor("#615C57").setAmbientStrength(1.5f).setDirectionalColor("#FFBCB7").setDirectionalStrength(2.0f).enableLightning()),
    DRAYNOR_MANOR_FOREST(Area.DRAYNOR_MANOR_FOREST, new Properties().setFogColor(71.0f, 64.0f, 85.0f).setFogDepth(20).setAmbientColor("#615C57").setAmbientStrength(1.5f).setDirectionalColor("#FFBCB7").setDirectionalStrength(2.0f).enableLightning()),
    DRAYNOR_MANOR_BASEMENT(Area.DRAYNOR_MANOR_BASEMENT, new Properties().setFogColor("#190D02").setFogDepth(40).setAmbientColor("#7891B5").setAmbientStrength(1.0f).setDirectionalColor(76.0f, 120.0f, 182.0f).setDirectionalStrength(0.0f).setLightDirection(260.0f, 10.0f)),
    MISTHALIN_MYSTERY_MANOR(Area.MISTHALIN_MYSTERY_MANOR, new Properties().setFogColor(15.0f, 14.0f, 13.0f).setFogDepth(30).setAmbientColor("#615C57").setAmbientStrength(1.5f).setDirectionalColor("#FFBCB7").setDirectionalStrength(2.0f).enableLightning()),
    MOTHERLODE_MINE(Area.MOTHERLODE_MINE, new Properties().setFogColor("#241809").setFogDepth(40).setAmbientColor("#AAAFB6").setAmbientStrength(4.0f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    GAMES_ROOM(Area.GAMES_ROOM, new Properties().setFogColor("#190D02").setFogDepth(20).setAmbientColor(181.0f, 155.0f, 121.0f).setAmbientStrength(1.5f).setDirectionalColor(162.0f, 151.0f, 148.0f).setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    SOUL_WARS_RED_BASE(Area.SOUL_WARS_RED_BASE, new Properties().setFogColor(28.0f, 21.0f, 13.0f)),
    SMOKE_DUNGEON(Area.SMOKE_DUNGEON, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(80).setAmbientColor(171.0f, 171.0f, 171.0f).setAmbientStrength(1.0f).setDirectionalColor(86.0f, 86.0f, 86.0f).setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    KHARIDIAN_DESERT_DEEP(Area.KHARIDIAN_DESERT_DEEP, new Properties().setFogColor("#CDAF7A").setFogDepth(50).setAmbientColor("#C0AE94").setAmbientStrength(3.0f).setDirectionalColor("#F5BC67").setDirectionalStrength(1.0f)),
    KHARIDIAN_DESERT_MID(Area.KHARIDIAN_DESERT_MID, new Properties().setFogColor("#C8B085").setFogDepth(40).setAmbientColor("#C0AE94").setAmbientStrength(3.0f).setDirectionalColor("#F5BC67").setDirectionalStrength(1.0f)),
    KHARIDIAN_DESERT(Area.KHARIDIAN_DESERT, new Properties().setFogColor("#C7B79B").setFogDepth(25).setAmbientColor("#A6AFC2").setAmbientStrength(2.5f).setDirectionalColor("#EDCFA3").setDirectionalStrength(2.5f)),
    DESERT_TREASURE_PYRAMID(Area.DESERT_TREASURE_PYRAMID, new Properties().setFogColor(39.0f, 23.0f, 4.0f).setFogDepth(40).setAmbientColor(192.0f, 159.0f, 110.0f).setAmbientStrength(1.0f).setDirectionalColor(138.0f, 158.0f, 182.0f).setDirectionalStrength(0.25f).setLightDirection(-128.0f, 55.0f)),
    PYRAMID_PLUNDER(Area.PYRAMID_PLUNDER, new Properties().setFogColor("#190D02").setFogDepth(40).setAmbientColor(181.0f, 155.0f, 121.0f).setAmbientStrength(1.0f).setDirectionalColor(138.0f, 158.0f, 182.0f).setDirectionalStrength(0.75f).setLightDirection(260.0f, 10.0f)),
    KALPHITE_LAIR(Area.KALPHITE_LAIR, new Properties().setFogColor("#161101").setFogDepth(35).setAmbientColor("#AAAFB6").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    GIELINOR_SNOWY_NORTHERN_REGION(Area.GIELINOR_SNOWY_NORTHERN_REGION, new Properties().setFogColor("#AEBDE0").setFogDepth(70).setAmbientColor("#6FB0FF").setAmbientStrength(1.5f).setDirectionalColor("#F4E5C9").setDirectionalStrength(2.5f)),
    MOUNTAIN_CAMP_ENTRY_PATH(Area.MOUNTAIN_CAMP_ENTRY_PATH, new Properties().setFogColor(178.0f, 187.0f, 197.0f).setFogDepth(50).setAmbientStrength(0.9f).setDirectionalStrength(1.0f).setGroundFog(-600, -900, 0.4f)),
    MOUNTAIN_CAMP(Area.MOUNTAIN_CAMP, new Properties().setFogColor(178.0f, 187.0f, 197.0f).setFogDepth(50).setAmbientStrength(0.9f).setDirectionalStrength(1.0f).setGroundFog(-1200, -1600, 0.5f)),
    FREMENNIK_PROVINCE(Area.FREMENNIK_PROVINCE, new Properties().setFogColor("#969CA2").setFogDepth(40).setAmbientStrength(0.9f).setAmbientColor("#96A3CB").setDirectionalStrength(2.0f).setDirectionalColor("#ABC2D3").setGroundFog(-200, -400, 0.3f)),
    PENGUIN_BASE(Area.PENGUIN_BASE, new Properties().setFogColor("#090808").setFogDepth(40).setAmbientColor("#AAAFB6").setAmbientStrength(0.75f).setDirectionalColor("#FFFFFF").setDirectionalStrength(0.75f).setLightDirection(260.0f, 10.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    KARAMJA_VOLCANO_DUNGEON(Area.KARAMJA_VOLCANO_DUNGEON, new Properties().setFogColor("#190D02").setFogDepth(40).setAmbientColor("#7891B5").setAmbientStrength(0.5f).setDirectionalColor(76.0f, 120.0f, 182.0f).setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    BRIMHAVEN_AGILITY_ARENA(Area.BRIMHAVEN_AGILITY_ARENA, new Properties().setFogColor("#1A0808").setFogDepth(25).setAmbientColor("#FFEACC").setAmbientStrength(1.2f).setDirectionalColor("#FFA400").setDirectionalStrength(1.0f).setLightDirection(240.0f, 190.0f)),
    UNGAEL(Area.UNGAEL, new Properties().setFogColor(226.0f, 230.0f, 237.0f).setFogDepth(40).setAmbientColor(234.0f, 226.0f, 205.0f).setAmbientStrength(0.6f).setDirectionalColor(130.0f, 172.0f, 224.0f).setDirectionalStrength(1.5f)),
    GOD_WARS_DUNGEON(Area.GOD_WARS_DUNGEON, new Properties().setFogColor(14.0f, 59.0f, 89.0f).setFogDepth(30).setAmbientColor(181.0f, 215.0f, 255.0f).setAmbientStrength(1.0f).setDirectionalColor(146.0f, 209.0f, 250.0f).setDirectionalStrength(1.8f).setLightDirection(260.0f, 10.0f).setWaterColor(56.0f, 188.0f, 255.0f)),
    TAR_SWAMP(Area.TAR_SWAMP, new Properties().setFogColor(42.0f, 49.0f, 36.0f).setFogDepth(50).setAmbientColor(248.0f, 224.0f, 172.0f).setAmbientStrength(0.8f).setDirectionalColor(168.0f, 171.0f, 144.0f).setDirectionalStrength(1.25f)),
    SOTE_LLETYA_MOSTLY_DONE_BURNING(Area.SOTE_LLETYA_MOSTLY_DONE_BURNING, new Properties().setFogColor(91.0f, 139.0f, 120.0f).setFogDepth(30).setAmbientStrength(1.0f).setDirectionalStrength(0.0f).setAllowSkyOverride(false)),
    SOTE_LLETYA_ON_FIRE(Area.SOTE_LLETYA_ON_FIRE, new Properties().setFogColor(91.0f, 139.0f, 120.0f).setFogDepth(50).setAmbientStrength(0.9f).setDirectionalStrength(0.0f).setAllowSkyOverride(false)),
    POISON_WASTE(Area.POISON_WASTE, new Properties().setFogColor(50.0f, 55.0f, 47.0f).setFogDepth(30).setAmbientColor(192.0f, 219.0f, 173.0f).setAmbientStrength(1.0f).setDirectionalColor(173.0f, 176.0f, 139.0f).setDirectionalStrength(2.0f)),
    TIRANNWN_MAINLAND(Area.TIRANNWN_MAINLAND, new Properties().setFogColor("#99D8C8").setFogDepth(15)),
    PRIFDDINAS(Area.PRIFDDINAS, new Properties().setFogColor("#99D8C8").setFogDepth(15).setLightDirection(-128.0f, 55.0f)),
    ZALCANO(Area.ZALCANO, new Properties().setFogColor(0.8f, 0.6f, 0.6f).setFogDepth(40).setAmbientColor("#AAAFB6").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    SOTE_GRAND_LIBRARY(Area.SOTE_GRAND_LIBRARY, new Properties().setFogColor(18.0f, 64.0f, 83.0f).setAmbientStrength(0.3f).setDirectionalStrength(1.0f).setAllowSkyOverride(false).setLightDirection(-128.0f, 55.0f)),
    SOTE_FRAGMENT_OF_SEREN_ARENA(Area.SOTE_FRAGMENT_OF_SEREN_ARENA, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setAllowSkyOverride(false).setLightDirection(-128.0f, 55.0f)),
    Shadow_DUNGEON(Area.SHADOW_DUNGEON, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(60).setAmbientColor(171.0f, 171.0f, 171.0f).setAmbientStrength(1.0f).setDirectionalColor(86.0f, 86.0f, 86.0f).setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    NIGHTMARE_ZONE(Area.NIGHTMARE_ZONE, new Properties().setFogColor("#190D02").setFogDepth(40).setAmbientColor("#F2B979").setAmbientStrength(0.9f).setDirectionalColor("#97DDFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    CASTLE_WARS_UNDERGROUND(Area.CASTLE_WARS_UNDERGROUND, new Properties().setFogColor("#190D02").setFogDepth(40).setAmbientColor("#AAAFB6").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    LMS_ARENA_WILD_VARROCK(Area.LMS_ARENA_WILD_VARROCK, new Properties().setFogColor("#695B6B").setFogDepth(30).setAmbientStrength(0.6f).setAmbientColor(215.0f, 210.0f, 210.0f).setDirectionalStrength(2.5f).setDirectionalColor("#C5B8B6").setGroundFog(0, -250, 0.3f)),
    KARUULM_SLAYER_DUNGEON(Area.KARUULM_SLAYER_DUNGEON, new Properties().setFogColor("#051E22").setFogDepth(40).setAmbientColor("#A4D2E5").setAmbientStrength(2.0f).setDirectionalColor("#9AEAFF").setDirectionalStrength(0.75f).setLightDirection(260.0f, 10.0f)),
    KOUREND_CATACOMBS(Area.KOUREND_CATACOMBS, new Properties().setFogColor("#0E0022").setFogDepth(40).setAmbientColor("#8B7DDB").setAmbientStrength(3.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(-128.0f, 55.0f)),
    KEBOS_LOWLANDS(Area.KEBOS_LOWLANDS, new Properties().setFogColor(41.0f, 44.0f, 16.0f).setFogDepth(50).setAmbientColor(255.0f, 215.0f, 133.0f).setAmbientStrength(0.8f).setDirectionalColor(207.0f, 229.0f, 181.0f).setDirectionalStrength(1.0f)),
    BLOOD_ALTAR(Area.BLOOD_ALTAR, new Properties().setFogColor(79.0f, 19.0f, 37.0f).setFogDepth(30).setAmbientColor(190.0f, 72.0f, 174.0f).setAmbientStrength(1.0f).setDirectionalColor(78.0f, 238.0f, 255.0f).setDirectionalStrength(2.5f)),
    ZEAH_SNOWY_NORTHERN_REGION(Area.ZEAH_SNOWY_NORTHERN_REGION, new Properties().setFogColor("#AEBDE0").setFogDepth(70).setAmbientColor("#6FB0FF").setAmbientStrength(1.5f).setDirectionalColor("#F4E5C9").setDirectionalStrength(2.5f)),
    ARCEUUS(Area.ARCEUUS, new Properties().setFogColor(19.0f, 24.0f, 79.0f).setFogDepth(30).setAmbientColor(99.0f, 105.0f, 255.0f).setAmbientStrength(1.0f).setDirectionalColor(78.0f, 238.0f, 255.0f).setDirectionalStrength(3.5f)),
    LOVAKENGJ(Area.LOVAKENGJ, new Properties().setFogColor(21.0f, 10.0f, 5.0f).setFogDepth(40).setAmbientColor(255.0f, 215.0f, 133.0f).setAmbientStrength(1.0f).setDirectionalColor(125.0f, 141.0f, 179.0f).setDirectionalStrength(4.0f).setWaterColor(185.0f, 214.0f, 255.0f)),
    THE_STRANGLEWOOD(Area.THE_STRANGLEWOOD, new Properties().setFogColor("#af979f").setFogDepth(35).setAmbientColor("#c0bde7").setAmbientStrength(2.0f).setDirectionalColor("#f2edf4").setDirectionalStrength(2.5f)),
    THE_STRANGLEWOOD_QUEST_UNDERGROUND_AREAS(Area.THE_STRANGLEWOOD_QUEST_UNDERGROUND_AREAS, new Properties().setFogColor("#070707").setFogDepth(20).setAmbientColor("#AAAFB6").setAmbientStrength(4.0f).setDirectionalColor("#FFFFFF").setDirectionalStrength(0.0f).setLightDirection(260.0f, 10.0f).setAllowSkyOverride(false)),
    JUDGE_OF_YAMA_BOSS(Area.JUDGE_OF_YAMA_BOSS, new Properties().setFogColor("#0e1826").setFogDepth(50).setAmbientColor("#8AABD5").setAmbientStrength(1.0f).setDirectionalColor("#62A3FF").setDirectionalStrength(4.0f).setGroundFog(-150, -350, 0.5f).setAllowSkyOverride(false)),
    COSMIC_ENTITYS_PLANE(Area.COSMIC_ENTITYS_PLANE, new Properties().setFogColor("#000000").setAmbientStrength(1.5f).setAmbientColor("#DB6FFF").setDirectionalStrength(3.0f).setDirectionalColor("#57FF00").setLightDirection(260.0f, 10.0f).setAllowSkyOverride(false)),
    ZANARIS(Area.ZANARIS, new Properties().setFogColor(22.0f, 63.0f, 71.0f).setFogDepth(30).setAmbientColor(115.0f, 181.0f, 195.0f).setAmbientStrength(0.5f).setDirectionalColor(245.0f, 214.0f, 122.0f).setDirectionalStrength(1.3f).setLightDirection(260.0f, 10.0f)),
    THE_GAUNTLET_NORMAL(Area.THE_GAUNTLET_NORMAL, new Properties().setFogColor("#090606").setFogDepth(20).setAmbientColor("#D2C0B7").setAmbientStrength(1.5f).setDirectionalColor("#78FFE3").setDirectionalStrength(3.0f).setLightDirection(260.0f, 10.0f)),
    THE_GAUNTLET_CORRUPTED(Area.THE_GAUNTLET_CORRUPTED, new Properties().setFogColor("#090606").setFogDepth(20).setAmbientColor("#BB9EAE").setAmbientStrength(1.5f).setDirectionalColor("#C58C9E").setDirectionalStrength(3.0f).setLightDirection(260.0f, 10.0f)),
    THE_GAUNTLET_LOBBY(Area.THE_GAUNTLET_LOBBY, new Properties().setFogColor("#090606").setFogDepth(20).setAmbientColor("#D2C0B7").setAmbientStrength(1.5f).setDirectionalColor("#78FFE3").setDirectionalStrength(3.0f).setLightDirection(260.0f, 10.0f)),
    PLAYER_OWNED_HOUSE_SNOWY(Area.PLAYER_OWNED_HOUSE_SNOWY, new Properties().setFogColor("#AEBDE0").setFogDepth(50).setAmbientColor("#6FB0FF").setAmbientStrength(1.5f).setDirectionalColor("#F4E5C9").setDirectionalStrength(2.5f)),
    BLACKHOLE(Area.BLACKHOLE, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(20).setAmbientStrength(1.2f).setAmbientColor(255.0f, 255.0f, 255.0f).setDirectionalStrength(0.0f).setLightDirection(260.0f, 10.0f).setAllowSkyOverride(false)),
    CAMDOZAAL(Area.CAMDOZAAL, new Properties().setFogColor("#080012").setFogDepth(40).setAmbientStrength(1.5f).setAmbientColor("#C9B9F7").setDirectionalStrength(0.0f).setDirectionalColor("#6DC5FF").setLightDirection(260.0f, 10.0f)),
    TEMPOROSS_COVE(Area.TEMPOROSS_COVE, new Properties().setFogColor("#45474B").setFogDepth(60).setAmbientStrength(2.0f).setAmbientColor("#A5ACBD").setDirectionalStrength(1.0f).setDirectionalColor("#707070").enableLightning()),
    TEMPLE_OF_THE_EYE(Area.TEMPLE_OF_THE_EYE, new Properties().setFogColor(0.0f, 32.0f, 51.0f).setFogDepth(15).setAmbientStrength(1.0f).setAmbientColor(255.0f, 255.0f, 255.0f).setDirectionalStrength(0.3f).setDirectionalColor(230.0f, 244.0f, 255.0f).setLightDirection(-130.0f, 55.0f).setUnderwater(true).setUnderwaterCausticsStrength(40.0f)),
    DEATHS_OFFICE(Area.DEATHS_OFFICE, new Properties().setFogColor("#000000").setFogDepth(20).setAmbientColor("#AAAFB6").setAmbientStrength(4.0f).setDirectionalColor("#FFFFFF").setDirectionalStrength(0.0f).setLightDirection(260.0f, 10.0f).setAllowSkyOverride(false)),
    CHAMBERS_OF_XERIC(Area.CHAMBERS_OF_XERIC, new Properties().setFogColor("#122717").setFogDepth(35).setAmbientStrength(3.0f).setAmbientColor("#7897C3").setDirectionalStrength(1.0f).setDirectionalColor("#ACFF68").setLightDirection(260.0f, 10.0f)),
    NIGHTMARE_OF_ASHIHAMA_ARENA(Area.NIGHTMARE_OF_ASHIHAMA_ARENA, new Properties().setFogColor("#000000").setFogDepth(30).setAmbientStrength(2.5f).setAmbientColor("#9A5DFD").setDirectionalStrength(2.0f).setDirectionalColor("#00FF60").setLightDirection(260.0f, 10.0f)),
    SISTERHOOD_SANCTUARY(Area.SISTERHOOD_SANCTUARY, new Properties().setFogColor("#000000").setFogDepth(25).setAmbientColor("#ffffff").setAmbientStrength(1.0f).setDirectionalColor("#ffffff").setDirectionalStrength(0.25f).setLightDirection(-128.0f, 55.0f).setWaterColor(102.0f, 234.0f, 255.0f).setAllowSkyOverride(false)),
    MOGRE_CAMP(Area.MOGRE_CAMP, new Properties().setFogColor("#133156").setFogDepth(60).setAmbientStrength(0.5f).setAmbientColor("#255590").setDirectionalStrength(5.0f).setDirectionalColor("#71A3D0").setGroundFog(0, -500, 0.5f).setUnderwater(true)),
    HARMONY_ISLAND_UNDERWATER_TUNNEL(Area.HARMONY_ISLAND_UNDERWATER_TUNNEL, new Properties().setFogColor("#133156").setFogDepth(80).setAmbientStrength(2.0f).setAmbientColor("#255590").setDirectionalStrength(2.5f).setDirectionalColor("#71A3D0").setLightDirection(260.0f, 10.0f).setGroundFog(-800, -1100, 0.5f).setUnderwater(true)),
    FOSSIL_ISLAND_UNDERWATER_AREA(Area.FOSSIL_ISLAND_UNDERWATER_AREA, new Properties().setFogColor("#133156").setFogDepth(60).setAmbientStrength(0.5f).setAmbientColor("#255590").setDirectionalStrength(5.0f).setDirectionalColor("#71A3D0").setLightDirection(260.0f, 10.0f).setGroundFog(-400, -750, 0.5f).setUnderwater(true)),
    LUNAR_DREAM_WORLD(Area.LUNAR_DREAM_WORLD, new Properties().setFogColor("#000000").setFogDepth(40).setAmbientColor("#77A0FF").setAmbientStrength(3.0f).setDirectionalColor("#CAB6CD").setDirectionalStrength(0.7f).setLightDirection(260.0f, 10.0f).setAllowSkyOverride(false)),
    COSMIC_ALTAR(Area.COSMIC_ALTAR, new Properties().setFogColor("#000000").setFogDepth(40).setAmbientColor("#FFFFFF").setAmbientStrength(0.2f).setDirectionalColor("#FFFFFF").setDirectionalStrength(3.0f).setLightDirection(260.0f, 10.0f).setAllowSkyOverride(false)),
    TRUE_BLOOD_ALTAR(Area.TRUE_BLOOD_ALTAR, new Properties().setFogColor("#000000").setFogDepth(25)),
    TARNS_LAIR(Area.TARNS_LAIR, new Properties().setFogColor("#241809").setFogDepth(40).setAmbientColor("#AAAFB6").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    RANDOM_EVENT_DRILL_DEMON(Area.RANDOM_EVENT_DRILL_DEMON, new Properties().setFogColor("#696559")),
    GIANTS_FOUNDRY(Area.GIANTS_FOUNDRY, new Properties().setFogColor(0.0f, 0.0f, 0.0f).setFogDepth(12).setAmbientStrength(1.1f).setAmbientColor(255.0f, 255.0f, 255.0f).setDirectionalStrength(1.0f).setDirectionalColor(255.0f, 193.0f, 153.0f).setLightDirection(-113.0f, -120.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    ELID_CAVE(Area.ELID_CAVE, new Properties().setFogColor("#000000").setFogDepth(40).setAmbientColor("#AAAFB6").setAmbientStrength(1.75f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    ANCIENT_CAVERN(Area.ANCIENT_CAVERN, new Properties().setFogColor("#000000").setFogDepth(25).setAmbientColor("#AAAFB6").setAmbientStrength(2.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f).setWaterColor(79.0f, 178.0f, 255.0f)),
    ICY_UNDERGROUND_DARK(Area.ICY_UNDERGROUND_DARK, new Properties().setFogColor("#030303").setFogDepth(25).setAmbientColor("#AAAFB6").setAmbientStrength(0.75f).setDirectionalColor("#FFFFFF").setDirectionalStrength(0.75f).setLightDirection(260.0f, 10.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    ICY_UNDERGROUND_BRIGHT(Area.ICY_UNDERGROUND_BRIGHT, new Properties().setFogColor("#ADC5E4").setFogDepth(68).setAmbientColor("#AAAFB6").setAmbientStrength(0.75f).setDirectionalColor("#FFFFFF").setDirectionalStrength(0.75f).setLightDirection(260.0f, 10.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    GOBLIN_VILLAGE_COOKS_CHAMBER(Area.GOBLIN_VILLAGE_COOKS_CHAMBER, new Properties().setFogColor("#030303").setFogDepth(5).setAmbientColor("#AAAFB6").setAmbientStrength(0.75f).setDirectionalColor("#FFFFFF").setDirectionalStrength(0.75f).setLightDirection(260.0f, 10.0f).setAllowSkyOverride(false)),
    MAGE_ARENA_BANK(Area.MAGE_ARENA_BANK, new Properties().setFogDepth(40).setFogColor("#000000").setAmbientStrength(1.5f).setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f)),
    TEARS_OF_GUTHIX(Area.TEARS_OF_GUTHIX, new Properties().setFogColor("#060505").setFogDepth(50).setAmbientColor("#AAAFB6").setAmbientStrength(2.5f).setDirectionalColor("#878474").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f)),
    BURGH_DE_ROTT_BASEMENT(Area.BURGH_DE_ROTT_BASEMENT, new Properties().setFogColor("#030403").setFogDepth(84).setAmbientColor("#FFFFFF").setAmbientStrength(1.0f).setDirectionalColor("#A29B71").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f)),
    KEEP_LE_FAYE_JAIL(Area.KEEP_LE_FAYE_JAIL, new Properties().setFogColor("#070606").setFogDepth(84).setAmbientColor("#AAAFB6").setAmbientStrength(1.0f).setDirectionalColor("#878474").setDirectionalStrength(1.5f).setLightDirection(260.0f, 10.0f)),
    POISON_WASTE_DUNGEON(Area.POISON_WASTE_DUNGEON, new Properties().setFogColor("#000000").setFogDepth(40).setAmbientColor("#AAAFB6").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(260.0f, 10.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    THE_SCAR(Area.THE_SCAR, new Properties().setFogColor("#080707").setFogDepth(15).setAmbientColor("#ffedec").setAmbientStrength(1.5f).setDirectionalColor("#fafaff").setDirectionalStrength(0.5f).setLightDirection(270.0f, 0.0f)),
    LASSAR_UNDERCITY_WATER_CUTSCENE(Area.LASSAR_UNDERCITY_WATER_CUTSCENE, new Properties().setFogColor("#000000").setFogDepth(50).setAmbientColor("#AAAFB6").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(210.0f, 135.0f).setWaterColor(43.0f, 43.0f, 64.0f)),
    LASSAR_UNDERCITY_NORMAL(Area.LASSAR_UNDERCITY_NORMAL, new Properties().setFogColor("#000000").setFogDepth(5).setAmbientColor("#AAAFB6").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(230.0f, -45.0f).setWaterColor(43.0f, 43.0f, 64.0f)),
    LASSAR_UNDERCITY_SHADOW_REALM(Area.LASSAR_UNDERCITY_SHADOW_REALM, new Properties().setFogColor("#030e09").setFogDepth(25).setAmbientColor("#aab6ac").setAmbientStrength(1.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.0f).setLightDirection(230.0f, -45.0f).setWaterColor(43.0f, 43.0f, 64.0f)),
    OVERWORLD(Area.OVERWORLD, new Properties().setLightDirection(-128.0f, 55.0f)),
    AUTUMN(Area.NONE, new Properties().setFogColor("#fddcb4").setFogDepth(18).setAmbientColor(ColorUtils.colorTemperatureToLinearRgb(3200.0)).setAmbientStrength(0.3f).setDirectionalColor(ColorUtils.colorTemperatureToLinearRgb(3200.0)).setDirectionalStrength(1.7f).setLightDirection(215.0f, -78.0f)),
    WINTER(Area.NONE, new Properties().setFogColor("#B8C5DB").setFogDepth(35).setAmbientColor("#8FCAFF").setAmbientStrength(3.5f).setDirectionalColor("#FFFFFF").setDirectionalStrength(1.5f).setLightDirection(-128.0f, 55.0f)),
    DEFAULT(Area.ALL, new Properties().setFogColor("#000000").setFogDepth(25).setAmbientColor("#ffffff").setAmbientStrength(1.0f).setDirectionalColor("#ffffff").setDirectionalStrength(0.25f).setLightDirection(-128.0f, 55.0f).setWaterColor(102.0f, 234.0f, 255.0f)),
    NONE(Area.NONE, new Properties().setFogColor("#ff00ff"));

    private final Area area;
    private final boolean isUnderwater;
    private final boolean allowSkyOverride;
    private final boolean lightningEffects;
    private final float[] ambientColor;
    private final float ambientStrength;
    private final float[] directionalColor;
    private final float directionalStrength;
    private final float[] sunAngles;
    private final float[] fogColor;
    private final float fogDepth;
    private final int groundFogStart;
    private final int groundFogEnd;
    private final float groundFogOpacity;
    private final float[] waterColor;
    private final float[] waterCausticsColor;
    private final float waterCausticsStrength;
    private final float[] underglowColor;
    private final float underglowStrength;

    private Environment(Area area, Properties properties) {
        float[] fArray;
        this.area = area;
        this.fogDepth = properties.fogDepth;
        this.fogColor = properties.customFogColor ? properties.fogColor : null;
        this.ambientStrength = properties.ambientStrength;
        this.ambientColor = properties.ambientColor;
        this.directionalStrength = properties.directionalStrength;
        this.directionalColor = properties.directionalColor;
        this.underglowColor = properties.underglowColor;
        this.underglowStrength = properties.underglowStrength;
        this.lightningEffects = properties.lightningEnabled;
        this.groundFogStart = properties.groundFogStart;
        this.groundFogEnd = properties.groundFogEnd;
        this.groundFogOpacity = properties.groundFogOpacity;
        if (properties.customLightDirection) {
            float[] fArray2 = new float[2];
            fArray2[0] = properties.lightPitch;
            fArray = fArray2;
            fArray2[1] = properties.lightYaw;
        } else {
            fArray = null;
        }
        this.sunAngles = fArray;
        this.allowSkyOverride = properties.allowSkyOverride;
        this.isUnderwater = properties.underwater;
        this.waterCausticsColor = properties.underwaterCausticsColor == null ? properties.directionalColor : properties.underwaterCausticsColor;
        this.waterCausticsStrength = properties.underwaterCausticsStrength == 0.0f ? properties.directionalStrength : properties.underwaterCausticsStrength;
        this.waterColor = properties.customWaterColor ? properties.waterColor : null;
    }

    public Area getArea() {
        return this.area;
    }

    public boolean isUnderwater() {
        return this.isUnderwater;
    }

    public boolean isAllowSkyOverride() {
        return this.allowSkyOverride;
    }

    public boolean isLightningEffects() {
        return this.lightningEffects;
    }

    public float[] getAmbientColor() {
        return this.ambientColor;
    }

    public float getAmbientStrength() {
        return this.ambientStrength;
    }

    public float[] getDirectionalColor() {
        return this.directionalColor;
    }

    public float getDirectionalStrength() {
        return this.directionalStrength;
    }

    public float[] getSunAngles() {
        return this.sunAngles;
    }

    public float[] getFogColor() {
        return this.fogColor;
    }

    public float getFogDepth() {
        return this.fogDepth;
    }

    public int getGroundFogStart() {
        return this.groundFogStart;
    }

    public int getGroundFogEnd() {
        return this.groundFogEnd;
    }

    public float getGroundFogOpacity() {
        return this.groundFogOpacity;
    }

    public float[] getWaterColor() {
        return this.waterColor;
    }

    public float[] getWaterCausticsColor() {
        return this.waterCausticsColor;
    }

    public float getWaterCausticsStrength() {
        return this.waterCausticsStrength;
    }

    public float[] getUnderglowColor() {
        return this.underglowColor;
    }

    public float getUnderglowStrength() {
        return this.underglowStrength;
    }

    private static class Properties {
        private float fogDepth = 6.5f;
        private float[] fogColor = ColorUtils.rgb(185.0f, 214.0f, 255.0f);
        private boolean customFogColor = false;
        private float ambientStrength = 1.0f;
        private float[] ambientColor = ColorUtils.rgb(151.0f, 186.0f, 255.0f);
        private float directionalStrength = 4.0f;
        private float[] directionalColor = ColorUtils.rgb(255.0f, 255.0f, 255.0f);
        private float underglowStrength = 0.0f;
        private float[] underglowColor = ColorUtils.rgb(0.0f, 0.0f, 0.0f);
        private boolean lightningEnabled = false;
        private int groundFogStart = -200;
        private int groundFogEnd = -500;
        private float groundFogOpacity = 0.0f;
        private float lightPitch = (float)Math.toRadians(-128.0) + (float)Math.PI;
        private float lightYaw = (float)Math.toRadians(55.0) + (float)Math.PI;
        private boolean customLightDirection = false;
        private boolean allowSkyOverride = true;
        private boolean underwater = false;
        private float[] underwaterCausticsColor = null;
        private float underwaterCausticsStrength = 0.0f;
        private float[] waterColor = ColorUtils.rgb(185.0f, 214.0f, 255.0f);
        private boolean customWaterColor = false;

        private Properties() {
        }

        public Properties setFogDepth(int depth) {
            this.fogDepth = depth;
            return this;
        }

        public Properties setFogColor(String hex) {
            return this.setFogColor(ColorUtils.rgb(hex));
        }

        public Properties setFogColor(float r, float g, float b) {
            return this.setFogColor(ColorUtils.rgb(r, g, b));
        }

        public Properties setFogColor(float[] linearRgb) {
            this.fogColor = linearRgb;
            this.customFogColor = true;
            return this;
        }

        public Properties setAmbientStrength(float str) {
            this.ambientStrength = str;
            return this;
        }

        public Properties setAmbientColor(float r, float g, float b) {
            this.ambientColor = ColorUtils.rgb(r, g, b);
            return this;
        }

        public Properties setAmbientColor(String hex) {
            return this.setAmbientColor(ColorUtils.rgb(hex));
        }

        public Properties setAmbientColor(float[] linearRgb) {
            this.ambientColor = linearRgb;
            return this;
        }

        public Properties setWaterColor(float r, float g, float b) {
            return this.setWaterColor(ColorUtils.rgb(r, g, b));
        }

        public Properties setWaterColor(float[] linearRgb) {
            this.waterColor = linearRgb;
            this.customWaterColor = true;
            return this;
        }

        public Properties setDirectionalStrength(float str) {
            this.directionalStrength = str;
            return this;
        }

        public Properties setDirectionalColor(float r, float g, float b) {
            return this.setDirectionalColor(ColorUtils.rgb(r, g, b));
        }

        public Properties setDirectionalColor(String hex) {
            return this.setDirectionalColor(ColorUtils.rgb(hex));
        }

        public Properties setDirectionalColor(float[] linearRgb) {
            this.directionalColor = linearRgb;
            return this;
        }

        public Properties setUnderglowStrength(float str) {
            this.underglowStrength = str;
            return this;
        }

        public Properties setUnderglowColor(float r, float g, float b) {
            this.underglowColor = ColorUtils.rgb(r, g, b);
            return this;
        }

        public Properties setGroundFog(int start, int end, float maxOpacity) {
            this.groundFogStart = start;
            this.groundFogEnd = end;
            this.groundFogOpacity = maxOpacity;
            return this;
        }

        public Properties enableLightning() {
            this.lightningEnabled = true;
            return this;
        }

        public Properties setLightDirection(float pitch, float yaw) {
            this.lightPitch = HDUtils.mod((float)Math.toRadians(pitch) + (float)Math.PI, (float)Math.PI * 2);
            this.lightYaw = HDUtils.mod((float)Math.toRadians(yaw) + (float)Math.PI, (float)Math.PI * 2);
            this.customLightDirection = true;
            return this;
        }

        public Properties setAllowSkyOverride(boolean s) {
            this.allowSkyOverride = s;
            return this;
        }

        public Properties setUnderwater(boolean underwater) {
            this.underwater = underwater;
            return this;
        }

        public Properties setUnderwaterCausticsColor(float[] linearRgb) {
            this.underwaterCausticsColor = linearRgb;
            return this;
        }

        public Properties setUnderwaterCausticsStrength(float strength) {
            this.underwaterCausticsStrength = strength;
            return this;
        }
    }
}

