/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data.environments;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.utils.AABB;
import rs117.hd.utils.GsonUtils;

public enum Area {
    EVIL_BOB_ISLAND(2496, 4748, 2559, 4801),
    TUTORIAL_ISLAND_WIZARD_BUILDING(3136, 3097, 3144, 3076),
    TUTORIAL_ISLAND_CHURCH(3114, 3111, 3129, 3102),
    TUTORIAL_ISLAND_BANK(3113, 3131, 3130, 3117),
    TUTORIAL_ISLAND_UNDERGROUND(3120, 9534, 3067, 9491),
    TUTORIAL_ISLAND_QUEST_BUILDING(3079, 3118, 3090, 3126),
    TUTORIAL_ISLAND_KITCHEN(3072, 3092, 3079, 3080),
    TUTORIAL_ISLAND_START_BUILDING(3086, 3113, 3098, 3099),
    TUTORIAL_ISLAND_THE_NODE(3084, 3048, 3124, 3006),
    TUTORIAL_ISLAND_INSTANCE(AABB.regionBox(6494, 7008)),
    TUTORIAL_ISLAND(Area.merge(new Object[]{new AABB(3052, 3137, 3155, 3057), new AABB(3084, 3048, 3124, 3006), TUTORIAL_ISLAND_INSTANCE})),
    LUMBRIDGE_CASTLE_BASEMENT(3205, 9613, 3220, 9626),
    LUMBRIDGE_CASTLE_ENTRYWAY(3213, 3212, 3216, 3225),
    LUMBRIDGE_CASTLE_DINING_ROOM(3205, 3218, 3212, 3226),
    LUMBRIDGE_CASTLE_COBBLE(new AABB(3216, 3230, 3204, 3207, 0), new AABB(3207, 3230, 3204, 3207, 1), new AABB(3213, 3225, 3208, 3212, 1), new AABB(3210, 3222, 3207, 3215, 2)),
    LUMBRIDGE_TOWER_FLOOR_INTERIOR(new AABB(3230, 3225, 3227, 3221, 0), new AABB(3230, 3216, 3227, 3212, 0)),
    RFD_QUIZ(2589, 4618, 2566, 4642),
    LUM_BRIDGE(3240, 3226, 3250, 3225),
    HAM_HIDEOUT(3137, 9661, 3192, 9602),
    LUMBRIDGE_CASTLE(new AABB(3216, 3230, 3204, 3207), new AABB(3230, 3225, 3227, 3212, 2)),
    LUMBRIDGE_CASTLE_ENTRANCE(3218, 3219, 3217, 3218),
    LUMBRIDGE_DRAYNOR_PATH_BLEND_1(3135, 3293, 3135, 3295),
    LUMBRIDGE_DRAYNOR_PATH_BLEND_2(3136, 3293, 3136, 3296),
    LUMBRIDGE_SWAMP_PATH_FIX(3242, 3184, 3244, 3186),
    LUMBRIDGE_VARROCK_PATH_BLEND_FIX(new AABB(3250, 3315, 3250, 3315), new AABB(3249, 3314, 3249, 3314), new AABB(3248, 3312, 3248, 3312), new AABB(3247, 3311, 3247, 3311), new AABB(3246, 3311, 3246, 3311), new AABB(3245, 3310, 3245, 3310), new AABB(3243, 3308, 3343, 3308), new AABB(3241, 3306, 3241, 3306), new AABB(3240, 3305, 3240, 3305)),
    LUMBRIDGE_VARROCK_PATH_FIX(3267, 3328, 3269, 3329),
    LUMBRIDGE_CASTLE_INSTANCE(3400, 4847, 3447, 4808),
    LUMBRIDGE(Area.merge(new Object[]{new AABB(3136, 3137, 3254, 3327), new AABB(3255, 3189, 3263, 3199), new AABB(3266, 3200, 3255, 3327), new AABB(3267, 3232, 3267, 3223), new AABB(3269, 3330, 3267, 3324), LUMBRIDGE_CASTLE_INSTANCE})),
    GOBLIN_MAZE(3221, 9660, 3307, 9602),
    LUMBRIDGE_SWAMP_CAVES(3265, 9602, 3141, 9536),
    TEARS_OF_GUTHIX(12948),
    DORGESHKAAN(new AABB(2687, 5376, 2752, 5247), new AABB(2751, 5440, 2816, 5311), new AABB(2815, 5504, 2880, 5375)),
    VARROCK_GUARD_POSTS(new AABB(3242, 3501, 3239, 3499, 0), new AABB(3207, 3390, 3201, 3384)),
    VARROCK_ZAMORAK_TEMPLE(new AABB(3263, 3390, 3256, 3380), new AABB(3255, 3385, 3253, 3380)),
    VARROCK_HORVIKS_ANVIL(3232, 3441, 3227, 3433),
    VARROCK_HOUSE_1(3257, 3462, 3253, 3459),
    VARROCK_HOUSE_2(new AABB(3238, 3386, 3230, 3382, 0), new AABB(3236, 3386, 3230, 3382, 1)),
    VARROCK_BLUE_MOON_INN(new AABB(3233, 3402, 3228, 3397, 0), new AABB(3233, 3402, 3231, 3401, 1), new AABB(3232, 3400, 3226, 3400, 1), new AABB(3232, 3399, 3218, 3393, 1), new AABB(3224, 3403, 3218, 3400, 1)),
    VARROCK_CHAMPIONS_GUILD(3194, 3362, 3188, 3352, 0),
    VARROCK_HALLOWEEN_EVENT_DIRT(3198, 3437, 3194, 3433),
    VARROCK_MUSEUM_BASEMENT(new AABB(1729, 4929, 1790, 4990), new AABB(1601, 4929, 1663, 4990)),
    VARROCK_MUSEUM(3253, 3442, 3267, 3455),
    VARROCK_CASTLE(new AABB(3224, 3497, 3201, 3467), new AABB(3225, 3473, 3225, 3470), new AABB(3226, 3479, 3225, 3490), new AABB(3206, 3499, 3200, 3498), new AABB(3205, 3500, 3201, 3500), new AABB(3200, 3497, 3200, 3495), new AABB(3200, 3474, 3200, 3470)),
    VARROCK_CASTLE_DIRT_PATH_FIXES_1(new AABB(3198, 3500, 3198, 3499), new AABB(3208, 3501), new AABB(3198, 3475, 3198, 3474)),
    VARROCK_CASTLE_DIRT_PATH_FIXES_2(new AABB(3206, 3502, 3206, 3501), new AABB(3208, 3502, 3207, 3502)),
    VARROCK_JULIETS_HOUSE_FLOWER_BED(3161, 3450, 3171, 3444),
    VARROCK_JULIETS_HOUSE(3164, 3441, 3149, 3427),
    VARROCK_JOLLY_BOAR_INN(3272, 3486, 3288, 3510),
    VARROCK_SARADOMIN_CHURCH(new AABB(3259, 3488, 3252, 3471), new AABB(3251, 3483, 3249, 3476)),
    VARROCK_ANVILS(3185, 3420, 3190, 3427),
    VARROCK_BUILDING_RUINS(new AABB(3185, 3416, 3194, 3427), new AABB(3193, 3410, 3197, 3416), new AABB(3254, 3406, 3263, 3411)),
    VARROCK_EAST_BANK_CENTER(3251, 3420, 3256, 3422),
    VARROCK_EAST_BANK(new AABB(3250, 3416, 3257, 3423)),
    VARROCK_EAST_BANK_OUTSIDE_1(new AABB(3250, 3424, 3257, 3424)),
    VARROCK_MOON_INN_BALCONY(3217, 3401, 3214, 3397),
    VARROCK_MOON_INN_FLOOR(new AABB(3229, 3396, 3228, 3394), new AABB(3217, 3396, 3216, 3394), new AABB(3227, 3402, 3218, 3394), new AABB(3228, 3402, 3227, 3401), new AABB(3229, 3393, 3226, 3393), new AABB(3220, 3393, 3217, 3393), new AABB(3221, 3403, 3219, 3403)),
    VARROCK_MOON_INN_FLOOR_FIX(new AABB(3225, 3393, 3225, 3393), new AABB(3221, 3393, 3221, 3393), new AABB(3216, 3393, 3216, 3393)),
    VARROCK_MUSEUM_SOUTH_PATH_FIX(3264, 3439, 3265, 3441),
    VARROCK_WEST_BANK_SOUTH_PATH_FIX(3182, 3432, 3183, 3432),
    VARROCK_WILDERNESS_DITCH_PATH_FIX(3242, 3519, 3275, 3526),
    VARROCK_GRAND_EXCHANGE_ROOF(3175, 3501, 3154, 3480),
    VARROCK(new AABB(3136, 3397, 3290, 3518), new AABB(3177, 3371, 3291, 3410)),
    BARBARIAN_VILLAGE_EAST_PATH_FIX(3111, 3420, 3112, 3421),
    STRONGHOLD_OF_SECURITY_WAR(7505),
    STRONGHOLD_OF_SECURITY_FAMINE(8017),
    STRONGHOLD_OF_SECURITY_PESTILENCE(8530),
    STRONGHOLD_OF_SECURITY_DEATH(9297),
    STRONGHOLD_OF_SECURITY(STRONGHOLD_OF_SECURITY_WAR, STRONGHOLD_OF_SECURITY_FAMINE, STRONGHOLD_OF_SECURITY_PESTILENCE, STRONGHOLD_OF_SECURITY_DEATH),
    TOLNA_DUNGEON_ANGER(new AABB(3008, 5216, 3039, 5247), new AABB(2963, 5228, 2995, 5198), new AABB(3264, 9823, 3298, 9855)),
    TOLNA_DUNGEON_FEAR(new AABB(3040, 5216, 3071, 5247), new AABB(3072, 5184, 3103, 5215), new AABB(3008, 5184, 3039, 5215), new AABB(3264, 9792, 3296, 9822), new AABB(3299, 9823, 3327, 9855)),
    TOLNA_DUNGEON_CONFUSION(new AABB(3040, 5184, 3071, 5215), new AABB(3297, 9792, 3327, 9822)),
    DIGSITE_EXAM_CENTRE(new AABB(3367, 3348, 3357, 3332), new AABB(3356, 3337, 3348, 3332)),
    DIGSITE_DOCK(3348, 3460, 3404, 3444),
    DRAYNOR_MANOR_INTERIOR(new AABB(3091, 3363, 3096, 3353), new AABB(3097, 3374, 3119, 3353), new AABB(3120, 3360, 3126, 3353)),
    DRAYNOR_MANOR(new AABB(3084, 3382, 3120, 3330), new AABB(3121, 3377, 3125, 3330), new AABB(3126, 3375, 3127, 3344), new AABB(3128, 3364, 3129, 3347), new AABB(3107, 3385, 3090, 3383), new AABB(3087, 3329, 3123, 3323), new AABB(3126, 3339, 3126, 3335)),
    DRAYNOR_MANOR_FOREST(new AABB(3076, 3393, 3119, 3315), new AABB(3120, 3315, 3144, 3387), new AABB(3145, 3376, 3150, 3315)),
    DRAYNOR_MANOR_BASEMENT(new AABB(3073, 9780, 3082, 9766)),
    DRAYNOR_NORTHERN_HOUSE_FLOOR(new AABB(3102, 3281, 3097, 3277)),
    DRAYNOR_AGGIES_HOUSE(3088, 3261, 3083, 3256),
    DRAYNOR_WOM_HOUSE_FRONT(3094, 3250, 3088, 3250),
    DRAYNOR_BANK(new AABB(3097, 3246, 3088, 3240), new AABB(2127, 4910, 2137, 4903)),
    DRAYNOR_PATH_BLENDING_FIXES(new AABB(3110, 3281, 3110, 3281), new AABB(3109, 3280, 3109, 3280), new AABB(3108, 3279, 3108, 3279)),
    DRAYNOR_NEDS_PATH_FIXES(new AABB(3103, 3257, 3103, 3256)),
    DRAYNOR_BANK_FRONT_PATH(3093, 3247, 3092, 3247),
    DRAYNOR_MARKET_PATH_FIX(new AABB(3095, 3247, 3094, 3247), new AABB(3087, 3246, 3085, 3243), new AABB(3091, 3247, 3087, 3247)),
    DRAYNOR_BANK_PATH_FIX_DARK(new AABB(3088, 3248, 3088, 3248), new AABB(3087, 3247, 3087, 3247), new AABB(3086, 3246, 3086, 3246), new AABB(3084, 3246, 3084, 3246)),
    DRAYNOR_BANK_PATH_FIX_LIGHT(new AABB(3095, 3248, 3095, 3248), new AABB(3095, 3250, 3095, 3250), new AABB(3096, 3251, 3096, 3251)),
    DRAYNOR_BANK_ROBBERY_CUTSCENE(2112, 4895, 2156, 4927),
    DRAYNOR(Area.merge(new Object[]{new AABB(3071, 3226, 3133, 3292), DRAYNOR_BANK_ROBBERY_CUTSCENE})),
    DRAYNOR_SEWERS(3075, 9701, 3127, 9642),
    WIZARDS_TOWER_PATH(new AABB(3115, 3171, 3112, 3168), new AABB(3117, 3169, 3116, 3166), new AABB(3111, 3169, 3110, 3167), new AABB(3115, 3167), new AABB(3118, 3168, 3118, 3167), new AABB(3109, 3168, 3108, 3168), new AABB(3109, 3167, 3108, 3167), new AABB(3116, 3170), new AABB(3118, 3169), new AABB(3108, 3169), new AABB(3109, 3169)),
    WIZARD_TOWER_PATH_PARTIAL_TILES(new AABB(3111, 3170), new AABB(3107, 3186), new AABB(3114, 3167), new AABB(3112, 3167), new AABB(3107, 3167), new AABB(3118, 3166), new AABB(3115, 3166)),
    WIZARD_TOWER_ROOF(new AABB(3101, 3167, 3116, 3153)),
    WIZARD_TOWER_BASEMENT(new AABB(3094, 9579, 3122, 9554)),
    MISTHALIN_MYSTERY_MANOR(1600, 4863, 1727, 4779),
    FALADOR_EAST_BANK_PATH_FIX_2(3006, 3348, 3006, 3346),
    FALADOR_EAST_BANK_PATH_FIX_1(3006, 3346, 3006, 3344),
    FALADOR_HAIRDRESSER(new AABB(2941, 3389, 2946, 3376), new AABB(2946, 3376, 2949, 3382)),
    FALADOR_PARTY_ROOM(3034, 3387, 3057, 3369),
    FALADOOR_PARTY_ROOM_STAIRS_FIX(new AABB(3054, 3084, 3053, 3383), new AABB(3038, 3084, 3037, 3383)),
    FALADOR_TRIANGLE_PATH_FIX_1(2973, 3413, 2974, 3415),
    FALADOR_TRIANGLE_PATH_FIX_2(2965, 3406, 2968, 3407),
    FALADOR_SOUTH_PATH_FIX(3006, 3320, 3008, 3321),
    FALADOR_INSTANCE(3456, 4783, 3527, 4736),
    FALADOR(Area.merge(new Object[]{new AABB(2932, 3306, 3068, 3401), new AABB(2964, 3401, 2969, 3405), FALADOR_INSTANCE})),
    DWARVEN_MINE_DUNGEON(new AABB(3071, 9855, 2985, 9690), new AABB(2960, 9820, 2984, 9801)),
    MOTHERLODE_MINE(new AABB(3713, 5696, 3776, 5633), new AABB(3827, 5692, 3868, 5652)),
    EDGEVILLE_PATH_OVERLAY(new AABB(3087, 3501, 3099, 3502), new AABB(3079, 3502, 3085, 3503), new AABB(3105, 3508, 3113, 3507), new AABB(3112, 3514, 3119, 3515), new AABB(3120, 3517, 3129, 3516), new AABB(3119, 3516, 3120, 3515), new AABB(3107, 3508, 3108, 3502), new AABB(3079, 3502, 3080, 3501), new AABB(3079, 3506, 3080, 3504), new AABB(3100, 3496, 3099, 3501), new AABB(3104, 3498, 3103, 3499), new AABB(3103, 3499, 3102, 3500), new AABB(3101, 3500, 3102, 3501), new AABB(3084, 3502, 3088, 3501), new AABB(3113, 3514, 3114, 3509), new AABB(3112, 3509, 3114, 3508), new AABB(3101, 3510, 3103, 3509), new AABB(3104, 3509, 3103, 3508), new AABB(3104, 3507, 3105, 3506), new AABB(3103, 3506, 3104, 3505), new AABB(3102, 3505, 3103, 3504), new AABB(3101, 3504, 3102, 3503), new AABB(3100, 3503, 3101, 3502), new AABB(3134, 3517, 3134, 3516)),
    EDGEVILLE_BRIDGE(3133, 3518, 3130, 3516),
    EDGEVILLE_BANK_PERIMETER_FIX(new AABB(3090, 3497, 3090, 3494), new AABB(3091, 3497, 3091, 3493)),
    EDGEVILLE_BANK_TILING(new AABB(3098, 3498, 3098, 3498), new AABB(3098, 3496, 3098, 3496), new AABB(3098, 3494, 3098, 3494), new AABB(3098, 3492, 3098, 3492), new AABB(3098, 3490, 3098, 3490), new AABB(3098, 3488, 3098, 3488), new AABB(3097, 3499, 3097, 3499), new AABB(3096, 3488, 3096, 3488), new AABB(3095, 3499, 3095, 3499), new AABB(3094, 3488, 3094, 3488), new AABB(3093, 3499, 3093, 3499), new AABB(3092, 3488, 3092, 3488), new AABB(3091, 3489, 3091, 3489), new AABB(3091, 3491, 3091, 3491), new AABB(3091, 3493, 3091, 3493), new AABB(3091, 3495, 3091, 3495), new AABB(3091, 3497, 3091, 3497), new AABB(3091, 3499, 3091, 3499), new AABB(3090, 3494, 3090, 3494), new AABB(3090, 3496, 3090, 3496)),
    EDGEVILLE_BANK(3098, 3499, 3091, 3488),
    EDGEVILLE_BANK_SURROUNDING_PATH(new AABB(3091, 3501, 3089, 3500), new AABB(3093, 3502, 3089, 3492), new AABB(3093, 3500, 3091, 3498), new AABB(3088, 3502, 3086, 3485), new AABB(3090, 3492, 3089, 3490), new AABB(3092, 3489, 3088, 3483)),
    EDGEVILLE_DORIS_HOUSE(3077, 3496, 3081, 3489),
    EDGEVILLE_MONASTERY(3041, 3509, 3062, 3471),
    EDGEVILLE_GUARD_TOWER_FLOOR(new AABB(3111, 3517, 3107, 3511)),
    EDGEVILLE_FURNACE_FLOOR(new AABB(3110, 3501, 3105, 3496)),
    EDGEVILLE_MANS_HOUSE_FLOOR(new AABB(3100, 3513, 3091, 3507)),
    EDGEVILLE_GENERAL_STORE_FLOOR_FIX(new AABB(3082, 3507, 3078, 3507)),
    EDGEVILLE_GENERAL_STORE_FLOOR(new AABB(3084, 3513, 3076, 3507)),
    SEERS_BANK(2719, 3497, 2730, 3487),
    SEERS_HOUSES(new AABB(2716, 3482, 2709, 3476), new AABB(2705, 3476, 2699, 3470), new AABB(2715, 3473, 2710, 3470), new AABB(2709, 3473, 2706, 3471, 1), new AABB(2716, 3473, 2716, 3470, 1), new AABB(2739, 3505, 2735, 3499)),
    SEERS_CHURCH(new AABB(2703, 3466, 2690, 3459)),
    SEERS_BAR(new AABB(2700, 3498, 2689, 3488), new AABB(2693, 3488, 2689, 3488), new AABB(2696, 3488)),
    SEERS_BAR_ENTRANCE(2695, 3488, 2694, 3488),
    SEERS_CAMELOT_CASTLE_BLENDED(new AABB(2750, 3495, 2), new AABB(2751, 3494, 2), new AABB(2750, 3494, 2), new AABB(2766, 3495, 2), new AABB(2765, 3494, 2), new AABB(2766, 3494, 2)),
    SEERS_CAMELOT_CASTLE(new AABB(2767, 3517, 2748, 3504, 0), new AABB(2751, 3503, 2748, 3496, 0), new AABB(2768, 3503, 2765, 3496, 0), new AABB(2764, 3503, 2752, 3501, 1), new AABB(2768, 3517, 2748, 3504, 1), new AABB(2751, 3503, 2748, 3496, 1), new AABB(2768, 3503, 2765, 3496, 1), new AABB(2764, 3495, 2752, 3492, 1), new AABB(2770, 3495, 2765, 3490, 0), new AABB(2751, 3495, 2746, 3490, 0), new AABB(2770, 3495, 2765, 3490, 1), new AABB(2751, 3495, 2746, 3490, 1), new AABB(2751, 3493, 2746, 3490, 2), new AABB(2749, 3495, 2746, 3494, 2), new AABB(2770, 3493, 2765, 3490, 2), new AABB(2770, 3495, 2767, 3494, 2)),
    SEERS_CAMELOT_CASTLE_KNIGHTSWAVE_OVERWORLD(new AABB(2764, 3512, 2764, 3502, 2), new AABB(2752, 3512, 2752, 3502, 2), new AABB(2763, 3513, 2753, 3502, 2)),
    ELEMENTAL_WORKSHOP_HOUSE(new AABB(2711, 3498, 2709, 3496), new AABB(2705, 3498, 2704, 3497), new AABB(2708, 3496, 2704, 3496), new AABB(2714, 3495, 2704, 3492), new AABB(2711, 3491, 2706, 3487), new AABB(2708, 3487, 2706, 3487), new AABB(2711, 3487)),
    ELEMENTAL_WORKSHOP_HOUSE_ENTRANCE(new AABB(2710, 3487, 2709, 3487)),
    SEERS_COURTHOUSE(2739, 3471, 2732, 3465),
    SINCLAIR_MANSION(new AABB(2747, 3582, 2733, 3574), new AABB(2742, 3573, 2739, 3573)),
    WHITE_WOLF_MOUNTAIN(new AABB(2789, 3530, 2879, 3488), new AABB(2832, 3439, 2879, 3502), new AABB(2431, 5374, 2496, 5439)),
    KEEP_LE_FAYE_JAIL(7490),
    KEEP_LE_FAYE_INSTANCE(1670, 4230, 1721, 4280),
    KEEP_LE_FAYE(Area.merge(new Object[]{new AABB(2747, 3415, 2782, 3389), KEEP_LE_FAYE_INSTANCE})),
    CATHERBY_BEACH_OBELISK_WATER_FIX(2843, 3423, 2845, 3421),
    CATHERBY_BEACH_LADDER_FIX(2842, 3424, 2842, 3424),
    CATHERBY_BEACH_SHORELINE_FIX(new AABB(2870, 3414, 2869, 3416), new AABB(2865, 3420, 2864, 3423), new AABB(2863, 3423, 2851, 3426), new AABB(2848, 3427, 2848, 3428), new AABB(2847, 3429, 2847, 3429), new AABB(2845, 3430, 2843, 3430)),
    CATHERBY_BANK(2806, 3445, 2812, 3438),
    CATHERBY(new AABB(2863, 3413, 2789, 3432), new AABB(2864, 3432, 2866, 3424), new AABB(2863, 3433, 2857, 3436), new AABB(2856, 3433, 2789, 3439), new AABB(2860, 3437, 2857, 3437), new AABB(2839, 3444, 2851, 3440), new AABB(2851, 3441, 2854, 3440), new AABB(2839, 3447, 2844, 3445), new AABB(2845, 3445, 2845, 3445), new AABB(2838, 3440, 2789, 3462), new AABB(2839, 3460, 2842, 3453), new AABB(2832, 3463, 2789, 3476), new AABB(2802, 3412, 2805, 3410)),
    RIMMINGTON(new AABB(2905, 3265, 2995, 3195), new AABB(2989, 3195, 2945, 3186)),
    PORT_SARIM_BETTYS_HOUSE(3016, 3261, 3011, 3256),
    PORT_SARIM(3005, 3265, 3064, 3174),
    MUDSKIPPER_POINT(2977, 3132, 3008, 3102),
    NORTH_OF_MUDSKIPPER(2984, 3169, 3041, 3133),
    IMCANDO_PENINSULA(MUDSKIPPER_POINT, NORTH_OF_MUDSKIPPER),
    SOUTH_FALADOR_FARM(3011, 3322, 3069, 3279),
    CRAFTING_GUILD(2910, 3296, 2945, 3265),
    SOUTH_FALADOR(new AABB(2900, 3308, 3069, 3195), new AABB(3060, 3195, 2971, 3100), new AABB(2980, 3185, 2924, 3202)),
    ASGARNIA_ICE_DUNGEON_SNOWY(3085, 9531, 3020, 9605),
    KARAMJA_VOLCANO(2827, 3192, 2859, 3158),
    BRIMHAVEN_DOCKS_TEXTURED(2773, 3235, 2771, 3223),
    BRIMHAVEN_AGILITY_ARENA(11157),
    HEROES_GUILD(new AABB(2892, 3507, 2898, 3514), new AABB(2894, 3504, 2896, 3517), new AABB(2899, 3509, 2901, 3512)),
    HEROES_GUILD_BASEMENT(2883, 9919, 2943, 9880),
    WARRIORS_GUILD(new AABB(2837, 3555, 2875, 3537), new AABB(2859, 3536, 2849, 3534)),
    WARRIORS_GUILD_FLOOR_2(2837, 3557, 2877, 3533, 1),
    BURTHORPE(new AABB(2830, 3533, 2938, 3576), new AABB(2938, 3576, 2880, 3581), new AABB(2838, 3538, 2928, 3553), new AABB(2873, 3533, 2935, 3521)),
    GAMES_ROOM_INNER(2221, 4973, 2194, 4946),
    GAMES_ROOM(8781),
    EAST_ARDOUGNE_FURNACE(2603, 3314, 2600, 3310),
    EAST_ARDOUGNE_BANK_NORTH(2621, 3335, 2612, 3330),
    EAST_ARDOUGNE_COBBLE_OFFICE(new AABB(2673, 3323, 2668, 3320), new AABB(2675, 3319, 2668, 3318), new AABB(2675, 3317, 2671, 3315), new AABB(2670, 3317, 2670, 3316)),
    EAST_ARDOUGNE_COBBLE_OFFICE_BLENDING(new AABB(2668, 3317), new AABB(2669, 3316), new AABB(2670, 3315)),
    EAST_ARDOUGNE_COBBLE_CHRUCH(2612, 3307, 2609, 3304, 0),
    EAST_ARDOUGNE_COBBLE_DOCK_HOUSE(new AABB(2650, 3272, 2643, 3269), new AABB(2650, 3273, 2647, 3273)),
    WEST_ARDOUGNE_COBBLE_HOUSES(new AABB(2549, 3292, 2547, 3289), new AABB(2546, 3292, 2539, 3284), new AABB(2529, 3319, 2522, 3313), new AABB(2546, 3327, 2542, 3324)),
    KHAZARD_BATTLEFIELD_COBBLE(new AABB(2526, 3258, 2522, 3255), new AABB(2506, 3259, 2500, 3251)),
    EAST_ARDOUGNE_PATHING_FIXES(new AABB(2570, 3313), new AABB(2564, 3306), new AABB(2565, 3307)),
    EAST_ARDOUGNE_HAZEL_HOUSE(new AABB(2579, 3278, 2562, 3265)),
    EAST_ARDOUGNE_BRIDGE(new AABB(2603, 3298, 2594, 3295)),
    EAST_ARDOUGNE_HANDELMORT_STONE_FLOOR(2645, 3327, 2625, 3308, 0),
    EAST_ARDOUGNE_HANDELMORT_BALCONY(2640, 3320, 2630, 3318, 1),
    WEST_ARDOUGNE(new AABB(2460, 3335, 2558, 3279), new AABB(2558, 3279, 2510, 3264), new AABB(2429, 3323, 2466, 3305)),
    WEST_ARDOUGNE_CARPET_FIX(new AABB(2544, 3289, 2542, 3286), new AABB(2526, 3317, 2526, 3314)),
    SOTE_CUTSCENE_ARDOUGNE_SQUARE(13404),
    EAST_ARDOUGNE(Area.merge(new Object[]{SOTE_CUTSCENE_ARDOUGNE_SQUARE, new AABB(2558, 3342, 2686, 3257)})),
    EAST_ARDOUGNE_CASTLE_DIRT_FIX(new AABB(2565, 3279, 2592, 3313)),
    EAST_ARDOUGNE_CASTLE_PATH_FIX(new AABB(2585, 3298, 2593, 3314)),
    EAST_ARDOUGNE_BANK(new AABB(2658, 3287, 2652, 3280, 0), new AABB(2651, 3287, 2649, 3285, 0), new AABB(2651, 3282, 2649, 3280, 0)),
    EAST_ARDOUGNE_DOCKS_FIX(new AABB(2689, 3276, 2667, 3264)),
    CLOCK_TOWER_DUNGEON_COLORED_TILES(2579, 9650, 2578, 9649),
    WITCHAVEN(new AABB(2693, 3298, 2744, 3262), new AABB(2702, 3299, 2744, 3310), new AABB(2714, 3311, 2744, 3320)),
    KHAZARD_BATTLEFIELD_COBBLE_OUTSIDE(new AABB(2512, 3259, 2507, 3254), new AABB(2509, 3251, 2508, 3250), new AABB(2518, 3257, 2517, 3256), new AABB(2520, 3250, 2514, 3248)),
    KANDARIN_MONISTARY(2622, 3221, 2590, 3203),
    KANDARIN_MONISTARY_WINGS_PARTIAL_TILES(new AABB(2620, 3213, 2611, 3205), new AABB(2601, 3213, 2592, 3205)),
    KANDARIN_MONISTARY_WINGS(new AABB(2617, 3214, 2614, 3214), new AABB(2618, 3213, 2613, 3213), new AABB(2619, 3212, 2612, 3212), new AABB(2620, 3211, 2611, 3207), new AABB(2621, 3210, 2621, 3208), new AABB(2619, 3206, 2612, 3206), new AABB(2618, 3205, 2613, 3205), new AABB(2617, 3204, 2614, 3204), new AABB(2598, 3214, 2595, 3214), new AABB(2599, 3213, 2594, 3213), new AABB(2600, 3212, 2593, 3212), new AABB(2601, 3211, 2592, 3207), new AABB(2591, 3210, 2591, 3208), new AABB(2600, 3206, 2593, 3206), new AABB(2599, 3205, 2594, 3205), new AABB(2598, 3204, 2595, 3204)),
    YANILLE_AGILITY_DUNGEON_ENTRANCE(2568, 3122, 2571, 3125),
    YANILLE_BANK(2609, 3088, 2616, 3097),
    YANILLE_WATCHTOWER_TOP(2934, 4718, 2927, 4711, 2),
    YANILLE_WATCHTOWER_MIDDLE(2550, 3118, 2543, 3111, 1),
    YANILLE_WATCHTOWER_BOTTOM_DOORWAY(2550, 3115, 2550, 3114, 0),
    YANILLE_WATCHTOWER_BOTTOM(new AABB(2549, 3118, 2543, 3111, 0), new AABB(2550, 3113, 2550, 3111, 0), new AABB(2550, 3118, 2550, 3116, 0)),
    YANILLE_MAGIC_GUILD_FLOORS(new AABB(2596, 3094, 2585, 3081, 1), new AABB(2596, 3094, 2585, 3081, 2)),
    YANILLE_INSTANCE(11593),
    YANILLE(Area.merge(new Object[]{new AABB(2531, 3127, 2622, 3070), YANILLE_INSTANCE})),
    GUTANOTH_CAVE(2560, 9408, 2626, 9475),
    NIGHTMARE_ZONE(2241, 4676, 2303, 4722),
    CASTLE_WARS_LOBBY(2434, 3104, 2448, 3080),
    CASTLE_WARS_ARENA_SARADOMIN_SIDE(new AABB(2435, 3068, 2373, 3086), new AABB(3282, 3086, 2435, 3091), new AABB(2435, 3091, 2388, 3093), new AABB(2404, 3093, 2435, 3095), new AABB(2435, 3095, 2407, 3098), new AABB(2409, 3098, 2435, 3117), new AABB(2435, 3117, 2414, 3123), new AABB(2420, 3123, 2430, 3127), new AABB(2400, 3104, 2411, 3092), new AABB(2400, 3113, 2411, 3103)),
    CASTLE_WARS_ARENA_ZAMORAK_SIDE(new AABB(2364, 3139, 2423, 3125), new AABB(2417, 3125, 2364, 3120), new AABB(2364, 3120, 2412, 3114), new AABB(2400, 3114, 2364, 3104), new AABB(2364, 3105, 2399, 3093), new AABB(2384, 3093, 2354, 3087), new AABB(2364, 3087, 2374, 3082)),
    CASTLE_WARS_ARENA(2364, 3139, 2435, 3068),
    CASTLE_WARS_UNDERGROUND(2444, 9544, 2361, 9473),
    CASTLE_WARS(new AABB(2364, 3139, 2435, 3068), new AABB(2434, 3104, 2448, 3080)),
    LMS_ARENA_WILD_VARROCK(AABB.regionBox(13918, 14432)),
    LMS_ARENA_DESERTED_ISLAND(AABB.regionBox(13658, 13916)),
    CLAN_WARS_ARENAS_OVERWORLD(AABB.regionBox(13644, 13646), new AABB(3384, 5112, 3391, 5096)),
    CLAN_WARS_ARENAS_OTHER(AABB.regionBox(13641, 13642), AABB.regionBox(13133, 13135), new AABB(3384, 5119, 3391, 5113), new AABB(3384, 5095, 3391, 5080)),
    CLAN_WARS_ARENAS(CLAN_WARS_ARENAS_OVERWORLD, CLAN_WARS_ARENAS_OTHER),
    SMOKE_DUNGEON(3198, 9409, 3329, 9341),
    PVP_ARENA(3312, 3290, 3407, 3199),
    SHANTAY_PASS(3294, 3135, 3311, 3114),
    MAGE_TRAINING_ARENA(3347, 3327, 3374, 3288),
    AL_KHARID_WELL(3293, 3183, 3293, 3183),
    AL_KHARID_BUILDINGS(new AABB(3265, 3173, 3272, 3161), new AABB(3270, 3194, 3279, 3179), new AABB(3285, 3192, 3290, 3187), new AABB(3289, 3206, 3296, 3202), new AABB(3297, 3194, 3306, 3185), new AABB(3319, 3197, 3323, 3191), new AABB(3312, 3186, 3318, 3173), new AABB(3313, 3165, 3318, 3160), new AABB(3282, 3177, 3303, 3159)),
    AL_KHARID(new AABB(3276, 3265, 3337, 3195), new AABB(3259, 3201, 3345, 3135), new AABB(3253, 3182, 3265, 3155)),
    EAST_AL_KHARID(new AABB(3344, 3200, 3384, 3129), new AABB(3384, 3141, 3391, 3203), new AABB(3391, 3203, 3412, 3164), new AABB(3412, 3170, 3426, 3197)),
    AL_KHARID_MINE(3270, 3322, 3337, 3258),
    DESERT_MINING_CAMP(3272, 3042, 3306, 3011),
    AGILITY_PYRAMID_TOP(12105),
    KHARIDIAN_DESERT_DEEP(Area.merge(new Object[]{new AABB(3198, 2989, 3322, 2817), new AABB(3315, 2928, 3469, 2812), AGILITY_PYRAMID_TOP})),
    KHARIDIAN_DESERT_MID(new AABB(3135, 3051, 3524, 2885)),
    KHARIDIAN_DESERT(new AABB(3196, 3134, 3526, 2997), new AABB(3134, 3069, 3565, 2600), new AABB(3114, 2974, 3216, 2786)),
    KHARID_DESERT_REGION(new AABB(3268, 3321, 3414, 2672), new AABB(3271, 3327, 3392, 3322), new AABB(3356, 3328, 3392, 3329), new AABB(3350, 3328, 3316, 3329), new AABB(3319, 3330, 3322, 3330), new AABB(3315, 3328, 3271, 3328), new AABB(3271, 3329, 3306, 3329), new AABB(3304, 3330, 3300, 3330), new AABB(3267, 3321, 3267, 3233), new AABB(3266, 3240, 3266, 3297), new AABB(3265, 3254, 3265, 3247), new AABB(3415, 3191, 3424, 3172), new AABB(3415, 3171, 3480, 2748), new AABB(3481, 3132, 3544, 2907), new AABB(3267, 3135, 3175, 2671), new AABB(3174, 3066, 3129, 2623), new AABB(3267, 3203, 3266, 3136), new AABB(3267, 3223, 3267, 3204), new AABB(3265, 3148, 3254, 3183), new AABB(3265, 3184, 3259, 3200), new AABB(3265, 3201, 3265, 3202), new AABB(3264, 3201, 3264, 3201)),
    DESERT_TREASURE_PYRAMID(new AABB(3198, 9339, 3267, 9275), new AABB(2755, 4934, 2812, 4982), new AABB(2825, 4976, 2873, 4938), new AABB(2894, 4972, 2933, 4941)),
    PYRAMID_PLUNDER(7749),
    SOPHANEM_TRAPDOOR(new AABB(3315, 2797, 0)),
    NECROPOLIS(new AABB(3275, 2749, 3405, 2670), new AABB(3322, 2773, 3370, 2750)),
    RIVER_ELID_WATERFALL(3369, 3131, 3370, 3133),
    KALPHITE_LAIR(13972),
    SOPHANEM_FLOORS(new AABB(3316, 2803, 3308, 2796, 0), new AABB(3307, 2803, 3307, 2801, 0), new AABB(3307, 2798, 3307, 2796, 0), new AABB(3285, 2777, 3277, 2765, 0), new AABB(3277, 2764, 3279, 2764, 0), new AABB(3285, 2764, 3283, 2764, 0)),
    CANIFIS_BAR_FLOOR(new AABB(3504, 3477, 3488, 3471), new AABB(3499, 3470, 3488, 3468), new AABB(3500, 3470, 3500, 3469), new AABB(3501, 3470), new AABB(3497, 3479, 3491, 3479)),
    CANIFIS_BAR_FLOOR_BLENDED(new AABB(3498, 3478), new AABB(3490, 3478), new AABB(3502, 3470), new AABB(3501, 3496), new AABB(3500, 3468)),
    HALLOWED_SEPULCHRE_LOBBY(2380, 5958, 2420, 6000),
    HALLOWED_SEPULCHRE_FLOOR_1(2220, 5938, 2325, 6032),
    HALLOWED_SEPULCHRE_FLOOR_2(2475, 5938, 2580, 6032),
    HALLOWED_SEPULCHRE_FLOOR_3(2350, 5800, 2455, 5906),
    HALLOWED_SEPULCHRE_FLOOR_4(2475, 5800, 2580, 5906),
    HALLOWED_SEPULCHRE_FLOOR_5(2220, 5800, 2325, 5906),
    VER_SINHAZA_WATER_FIX(new AABB(3682, 3257, 3682, 3257), new AABB(3681, 3256, 3681, 3256), new AABB(3684, 3259, 3678, 3263), new AABB(3683, 3258, 3683, 3258)),
    VER_SINHAZA_CUTSCENE(2087, 4903, 2064, 4880),
    VER_SINHAZA(Area.merge(new Object[]{VER_SINHAZA_CUTSCENE, new AABB(3641, 3236, 3684, 3202)})),
    MEIYERDITCH(new AABB(3587, 3310, 3627, 3200), new AABB(3618, 3327, 3647, 3311), new AABB(3628, 3310, 3647, 3239), new AABB(3628, 3238, 3637, 3232), new AABB(3638, 3238, 3639, 3237), new AABB(3628, 3231, 3630, 3229), new AABB(3628, 3208, 3632, 3200), new AABB(3633, 3206, 3637, 3200), new AABB(3586, 3199, 3647, 3136)),
    MEIYERDITCH_MYREQUE_HIDEOUT(14486),
    MEIYERDITCH_MINES(9544),
    CASTLE_DRAKAN(3520, 3388, 3594, 3328),
    DARKMEYER(new AABB(3590, 3399, 3636, 3330), new AABB(3636, 3330, 3662, 3392), new AABB(3662, 3384, 3669, 3335)),
    PORT_PHASMATYS(new AABB(3649, 3508, 3688, 3456), new AABB(3688, 3456, 3710, 3484), new AABB(3670, 3503, 3684, 3514)),
    FENKENSTRAINS_CASTLE(3534, 3565, 3562, 3536),
    MORYTANIA_SLAYER_TOWER(3405, 3531, 3452, 3579),
    CANIFIS(13878),
    TEMPLE_TREKKING_INSTANCES(AABB.regionBox(8014, 8270), new AABB(2123, 5036, 2164, 4996), AABB.regionBox(8782, 9806)),
    MORTTON(13875),
    BARROWS_CRYPTS(3520, 9664, 3583, 9727, 3),
    BARROWS_TUNNELS(3520, 9664, 3583, 9727, 0),
    BARROWS(14131),
    BURGH_DE_ROTT(3468, 3258, 3583, 3164),
    BURGH_DE_ROTT_BASEMENT(13974),
    ABANDONED_MINE(3423, 3261, 3461, 3201),
    GROTESQUE_GUARDIANS(6727),
    MORYTANIA(Area.merge(new Object[]{new AABB(3432, 3486, 3775, 3167), new AABB(3494, 3166, 3775, 3145), new AABB(3431, 3204, 3422, 3274), new AABB(3431, 3275, 3414, 3294), new AABB(3431, 3295, 3417, 3327), new AABB(3431, 3328, 3400, 3452), new AABB(3400, 3327, 3416, 3321), new AABB(3413, 3453, 3431, 3466), new AABB(3424, 3467, 3431, 3470), new AABB(3432, 3487, 3755, 3598), new AABB(3403, 3583, 3431, 3509), new AABB(3413, 3508, 3431, 3501), new AABB(3416, 3500, 3431, 3496), new AABB(3420, 3495, 3431, 3486), new AABB(3419, 3486, 3433, 3482), VER_SINHAZA_CUTSCENE, TEMPLE_TREKKING_INSTANCES, GROTESQUE_GUARDIANS})),
    THE_INFERNO(9043),
    TZHAAR(AABB.regionBox(9551, 10064)),
    TREE_GNOME_STRONGHOLD_INSTANCE(AABB.regionBox(7766, 8023)),
    TREE_GNOME_STRONGHOLD(Area.merge(new Object[]{new AABB(2368, 3525, 2496, 3387), new AABB(2404, 3547, 2431, 3511), new AABB(2484, 3406, 2507, 3387), TREE_GNOME_STRONGHOLD_INSTANCE})),
    EYES_OF_GLOUPHRIE_GNOME_AND_GOBLIN_BATTLE_CUTSCENE(2165, 4928, 2112, 4991),
    REVENANT_CAVES(AABB.regionBox(12701, 12959)),
    FROZEN_WASTE_PLATEAU(new AABB(2939, 3970, 2988, 3904), new AABB(2988, 3907, 3002, 3940), new AABB(2980, 3909, 2939, 3865), new AABB(2939, 3865, 2958, 3834)),
    WILDERNESS_HIGH(2939, 3974, 3391, 3903),
    WILDERNESS_MID_HIGH(2939, 3903, 3391, 3806),
    WILDERNESS_MID(2939, 3806, 3391, 3730),
    WILDERNESS_MID_LOW(2939, 3730, 3391, 3558),
    WILDERNESS_LOW(2939, 3558, 3391, 3522),
    WILDERNESS(2939, 3974, 3391, 3522),
    WILDERNESS_NORTH_OF_RESOURCE_AREA(3175, 3967, 3202, 3945),
    WILDERNESS_FOUNTAIN_OF_RUNE(3373, 3892, 3375, 3894),
    MAGE_ARENA_BANK(2527, 4725, 2549, 4708),
    MAGE_ARENA_GOD_STATUES(2520, 4730, 2495, 4682),
    GIELINOR_SNOWY_NORTHERN_REGION(new AABB(2942, 3711, 2748, 3980), new AABB(2696, 3839, 2741, 3799), new AABB(2714, 3803, 2757, 3767), new AABB(2723, 3743, 2758, 3710)),
    TROLLHEIM(AABB.regions(11577, 11321, 11320, 11576, 11319, 11063), new AABB[]{new AABB(2751, 3753, 2726, 3662), new AABB(2780, 3647, 2815, 3584)}),
    WEISS_REGION(AABB.regions(11325, 11581)),
    WEISS_UNDERGROUND(10842),
    WEISS_FIRE_PIT(2877, 3934, 2875, 3932),
    INTERIOR_WEISS_THRONE_TENT(2877, 3941, 2868, 3931),
    MOUNTAIN_CAMP_LAKE(new AABB(2754, 3707, 2789, 3675), new AABB(2789, 3682, 2802, 3708)),
    MOUNTAIN_CAMP_ENTRY_PATH(2780, 3673, 2766, 3655),
    MOUNTAIN_CAMP(new AABB(2750, 3711, 2815, 3671), new AABB(2815, 3671, 2779, 3652)),
    RELLEKKA(2594, 3646, 2692, 3747),
    FREMENNIK_PROVINCE(new AABB(2692, 3711, 2815, 3639), new AABB(2753, 3740, 2752, 3720), new AABB(2751, 3712, 2626, 3799), new AABB(2739, 3800, 2687, 3838), new AABB(2706, 3881, 2730, 3839), new AABB(2691, 3711, 2468, 3606), new AABB(2566, 3605, 2639, 3583), new AABB(2652, 3595, 2640, 3605), new AABB(2640, 3594, 2649, 3593), new AABB(2653, 3605, 2677, 3599), new AABB(2671, 3598, 2666, 3598), new AABB(2657, 3598, 2655, 3597), new AABB(2678, 3605, 2691, 3603), new AABB(2685, 3602, 2701, 3599), new AABB(2692, 3638, 2798, 3603), new AABB(2795, 3602, 2702, 3598), new AABB(2714, 3597, 2730, 3594), new AABB(2731, 3597, 2792, 3592), new AABB(2740, 3591, 2756, 3590), new AABB(2742, 3589, 2747, 3588), new AABB(2758, 3591, 2790, 3586), new AABB(2765, 3585, 2786, 3577)),
    FREMENNIK_SLAYER_DUNGEON(AABB.regions(10907, 10908, 11164)),
    GWENITH(2187, 3424, 2229, 3397),
    PRIFDDINAS(AABB.regionBox(12637, 13408)),
    ZALCANO(12126),
    MYNYDD(2119, 3453, 2215, 3384),
    LLETYA(2313, 3147, 2363, 3194),
    POISON_WASTE(new AABB(2166, 3119, 2315, 3025), new AABB(2181, 3117, 2280, 3131), new AABB(2301, 3137, 2364, 3079)),
    POISON_WASTE_DUNGEON(AABB.regions(5954, 5955)),
    ARANDAR_MAINLAND(2309, 3337, 2394, 3234),
    ARANDAR_PRIFDDINAS(3333, 6089, 3391, 5986),
    ARANDAR(ARANDAR_MAINLAND, ARANDAR_PRIFDDINAS),
    SOTE_GRAND_LIBRARY(AABB.regionBox(10335, 10592)),
    SOTE_LLETYA_ON_FIRE(11616),
    SOTE_LLETYA_MOSTLY_DONE_BURNING(11103),
    SOTE_TEMPLE_OF_LIGHT_SEREN_CUTSCENE(3237, 5913, 3219, 5933),
    SOTE_FRAGMENT_OF_SEREN_ARENA(3264, 5887, 3328, 5951),
    SOTE_CUTSCENE_LLETYA(AABB.regionBox(10846, 11360)),
    TYRAS_CAMP_INSTANCE(9287),
    TIRANNWN_MAINLAND(Area.merge(new Object[]{SOTE_LLETYA_ON_FIRE, SOTE_CUTSCENE_LLETYA, new AABB(2116, 3455, 2320, 3021), new AABB(2321, 3202, 2365, 3140), new AABB(2392, 3334, 2321, 3227)})),
    TIRANNWN(TIRANNWN_MAINLAND, PRIFDDINAS),
    ZANARIS(2315, 4345, 2500, 4485),
    GOD_WARS_DUNGEON_WILDERNESS(12190),
    GOD_WARS_DUNGEON(Area.merge(new Object[]{AABB.regionBox(11345, 11603), GOD_WARS_DUNGEON_WILDERNESS})),
    ISLE_OF_SOULS_MAINLAND(AABB.regionBox(8235, 9262)),
    ISLE_OF_SOULS_INSTANCE(AABB.regionBox(7515, 8542)),
    SOUL_WARS_ARENA_TUTORIAL(1921, 6018, 2110, 5950),
    SOUL_WARS_RED_BASE_TUTORIAL(new AABB(2080, 6018, 2110, 5982), new AABB(2105, 5982, 2076, 5956), new AABB(2081, 5963, 2048, 6010), new AABB(2048, 6010, 2068, 5954)),
    SOUL_WARS_BLUE_BASE_TUTORIAL(new AABB(1924, 5953, 1953, 6013), new AABB(1953, 6013, 1985, 5961)),
    SOUL_WARS_ARENA(Area.merge(new Object[]{SOUL_WARS_ARENA_TUTORIAL, new AABB(2113, 2946, 2302, 2878)})),
    SOUL_WARS_RED_BASE(Area.merge(new Object[]{SOUL_WARS_RED_BASE_TUTORIAL, new AABB(2272, 2946, 2302, 2910), new AABB(2297, 2910, 2268, 2884), new AABB(2273, 2891, 2240, 2938), new AABB(2240, 2938, 2260, 2882)})),
    SOUL_WARS_BLUE_BASE(Area.merge(new Object[]{SOUL_WARS_BLUE_BASE_TUTORIAL, new AABB(2116, 2881, 2145, 2941), new AABB(2145, 2941, 2177, 2889)})),
    KARUULM_SLAYER_DUNGEON(AABB.regions(5536), new AABB[]{AABB.regionBox(5022, 5023), AABB.regionBox(5279, 5280), new AABB(1344, 10239, 1354, 10231)}),
    MOUNT_KARUULM(1245, 3765, 1358, 3860),
    LIZARDMAN_TEMPLE(5277),
    XERICS_LOOKOUT(1580, 3526, 1596, 3534),
    SHAYZIEN_COMBAT_RING(1539, 3627, 1548, 3618),
    SHAYZIEN_ENCAMPMENT(new AABB(1467, 3678, 1540, 3607), new AABB(1540, 3613, 1559, 3650)),
    SHAYZIEN_SHAYZIA_RUIN(1577, 3587, 1594, 3604),
    SHAYZIEN_GRAVEYARD_OF_HEROES(1472, 3583, 1515, 3541),
    SHAYZIEN_EAST_ENTRANCE_BLEND_FIX(1556, 3577, 1556, 3575),
    SHAYZIEN(new AABB(1467, 3678, 1540, 3607), new AABB(1540, 3613, 1559, 3650), new AABB(1477, 3616, 1525, 3584), new AABB(1460, 3599, 1574, 3537), new AABB(1574, 3537, 1535, 3523), new AABB(1595, 3584, 1567, 3606)),
    HOSIDIUS(1720, 3641, 1802, 3560),
    SKOTIZO(9048),
    KOUREND_CATACOMBS(Area.merge(new Object[]{SKOTIZO, AABB.regionBox(6556, 6813)})),
    BLOOD_ALTAR(new AABB(1703, 3844, 1739, 3815), new AABB(1739, 3817, 1751, 3839), new AABB(1751, 3833, 1791, 3815)),
    DARK_ALTAR(1660, 3904, 1747, 3864),
    ARCEUUS(new AABB(1572, 3838, 1597, 3799), new AABB(1566, 3832, 1586, 3805), new AABB(1562, 3823, 1570, 3811), new AABB(1588, 3838, 1608, 3778), new AABB(1598, 3854, 1730, 3731), new AABB(1730, 3731, 1623, 3710), new AABB(1616, 3874, 1658, 3842), new AABB(1625, 3905, 1856, 3817)),
    ZEAH_SNOWY_NORTHERN_REGION(new AABB(1896, 3902, 1413, 4058), new AABB(1852, 3901, 1914, 3839), new AABB(1503, 3901, 1636, 3887), new AABB(1513, 3886, 1622, 3876), new AABB(1518, 3875, 1600, 3839), new AABB(1637, 3901, 1668, 3894)),
    LOVAKENGJ(new AABB(1416, 3899, 1521, 3835), new AABB(1560, 3840, 1420, 3787), new AABB(1434, 3787, 1586, 3755), new AABB(1595, 3767, 1448, 3737), new AABB(1460, 3737, 1598, 3719)),
    MOUNT_QUIDAMORTEM(new AABB(1194, 3594, 1292, 3520), new AABB(1287, 3556, 1300, 3596), new AABB(1300, 3596, 1308, 3580), new AABB(1230, 3611, 1269, 3588)),
    KEBOS_LOWLANDS(new AABB(1167, 3664, 1345, 3582), new AABB(1292, 3588, 1355, 3526), new AABB(1275, 3692, 1329, 3631)),
    ZEAH_WOODLAND_AREAS(new AABB(1430, 3677, 1897, 3383), new AABB(1539, 3711, 1639, 3678), new AABB(1548, 3732, 1617, 3712), new AABB(1640, 3707, 1897, 3678), new AABB(1735, 3708, 1856, 3815), new AABB(1198, 3790, 1253, 3665), new AABB(1254, 3772, 1287, 3693), new AABB(1288, 3764, 1324, 3694), new AABB(1325, 3755, 1351, 3694), new AABB(1352, 3751, 1363, 3715), new AABB(1272, 3692, 1254, 3666), new AABB(1400, 3589, 1429, 3465)),
    MESS_HALL_KITCHEN(1643, 3631, 1649, 3622),
    THE_STRANGLEWOOD_EXTENDED(1378, 3476, 1080, 3264),
    THE_STRANGLEWOOD(AABB.regionBox(4403, 4659), AABB.regionBox(4404, 4917)),
    THE_STRANGLEWOOD_QUEST_UNDERGROUND_AREAS(AABB.regionBox(4760, 4761)),
    JUDGE_OF_YAMA_BOSS(AABB.regionBox(6492, 6748)),
    XAMPHUR_BOSS(12124),
    ZEAH(1085, 4078, 1938, 2870),
    TAR_SWAMP(new AABB(3712, 3800, 3632, 3694), new AABB(3697, 3809, 3631, 3782)),
    FOSSIL_ISLAND(3626, 3908, 3851, 3693),
    FOSSIL_ISLAND_CENTRAL_BANK_FIX(new AABB(3744, 3805, 3742, 3802)),
    FOSSIL_ISLAND_HILL_HOUSE_INTERIOR(new AABB(3772, 3872, 3770, 3867), new AABB(3769, 3875, 3759, 3864), new AABB(3758, 3874, 3758, 3871), new AABB(3758, 3867, 3758, 3864)),
    FOSSIL_ISLAND_HILL_HOUSE_FIX(new AABB(3799, 3885, 3747, 3858)),
    FOSSIL_ISLAND_HILL_TEXTURE_FIX(new AABB(3845, 3900, 3657, 3720)),
    APE_ATOLL_WATERFALLS(new AABB(2754, 2734, 2754, 2736), new AABB(2751, 2738, 2752, 2738)),
    KARAMJA_INSTANCE_SOUTH_OF_MUSA_POINT(10055),
    KARAMJA_INSTANCE_SHIPYARD(2560, 4607, 2642, 4544),
    KARAMJA_INSTANCES(KARAMJA_INSTANCE_SOUTH_OF_MUSA_POINT, KARAMJA_INSTANCE_SHIPYARD),
    KARAMJA_VOLCANO_DUNGEON(2821, 9663, 2875, 9541),
    KARAMJA(Area.merge(new Object[]{new AABB(2686, 3257, 2809, 3124), new AABB(2810, 3124, 2917, 3209), new AABB(2918, 3184, 2964, 3132), new AABB(2746, 3123, 2973, 2873), new AABB(2974, 2873, 3009, 3081), KARAMJA_INSTANCES})),
    COSMIC_ENTITYS_PLANE(2048, 4863, 2111, 4800),
    VOID_KNIGHTS_OUTPOST(10537),
    PEST_CONTROL(10536),
    CRASH_ISLAND(11562),
    ENTRANA_GLASS_BUILDING_FIX(new AABB(2829, 3347, 2835, 3353), new AABB(2829, 3346, 2829, 3346), new AABB(2833, 3346, 2833, 3346)),
    ENTRANA(new AABB(2798, 3396, 2873, 3326), new AABB(2873, 3326, 2882, 3344)),
    CRANDOR(2810, 3314, 2869, 3221),
    FISHING_PLATFORM(2756, 3295, 2799, 3268),
    MOS_LE_HARMLESS(3643, 3075, 3858, 2923),
    MOS_LE_HARMLESS_INSTANCE(1952, 5344, 1983, 5312),
    BRAINDEATH_ISLAND(AABB.regions(8784), new AABB[]{new AABB(2112, 5042, 2175, 5183)}),
    HARMONY(15148),
    DRAGONTOOTH_ISLAND(15159),
    ICEBERG(2622, 4091, 2686, 3974),
    PENGUIN_BASE(2684, 10431, 2631, 10369),
    ISLAND_OF_STONE(9790),
    MISCELLANIA(2485, 3923, 2629, 3800),
    WATERBIRTH_ISLAND(10042),
    NEITIZNOT(9275),
    JATIZSO(9531),
    FREMENNIK_ISLES_NORTH(AABB.regionBox(9276, 9532)),
    FREMENNIK_ISLES(JATIZSO, NEITIZNOT, FREMENNIK_ISLES_NORTH),
    UNGAEL(9023),
    PIRATES_COVE(8763),
    LUNAR_DREAM_WORLD(AABB.regions(6991), new AABB[]{AABB.regionBox(7247, 7250)}),
    LUNAR_VILLAGE_HOUSE_INTERIORS_GROUND(new AABB(2104, 3922, 2097, 3917, 0), new AABB(2091, 3922, 2090, 3922, 0), new AABB(2092, 3921, 2089, 3917, 0), new AABB(2084, 3922, 2082, 3921, 0), new AABB(2075, 3922, 2070, 3919), new AABB(2078, 3915, 0), new AABB(2069, 3915, 0), new AABB(2071, 3907, 0), new AABB(2081, 3914, 2066, 3913, 0), new AABB(2081, 3912, 2069, 3910, 0), new AABB(2068, 3910, 2066, 3908, 0), new AABB(2078, 3909, 2069, 3909, 0), new AABB(2078, 3908, 2075, 3908, 0), new AABB(2072, 3908, 2069, 3908, 0), new AABB(2090, 3909, 2086, 3904, 0), new AABB(2098, 3908, 2094, 3905, 0), new AABB(2107, 3911, 0), new AABB(2102, 3911, 0), new AABB(2107, 3904, 0), new AABB(2103, 3904, 0), new AABB(2107, 3910, 2102, 3905, 0), new AABB(2076, 3899, 2072, 3897), new AABB(2084, 3899, 2083, 3892, 0), new AABB(2082, 3897, 2080, 3893, 0), new AABB(2082, 3892, 2081, 3892, 0), new AABB(2092, 3900, 2089, 3899, 0), new AABB(2092, 3898, 2091, 3896, 0), new AABB(2101, 3898, 2099, 3897, 0), new AABB(2102, 3901, 2096, 3896, 0)),
    LUNAR_VILLAGE_HOUSE_INTERIORS_FIRST(new AABB(2091, 3922, 2090, 3922, 1), new AABB(2092, 3921, 2089, 3917, 1), new AABB(2084, 3922, 2082, 3919, 1), new AABB(2078, 3915, 1), new AABB(2069, 3915, 1), new AABB(2071, 3907, 1), new AABB(2079, 3915, 2079, 3910, 1), new AABB(2078, 3915, 2076, 3908, 1), new AABB(2082, 3915, 2080, 3904, 1), new AABB(2079, 3909, 2079, 3904, 1), new AABB(2078, 3907, 2074, 3904, 1), new AABB(2091, 3910, 2085, 3903, 1), new AABB(2100, 3911, 2094, 3904, 1), new AABB(2108, 3912, 2101, 3903, 1), new AABB(2085, 3900, 2079, 3891, 1), new AABB(2093, 3901, 2088, 3890, 1), new AABB(2101, 3899, 2097, 3899, 1), new AABB(2101, 3898, 2099, 3897, 1), new AABB(2102, 3901, 2096, 3896, 1)),
    LUNAR_ESSENCE_MINE(9377),
    LUNAR_ISLE(AABB.regionBox(8252, 8509)),
    MM2_AIRSHIP_PLATFORM(2056, 5375, 2109, 5442),
    APE_ATOLL(AABB.regionBox(10794, 11051)),
    KOUREND_CASTLE_ENTRANCE_FIX(1623, 3677, 1623, 3669, 0),
    KOUREND_CASTLE(new AABB(1626, 3690, 1587, 3656, 0), new AABB(1617, 3690, 1610, 3656, 1), new AABB(1619, 3690, 1618, 3684, 1), new AABB(1621, 3683, 1618, 3676, 1), new AABB(1621, 3670, 1618, 3663, 1), new AABB(1619, 3662, 1618, 3656, 1), new AABB(1609, 3683, 1608, 3676, 1), new AABB(1609, 3670, 1608, 3663, 1), new AABB(1607, 3683, 1605, 3681, 1), new AABB(1607, 3665, 1605, 3663, 1), new AABB(1604, 3685, 1586, 3661, 1), new AABB(1621, 3690, 1610, 3656, 2), new AABB(1599, 3685, 1591, 3681, 2), new AABB(1599, 3667, 1591, 3661, 2)),
    KOUREND_GUARDPOSTS(new AABB(1615, 3700, 1613, 3695, 0), new AABB(1615, 3700, 1613, 3695, 1), new AABB(1692, 3678, 1690, 3677, 0), new AABB(1692, 3678, 1690, 3677, 1), new AABB(1692, 3669, 1690, 3668, 0), new AABB(1692, 3669, 1690, 3668, 1), new AABB(1626, 3700, 1625, 3699, 0), new AABB(1632, 3700, 1631, 3699, 0), new AABB(1633, 3647, 1632, 3646, 0), new AABB(1625, 3647, 1624, 3646, 0), new AABB(1614, 3650, 1613, 3646, 0), new AABB(1614, 3650, 1613, 3646, 1)),
    KOUREND_HOUSES(new AABB(1677, 3692, 1670, 3686), new AABB(1683, 3683, 1669, 3677, 0), new AABB(1683, 3683, 1669, 3677, 1), new AABB(1683, 3682, 1669, 3677, 2), new AABB(1683, 3669, 1670, 3663), new AABB(1679, 3660, 1674, 3654)),
    SHAYZIEN_INTERIORS_COBBLE(new AABB(1486, 3552, 1480, 3548, 0), new AABB(1513, 3595, 1504, 3589), new AABB(1521, 3593, 1517, 3588), new AABB(1521, 3587, 1520, 3587), new AABB(1518, 3587, 1517, 3587), new AABB(1541, 3582, 1531, 3578), new AABB(1544, 3572, 1541, 3568), new AABB(1540, 3572, 1540, 3571), new AABB(1540, 3596, 1540, 3568), new AABB(1542, 3558, 1542, 3557), new AABB(1542, 3555, 1542, 3554), new AABB(1541, 3558, 1538, 3554), new AABB(1542, 3549, 1542, 3548), new AABB(1542, 3546, 1542, 3541), new AABB(1541, 3549, 1538, 3541), new AABB(1534, 3547, 1530, 3542), new AABB(1553, 3569, 1548, 3560), new AABB(1552, 3559, 1549, 3559), new AABB(1567, 3571, 1561, 3568), new AABB(1567, 3567, 1566, 3567), new AABB(1564, 3567, 1561, 3567), new AABB(1569, 3547, 1565, 3543)),
    SHAYZIEN_BANK(new AABB(1491, 3595, 1482, 3589)),
    GREAT_KOUREND_STATUE(1641, 3678, 1631, 3668),
    HOSIDIUS_WELL(1764, 3600, 1761, 3597),
    HOSIDIUS_STAIRS(new AABB(1763, 3608, 1762, 3607)),
    KEBOS_SWAMP_XERIC_DIRT(1241, 3621, 1234, 3614),
    FISHING_TRAWLER_BOAT_PORT_KHAZARD(2669, 3183, 2673, 3166),
    FISHING_TRAWLER_BOAT_FLOODED(2012, 4826, 2021, 4824),
    FISHING_TRAWLER(new AABB(1792, 4863, 1855, 4734), new AABB(1855, 4893, 1920, 4798), new AABB(1920, 4863, 1990, 4798), new AABB(1990, 4917, 2047, 4798)),
    MOGRE_CAMP(11924),
    HARMONY_ISLAND_UNDERWATER_TUNNEL(3779, 9278, 3839, 9216, 1),
    FOSSIL_ISLAND_UNDERWATER_AREA(3712, 10303, 3839, 10240),
    AIR_ALTAR(11339),
    BODY_ALTAR(2552, 4805, 2496, 4863),
    CHAOS_ALTAR(9035),
    COSMIC_ALTAR(8523),
    DEATH_ALTAR(8779),
    EARTH_ALTAR(10571),
    FIRE_ALTAR(2553, 4863, 2623, 4802),
    LAW_ALTAR(9803),
    MIND_ALTAR(2815, 4800, 2752, 4863),
    NATURE_ALTAR(2369, 4804, 2426, 4863),
    WATER_ALTAR(10827),
    WRATH_ALTAR(9291),
    TRUE_BLOOD_ALTAR(3200, 4862, 3262, 4800),
    LITHKREN_DUNGEON(AABB.regions(6223), new AABB[]{AABB.regionBox(14242, 14243)}),
    LITHKREN(3519, 4032, 3602, 3967),
    DS2_SHIPS(AABB.regionBox(6486, 6745)),
    THE_GAUNTLET_NORMAL(new AABB(7512).onPlane(1)),
    THE_GAUNTLET_CORRUPTED(new AABB(7768).onPlane(1)),
    THE_GAUNTLET(THE_GAUNTLET_NORMAL, THE_GAUNTLET_CORRUPTED),
    THE_GAUNTLET_LOBBY(3025, 6131, 3040, 6116),
    PLAYER_OWNED_HOUSE(AABB.regionBox(7257, 8026)),
    PLAYER_OWNED_HOUSE_SNOWY(AABB.regionBox(8025, 8026).onPlane(1)),
    BLACKHOLE(1616, 4728, 1623, 4735),
    CAMDOZAAL(2897, 5848, 3036, 5760),
    TEMPOROSS_COVE(3005, 3011, 3066, 2941),
    TEMPLE_OF_THE_EYE_REGULAR(3680, 9535, 3548, 9441),
    TEMPLE_OF_THE_EYE_QUEST_1(2431, 5695, 2368, 5601),
    TEMPLE_OF_THE_EYE_QUEST_2(2432, 5665, 2495, 5759),
    TEMPLE_OF_THE_EYE(TEMPLE_OF_THE_EYE_REGULAR, TEMPLE_OF_THE_EYE_QUEST_1, TEMPLE_OF_THE_EYE_QUEST_2),
    TEMPLE_OF_THE_EYE_BLEND_FIX(new AABB(3613, 9474, 3613, 9474), new AABB(3616, 9475, 3614, 9474), new AABB(3617, 9475, 3617, 9474), new AABB(2397, 5634, 2397, 5634), new AABB(2398, 5634, 2400, 5635), new AABB(2401, 5635, 2401, 5634), new AABB(2461, 5698, 2461, 5698), new AABB(2462, 5698, 2464, 5699), new AABB(2465, 5699, 2465, 5698)),
    TEMPLE_OF_THE_EYE_CENTER_PLATFORM(new AABB(3620, 9511, 3610, 9498), new AABB(2394, 5658, 2404, 5671), new AABB(2458, 5722, 2468, 5735)),
    TEMPLE_OF_THE_EYE_ENTRANCE_BRIGHTNESS_FIX(new AABB(3618, 9478, 3611, 9473), new AABB(2395, 5633, 2402, 5638), new AABB(2459, 5697, 2466, 5702)),
    TEMPLE_OF_THE_EYE_ENTRANCE_FIX(new AABB(3613, 9471, 3617, 9481), new AABB(2461, 5695, 2465, 5705), new AABB(2397, 5631, 2401, 5641)),
    DEATHS_OFFICE(3164, 5734, 3185, 5719),
    TOB_ROOM_MAIDEN(3231, 4468, 3152, 4416),
    TOB_ROOM_BLOAT(3260, 4474, 3327, 4427),
    TOB_ROOM_NYCOLAS(3274, 4226, 3318, 4290),
    TOB_ROOM_SOTETSEG(3295, 4288, 3264, 4336),
    TOB_ROOM_XARPUS(3191, 4406, 3151, 4368),
    TOB_ROOM_VERZIK(3152, 4332, 3186, 4296),
    TOB_ROOM_VAULT(3224, 4334, 3250, 4305),
    THEATRE_OF_BLOOD(3151, 4226, 3327, 4474),
    TOA_ENTRANCE_LOBBY(3375, 9135, 3344, 9102),
    TOA_PATH_HUB(3520, 5183, 3583, 5120),
    TOA_LOOT_ROOM(3648, 5183, 3711, 5120),
    TOA_FINAL_BOSS_PHASE_1(3776, 5183, 3839, 5120),
    TOA_FINAL_BOSS_PHASE_2(3904, 5183, 3967, 5120),
    TOA_FINAL_BOSS(TOA_FINAL_BOSS_PHASE_1, TOA_FINAL_BOSS_PHASE_2),
    TOA_PATH_OF_SCABARAS_PUZZLE(3520, 5311, 3583, 5248),
    TOA_PATH_OF_SCABARAS_BOSS(3520, 5439, 3583, 5376),
    TOA_PATH_OF_SCABARAS(TOA_PATH_OF_SCABARAS_PUZZLE, TOA_PATH_OF_SCABARAS_BOSS),
    TOA_PATH_OF_HET_PUZZLE(3648, 5311, 3711, 5248),
    TOA_PATH_OF_HET_BOSS(3648, 5439, 3711, 5376),
    TOA_PATH_OF_HET(TOA_PATH_OF_HET_PUZZLE, TOA_PATH_OF_HET_BOSS),
    TOA_PATH_OF_APMEKEN_PUZZLE(3776, 5311, 3839, 5248),
    TOA_PATH_OF_APMEKEN_BOSS(3776, 5439, 3839, 5376),
    TOA_PATH_OF_APMEKEN(TOA_PATH_OF_APMEKEN_PUZZLE, TOA_PATH_OF_APMEKEN_BOSS),
    TOA_PATH_OF_CRONDIS_PUZZLE(3904, 5311, 3967, 5248),
    TOA_PATH_OF_CRONDIS_BOSS(3904, 5439, 3967, 5376),
    TOA_PATH_OF_CRONDIS(TOA_PATH_OF_CRONDIS_PUZZLE, TOA_PATH_OF_CRONDIS_BOSS),
    TOA_CRONDIS_ISLAND(new AABB(3942, 5403, 3942, 5413), new AABB(3941, 5400, 3926, 5416), new AABB(3939, 5399, 3939, 5417), new AABB(3938, 5399, 3929, 5418), new AABB(3925, 5403, 3923, 5413)),
    TOA_CRONDIS_ISLAND_SUBMERGED(3944, 5402, 3943, 5415),
    TOA_CRONDIS_WATER(new AABB(3957, 5387, 3948, 5429), new AABB(3947, 5389, 3943, 5427), new AABB(3942, 5387, 3921, 5429), new AABB(3920, 5388, 3920, 5428), new AABB(3919, 5389, 3916, 5427), new AABB(3915, 5390, 3915, 5426), new AABB(3914, 5391, 3914, 5425), new AABB(3913, 5392, 3913, 5424), new AABB(3912, 5398, 3912, 5418), new AABB(3911, 5399, 3906, 5417)),
    TOMBS_OF_AMASCUT(TOA_ENTRANCE_LOBBY, TOA_PATH_HUB, TOA_LOOT_ROOM, TOA_FINAL_BOSS_PHASE_1, TOA_FINAL_BOSS_PHASE_2, TOA_PATH_OF_SCABARAS_PUZZLE, TOA_PATH_OF_SCABARAS_BOSS, TOA_PATH_OF_HET_PUZZLE, TOA_PATH_OF_HET_BOSS, TOA_PATH_OF_APMEKEN_PUZZLE, TOA_PATH_OF_APMEKEN_BOSS, TOA_PATH_OF_CRONDIS_PUZZLE, TOA_PATH_OF_CRONDIS_BOSS),
    CHAMBERS_OF_XERIC_ICE_DEMON(3264, 5344, 3359, 5375),
    CHAMBERS_OF_XERIC(AABB.regions(12889, 13136), new AABB[]{AABB.regionBox(13137, 13401)}),
    SISTERHOOD_SANCTUARY(AABB.regionBox(14999, 15513)),
    NIGHTMARE_OF_ASHIHAMA_ARENA(15515),
    PEST_CONTROL_LANDER_WATER_FIX(new AABB(2660, 2644, 2663, 2638), new AABB(2638, 2642, 2641, 2648), new AABB(2632, 2649, 2635, 2655), new AABB(2656, 2615, 2659, 2609)),
    BARBARIAN_ASSAULT_WAITING_ROOMS(2571, 5252, 2616, 5305),
    TARNS_LAIR(AABB.regionBox(12615, 12616)),
    RANDOM_EVENT_CLASSROOM(1894, 5036, 1878, 5014),
    RANDOM_EVENT_FREAKY_FORESTER(2623, 4799, 2576, 4745),
    RANDOM_EVENT_GRAVEDIGGER(1920, 5007, 1935, 4992),
    RANDOM_EVENT_BEE_KEEPER(1920, 5055, 1940, 5033),
    RANDOM_EVENT_DRILL_DEMON(12619),
    RANDOM_EVENT_FROG_CAVE(2450, 4764, 2480, 4794),
    RANDOM_EVENT_PRISON_PETE(2059, 4479, 2111, 4447),
    RANDOM_EVENT_QUIZ_MASTER(7754),
    BLACK_ROOMS(RFD_QUIZ, RANDOM_EVENT_QUIZ_MASTER),
    CLAN_HALL(6997),
    LIGHTHOUSE(new AABB(2493, 3606, 2594, 3648), new AABB(2564, 3582, 2600, 3613)),
    LIGHTHOUSE_INSTANCE(2432, 4544, 2495, 4624),
    SORCERESSS_GARDEN(11605),
    PURO_PURO(10307),
    RATCATCHERS_HOUSE(2821, 5059, 2875, 5114),
    CANOE_CUTSCENE(7238),
    FISHER_KINGS_REALM(new AABB(2815, 4799, 2624, 4624), new AABB(2576, 4744, 2623, 4655)),
    ENCHANTED_VALLEY(12102),
    GIANTS_PLATEAU_CABBAGE_PATCH(3413, 3181, 3412, 3179),
    GIANTS_FOUNDRY(3331, 11456, 3393, 11520),
    ELID_CAVE(3325, 9520, 3395, 9605),
    ANCIENT_CAVERN(AABB.regionBox(6482, 6483), AABB.regionBox(6994, 6995)),
    LAND_OF_GOBLINS_CUTSCENE_WATER(3903, 4352, 3840, 4415),
    SHIP_SAILING(Area.merge(new Object[]{AABB.regions(7242, 7243, 7499, 7500, 7755, 8011, 8012), DS2_SHIPS})),
    WEISS_SALT_MINE(11425),
    SECRETS_OF_THE_NORTH_DUNGEON(AABB.regions(11681), new AABB[]{AABB.regionBox(11619, 12132)}),
    GOBLIN_VILLAGE_ICE_CAVE(7777),
    GOBLIN_VILLAGE_COOKS_CHAMBER_BLEND_FIX(new AABB(2982, 9872, 2979, 9870)),
    GOBLIN_VILLAGE_COOKS_CHAMBER_POST_RFD(2991, 9879, 2968, 9864),
    GOBLIN_VILLAGE_COOKS_CHAMBER_PRE_RFD(2991, 9919, 2968, 9904),
    GOBLIN_VILLAGE_COOKS_CHAMBER(GOBLIN_VILLAGE_COOKS_CHAMBER_PRE_RFD, GOBLIN_VILLAGE_COOKS_CHAMBER_POST_RFD),
    GOBLIN_VILLAGE_INSTANCE(9812),
    TAVERLEY_DUNGEON_BLACK_KNIGHT_KITCHEN(new AABB(2918, 9706, 2925, 9713)),
    TAVERLEY_DUNGEON(new AABB(2813, 9855, 2949, 9783), new AABB(2950, 9800, 2970, 9770), new AABB(2844, 9782, 2949, 9775), new AABB(2848, 9774, 2949, 9768), new AABB(2853, 9767, 2938, 9759), new AABB(2884, 9758, 2939, 9668)),
    ICE_QUEENS_DUNGEON(new AABB(2816, 9983, 2879, 9897), new AABB(2880, 9977, 2896, 9920)),
    TROLLWEISS_CAVES(new AABB(2766, 10238, 2809, 10185)),
    PHANTOM_MUSPAH_BOSS_ROOM(11330),
    ICY_UNDERGROUND_DARK(WEISS_SALT_MINE, SECRETS_OF_THE_NORTH_DUNGEON),
    ICY_UNDERGROUND_BRIGHT(ASGARNIA_ICE_DUNGEON_SNOWY, ICE_QUEENS_DUNGEON, GOBLIN_VILLAGE_ICE_CAVE, TROLLWEISS_CAVES),
    SHADOW_DUNGEON(AABB.regions(10575, 10831)),
    THE_SCAR_MAIN_AREA(AABB.regions(7779), new AABB[]{new AABB(1984, 6304, 2143, 6463)}),
    THE_SCAR_QUEST_AREAS(AABB.regions(7012, 7524, 8804)),
    THE_SCAR(THE_SCAR_MAIN_AREA, THE_SCAR_QUEST_AREAS),
    LASSAR_UNDERCITY_MAIN_NORMAL(AABB.regions(10083), new AABB[]{AABB.regionBox(10338, 10852)}),
    LASSAR_UNDERCITY_MAIN_SHADOW_REALM(AABB.regions(9059), new AABB[]{AABB.regionBox(9314, 9828)}),
    LASSAR_UNDERCITY_DRAIN_NORMAL(11106),
    LASSAR_UNDERCITY_DRAIN_SHADOW_REALM(10082),
    LASSAR_UNDERCITY_SUNKEN_CATHEDRAL(new AABB(2372, 6397, 2428, 6333), new AABB(2628, 6397, 2684, 6333)),
    LASSAR_UNDERCITY_WATER_CUTSCENE(12898),
    LASSAR_UNDERCITY_WATER(LASSAR_UNDERCITY_MAIN_NORMAL, LASSAR_UNDERCITY_MAIN_SHADOW_REALM, LASSAR_UNDERCITY_WATER_CUTSCENE),
    LASSAR_UNDERCITY_NORMAL(LASSAR_UNDERCITY_MAIN_NORMAL, LASSAR_UNDERCITY_DRAIN_NORMAL, LASSAR_UNDERCITY_WATER_CUTSCENE),
    LASSAR_UNDERCITY_SHADOW_REALM(LASSAR_UNDERCITY_MAIN_SHADOW_REALM, LASSAR_UNDERCITY_DRAIN_SHADOW_REALM),
    LASSAR_UNDERCITY(LASSAR_UNDERCITY_NORMAL, LASSAR_UNDERCITY_SHADOW_REALM),
    ANCIENT_VAULT(13156),
    GLOD_INSTANCE(8534),
    PROBABLY_CUTSCENE_GRASS(3392, 4807, 3399, 4800),
    YU_BIUSK(15428),
    GIANT_MOLE_LAIR(AABB.regions(6992, 6993)),
    WATERBIRTH_DUNGEON_LEVEL_1(AABB.regionBox(9886, 10142).onPlane(0)),
    WATERBIRTH_DUNGEON_LEVEL_2(AABB.regionBox(7236, 7748).onPlane(1)),
    WATERBIRTH_DUNGEON_LEVEL_3(AABB.regionBox(7236, 7748).onPlane(2)),
    WATERBIRTH_DUNGEON_LEVEL_4(AABB.regionBox(7236, 7748).onPlane(3)),
    WATERBIRTH_DUNGEON_LEVEL_5(AABB.regionBox(7492, 7748).onPlane(0)),
    DAGANNOTH_KINGS_REGULAR_CAVE(new AABB(11589).onPlane(0)),
    DAGANNOTH_KINGS_SLAYER_CAVE(new AABB(11588).onPlane(0)),
    WATERBIRTH_DUNGEON(Area.merge(new Object[]{WATERBIRTH_DUNGEON_LEVEL_1, WATERBIRTH_DUNGEON_LEVEL_2, WATERBIRTH_DUNGEON_LEVEL_3, WATERBIRTH_DUNGEON_LEVEL_4, WATERBIRTH_DUNGEON_LEVEL_5, DAGANNOTH_KINGS_REGULAR_CAVE, DAGANNOTH_KINGS_SLAYER_CAVE})),
    ESSENCE_MINE(11595),
    ICE_MOUNTAIN(3028, 3458, 2991, 3510),
    SNOW_REGIONS(ASGARNIA_ICE_DUNGEON_SNOWY, ESSENCE_MINE, FREMENNIK_ISLES_NORTH, FROZEN_WASTE_PLATEAU, GIELINOR_SNOWY_NORTHERN_REGION, GOBLIN_VILLAGE_ICE_CAVE, ICEBERG, ICE_MOUNTAIN, ICE_QUEENS_DUNGEON, LUNAR_ISLE, MISCELLANIA, WHITE_WOLF_MOUNTAIN, ZEAH_SNOWY_NORTHERN_REGION, ICE_MOUNTAIN, PLAYER_OWNED_HOUSE_SNOWY, TROLLHEIM),
    KINGDOM_OF_MISTHALIN_REGION(new AABB(3067, 3521, 3399, 3330), new AABB(3070, 3329, 3263, 3201), new AABB(3257, 3200, 3090, 3186), new AABB(3252, 3185, 3094, 3136), new AABB(3266, 3329, 3264, 3204), new AABB(3267, 3231, 3267, 3224), new AABB(3267, 3329, 3270, 3326), new AABB(3269, 3325, 3267, 3325), new AABB(3267, 3324, 3267, 3323), new AABB(3268, 3324, 3268, 3324), new AABB(3334, 3329, 3339, 3328), new AABB(3346, 3329, 3360, 3328), new AABB(3370, 3329, 3375, 3329), new AABB(3069, 3267, 3068, 3244), new AABB(3067, 3256, 3067, 3255), new AABB(3066, 3255, 3066, 3255), new AABB(3065, 3254, 3067, 3245), new AABB(3069, 3268, 3069, 3272), new AABB(3069, 3285, 3069, 3310), new AABB(3068, 3309, 3068, 3296), new AABB(3069, 3314, 3069, 3323), new AABB(3400, 3508, 3411, 3452), new AABB(3412, 3503, 3419, 3462), new AABB(3420, 3493, 3425, 3468), new AABB(3426, 3485, 3431, 3472), new AABB(3420, 3467, 3421, 3466)),
    KINGDOM_OF_ASGARNIA_REGION(new AABB(3064, 3521, 2892, 3198), new AABB(2934, 3197, 3063, 3169), new AABB(2973, 3168, 3039, 3097), new AABB(3067, 3257, 3065, 3453), new AABB(3069, 3327, 3068, 3323), new AABB(3068, 3322, 3068, 3309), new AABB(3069, 3310, 3069, 3314), new AABB(3068, 3296, 3068, 3267), new AABB(3069, 3272, 3069, 3285), new AABB(3066, 3256, 3065, 3256), new AABB(3065, 3255, 3065, 3255), new AABB(2891, 3344, 2881, 3521), new AABB(2880, 3390, 2868, 3521), new AABB(2937, 3522, 2882, 3578), new AABB(2837, 3556, 2881, 3522), new AABB(2854, 3578, 2881, 3557), new AABB(2853, 3560, 2848, 3557), new AABB(2836, 3551, 2784, 3526), new AABB(2790, 3525, 2836, 3500), new AABB(2790, 3499, 2836, 3495), new AABB(2796, 3494, 2809, 3493), new AABB(2826, 3494, 2836, 3491), new AABB(2830, 3490, 2836, 3482), new AABB(2832, 3481, 2836, 3475), new AABB(2834, 3474, 2836, 3464), new AABB(2837, 3521, 2867, 3464), new AABB(2838, 3463, 2867, 3461), new AABB(2842, 3460, 2867, 3448), new AABB(2841, 3451, 2840, 3449), new AABB(2845, 3447, 2867, 3446), new AABB(2851, 3445, 2867, 3443), new AABB(2854, 3442, 2867, 3441), new AABB(2858, 3440, 2867, 3438), new AABB(2867, 3430, 2866, 3437), new AABB(2865, 3437, 2864, 3434)),
    KINGDOM_OF_KANDARIN_REGION(new AABB(2827, 3491, 2304, 3392), new AABB(2303, 3458, 2286, 3491), new AABB(2761, 3585, 2258, 3492), new AABB(2258, 3586, 2414, 3708), new AABB(2512, 3596, 2548, 3586), new AABB(2758, 3586, 2747, 3588), new AABB(2741, 3586, 2638, 3590), new AABB(2646, 3591, 2652, 3592), new AABB(2652, 3593, 2650, 3594), new AABB(2653, 3596, 2716, 3591), new AABB(2717, 3593, 2729, 3591), new AABB(2697, 3597, 2672, 3598), new AABB(2678, 3602, 2684, 3599), new AABB(2658, 3597, 2666, 3598), new AABB(2353, 3391, 2766, 3335), new AABB(2431, 3334, 2801, 3255), new AABB(2431, 3254, 2688, 3066), new AABB(2689, 3254, 2705, 3237), new AABB(2365, 3140, 2430, 3066), new AABB(2400, 3202, 2430, 3141), new AABB(2441, 3065, 2320, 3028), new AABB(2324, 3078, 2364, 3066), new AABB(2558, 3065, 2619, 3044), new AABB(2555, 3065, 2557, 3063), new AABB(2557, 3062, 2557, 3062), new AABB(2554, 3065, 2554, 3065), new AABB(2576, 3043, 2590, 3041), new AABB(2579, 3040, 2586, 3037), new AABB(2762, 3521, 2789, 3492), new AABB(2834, 3449, 2828, 3474), new AABB(2830, 3475, 2828, 3487), new AABB(2835, 3461, 2841, 3452), new AABB(2835, 3451, 2839, 3449), new AABB(2842, 3448, 2828, 3411), new AABB(2843, 3411, 2866, 3430), new AABB(2865, 3431, 2843, 3433), new AABB(2862, 3434, 2843, 3437), new AABB(2843, 3446, 2847, 3438), new AABB(2848, 3444, 2851, 3438), new AABB(2852, 3440, 2853, 3438)),
    FREMENNIK_REGION(FREMENNIK_PROVINCE, FREMENNIK_ISLES, MISCELLANIA, PIRATES_COVE, LUNAR_ISLE),
    FELDIP_HILLS(new AABB(2579, 3040, 2586, 3037), new AABB(2762, 3521, 2789, 3492), new AABB(2834, 3449, 2828, 3474), new AABB(2830, 3475, 2828, 3487), new AABB(2835, 3461, 2841, 3452), new AABB(2835, 3451, 2839, 3449), new AABB(2842, 3448, 2828, 3411), new AABB(2843, 3411, 2866, 3430), new AABB(2865, 3431, 2843, 3433), new AABB(2862, 3434, 2843, 3437), new AABB(2843, 3446, 2847, 3438), new AABB(2848, 3444, 2851, 3438), new AABB(2852, 3440, 2853, 3438), new AABB(2442, 3065, 2554, 2997), new AABB(2555, 3062, 2557, 2997), new AABB(2558, 3043, 2575, 2997), new AABB(2576, 3040, 2578, 3013), new AABB(2579, 3036, 2652, 3013), new AABB(2576, 3012, 2652, 2997), new AABB(2438, 2996, 2657, 2816)),
    CERBERUS(1216, 1216, 1406, 1343),
    MAINLAND(1024, 4159, 3967, 2496),
    MAINLAND_EXTENSIONS(Area.merge(new Object[]{BRAINDEATH_ISLAND, CLAN_HALL, CLAN_WARS_ARENAS_OVERWORLD, EVIL_BOB_ISLAND, FISHER_KINGS_REALM, LMS_ARENA_DESERTED_ISLAND, LMS_ARENA_WILD_VARROCK, PLAYER_OWNED_HOUSE, PURO_PURO, RANDOM_EVENT_BEE_KEEPER, RANDOM_EVENT_CLASSROOM, RANDOM_EVENT_DRILL_DEMON, RANDOM_EVENT_FREAKY_FORESTER, RANDOM_EVENT_GRAVEDIGGER, SORCERESSS_GARDEN, TIRANNWN_MAINLAND, YU_BIUSK, AIR_ALTAR, NATURE_ALTAR, WATER_ALTAR, CANOE_CUTSCENE, EYES_OF_GLOUPHRIE_GNOME_AND_GOBLIN_BATTLE_CUTSCENE, PROBABLY_CUTSCENE_GRASS, SOTE_CUTSCENE_ARDOUGNE_SQUARE, FALADOR_INSTANCE, GLOD_INSTANCE, GOBLIN_VILLAGE_INSTANCE, ISLE_OF_SOULS_INSTANCE, KARAMJA_INSTANCES, KEEP_LE_FAYE_INSTANCE, LIGHTHOUSE_INSTANCE, LUMBRIDGE_CASTLE_INSTANCE, MOS_LE_HARMLESS_INSTANCE, TREE_GNOME_STRONGHOLD_INSTANCE, TUTORIAL_ISLAND_INSTANCE, TYRAS_CAMP_INSTANCE, SHIP_SAILING, VER_SINHAZA_CUTSCENE, AABB.regions(8288, 8801, 11593)})),
    OVERWORLD(MAINLAND, MAINLAND_EXTENSIONS),
    ALL(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE),
    NONE(0, 0, 0, 0);

    public final AABB[] aabbs;

    private Area(AABB ... aabbs) {
        this.aabbs = aabbs;
    }

    private Area(AABB[] aabbs1, AABB ... aabbs2) {
        this.aabbs = new AABB[aabbs1.length + aabbs2.length];
        System.arraycopy(aabbs1, 0, this.aabbs, 0, aabbs1.length);
        System.arraycopy(aabbs2, 0, this.aabbs, aabbs1.length, aabbs2.length);
    }

    private Area(Area ... areas) {
        this.aabbs = Area.areas(areas);
    }

    private Area(int pointAX, int pointAY, int pointBX, int pointBY) {
        this.aabbs = new AABB[]{new AABB(pointAX, pointAY, pointBX, pointBY)};
    }

    private Area(int pointAX, int pointAY, int pointBX, int pointBY, int plane) {
        this.aabbs = new AABB[]{new AABB(pointAX, pointAY, pointBX, pointBY, plane)};
    }

    private Area(int regionId) {
        this(AABB.regions(regionId));
    }

    private static AABB[] merge(Object ... objects) {
        int count = 0;
        for (Object obj : objects) {
            if (obj instanceof Area) {
                count += ((Area)((Object)obj)).aabbs.length;
                continue;
            }
            if (obj instanceof AABB[]) {
                count += ((AABB[])obj).length;
                continue;
            }
            if (obj instanceof AABB) {
                ++count;
                continue;
            }
            throw new IllegalArgumentException("Not sure what to do with provided object: " + obj);
        }
        AABB[] aabbs = new AABB[count];
        int i = 0;
        for (Object obj : objects) {
            if (obj instanceof Area) {
                for (AABB aabb : ((Area)((Object)obj)).aabbs) {
                    aabbs[i++] = aabb;
                }
                continue;
            }
            if (obj instanceof AABB[]) {
                for (AABB aabb : (AABB[])obj) {
                    aabbs[i++] = aabb;
                }
                continue;
            }
            if (!(obj instanceof AABB)) continue;
            aabbs[i++] = (AABB)obj;
        }
        return aabbs;
    }

    private static AABB[] areas(Area ... areas) {
        return (AABB[])Arrays.stream(areas).flatMap(a -> Arrays.stream(a.aabbs)).toArray(AABB[]::new);
    }

    public boolean containsPoint(int worldX, int worldY, int plane) {
        for (AABB aabb : this.getAabbs()) {
            if (!aabb.contains(worldX, worldY, plane)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint(int[] worldPoint) {
        return this.containsPoint(worldPoint[0], worldPoint[1], worldPoint[2]);
    }

    public boolean containsPoint(WorldPoint worldPoint) {
        return this.containsPoint(worldPoint.getX(), worldPoint.getY(), worldPoint.getPlane());
    }

    public boolean intersects(Area otherArea) {
        if (otherArea == null) {
            return false;
        }
        for (AABB other : otherArea.aabbs) {
            for (AABB self : this.aabbs) {
                if (!self.intersects(other)) continue;
                return true;
            }
        }
        return false;
    }

    public AABB[] getAabbs() {
        return this.aabbs;
    }

    public static class JsonAdapter
    extends TypeAdapter<Area> {
        private static final Logger log = LoggerFactory.getLogger(JsonAdapter.class);

        public Area read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                return null;
            }
            if (token != JsonToken.STRING) {
                log.warn("Invalid type for area enum: '{}' at {}", new Object[]{token, GsonUtils.location(in), new Throwable()});
                return NONE;
            }
            String str = in.nextString();
            try {
                return Area.valueOf(str);
            }
            catch (IllegalArgumentException ex) {
                log.warn("Area enum '{}' does not exist at {}", new Object[]{str, GsonUtils.location(in), new Throwable()});
                return NONE;
            }
        }

        public void write(JsonWriter out, Area area) throws IOException {
            if (area == null) {
                out.nullValue();
            } else {
                out.value(area.name());
            }
        }
    }
}

