/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.data;

import java.util.function.Consumer;
import rs117.hd.data.materials.Material;
import rs117.hd.utils.ColorUtils;

public enum WaterType {
    NONE,
    WATER,
    WATER_FLAT(WATER, true),
    SWAMP_WATER(b -> b.specularStrength(0.1f).specularGloss(100.0f).normalStrength(0.05f).baseOpacity(0.8f).fresnelAmount(0.3f).surfaceColor(ColorUtils.srgb(23.0f, 33.0f, 20.0f)).foamColor(ColorUtils.srgb(115.0f, 120.0f, 101.0f)).depthColor(ColorUtils.srgb(41.0f, 82.0f, 26.0f)).causticsStrength(0.0f).duration(1.2f)),
    SWAMP_WATER_FLAT(SWAMP_WATER, true),
    POISON_WASTE(b -> b.specularStrength(0.1f).specularGloss(100.0f).normalStrength(0.05f).baseOpacity(0.9f).fresnelAmount(0.3f).surfaceColor(ColorUtils.srgb(22.0f, 23.0f, 13.0f)).foamColor(ColorUtils.srgb(106.0f, 108.0f, 100.0f)).depthColor(ColorUtils.srgb(50.0f, 52.0f, 46.0f)).causticsStrength(0.0f).duration(1.6f)),
    BLACK_TAR_FLAT(b -> b.specularStrength(0.05f).specularGloss(300.0f).normalStrength(0.05f).baseOpacity(0.9f).fresnelAmount(0.02f).surfaceColor(ColorUtils.rgb(38.0f, 40.0f, 43.0f)).foamColor(ColorUtils.rgb(0.0f, 0.0f, 0.0f)).depthColor(ColorUtils.rgb(38.0f, 40.0f, 43.0f)).causticsStrength(0.0f).duration(1.6f).flat(true)),
    BLOOD(b -> b.specularStrength(0.5f).specularGloss(500.0f).normalStrength(0.05f).baseOpacity(0.8f).fresnelAmount(0.3f).surfaceColor(ColorUtils.srgb(38.0f, 0.0f, 0.0f)).foamColor(ColorUtils.srgb(117.0f, 63.0f, 45.0f)).depthColor(ColorUtils.srgb(50.0f, 26.0f, 22.0f)).causticsStrength(0.0f).duration(2.0f)),
    ICE(b -> b.specularStrength(0.3f).specularGloss(200.0f).normalStrength(0.04f).baseOpacity(0.85f).fresnelAmount(1.0f).foamColor(ColorUtils.srgb(150.0f, 150.0f, 150.0f)).depthColor(ColorUtils.srgb(0.0f, 117.0f, 142.0f)).causticsStrength(0.4f).duration(0.0f).normalMap(Material.WATER_NORMAL_MAP_2)),
    ICE_FLAT(ICE, true),
    MUDDY_WATER(b -> b.specularStrength(0.1f).specularGloss(100.0f).normalStrength(0.05f).baseOpacity(0.7f).fresnelAmount(0.3f).surfaceColor(ColorUtils.srgb(35.0f, 10.0f, 0.0f)).foamColor(ColorUtils.srgb(106.0f, 108.0f, 24.0f)).depthColor(ColorUtils.srgb(65.0f, 23.0f, 0.0f)).causticsStrength(0.0f).duration(2.7f)),
    SCAR_SLUDGE(b -> b.specularStrength(0.0f).specularGloss(100.0f).normalStrength(0.05f).baseOpacity(0.85f).fresnelAmount(0.3f).surfaceColor(ColorUtils.srgb(38.0f, 38.0f, 35.0f)).foamColor(ColorUtils.srgb(105.0f, 119.0f, 94.0f)).depthColor(ColorUtils.srgb(105.0f, 119.0f, 94.0f)).causticsStrength(0.0f).duration(1.2f)),
    PLAIN_WATER(b -> b.depthColor(ColorUtils.rgb(0.0f, 0.0f, 0.0f)).foamColor(ColorUtils.rgb(64.0f, 64.0f, 64.0f)).causticsStrength(0.0f).flat(true));

    public final boolean flat;
    public final float specularStrength;
    public final float specularGloss;
    public final float normalStrength;
    public final float baseOpacity;
    public final float fresnelAmount;
    public final Material normalMap;
    public final float[] surfaceColor;
    public final float[] foamColor;
    public final float[] depthColor;
    public final float causticsStrength;
    public final boolean hasFoam;
    public final float duration;

    private WaterType() {
        this(b -> {});
    }

    private WaterType(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        this.flat = builder.flat;
        this.specularStrength = builder.specularStrength;
        this.specularGloss = builder.specularGloss;
        this.normalStrength = builder.normalStrength;
        this.baseOpacity = builder.baseOpacity;
        this.fresnelAmount = builder.fresnelAmount;
        this.normalMap = builder.normalMap;
        this.surfaceColor = builder.surfaceColor;
        this.foamColor = builder.foamColor;
        this.depthColor = builder.depthColor;
        this.causticsStrength = builder.causticsStrength;
        this.hasFoam = builder.hasFoam;
        this.duration = builder.duration;
    }

    private WaterType(WaterType parent, boolean flat) {
        this.flat = flat;
        this.specularStrength = parent.specularStrength;
        this.specularGloss = parent.specularGloss;
        this.normalStrength = parent.normalStrength;
        this.baseOpacity = parent.baseOpacity;
        this.fresnelAmount = parent.fresnelAmount;
        this.normalMap = parent.normalMap;
        this.surfaceColor = parent.surfaceColor;
        this.foamColor = parent.foamColor;
        this.depthColor = parent.depthColor;
        this.causticsStrength = parent.causticsStrength;
        this.hasFoam = parent.hasFoam;
        this.duration = parent.duration;
    }

    private static class Builder {
        private boolean flat = false;
        private float specularStrength = 0.5f;
        private float specularGloss = 500.0f;
        private float normalStrength = 0.09f;
        private float baseOpacity = 0.5f;
        private float fresnelAmount = 1.0f;
        private Material normalMap = Material.WATER_NORMAL_MAP_1;
        private float[] surfaceColor = new float[]{1.0f, 1.0f, 1.0f};
        private float[] foamColor = ColorUtils.srgb(176.0f, 164.0f, 146.0f);
        private float[] depthColor = ColorUtils.srgb(0.0f, 117.0f, 142.0f);
        private float causticsStrength = 1.0f;
        private boolean hasFoam = true;
        private float duration = 1.0f;

        private Builder() {
        }

        public Builder flat(boolean flat) {
            this.flat = flat;
            return this;
        }

        public Builder specularStrength(float specularStrength) {
            this.specularStrength = specularStrength;
            return this;
        }

        public Builder specularGloss(float specularGloss) {
            this.specularGloss = specularGloss;
            return this;
        }

        public Builder normalStrength(float normalStrength) {
            this.normalStrength = normalStrength;
            return this;
        }

        public Builder baseOpacity(float baseOpacity) {
            this.baseOpacity = baseOpacity;
            return this;
        }

        public Builder fresnelAmount(float fresnelAmount) {
            this.fresnelAmount = fresnelAmount;
            return this;
        }

        public Builder normalMap(Material normalMap) {
            this.normalMap = normalMap;
            return this;
        }

        public Builder surfaceColor(float[] surfaceColor) {
            this.surfaceColor = surfaceColor;
            return this;
        }

        public Builder foamColor(float[] foamColor) {
            this.foamColor = foamColor;
            return this;
        }

        public Builder depthColor(float[] depthColor) {
            this.depthColor = depthColor;
            return this;
        }

        public Builder causticsStrength(float causticsStrength) {
            this.causticsStrength = causticsStrength;
            return this;
        }

        public Builder hasFoam(boolean hasFoam) {
            this.hasFoam = hasFoam;
            return this;
        }

        public Builder duration(float duration) {
            this.duration = duration;
            return this;
        }
    }
}

