/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts.Util;

import com.salverrs.RemainingCasts.Model.SpellCost;
import com.salverrs.RemainingCasts.Model.SpellInfo;
import com.salverrs.RemainingCasts.Model.SpellProduct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpellIds {
    private static final List<SpellInfo> Spells = new ArrayList<SpellInfo>();
    private static final Map<SpellProduct, SpellInfo> SpellProductMap = new HashMap<SpellProduct, SpellInfo>();
    private static final Map<String, SpellInfo> SpellNameMap = new HashMap<String, SpellInfo>();
    private static final Map<Integer, SpellInfo> SpellSpriteMap = new HashMap<Integer, SpellInfo>();

    public static List<SpellInfo> getAllSpells() {
        return Spells;
    }

    public static SpellInfo getSpellBySpriteId(int spriteId) {
        return SpellSpriteMap.getOrDefault(spriteId, null);
    }

    public static SpellInfo getSpellByName(String spellName) {
        return SpellNameMap.getOrDefault(spellName.toLowerCase(), null);
    }

    public static SpellInfo getSpellByProduct(int itemId, int quantity) {
        return SpellProductMap.getOrDefault(new SpellProduct(itemId, quantity), null);
    }

    static {
        Spells.add(new SpellInfo("Wind Strike", 15, new SpellCost(new int[]{558, 556}, new int[]{1, 1})));
        Spells.add(new SpellInfo("Confuse", 16, new SpellCost(new int[]{559, 555, 557}, new int[]{1, 3, 2})));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Opal)", 358, new SpellCost(new int[]{556, 564, 879}, new int[]{2, 1, 10}), new SpellProduct(9236, 10), new SpellProduct(21932, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Sapphire)", 358, new SpellCost(new int[]{555, 564, 558, 9337}, new int[]{1, 1, 1, 10}), new SpellProduct(9240, 10), new SpellProduct(21940, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Jade)", 358, new SpellCost(new int[]{557, 564, 9335}, new int[]{2, 1, 10}), new SpellProduct(9237, 10), new SpellProduct(21934, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Pearl)", 358, new SpellCost(new int[]{555, 564, 880}, new int[]{2, 1, 10}), new SpellProduct(9238, 10), new SpellProduct(21936, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Emerald)", 358, new SpellCost(new int[]{556, 564, 561, 9338}, new int[]{3, 1, 1, 10}), new SpellProduct(9241, 10), new SpellProduct(21942, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Red Topaz)", 358, new SpellCost(new int[]{554, 564, 9336}, new int[]{2, 1, 10}), new SpellProduct(9239, 10), new SpellProduct(21938, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Ruby)", 358, new SpellCost(new int[]{554, 565, 564, 9339}, new int[]{5, 1, 1, 10}), new SpellProduct(9242, 10), new SpellProduct(21944, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Diamond)", 358, new SpellCost(new int[]{557, 564, 563, 9340}, new int[]{10, 1, 2, 10}), new SpellProduct(9243, 10), new SpellProduct(21946, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Dragonstone)", 358, new SpellCost(new int[]{557, 564, 566, 9341}, new int[]{15, 1, 1, 10}), new SpellProduct(9244, 10), new SpellProduct(21948, 10)));
        Spells.add(new SpellInfo("Enchant Crossbow Bolt (Onyx)", 358, new SpellCost(new int[]{554, 564, 560, 9342}, new int[]{20, 1, 1, 10}), new SpellProduct(9245, 10), new SpellProduct(21950, 10)));
        Spells.add(new SpellInfo("Water Strike", 17, new SpellCost(new int[]{558, 555, 556}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Lvl-1 Enchant", 18, new SpellCost(new int[]{564, 555}, new int[]{1, 1})));
        Spells.add(new SpellInfo("Earth Strike", 19, new SpellCost(new int[]{558, 557, 556}, new int[]{1, 2, 1})));
        Spells.add(new SpellInfo("Weaken", 20, new SpellCost(new int[]{559, 555, 557}, new int[]{1, 3, 2})));
        Spells.add(new SpellInfo("Fire Strike", 21, new SpellCost(new int[]{558, 554, 556}, new int[]{1, 3, 2})));
        Spells.add(new SpellInfo("Bones to Bananas", 22, new SpellCost(new int[]{561, 555, 557}, new int[]{1, 2, 2})));
        Spells.add(new SpellInfo("Wind Bolt", 23, new SpellCost(new int[]{562, 556}, new int[]{1, 2})));
        Spells.add(new SpellInfo("Curse", 24, new SpellCost(new int[]{559, 555, 557}, new int[]{1, 2, 3})));
        Spells.add(new SpellInfo("Bind", 319, new SpellCost(new int[]{561, 555, 557}, new int[]{2, 3, 3})));
        Spells.add(new SpellInfo("Low Level Alchemy", 25, new SpellCost(new int[]{561, 554}, new int[]{1, 3})));
        Spells.add(new SpellInfo("Water Bolt", 26, new SpellCost(new int[]{562, 555, 556}, new int[]{1, 2, 2})));
        Spells.add(new SpellInfo("Varrock Teleport", 27, new SpellCost(new int[]{563, 556, 554}, new int[]{1, 3, 1})));
        Spells.add(new SpellInfo("Lvl-2 Enchant", 28, new SpellCost(new int[]{564, 556}, new int[]{1, 3})));
        Spells.add(new SpellInfo("Earth Bolt", 29, new SpellCost(new int[]{562, 557, 556}, new int[]{1, 3, 2})));
        Spells.add(new SpellInfo("Lumbridge Teleport", 30, new SpellCost(new int[]{563, 556, 557}, new int[]{1, 3, 1})));
        Spells.add(new SpellInfo("Telekinetic Grab", 31, new SpellCost(new int[]{563, 556}, new int[]{1, 1})));
        Spells.add(new SpellInfo("Fire Bolt", 32, new SpellCost(new int[]{562, 554, 556}, new int[]{1, 4, 3})));
        Spells.add(new SpellInfo("Falador Teleport", 33, new SpellCost(new int[]{563, 556, 555}, new int[]{1, 3, 1})));
        Spells.add(new SpellInfo("Crumble Undead", 34, new SpellCost(new int[]{562, 557, 556}, new int[]{1, 2, 2})));
        Spells.add(new SpellInfo("Teleport to House", 355, new SpellCost(new int[]{563, 556, 557}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Wind Blast", 35, new SpellCost(new int[]{560, 556}, new int[]{1, 3})));
        Spells.add(new SpellInfo("Superheat Item", 36, new SpellCost(new int[]{561, 554}, new int[]{1, 4})));
        Spells.add(new SpellInfo("Camelot Teleport", 37, new SpellCost(new int[]{563, 556}, new int[]{1, 5})));
        Spells.add(new SpellInfo("Water Blast", 38, new SpellCost(new int[]{560, 555, 556}, new int[]{1, 3, 3})));
        Spells.add(new SpellInfo("Lvl-3 Enchant", 39, new SpellCost(new int[]{564, 554}, new int[]{1, 5})));
        Spells.add(new SpellInfo("Iban Blast", 53, new SpellCost(new int[]{1409, 560, 554}, new int[]{1, 1, 5})));
        Spells.add(new SpellInfo("Snare", 320, new SpellCost(new int[]{561, 555, 557}, new int[]{3, 4, 4})));
        Spells.add(new SpellInfo("Magic Dart", 324, new SpellCost(new int[]{4170, 560, 558}, new int[]{1, 1, 4})));
        Spells.add(new SpellInfo("Ardougne Teleport", 54, new SpellCost(new int[]{563, 555}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Earth Blast", 40, new SpellCost(new int[]{560, 557, 556}, new int[]{1, 4, 3})));
        Spells.add(new SpellInfo("High Level Alchemy", 41, new SpellCost(new int[]{561, 554}, new int[]{1, 5})));
        Spells.add(new SpellInfo("Charge Water Orb", 42, new SpellCost(new int[]{564, 555, 567}, new int[]{3, 30, 1})));
        Spells.add(new SpellInfo("Lvl-4 Enchant", 43, new SpellCost(new int[]{564, 557}, new int[]{1, 10})));
        Spells.add(new SpellInfo("Watchtower Teleport", 55, new SpellCost(new int[]{563, 557}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Fire Blast", 44, new SpellCost(new int[]{560, 554, 556}, new int[]{1, 5, 4})));
        Spells.add(new SpellInfo("Charge Earth Orb", 45, new SpellCost(new int[]{564, 557, 567}, new int[]{3, 30, 1})));
        Spells.add(new SpellInfo("Bones to Peaches", 354, new SpellCost(new int[]{561, 555, 557}, new int[]{2, 4, 4})));
        Spells.add(new SpellInfo("Saradomin Strike", 61, new SpellCost(new int[]{2415, 565, 556, 554}, new int[]{1, 2, 4, 2})));
        Spells.add(new SpellInfo("Claws of Guthix", 60, new SpellCost(new int[]{2416, 565, 556, 554}, new int[]{1, 2, 4, 1})));
        Spells.add(new SpellInfo("Flames of Zamorak", 59, new SpellCost(new int[]{2417, 565, 556, 554}, new int[]{1, 2, 1, 4})));
        Spells.add(new SpellInfo("Trollheim Teleport", 323, new SpellCost(new int[]{563, 554}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Wind Wave", 46, new SpellCost(new int[]{565, 556}, new int[]{1, 5})));
        Spells.add(new SpellInfo("Charge Fire Orb", 47, new SpellCost(new int[]{564, 554, 567}, new int[]{3, 30, 1})));
        Spells.add(new SpellInfo("Ape Atoll Teleport", 1263, new SpellCost(new int[]{563, 555, 554, 1963}, new int[]{2, 2, 2, 1})));
        Spells.add(new SpellInfo("Water Wave", 48, new SpellCost(new int[]{565, 555, 556}, new int[]{1, 7, 5})));
        Spells.add(new SpellInfo("Charge Air Orb", 49, new SpellCost(new int[]{564, 556, 567}, new int[]{3, 30, 1})));
        Spells.add(new SpellInfo("Vulnerability", 56, new SpellCost(new int[]{566, 555, 557}, new int[]{1, 5, 5})));
        Spells.add(new SpellInfo("Lvl-5 Enchant", 50, new SpellCost(new int[]{564, 555, 557}, new int[]{1, 15, 15})));
        Spells.add(new SpellInfo("Kourend Castle Teleport", 360, new SpellCost(new int[]{563, 566, 555, 554}, new int[]{2, 2, 4, 5})));
        Spells.add(new SpellInfo("Earth Wave", 51, new SpellCost(new int[]{565, 557, 556}, new int[]{1, 7, 5})));
        Spells.add(new SpellInfo("Enfeeble", 57, new SpellCost(new int[]{566, 555, 557}, new int[]{1, 8, 8})));
        Spells.add(new SpellInfo("Teleother Lumbridge", 349, new SpellCost(new int[]{563, 566, 557}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Fire Wave", 52, new SpellCost(new int[]{565, 554, 556}, new int[]{1, 7, 5})));
        Spells.add(new SpellInfo("Entangle", 321, new SpellCost(new int[]{561, 555, 557}, new int[]{4, 5, 5})));
        Spells.add(new SpellInfo("Stun", 58, new SpellCost(new int[]{566, 555, 557}, new int[]{1, 12, 12})));
        Spells.add(new SpellInfo("Charge", 322, new SpellCost(new int[]{565, 556, 554}, new int[]{3, 3, 3})));
        Spells.add(new SpellInfo("Wind Surge", 362, new SpellCost(new int[]{21880, 556}, new int[]{1, 7})));
        Spells.add(new SpellInfo("Teleother Falador", 350, new SpellCost(new int[]{563, 566, 555}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Water Surge", 363, new SpellCost(new int[]{21880, 555, 556}, new int[]{1, 10, 7})));
        Spells.add(new SpellInfo("Tele Block", 352, new SpellCost(new int[]{563, 560, 562}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Teleport to Target", 359, new SpellCost(new int[]{563, 560, 562}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Lvl-6 Enchant", 353, new SpellCost(new int[]{564, 557, 554}, new int[]{1, 20, 20})));
        Spells.add(new SpellInfo("Teleother Camelot", 351, new SpellCost(new int[]{563, 566}, new int[]{1, 2})));
        Spells.add(new SpellInfo("Earth Surge", 364, new SpellCost(new int[]{21880, 557, 556}, new int[]{1, 10, 7})));
        Spells.add(new SpellInfo("Lvl-7 Enchant", 361, new SpellCost(new int[]{564, 566, 565}, new int[]{1, 20, 20})));
        Spells.add(new SpellInfo("Fire Surge", 365, new SpellCost(new int[]{21880, 554, 556}, new int[]{1, 10, 7})));
        Spells.add(new SpellInfo("Smoke Rush", 329, new SpellCost(new int[]{560, 562, 556, 554}, new int[]{2, 2, 1, 1})));
        Spells.add(new SpellInfo("Shadow Rush", 337, new SpellCost(new int[]{560, 562, 566, 556}, new int[]{2, 2, 1, 1})));
        Spells.add(new SpellInfo("Paddewwa Teleport", 341, new SpellCost(new int[]{563, 556, 554}, new int[]{2, 1, 1})));
        Spells.add(new SpellInfo("Blood Rush", 333, new SpellCost(new int[]{560, 562, 565}, new int[]{2, 2, 1})));
        Spells.add(new SpellInfo("Ice Rush", 325, new SpellCost(new int[]{560, 562, 555}, new int[]{2, 2, 2})));
        Spells.add(new SpellInfo("Senntisten Teleport", 342, new SpellCost(new int[]{563, 566}, new int[]{2, 1})));
        Spells.add(new SpellInfo("Smoke Burst", 330, new SpellCost(new int[]{560, 562, 556, 554}, new int[]{2, 4, 2, 2})));
        Spells.add(new SpellInfo("Shadow Burst", 338, new SpellCost(new int[]{560, 562, 566, 556}, new int[]{2, 4, 2, 1})));
        Spells.add(new SpellInfo("Kharyrll Teleport", 343, new SpellCost(new int[]{563, 565}, new int[]{2, 1})));
        Spells.add(new SpellInfo("Blood Burst", 334, new SpellCost(new int[]{560, 562, 565}, new int[]{2, 4, 2})));
        Spells.add(new SpellInfo("Ice Burst", 326, new SpellCost(new int[]{560, 562, 555}, new int[]{2, 4, 4})));
        Spells.add(new SpellInfo("Lassar Teleport", 344, new SpellCost(new int[]{563, 555}, new int[]{2, 4})));
        Spells.add(new SpellInfo("Smoke Blitz", 331, new SpellCost(new int[]{560, 565, 556, 554}, new int[]{2, 2, 2, 2})));
        Spells.add(new SpellInfo("Shadow Blitz", 339, new SpellCost(new int[]{560, 565, 566, 556}, new int[]{2, 2, 2, 2})));
        Spells.add(new SpellInfo("Dareeyak Teleport", 345, new SpellCost(new int[]{563, 556, 554}, new int[]{2, 2, 3})));
        Spells.add(new SpellInfo("Blood Blitz", 335, new SpellCost(new int[]{560, 565}, new int[]{2, 4})));
        Spells.add(new SpellInfo("Ice Blitz", 327, new SpellCost(new int[]{560, 565, 555}, new int[]{2, 2, 3})));
        Spells.add(new SpellInfo("Carrallangar Teleport", 346, new SpellCost(new int[]{563, 566}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Teleport to Target", 359, new SpellCost(new int[]{563, 560, 562}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Smoke Barrage", 332, new SpellCost(new int[]{560, 565, 556, 554}, new int[]{4, 2, 4, 4})));
        Spells.add(new SpellInfo("Shadow Barrage", 340, new SpellCost(new int[]{560, 565, 566, 556}, new int[]{4, 2, 3, 4})));
        Spells.add(new SpellInfo("Annakarl Teleport", 347, new SpellCost(new int[]{563, 565}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Blood Barrage", 336, new SpellCost(new int[]{560, 565, 566}, new int[]{4, 4, 1})));
        Spells.add(new SpellInfo("Ice Barrage", 328, new SpellCost(new int[]{560, 565, 555}, new int[]{4, 2, 6})));
        Spells.add(new SpellInfo("Ghorrock Teleport", 348, new SpellCost(new int[]{563, 555}, new int[]{2, 8})));
        Spells.add(new SpellInfo("Edgeville Teleport", 341, new SpellCost(new int[]{563, 556, 554}, new int[]{2, 1, 1})));
        Spells.add(new SpellInfo("Digsite Teleport", 342, new SpellCost(new int[]{563, 566}, new int[]{2, 1})));
        Spells.add(new SpellInfo("Canifis Teleport", 343, new SpellCost(new int[]{563, 565}, new int[]{2, 1})));
        Spells.add(new SpellInfo("Ice Mountain Teleport", 344, new SpellCost(new int[]{563, 555}, new int[]{2, 4})));
        Spells.add(new SpellInfo("Forgotten Cemetery Teleport", 345, new SpellCost(new int[]{563, 556, 554}, new int[]{2, 2, 3})));
        Spells.add(new SpellInfo("Graveyard of Shadows Teleport", 346, new SpellCost(new int[]{563, 566}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Demonic Ruins Teleport", 347, new SpellCost(new int[]{563, 565}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Frozen Waste Plateau Teleport", 348, new SpellCost(new int[]{563, 555}, new int[]{2, 8})));
        Spells.add(new SpellInfo("Bake Pie", 543, new SpellCost(new int[]{9075, 555, 554}, new int[]{1, 4, 5})));
        Spells.add(new SpellInfo("Geomancy", 563, new SpellCost(new int[]{9075, 561, 557}, new int[]{3, 3, 8})));
        Spells.add(new SpellInfo("Cure Plant", 567, new SpellCost(new int[]{9075, 557}, new int[]{1, 8})));
        Spells.add(new SpellInfo("Monster Examine", 577, new SpellCost(new int[]{9075, 564, 558}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("NPC Contact", 568, new SpellCost(new int[]{9075, 564, 556}, new int[]{1, 1, 2})));
        Spells.add(new SpellInfo("Cure Other", 559, new SpellCost(new int[]{9075, 563, 557}, new int[]{1, 1, 10})));
        Spells.add(new SpellInfo("Humidify", 578, new SpellCost(new int[]{9075, 555, 554}, new int[]{1, 3, 1})));
        Spells.add(new SpellInfo("Moonclan Teleport", 544, new SpellCost(new int[]{563, 9075, 557}, new int[]{1, 2, 2})));
        Spells.add(new SpellInfo("Tele Group Moonclan", 569, new SpellCost(new int[]{563, 9075, 557}, new int[]{1, 2, 4})));
        Spells.add(new SpellInfo("Cure Me", 562, new SpellCost(new int[]{9075, 564, 563}, new int[]{2, 2, 1})));
        Spells.add(new SpellInfo("Ourania Teleport", 586, new SpellCost(new int[]{563, 9075, 557}, new int[]{1, 2, 6})));
        Spells.add(new SpellInfo("Hunter Kit", 579, new SpellCost(new int[]{9075, 557}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Waterbirth Teleport", 545, new SpellCost(new int[]{563, 9075, 555}, new int[]{1, 2, 1})));
        Spells.add(new SpellInfo("Tele Group Waterbirth", 570, new SpellCost(new int[]{563, 9075, 555}, new int[]{1, 2, 5})));
        Spells.add(new SpellInfo("Cure Group", 565, new SpellCost(new int[]{9075, 564, 563}, new int[]{2, 2, 2})));
        Spells.add(new SpellInfo("Stat Spy", 576, new SpellCost(new int[]{9075, 564, 559}, new int[]{2, 2, 5})));
        Spells.add(new SpellInfo("Barbarian Teleport", 547, new SpellCost(new int[]{563, 9075, 554}, new int[]{2, 2, 3})));
        Spells.add(new SpellInfo("Tele Group Barbarian", 571, new SpellCost(new int[]{563, 9075, 554}, new int[]{2, 2, 6})));
        Spells.add(new SpellInfo("Spin Flax", 585, new SpellCost(new int[]{9075, 561, 556}, new int[]{1, 2, 5})));
        Spells.add(new SpellInfo("Superglass Make", 548, new SpellCost(new int[]{9075, 554, 556}, new int[]{2, 6, 10})));
        Spells.add(new SpellInfo("Tan Leather", 583, new SpellCost(new int[]{554, 9075, 561}, new int[]{5, 2, 1})));
        Spells.add(new SpellInfo("Khazard Teleport", 549, new SpellCost(new int[]{563, 9075, 555}, new int[]{2, 2, 4})));
        Spells.add(new SpellInfo("Tele Group Khazard", 572, new SpellCost(new int[]{563, 9075, 555}, new int[]{2, 2, 8})));
        Spells.add(new SpellInfo("Dream", 580, new SpellCost(new int[]{9075, 564, 559}, new int[]{2, 1, 5})));
        Spells.add(new SpellInfo("String Jewellery", 550, new SpellCost(new int[]{9075, 555, 557}, new int[]{2, 5, 10})));
        Spells.add(new SpellInfo("Stat Restore Pot Share", 554, new SpellCost(new int[]{9075, 555, 557}, new int[]{2, 10, 10})));
        Spells.add(new SpellInfo("Magic Imbue", 552, new SpellCost(new int[]{9075, 555, 554}, new int[]{2, 7, 7})));
        Spells.add(new SpellInfo("Fertile Soil", 553, new SpellCost(new int[]{9075, 561, 557}, new int[]{3, 2, 15})));
        Spells.add(new SpellInfo("Boost Potion Share", 551, new SpellCost(new int[]{9075, 555, 557}, new int[]{3, 10, 12})));
        Spells.add(new SpellInfo("Fishing Guild Teleport", 555, new SpellCost(new int[]{563, 9075, 555}, new int[]{3, 3, 10})));
        Spells.add(new SpellInfo("Teleport to Target", 359, new SpellCost(new int[]{563, 560, 562}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Tele Group Fishing Guild", 573, new SpellCost(new int[]{563, 9075, 555}, new int[]{3, 3, 14})));
        Spells.add(new SpellInfo("Plank Make", 581, new SpellCost(new int[]{9075, 561, 557}, new int[]{2, 1, 15})));
        Spells.add(new SpellInfo("Catherby Teleport", 556, new SpellCost(new int[]{563, 9075, 555}, new int[]{3, 3, 10})));
        Spells.add(new SpellInfo("Tele Group Catherby", 574, new SpellCost(new int[]{563, 9075, 555}, new int[]{3, 3, 15})));
        Spells.add(new SpellInfo("Recharge Dragonstone", 584, new SpellCost(new int[]{555, 9075, 566}, new int[]{4, 1, 1})));
        Spells.add(new SpellInfo("Ice Plateau Teleport", 557, new SpellCost(new int[]{563, 9075, 555}, new int[]{3, 3, 8})));
        Spells.add(new SpellInfo("Tele Group Ice Plateau", 575, new SpellCost(new int[]{563, 9075, 555}, new int[]{3, 3, 16})));
        Spells.add(new SpellInfo("Energy Transfer", 558, new SpellCost(new int[]{9075, 563, 561}, new int[]{3, 2, 1})));
        Spells.add(new SpellInfo("Heal Other", 560, new SpellCost(new int[]{9075, 563, 565}, new int[]{3, 3, 1})));
        Spells.add(new SpellInfo("Vengeance Other", 561, new SpellCost(new int[]{9075, 560, 557}, new int[]{3, 2, 10})));
        Spells.add(new SpellInfo("Vengeance", 564, new SpellCost(new int[]{9075, 560, 557}, new int[]{4, 2, 10})));
        Spells.add(new SpellInfo("Heal Group", 566, new SpellCost(new int[]{9075, 563, 565}, new int[]{4, 6, 3})));
        Spells.add(new SpellInfo("Spellbook Swap", 582, new SpellCost(new int[]{9075, 564, 563}, new int[]{3, 2, 1})));
        Spells.add(new SpellInfo("Arceuus Library Teleport", 1252, new SpellCost(new int[]{563, 557}, new int[]{1, 2})));
        Spells.add(new SpellInfo("Basic Reanimation", 1247, new SpellCost(new int[]{559, 561}, new int[]{4, 2})));
        Spells.add(new SpellInfo("Draynor Manor Teleport", 1253, new SpellCost(new int[]{563, 555, 557}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Battlefront Teleport", 1255, new SpellCost(new int[]{563, 557, 554}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Mind Altar Teleport", 1256, new SpellCost(new int[]{563, 558}, new int[]{1, 2})));
        Spells.add(new SpellInfo("Respawn Teleport", 1257, new SpellCost(new int[]{563, 566}, new int[]{1, 1})));
        Spells.add(new SpellInfo("Ghostly Grasp", 1267, new SpellCost(new int[]{562, 556}, new int[]{1, 4})));
        Spells.add(new SpellInfo("Resurrect Lesser Ghost", 1270, new SpellCost(new int[]{558, 556, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Resurrect Lesser Skeleton", 1271, new SpellCost(new int[]{558, 556, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Resurrect Lesser Zombie", 1300, new SpellCost(new int[]{558, 556, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Salve Graveyard Teleport", 1254, new SpellCost(new int[]{563, 566}, new int[]{1, 2})));
        Spells.add(new SpellInfo("Adept Reanimation", 1248, new SpellCost(new int[]{559, 561, 566}, new int[]{4, 3, 1})));
        Spells.add(new SpellInfo("Inferior Demonbane", 1302, new SpellCost(new int[]{562, 554}, new int[]{1, 4})));
        Spells.add(new SpellInfo("Shadow Veil", 1315, new SpellCost(new int[]{557, 554, 564}, new int[]{5, 5, 5})));
        Spells.add(new SpellInfo("Fenkenstrain's Castle Teleport", 1259, new SpellCost(new int[]{563, 566, 557}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Dark Lure", 1316, new SpellCost(new int[]{560, 561}, new int[]{1, 1})));
        Spells.add(new SpellInfo("Skeletal Grasp", 1268, new SpellCost(new int[]{560, 557}, new int[]{1, 8})));
        Spells.add(new SpellInfo("Resurrect Superior Ghost", 2979, new SpellCost(new int[]{560, 557, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Resurrect Superior Skeleton", 2981, new SpellCost(new int[]{560, 557, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Resurrect Superior Zombie", 2983, new SpellCost(new int[]{560, 557, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Mark of Darkness", 1305, new SpellCost(new int[]{566, 564}, new int[]{1, 1})));
        Spells.add(new SpellInfo("West Ardougne Teleport", 1260, new SpellCost(new int[]{563, 566}, new int[]{2, 2})));
        Spells.add(new SpellInfo("Superior Demonbane", 1303, new SpellCost(new int[]{566, 554}, new int[]{1, 8})));
        Spells.add(new SpellInfo("Lesser Corruption", 1307, new SpellCost(new int[]{560, 566}, new int[]{1, 2})));
        Spells.add(new SpellInfo("Harmony Island Teleport", 1261, new SpellCost(new int[]{563, 566, 561}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Vile Vigour", 1317, new SpellCost(new int[]{566, 556}, new int[]{1, 3})));
        Spells.add(new SpellInfo("Degrime", 1318, new SpellCost(new int[]{557, 561}, new int[]{4, 2})));
        Spells.add(new SpellInfo("Cemetery Teleport", 1264, new SpellCost(new int[]{563, 566, 565}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Expert Reanimation", 1249, new SpellCost(new int[]{565, 561, 566}, new int[]{1, 3, 2})));
        Spells.add(new SpellInfo("Ward of Arceuus", 1306, new SpellCost(new int[]{566, 561, 564}, new int[]{4, 2, 1})));
        Spells.add(new SpellInfo("Resurrect Greater Ghost", 2980, new SpellCost(new int[]{565, 554, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Resurrect Greater Skeleton", 2982, new SpellCost(new int[]{565, 554, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Resurrect Greater Zombie", 2984, new SpellCost(new int[]{565, 554, 564}, new int[]{5, 10, 1})));
        Spells.add(new SpellInfo("Resurrect Crops", 1266, new SpellCost(new int[]{566, 561, 565, 557}, new int[]{8, 12, 8, 25})));
        Spells.add(new SpellInfo("Undead Grasp", 1269, new SpellCost(new int[]{565, 554}, new int[]{1, 12})));
        Spells.add(new SpellInfo("Death Charge", 1310, new SpellCost(new int[]{560, 565, 566}, new int[]{1, 1, 1})));
        Spells.add(new SpellInfo("Dark Demonbane", 1304, new SpellCost(new int[]{566, 554}, new int[]{2, 12})));
        Spells.add(new SpellInfo("Barrows Teleport", 1262, new SpellCost(new int[]{563, 566, 565}, new int[]{2, 2, 1})));
        Spells.add(new SpellInfo("Demonic Offering", 1311, new SpellCost(new int[]{566, 21880}, new int[]{1, 1})));
        Spells.add(new SpellInfo("Greater Corruption", 1308, new SpellCost(new int[]{565, 566}, new int[]{1, 3})));
        Spells.add(new SpellInfo("Master Reanimation", 1250, new SpellCost(new int[]{565, 561, 566}, new int[]{2, 4, 4})));
        Spells.add(new SpellInfo("Ape Atoll Teleport", 1263, new SpellCost(new int[]{563, 566, 565}, new int[]{2, 2, 2})));
        Spells.add(new SpellInfo("Sinister Offering", 1312, new SpellCost(new int[]{565, 21880}, new int[]{1, 1})));
        ArrayList spriteIgnore = new ArrayList();
        Spells.forEach(s -> {
            SpellCost cost = s.getSpellCost();
            int spriteId = s.getSpriteId();
            String name = s.getName();
            if (s.getSpellProducts() != null) {
                SpellProduct[] products;
                for (SpellProduct p : products = s.getSpellProducts()) {
                    SpellProductMap.put(p, (SpellInfo)s);
                }
            }
            if (!spriteIgnore.contains(spriteId)) {
                if (!SpellSpriteMap.containsKey(spriteId)) {
                    SpellSpriteMap.put(spriteId, (SpellInfo)s);
                } else {
                    SpellSpriteMap.remove(spriteId);
                    spriteIgnore.add(spriteId);
                }
            }
            if (!SpellNameMap.containsKey(name)) {
                SpellNameMap.put(name.toLowerCase(), (SpellInfo)s);
            }
        });
    }
}

