/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts;

import com.salverrs.RemainingCasts.CastSuppliesTracker;
import com.salverrs.RemainingCasts.Model.SpellCost;
import com.salverrs.RemainingCasts.Model.SpellInfo;
import com.salverrs.RemainingCasts.Model.TooltipDetails;
import com.salverrs.RemainingCasts.RemainingCastsConfig;
import com.salverrs.RemainingCasts.Util.CastUtils;
import com.salverrs.RemainingCasts.Util.SpellIds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.util.Text;

@Singleton
public class TooltipCastUpdater {
    private int mageBookTooltipWidgetId = -1;
    private int autocastTooltipWidgetId = -1;
    private boolean active = false;
    private ArrayList<String> pinnedSpellNames;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private CastSuppliesTracker castSuppliesTracker;
    @Inject
    RemainingCastsConfig config;

    public void start() {
        this.active = true;
        this.pinnedSpellNames = new ArrayList(Text.fromCSV((String)this.config.pinnedSpells()));
    }

    public void stop() {
        this.active = false;
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (!this.active || !this.config.enableMenuTooltip() && !this.config.enableInfoboxes() || this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>(Arrays.asList(this.client.getMenuEntries()));
        boolean appendToOption = false;
        SpellInfo spellInfoFound = null;
        String formattedSpellInfoName = null;
        if (entries.stream().anyMatch(e -> e.getOption().equals("Examine"))) {
            return;
        }
        for (MenuEntry entry : entries) {
            Widget widget = entry.getWidget();
            if (widget == null) continue;
            if (entry.getOption().equals("Choose spell")) {
                int spriteId;
                SpellInfo spellInfo;
                Widget spellIcon = this.client.getWidget(WidgetInfo.COMBAT_SPELL_ICON);
                if (spellIcon == null || (spellInfo = SpellIds.getSpellBySpriteId(spriteId = spellIcon.getSpriteId())) == null) continue;
                spellInfoFound = spellInfo;
                formattedSpellInfoName = spellInfo.getName();
                if (!this.config.enableMenuTooltip()) continue;
                Map<Integer, Integer> runeCount = this.castSuppliesTracker.getLastRuneCount();
                int numCasts = spellInfo.getSpellCost().getRemainingCasts(runeCount);
                String casts = "(" + this.getRemainingCastsString(numCasts) + ")";
                entry.setOption(spellInfo.getName() + " " + casts);
                continue;
            }
            String spellName = Text.removeFormattingTags((String)widget.getName());
            SpellInfo spellInfo = SpellIds.getSpellByName(spellName);
            if (spellInfo == null) {
                spellName = Text.removeFormattingTags((String)entry.getOption());
                spellInfo = SpellIds.getSpellByName(spellName);
                formattedSpellInfoName = entry.getOption();
                appendToOption = true;
            } else {
                formattedSpellInfoName = entry.getTarget();
            }
            if (spellInfo == null) continue;
            spellInfoFound = spellInfo;
            if (!this.config.enableMenuTooltip() || entry.getOption().equals("Configure") || entry.getOption().equals("Warnings")) continue;
            Map<Integer, Integer> runeCount = this.castSuppliesTracker.getLastRuneCount();
            int numCasts = spellInfo.getSpellCost().getRemainingCasts(runeCount);
            String casts = "(" + this.getRemainingCastsString(numCasts) + ")";
            if (appendToOption) {
                String option = entry.getOption();
                if (option.endsWith(casts)) continue;
                entry.setOption(option + " " + casts);
                continue;
            }
            String target = entry.getTarget();
            if (target.endsWith(casts)) continue;
            entry.setTarget(target + " " + casts);
        }
        if (spellInfoFound == null || !this.config.enableInfoboxes()) {
            return;
        }
        SpellInfo target = spellInfoFound;
        boolean isPinned = Text.fromCSV((String)this.config.pinnedSpells()).stream().anyMatch(s -> s.equalsIgnoreCase(target.getName()));
        this.client.createMenuEntry(-1).setOption(isPinned ? "Unpin" : "Pin").setTarget(formattedSpellInfoName).setType(MenuAction.RUNELITE).onClick(isPinned ? this.unpinSpell(target) : this.pinSpell(target));
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        int tooltipWidgetArgIndex;
        boolean isAutocastTooltip;
        if (!this.active || !this.config.enableSpellTooltip()) {
            return;
        }
        boolean isMageBookTooltip = event.getScriptId() == 2622;
        boolean bl = isAutocastTooltip = event.getScriptId() == 238;
        if (!isMageBookTooltip && !isAutocastTooltip) {
            return;
        }
        ScriptEvent scriptEvent = event.getScriptEvent();
        Object[] args = scriptEvent.getArguments();
        int n = tooltipWidgetArgIndex = isMageBookTooltip ? 5 : 1;
        if (isMageBookTooltip) {
            this.mageBookTooltipWidgetId = (Integer)args[tooltipWidgetArgIndex];
        } else if (isAutocastTooltip) {
            this.autocastTooltipWidgetId = (Integer)args[tooltipWidgetArgIndex];
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (!this.active || !this.config.enableSpellTooltip()) {
            return;
        }
        int scriptId = event.getScriptId();
        if (scriptId != 2622 && scriptId != 238) {
            return;
        }
        int widgetId = scriptId == 2622 ? this.mageBookTooltipWidgetId : this.autocastTooltipWidgetId;
        this.clientThread.invoke(() -> {
            Widget widget = this.client.getWidget(widgetId);
            if (widget == null) {
                return;
            }
            Widget[] children = widget.getChildren();
            if (children == null || children.length == 0) {
                return;
            }
            Widget spellTitle = this.getTitleWidget(children);
            if (spellTitle == null) {
                return;
            }
            TooltipDetails details = this.getSpellTooltipDetails(spellTitle);
            if (details == null) {
                return;
            }
            if (details.getSpellName().contains("Home Teleport")) {
                String newText = "[" + details.getSpellLevel() + "] " + details.getSpellName();
                spellTitle.setText(newText);
                return;
            }
            SpellInfo spellInfo = SpellIds.getSpellByName(details.getSpellName());
            if (spellInfo == null) {
                spellInfo = SpellIds.getSpellByName(details.getSpellName().concat(" Teleport"));
            }
            if (spellInfo == null) {
                return;
            }
            SpellCost spellCost = spellInfo.getSpellCost();
            int numCasts = spellCost.getRemainingCasts(this.castSuppliesTracker.getLastRuneCount());
            String newText = "[" + details.getSpellLevel() + "] " + details.getSpellName();
            newText = newText + " (" + this.getRemainingCastsString(numCasts) + ")";
            spellTitle.setText(newText);
        });
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("RemainingCasts")) {
            return;
        }
        this.pinnedSpellNames = new ArrayList(Text.fromCSV((String)this.config.pinnedSpells()));
    }

    private Widget getTitleWidget(Widget[] tooltipChildren) {
        return Arrays.stream(tooltipChildren).filter(c -> c.getText().contains("Level")).findFirst().orElse(null);
    }

    private TooltipDetails getSpellTooltipDetails(Widget titleWidget) {
        String titleText = titleWidget.getText();
        String[] split = titleText.split(": ");
        if (split.length < 2) {
            return null;
        }
        String name = split[1];
        String[] levelSplit = split[0].split("Level ");
        if (levelSplit.length < 2) {
            return null;
        }
        String level = levelSplit[1];
        return new TooltipDetails(name, level);
    }

    private String getRemainingCastsString(int numCasts) {
        if (numCasts == -1) {
            return "N/A";
        }
        return this.config.shortenCastAmounts() ? CastUtils.getShortenedAmount(numCasts) : CastUtils.formatCastAmount(numCasts);
    }

    private Consumer<MenuEntry> pinSpell(SpellInfo spellInfo) {
        return e -> {
            this.pinnedSpellNames.add(spellInfo.getName());
            this.config.setPinnedSpells(Text.toCSV(this.pinnedSpellNames));
        };
    }

    private Consumer<MenuEntry> unpinSpell(SpellInfo spellInfo) {
        return e -> {
            this.pinnedSpellNames.removeIf(s -> s.equalsIgnoreCase(spellInfo.getName()));
            this.config.setPinnedSpells(Text.toCSV(this.pinnedSpellNames));
        };
    }
}

