/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts;

import com.google.inject.Provides;
import com.salverrs.RemainingCasts.CastSuppliesTracker;
import com.salverrs.RemainingCasts.RemainingCastTracker;
import com.salverrs.RemainingCasts.RemainingCastsConfig;
import com.salverrs.RemainingCasts.TooltipCastUpdater;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Remaining Casts", description="Displays the number of casts remaining for your spells.", tags={"remaining", "casts", "magic", "spell", "rune", "tracker"})
public class RemainingCastsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RemainingCastsPlugin.class);
    public static final String CONFIG_GROUP = "RemainingCasts";
    @Inject
    private RemainingCastsConfig config;
    @Inject
    private EventBus eventBus;
    @Inject
    private CastSuppliesTracker castSuppliesTracker;
    @Inject
    private RemainingCastTracker castTracker;
    @Inject
    private TooltipCastUpdater tooltipUpdater;

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this.castSuppliesTracker);
        this.eventBus.register((Object)this.castTracker);
        this.eventBus.register((Object)this.tooltipUpdater);
        this.castSuppliesTracker.start();
        this.castTracker.start(this);
        this.tooltipUpdater.start();
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this.castSuppliesTracker);
        this.eventBus.unregister((Object)this.castTracker);
        this.eventBus.unregister((Object)this.tooltipUpdater);
        this.castSuppliesTracker.stop();
        this.castTracker.stop();
        this.tooltipUpdater.stop();
    }

    @Provides
    RemainingCastsConfig provideConfig(ConfigManager configManager) {
        return (RemainingCastsConfig)configManager.getConfig(RemainingCastsConfig.class);
    }
}

