/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts;

import com.salverrs.RemainingCasts.Model.SpellFilterOption;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Units;

@ConfigGroup(value="RemainingCasts")
public interface RemainingCastsConfig
extends Config {
    @ConfigSection(name="General", description="Enable/disable Remaining Casts features", position=0)
    public static final String generalSection = "general";
    @ConfigSection(name="Infoboxes", description="Options relating to remaining casts infoboxes", position=1)
    public static final String infoboxSection = "infoboxes";
    @ConfigSection(name="Chat warnings", description="Options relating to remaining casts chat warnings", position=2)
    public static final String warningsSection = "warnings";

    @ConfigItem(keyName="enableInfoboxes", name="Show infoboxes", description="Show remaining casts as individual info boxes", section="general", position=0)
    default public boolean enableInfoboxes() {
        return true;
    }

    @ConfigItem(keyName="enableMenuTooltip", name="Show on menu tooltip", description="Show remaining casts on the menu action tooltip", section="general", position=1)
    default public boolean enableMenuTooltip() {
        return true;
    }

    @ConfigItem(keyName="enableSpellTooltip", name="Show on spell tooltip", description="Show remaining casts on the detailed spell tooltip", section="general", position=2)
    default public boolean enableSpellTooltip() {
        return true;
    }

    @ConfigItem(keyName="enableChatWarnings", name="Show chat warnings", description="Show chat warnings when remaining casts reach a predefined amount", section="general", position=3)
    default public boolean useChatWarnings() {
        return true;
    }

    @ConfigItem(keyName="shortenCastAmounts", name="Shorten cast amounts", description="Shorten remaining cast amounts (e.g. 2512 -> 2.5k)", section="general", position=4)
    default public boolean shortenCastAmounts() {
        return true;
    }

    @Units(value="s")
    @ConfigItem(keyName="infoBoxExpirySeconds", name="Infobox expiry", description="The number of seconds until an infobox will expire - 0 represents no expiry", section="infoboxes", position=5)
    default public int infoBoxExpirySeconds() {
        return 15;
    }

    @ConfigItem(keyName="infoBoxSpellLimit", name="Maximum spells", description="The maximum number of spells to track remaining casts for - 0 represents no limit", section="infoboxes", position=6)
    default public int infoBoxSpellLimit() {
        return 0;
    }

    @ConfigItem(keyName="infoBoxThreshold", name="Cast threshold", description="Only show when casts remaining is less than the threshold - 0 represents no threshold", section="infoboxes", position=7)
    default public int infoBoxThreshold() {
        return 0;
    }

    @ConfigItem(keyName="showDetailedTooltip", name="Show cost in tooltip", description="Show the spell's rune cost within the infobox tooltip", section="infoboxes", position=8)
    default public boolean showDetailedTooltip() {
        return true;
    }

    @ConfigItem(keyName="showInfoBoxSprites", name="Show spell sprites", description="Show the sprite image for the spell on the infobox", section="infoboxes", position=9)
    default public boolean showInfoBoxSprites() {
        return true;
    }

    @ConfigItem(keyName="spellFilterOption", name="Spell filter", description="Enable or disable whitelist/blacklist for spells", section="infoboxes", position=10)
    default public SpellFilterOption spellFilterOption() {
        return SpellFilterOption.DISABLED;
    }

    @ConfigItem(keyName="filterList", name="Filter list", description="The names of the spells you wish to whitelist/blacklist as comma separated values", section="infoboxes", position=11)
    default public String filterList() {
        return "";
    }

    @ConfigItem(keyName="pinnedSpells", name="Pinned spells", description="The names of the spells that should always display an infobox which never expires", section="infoboxes", position=12)
    default public String pinnedSpells() {
        return "";
    }

    @ConfigItem(keyName="pinnedSpells", name="", description="")
    public void setPinnedSpells(String var1);

    @ConfigItem(keyName="infoBoxTextColor", name="Text color", description="The color of the text displayed in the infobox", section="infoboxes", position=13)
    default public Color infoBoxTextColor() {
        return Color.white;
    }

    @ConfigItem(keyName="chatWarningNotification", name="Enable notifications", description="Enable Runelite notification alongside the chat warning", section="warnings", position=14)
    default public boolean useChatWarningNotifications() {
        return true;
    }

    @ConfigItem(keyName="chatWarningThresholds", name="Chat warning thresholds", description="The cast amounts at which a chat warning will be triggered", section="warnings", position=15)
    default public String chatWarningThresholds() {
        return "0, 10, 50, 100, 500";
    }

    @ConfigItem(keyName="chatWarningColor", name="Text color", description="The color of the text displayed in the chat warning", section="warnings", position=16)
    default public Color chatWarningColor() {
        return Color.orange;
    }
}

