/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts;

import com.salverrs.RemainingCasts.CastSuppliesTracker;
import com.salverrs.RemainingCasts.Events.BoltsEnchanted;
import com.salverrs.RemainingCasts.Events.RunesChanged;
import com.salverrs.RemainingCasts.Infobox.RemainingCastsInfoBox;
import com.salverrs.RemainingCasts.Model.RuneChanges;
import com.salverrs.RemainingCasts.Model.SpellFilterOption;
import com.salverrs.RemainingCasts.Model.SpellInfo;
import com.salverrs.RemainingCasts.RemainingCastsConfig;
import com.salverrs.RemainingCasts.Util.SpellIds;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;

@Singleton
public class RemainingCastTracker {
    private Map<SpellInfo, RemainingCastsInfoBox> castBoxes = new HashMap<SpellInfo, RemainingCastsInfoBox>();
    private Queue<SpellInfo> spellQueue = new LinkedList<SpellInfo>();
    private Map<Integer, Integer> runeCount = new HashMap<Integer, Integer>();
    private boolean active = false;
    private boolean otherItemContainerOpen = false;
    private int lastCastSpriteId = -1;
    private String lastCastSpellName;
    private Plugin plugin;
    private long lastSpellCastTime = 0L;
    private long lastManualCastSpellTime = 0L;
    private long lastManualAttackTime = 0L;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Notifier notifier;
    @Inject
    private ChatMessageManager chatManager;
    @Inject
    private CastSuppliesTracker suppliesTracker;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private RemainingCastsConfig config;

    @Subscribe
    public void onClientTick(ClientTick tick) {
        if (!this.active) {
            return;
        }
        this.checkCastBoxExpiry();
    }

    @Subscribe
    public void onRunesChanged(RunesChanged event) {
        if (!this.active || !this.config.enableInfoboxes() && !this.config.useChatWarnings()) {
            return;
        }
        RuneChanges changes = event.getChanges();
        SpellInfo spellInfo = this.getLastSpellCasted(changes);
        if (this.otherItemContainerOpen || this.client.getGameState() != GameState.LOGGED_IN) {
            spellInfo = null;
        }
        this.runeCount = changes.getCurrentRunes();
        this.lastSpellCastTime = Instant.now().getEpochSecond();
        if (this.config.enableInfoboxes()) {
            this.updateCastBoxes(spellInfo);
        }
        if (this.config.useChatWarnings()) {
            this.updateWarnings(spellInfo);
        }
        if (!this.config.enableInfoboxes() || spellInfo == null || this.isFiltered(spellInfo)) {
            return;
        }
        this.processCast(spellInfo);
    }

    @Subscribe
    public void onBoltsEnchanted(BoltsEnchanted event) {
        if (!this.active || !this.config.enableInfoboxes() && !this.config.useChatWarnings() || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        RuneChanges changes = event.getChanges();
        SpellInfo enchant = event.getEnchantSpell();
        if (!this.matchesSpellInfo(enchant, changes) || this.otherItemContainerOpen) {
            enchant = null;
        }
        this.runeCount = changes.getCurrentRunes();
        if (this.config.enableInfoboxes()) {
            this.updateCastBoxes(enchant);
        }
        if (this.config.useChatWarnings()) {
            this.updateWarnings(enchant);
        }
        if (!this.config.enableInfoboxes() || enchant == null || this.isFiltered(enchant)) {
            return;
        }
        this.processCast(enchant);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String spellName;
        if (!this.active) {
            return;
        }
        MenuEntry entry = event.getMenuEntry();
        String option = entry.getOption();
        String target = entry.getTarget();
        if (option.equals("Attack")) {
            this.lastManualAttackTime = Instant.now().getEpochSecond();
            return;
        }
        if (!option.equals("Cast") && !target.contains("Teleport")) {
            return;
        }
        Widget widget = entry.getWidget();
        String string = spellName = widget != null ? Text.removeFormattingTags((String)widget.getName()) : Text.removeFormattingTags((String)target).replaceAll(" ->.*", "");
        if (SpellIds.getSpellByName(spellName) != null) {
            this.lastCastSpellName = spellName;
        }
        if (widget == null || widget.getTargetVerb().isEmpty()) {
            this.lastManualCastSpellTime = Instant.now().getEpochSecond();
        }
        if (widget == null) {
            return;
        }
        int spriteId = widget.getSpriteId();
        if (SpellIds.getSpellBySpriteId(spriteId) != null) {
            this.lastCastSpriteId = spriteId;
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (this.isOtherItemContainerWidget(event.getGroupId())) {
            this.otherItemContainerOpen = true;
            this.lastCastSpriteId = -1;
            this.lastCastSpellName = null;
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        if (this.isOtherItemContainerWidget(event.getGroupId())) {
            this.otherItemContainerOpen = false;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("RemainingCasts")) {
            return;
        }
        if (configChanged.getKey().equals("enableInfoboxes")) {
            this.stop();
            this.start(this.plugin);
        } else if (this.config.enableInfoboxes()) {
            this.updatePinnedSpells();
        }
    }

    public void start(Plugin plugin) {
        this.active = true;
        this.plugin = plugin;
        if (this.config.enableInfoboxes()) {
            this.updatePinnedSpells();
        }
    }

    public void stop() {
        this.active = false;
        this.lastCastSpriteId = -1;
        this.lastCastSpellName = null;
        this.removeAllCastBoxes();
    }

    private SpellInfo getLastSpellCasted(RuneChanges changes) {
        boolean autoCastFirst = this.wasLastCastAutocast();
        if (autoCastFirst) {
            SpellInfo spellInfo = this.getSpellFromAutocast(changes);
            if (spellInfo != null) {
                return spellInfo;
            }
            spellInfo = this.getSpellFromManualCast(changes);
            if (spellInfo != null) {
                return spellInfo;
            }
        } else {
            SpellInfo spellInfo = this.getSpellFromManualCast(changes);
            if (spellInfo != null) {
                return spellInfo;
            }
            spellInfo = this.getSpellFromAutocast(changes);
            if (spellInfo != null) {
                return spellInfo;
            }
        }
        return null;
    }

    private boolean matchesSpellInfo(SpellInfo info, RuneChanges changes) {
        Map<Integer, Integer> cost = changes.getInvertedChanges();
        return info != null && info.getSpellCost().matchesCost(cost, changes.getUnlimitedRunes());
    }

    private SpellInfo getSpellFromManualCast(RuneChanges changes) {
        SpellInfo spellInfo;
        SpellInfo spellInfo2 = spellInfo = this.lastCastSpellName != null ? SpellIds.getSpellByName(this.lastCastSpellName) : null;
        if (this.matchesSpellInfo(spellInfo, changes)) {
            return spellInfo;
        }
        SpellInfo spellInfo3 = spellInfo = this.lastCastSpriteId != -1 ? SpellIds.getSpellBySpriteId(this.lastCastSpriteId) : null;
        if (this.matchesSpellInfo(spellInfo, changes)) {
            return spellInfo;
        }
        return null;
    }

    private SpellInfo getSpellFromAutocast(RuneChanges changes) {
        Widget w = this.client.getWidget(WidgetInfo.COMBAT_SPELL_ICON);
        if (w == null) {
            return null;
        }
        int spriteId = w.getSpriteId();
        SpellInfo spellInfo = SpellIds.getSpellBySpriteId(spriteId);
        return this.matchesSpellInfo(spellInfo, changes) ? spellInfo : null;
    }

    private boolean wasLastCastAutocast() {
        if (this.lastManualAttackTime > this.lastManualCastSpellTime) {
            return true;
        }
        return this.lastManualCastSpellTime < this.lastSpellCastTime;
    }

    private void updateWarnings(SpellInfo recentCast) {
        if (recentCast == null) {
            return;
        }
        ArrayList thresholds = new ArrayList();
        List thresholdStrings = Text.fromCSV((String)this.config.chatWarningThresholds());
        thresholdStrings.forEach(ts -> thresholds.add(this.tryParseInt((String)ts, -1)));
        Collections.sort(thresholds);
        if (thresholds.size() == 0) {
            return;
        }
        int remaining = recentCast.getSpellCost().getRemainingCasts(this.runeCount);
        Iterator iterator = thresholds.iterator();
        while (iterator.hasNext()) {
            int val = (Integer)iterator.next();
            if (remaining != val) continue;
            String msgContent = this.getWarningMessage(recentCast.getName(), val);
            String msg = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(this.config.chatWarningColor(), msgContent).build();
            this.chatManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).name("RemainingCasts").runeLiteFormattedMessage(msg).build());
            if (!this.config.useChatWarningNotifications()) break;
            this.notifier.notify(msgContent);
            break;
        }
    }

    private String getWarningMessage(String spellName, int casts) {
        String message = spellName + " has " + (Serializable)(casts == 0 ? "no" : Integer.valueOf(casts));
        message = message + (casts == 1 ? " cast " : " casts ") + "remaining.";
        return message;
    }

    private void updateCastBoxes(SpellInfo recentCast) {
        int threshold = this.config.infoBoxThreshold();
        ArrayList toRemove = new ArrayList();
        if (recentCast != null && this.castBoxes.containsKey(recentCast)) {
            RemainingCastsInfoBox infoBox = this.castBoxes.get(recentCast);
            infoBox.update(this.runeCount, true);
        }
        this.castBoxes.values().forEach(c -> {
            if (threshold != 0 && c.getRemainingCasts() > threshold) {
                toRemove.add(c.getSpellInfo());
            } else {
                c.update(this.runeCount);
            }
        });
        toRemove.forEach(this::removeCastBox);
    }

    private void processCast(SpellInfo spellInfo) {
        if (!this.castBoxes.containsKey(spellInfo)) {
            this.createRemainingCastsBox(spellInfo, false);
        }
    }

    private RemainingCastsInfoBox createRemainingCastsBox(SpellInfo spellInfo, boolean isPinned) {
        BufferedImage sprite = this.config.showInfoBoxSprites() ? this.spriteManager.getSprite(spellInfo.getSpriteId(), 0) : this.getSpellBookSprite();
        int threshold = this.config.infoBoxThreshold();
        int remainingCasts = spellInfo.getSpellCost().getRemainingCasts(this.runeCount);
        if (!isPinned && threshold != 0 && remainingCasts > threshold) {
            return null;
        }
        RemainingCastsInfoBox infoBox = new RemainingCastsInfoBox(spellInfo, this.runeCount, sprite, this.plugin, this.config, this.itemManager);
        infoBox.setPinned(isPinned);
        this.infoBoxManager.addInfoBox((InfoBox)infoBox);
        this.castBoxes.put(spellInfo, infoBox);
        if (isPinned) {
            infoBox.resetActiveTime();
        } else {
            this.spellQueue.add(spellInfo);
        }
        this.checkCastBoxLimit();
        return infoBox;
    }

    private void checkCastBoxLimit() {
        if (this.spellQueue.size() == 0 || this.config.infoBoxSpellLimit() <= 0) {
            return;
        }
        if (this.spellQueue.size() > this.config.infoBoxSpellLimit()) {
            SpellInfo oldest = this.spellQueue.peek();
            this.removeCastBox(oldest);
        }
    }

    private void checkCastBoxExpiry() {
        int expirySeconds = this.config.infoBoxExpirySeconds();
        if (expirySeconds == 0) {
            return;
        }
        ArrayList<SpellInfo> expired = new ArrayList<SpellInfo>();
        for (SpellInfo spellInfo : this.castBoxes.keySet()) {
            RemainingCastsInfoBox box = this.castBoxes.get(spellInfo);
            if (box.isPinned() || box.getActiveTime() <= (long)expirySeconds) continue;
            expired.add(spellInfo);
        }
        expired.forEach(this::removeCastBox);
    }

    private void updatePinnedSpells() {
        String pinned = this.config.pinnedSpells();
        List spellNames = Text.fromCSV((String)pinned);
        this.clientThread.invoke(() -> {
            this.castBoxes.values().forEach(cb -> cb.setPinned(false));
            if (spellNames.size() == 0) {
                return;
            }
            spellNames.forEach(name -> {
                SpellInfo info = SpellIds.getSpellByName(name);
                if (info == null) {
                    return;
                }
                RemainingCastsInfoBox box = this.castBoxes.getOrDefault(info, null);
                if (box != null) {
                    box.setPinned(true);
                } else {
                    box = this.createRemainingCastsBox(info, true);
                    if (box != null) {
                        box.setPinned(true);
                    }
                }
            });
        });
    }

    private void removeCastBox(SpellInfo spellInfo) {
        if (!this.castBoxes.containsKey(spellInfo)) {
            return;
        }
        RemainingCastsInfoBox box = this.castBoxes.get(spellInfo);
        this.infoBoxManager.removeInfoBox((InfoBox)box);
        this.castBoxes.remove(spellInfo);
        this.spellQueue.remove(spellInfo);
    }

    private void removeAllCastBoxes() {
        this.infoBoxManager.removeIf(i -> i instanceof RemainingCastsInfoBox);
        this.castBoxes.clear();
        this.spellQueue.clear();
    }

    private boolean isFiltered(SpellInfo spellInfo) {
        if (this.config.spellFilterOption() == SpellFilterOption.DISABLED) {
            return false;
        }
        String filterList = this.config.filterList();
        List spellNames = Text.fromCSV((String)filterList);
        if (this.config.spellFilterOption() == SpellFilterOption.BLACKLIST) {
            return spellNames.stream().anyMatch(s -> spellInfo.getName().equalsIgnoreCase((String)s));
        }
        if (this.config.spellFilterOption() == SpellFilterOption.WHITELIST) {
            return spellNames.stream().noneMatch(s -> spellInfo.getName().equalsIgnoreCase((String)s));
        }
        return false;
    }

    private BufferedImage getSpellBookSprite() {
        Widget spellBook = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_MAGIC_ICON);
        return spellBook != null ? this.spriteManager.getSprite(spellBook.getSpriteId(), 0) : this.spriteManager.getSprite(780, 0);
    }

    private boolean isOtherItemContainerWidget(int groupId) {
        switch (groupId) {
            case 12: 
            case 192: 
            case 335: 
            case 724: {
                return true;
            }
        }
        return false;
    }

    public int tryParseInt(String value, int defaultVal) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }
}

