/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts.Model;

import com.salverrs.RemainingCasts.Util.RuneIds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SpellCost {
    private final int[] runes;
    private final int[] quantities;

    public SpellCost(int[] runeIds, int[] quantities) {
        if (runeIds.length != quantities.length) {
            throw new IndexOutOfBoundsException();
        }
        this.runes = runeIds;
        this.quantities = quantities;
    }

    public boolean matchesCost(Map<Integer, Integer> runeCount, Set<Integer> unlimitedRunes) {
        for (int i = 0; i < this.runes.length; ++i) {
            int targetRuneId = this.runes[i];
            if (unlimitedRunes.contains(targetRuneId) || runeCount.containsKey(targetRuneId) && runeCount.get(targetRuneId) >= this.quantities[i]) continue;
            return false;
        }
        return true;
    }

    public int getRemainingCasts(Map<Integer, Integer> runeCount) {
        ArrayList<Integer> castsPerRune = new ArrayList<Integer>();
        for (int i = 0; i < this.runes.length; ++i) {
            int targetRuneId = this.runes[i];
            if (runeCount.containsKey(targetRuneId)) {
                boolean isReqStaff;
                int available = runeCount.get(targetRuneId);
                int cost = this.quantities[i];
                boolean bl = isReqStaff = available >= 1 && RuneIds.isReqStaff(targetRuneId);
                if (available == Integer.MAX_VALUE || isReqStaff) {
                    castsPerRune.add(Integer.MAX_VALUE);
                    continue;
                }
                castsPerRune.add(Math.floorDiv(available, cost));
                continue;
            }
            return 0;
        }
        return (Integer)Collections.min(castsPerRune);
    }

    public int[] getRunes() {
        return this.runes;
    }

    public int[] getQuantities() {
        return this.quantities;
    }
}

