/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts.Infobox;

import com.salverrs.RemainingCasts.Model.SpellCost;
import com.salverrs.RemainingCasts.Model.SpellInfo;
import com.salverrs.RemainingCasts.RemainingCastsConfig;
import com.salverrs.RemainingCasts.Util.CastUtils;
import com.salverrs.RemainingCasts.Util.RuneIds;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;

public class RemainingCastsInfoBox
extends InfoBox {
    private final SpellInfo spellInfo;
    private final SpellCost spellCost;
    private final RemainingCastsConfig config;
    private final String[] runeNames;
    private String tooltip = "";
    private Map<Integer, Integer> runeCount;
    private int remainingCasts;
    private long lastUpdated;
    private boolean advTooltipDisabled = false;
    private boolean isPinned;

    public RemainingCastsInfoBox(SpellInfo spellInfo, Map<Integer, Integer> runeCount, BufferedImage image, Plugin plugin, RemainingCastsConfig config, ItemManager itemManager) {
        super(image, plugin);
        this.spellInfo = spellInfo;
        this.spellCost = spellInfo.getSpellCost();
        this.lastUpdated = Instant.now().getEpochSecond();
        this.runeCount = runeCount;
        this.remainingCasts = this.spellCost.getRemainingCasts(runeCount);
        this.config = config;
        int[] runes = this.spellCost.getRunes();
        this.runeNames = new String[runes.length];
        for (int i = 0; i < runes.length; ++i) {
            this.runeNames[i] = itemManager.getItemComposition(runes[i]).getName();
            if (this.runeNames[i] != null && !this.runeNames[i].equals("")) continue;
            this.advTooltipDisabled = true;
            break;
        }
        this.buildTooltip();
    }

    public String getText() {
        return this.getRemainingCastsString();
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Color getTextColor() {
        return this.config.infoBoxTextColor();
    }

    public void update(Map<Integer, Integer> runeCount) {
        this.update(runeCount, false);
    }

    public void update(Map<Integer, Integer> runeCount, boolean wasCast) {
        this.runeCount = runeCount;
        this.remainingCasts = this.spellCost.getRemainingCasts(runeCount);
        this.buildTooltip();
        if (wasCast) {
            this.lastUpdated = Instant.now().getEpochSecond();
        }
    }

    public long getActiveTime() {
        return Instant.now().getEpochSecond() - this.lastUpdated;
    }

    public void resetActiveTime() {
        this.lastUpdated = 0L;
    }

    private String getRemainingCastsString() {
        if (this.remainingCasts == -1) {
            return "N/A";
        }
        return this.config.shortenCastAmounts() ? CastUtils.getShortenedAmount(this.remainingCasts) : CastUtils.formatCastAmount(this.remainingCasts);
    }

    private void buildTooltip() {
        String base = this.spellInfo.getName() + " - " + (Serializable)(this.remainingCasts != Integer.MAX_VALUE ? Integer.valueOf(this.remainingCasts) : "Unlimited");
        base = base + (this.remainingCasts != 1 ? " casts " : " cast ") + "remaining";
        if (!this.config.showDetailedTooltip() || this.advTooltipDisabled) {
            this.tooltip = base;
            return;
        }
        StringBuilder advTooltip = new StringBuilder(base + "</br>");
        int[] runes = this.spellCost.getRunes();
        int[] quantities = this.spellCost.getQuantities();
        for (int i = 0; i < runes.length; ++i) {
            int runeId = runes[i];
            int quantity = quantities[i];
            int available = this.runeCount.getOrDefault(runeId, 0);
            int floorDiv = this.getCostDivision(runeId, quantity, available);
            String runeName = this.runeNames[i];
            if (runeName == null || runeName.equals("")) {
                this.tooltip = base;
                return;
            }
            advTooltip.append("</br>").append(runeName).append(": ").append(available != Integer.MAX_VALUE ? Integer.valueOf(available) : "*").append("/").append(quantity);
            if (available == Integer.MAX_VALUE || floorDiv == Integer.MAX_VALUE) continue;
            advTooltip.append(" (").append(floorDiv).append(")");
        }
        this.tooltip = advTooltip.toString();
    }

    private int getCostDivision(int itemId, int cost, int available) {
        if (available == Integer.MAX_VALUE || available >= 1 && RuneIds.isReqStaff(itemId)) {
            return Integer.MAX_VALUE;
        }
        return cost != 0 && available != 0 ? Math.floorDiv(available, cost) : 0;
    }

    public SpellInfo getSpellInfo() {
        return this.spellInfo;
    }

    public SpellCost getSpellCost() {
        return this.spellCost;
    }

    public RemainingCastsConfig getConfig() {
        return this.config;
    }

    public String[] getRuneNames() {
        return this.runeNames;
    }

    public Map<Integer, Integer> getRuneCount() {
        return this.runeCount;
    }

    public int getRemainingCasts() {
        return this.remainingCasts;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public boolean isAdvTooltipDisabled() {
        return this.advTooltipDisabled;
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    public void setPinned(boolean isPinned) {
        this.isPinned = isPinned;
    }
}

