/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.RemainingCasts;

import com.salverrs.RemainingCasts.Events.BoltsEnchanted;
import com.salverrs.RemainingCasts.Events.RunesChanged;
import com.salverrs.RemainingCasts.Model.RuneChanges;
import com.salverrs.RemainingCasts.Model.SpellInfo;
import com.salverrs.RemainingCasts.Util.RuneIds;
import com.salverrs.RemainingCasts.Util.SpellIds;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.PostClientTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class CastSuppliesTracker {
    private static final int[] RUNE_POUCH_RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
    private static final int[] RUNE_POUCH_AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private static final int FOUNTAIN_OF_RUNES_VARBIT = 4145;
    private final Map<Integer, Integer> runeCount = new HashMap<Integer, Integer>();
    private final Set<Integer> unlimitedRunes = new HashSet<Integer>();
    private RuneChanges lastChanges;
    private boolean active = false;
    private boolean requiresPostUpdate = false;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.active || !this.isRelevantItemContainer(event.getItemContainer())) {
            return;
        }
        this.updateRuneCount();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.active || this.requiresPostUpdate || !this.isRelevantVarbit(event.getVarbitId())) {
            return;
        }
        this.requiresPostUpdate = true;
    }

    @Subscribe
    public void onPostClientTick(PostClientTick event) {
        if (!this.requiresPostUpdate) {
            return;
        }
        this.updateRuneCount();
        this.requiresPostUpdate = false;
    }

    public void start() {
        this.active = true;
        this.requiresPostUpdate = true;
    }

    public void stop() {
        this.requiresPostUpdate = false;
        this.active = false;
    }

    public Map<Integer, Integer> forceUpdateRuneCount() {
        this.updateRuneCount();
        return this.runeCount;
    }

    public Map<Integer, Integer> getLastRuneCount() {
        return this.runeCount;
    }

    private void updateRuneCount() {
        HashMap<Integer, Integer> lastCount = new HashMap<Integer, Integer>(this.runeCount);
        this.updateCurrentRuneCount();
        Map<Integer, Integer> changes = this.calculateRuneChangesMap(lastCount, this.runeCount);
        if (changes.size() != 0) {
            this.lastChanges = new RuneChanges(changes, this.runeCount, this.unlimitedRunes);
            this.eventBus.post((Object)new RunesChanged(this.lastChanges));
            SpellInfo enchant = this.getEnchantSpellCast(changes);
            if (enchant != null) {
                this.eventBus.post((Object)new BoltsEnchanted(enchant, this.lastChanges));
            }
        }
    }

    public void updateCurrentRuneCount() {
        this.resetRuneCount();
        this.updateContainerItems();
        this.checkGlobalVarbits();
    }

    private void updateContainerItems() {
        this.unlimitedRunes.clear();
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        Item[] inventoryItems = inventory != null ? inventory.getItems() : new Item[]{};
        Item[] equipmentItems = equipment != null ? equipment.getItems() : new Item[]{};
        Arrays.stream(inventoryItems).forEach(i -> this.updateInventoryItem(i.getId(), i.getQuantity()));
        Arrays.stream(equipmentItems).forEach(i -> this.updateEquipmentItems(i.getId(), i.getQuantity()));
    }

    private void updateInventoryItem(int itemId, int quantity) {
        int ingredient;
        if (itemId == 12791 || itemId == 24416) {
            this.updateRunePouchItems(false);
            return;
        }
        if (itemId == 27281 || itemId == 27509) {
            this.updateRunePouchItems(true);
            return;
        }
        if (itemId == 23650) {
            this.addLMSRunePouch();
            return;
        }
        if (itemId == 27086) {
            this.addUnlimitedRunes();
            return;
        }
        Integer[] runes = RuneIds.getRuneIds(itemId);
        if (runes != null) {
            Arrays.stream(runes).forEach(r -> this.updateRuneCount((int)r, quantity));
        }
        if ((ingredient = RuneIds.getIngredientId(itemId)) != -1) {
            this.updateRuneCount(ingredient, quantity);
        }
        if (RuneIds.isEnchantProduct(itemId)) {
            this.updateRuneCount(itemId, quantity);
        }
    }

    private void updateEquipmentItems(int itemId, int quantity) {
        Integer[] items;
        Integer[] runes;
        if (RuneIds.isEnchantProduct(itemId)) {
            this.updateRuneCount(itemId, quantity);
        }
        if ((runes = RuneIds.getRuneIdsFromEquipment(itemId)) != null) {
            Arrays.stream(runes).forEach(r -> {
                this.unlimitedRunes.add((Integer)r);
                this.updateRuneCount((int)r, Integer.MAX_VALUE);
            });
        }
        if ((items = RuneIds.getItemIdsFromEquipment(itemId)) != null) {
            Arrays.stream(items).forEach(i -> {
                this.unlimitedRunes.add((Integer)i);
                this.updateRuneCount((int)i, quantity);
            });
        }
    }

    private void checkGlobalVarbits() {
        boolean nearFountain;
        boolean bl = nearFountain = this.client.getVarbitValue(4145) == 1;
        if (nearFountain) {
            this.addUnlimitedRunes();
        }
    }

    private void updateRunePouchItems(boolean isDivine) {
        EnumComposition runepouchEnum = this.client.getEnum(982);
        int pouchSize = isDivine ? 4 : 3;
        for (int i = 0; i < pouchSize; ++i) {
            int runeId;
            Integer[] runes;
            int id = this.client.getVarbitValue(RUNE_POUCH_RUNE_VARBITS[i]);
            int quantity = this.client.getVarbitValue(RUNE_POUCH_AMOUNT_VARBITS[i]);
            if (id == 0 || quantity <= 0 || (runes = RuneIds.getRuneIds(runeId = runepouchEnum.getIntValue(id))) == null) continue;
            Arrays.stream(runes).forEach(r -> this.updateRuneCount((int)r, quantity));
        }
    }

    private void addLMSRunePouch() {
        this.runeCount.put(555, Integer.MAX_VALUE);
        this.runeCount.put(560, Integer.MAX_VALUE);
        this.runeCount.put(565, Integer.MAX_VALUE);
        this.runeCount.put(566, Integer.MAX_VALUE);
    }

    private void addUnlimitedRunes() {
        Set<Integer> allRuneIds = RuneIds.getAllRuneIds();
        allRuneIds.forEach(id -> this.runeCount.put((Integer)id, Integer.MAX_VALUE));
    }

    private void updateRuneCount(int runeId, int quantity) {
        long expectedValue;
        Integer currentValue = this.runeCount.getOrDefault(runeId, null);
        long l = expectedValue = currentValue != null ? (long)currentValue.intValue() + (long)quantity : (long)quantity;
        if (expectedValue >= Integer.MAX_VALUE) {
            this.runeCount.put(runeId, Integer.MAX_VALUE);
        } else {
            this.runeCount.put(runeId, (int)expectedValue);
        }
    }

    private Map<Integer, Integer> calculateRuneChangesMap(Map<Integer, Integer> oldRunes, Map<Integer, Integer> newRunes) {
        HashMap<Integer, Integer> changeMap = new HashMap<Integer, Integer>();
        HashSet<Integer> runeKeys = new HashSet<Integer>(oldRunes.keySet());
        runeKeys.addAll(newRunes.keySet());
        for (Integer runeId : runeKeys) {
            int oldQuantity = oldRunes.getOrDefault(runeId, 0);
            int newQuantity = newRunes.getOrDefault(runeId, 0);
            int change = newQuantity - oldQuantity;
            if (change == 0) continue;
            changeMap.put(runeId, change);
        }
        return changeMap;
    }

    private SpellInfo getEnchantSpellCast(Map<Integer, Integer> changes) {
        for (int itemId : changes.keySet()) {
            int change;
            SpellInfo enchant = SpellIds.getSpellByProduct(itemId, change = changes.get(itemId).intValue());
            if (enchant == null) continue;
            return enchant;
        }
        return null;
    }

    private void resetRuneCount() {
        this.runeCount.clear();
    }

    private boolean isRelevantItemContainer(ItemContainer container) {
        return container == this.client.getItemContainer(InventoryID.INVENTORY) || container == this.client.getItemContainer(InventoryID.EQUIPMENT);
    }

    private boolean isRelevantVarbit(int varbitId) {
        return varbitId == 4145 || Arrays.stream(RUNE_POUCH_RUNE_VARBITS).anyMatch(v -> v == varbitId) || Arrays.stream(RUNE_POUCH_AMOUNT_VARBITS).anyMatch(v -> v == varbitId);
    }
}

