/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing.ui;

import com.togcrowdsourcing.WorldData;
import com.togcrowdsourcing.ui.WorldSwitcherPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.plugins.worldhopper.WorldHopperPlugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldRegion;
import net.runelite.http.api.worlds.WorldType;

class WorldTableRow
extends JPanel {
    private static final ImageIcon FLAG_AUS;
    private static final ImageIcon FLAG_UK;
    private static final ImageIcon FLAG_US;
    private static final ImageIcon FLAG_GER;
    private static final int WORLD_COLUMN_WIDTH;
    private static final int HITS_COLUMN_WIDTH;
    private static final Color CURRENT_WORLD;
    private static final Color DANGEROUS_WORLD;
    private static final Color TOURNAMENT_WORLD;
    private static final Color MEMBERS_WORLD;
    private static final Color FREE_WORLD;
    private static final Color SEASONAL_WORLD;
    private static final Color GGGBBB_WORLD;
    private static final Color BBBGGG_WORLD;
    private JLabel worldField;
    private JLabel hitsField;
    private JLabel streamOrderField;
    private final World world;
    private final WorldData worldData;
    private int updatedHitsCount;
    private Color lastBackground;

    WorldTableRow(final World world, WorldData worldData, boolean current, final Consumer<World> onSelect) {
        this.world = world;
        this.worldData = worldData;
        this.updatedHitsCount = worldData.getHits();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && onSelect != null) {
                    onSelect.accept(world);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WorldTableRow.this.setBackground(WorldTableRow.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WorldTableRow.this.setBackground(WorldTableRow.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WorldTableRow.this.lastBackground = WorldTableRow.this.getBackground();
                WorldTableRow.this.setBackground(WorldTableRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WorldTableRow.this.setBackground(WorldTableRow.this.lastBackground);
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setComponentPopupMenu(popupMenu);
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        leftSide.setOpaque(false);
        rightSide.setOpaque(false);
        JPanel worldField = this.buildWorldField();
        worldField.setPreferredSize(new Dimension(WORLD_COLUMN_WIDTH, 0));
        worldField.setOpaque(false);
        JPanel hitsField = this.buildHitsField();
        hitsField.setPreferredSize(new Dimension(HITS_COLUMN_WIDTH, 0));
        hitsField.setOpaque(false);
        JPanel activityField = this.buildStreamOrderField();
        activityField.setBorder(new EmptyBorder(5, 5, 5, 5));
        activityField.setOpaque(false);
        this.recolour(current);
        leftSide.add((Component)worldField, "West");
        leftSide.add((Component)hitsField, "Center");
        rightSide.add((Component)activityField, "Center");
        this.add((Component)leftSide, "West");
        this.add((Component)rightSide, "Center");
    }

    private static String hitsCountString(int hitsCount) {
        return hitsCount < 0 ? "OFF" : Integer.toString(hitsCount);
    }

    public void recolour(boolean current) {
        this.hitsField.setForeground(current ? CURRENT_WORLD : Color.WHITE);
        if (current) {
            this.streamOrderField.setForeground(CURRENT_WORLD);
            this.worldField.setForeground(CURRENT_WORLD);
            return;
        }
        if (this.world.getTypes().contains(WorldType.PVP) || this.world.getTypes().contains(WorldType.HIGH_RISK) || this.world.getTypes().contains(WorldType.DEADMAN)) {
            this.streamOrderField.setForeground(DANGEROUS_WORLD);
        } else if (this.world.getTypes().contains(WorldType.SEASONAL)) {
            this.streamOrderField.setForeground(SEASONAL_WORLD);
        } else if (this.world.getTypes().contains(WorldType.NOSAVE_MODE)) {
            this.streamOrderField.setForeground(TOURNAMENT_WORLD);
        } else if (this.worldData.getStream_order().equals("gggbbb")) {
            this.streamOrderField.setForeground(GGGBBB_WORLD);
        } else if (this.worldData.getStream_order().equals("bbbggg")) {
            this.streamOrderField.setForeground(BBBGGG_WORLD);
        } else {
            this.streamOrderField.setForeground(Color.WHITE);
        }
        this.worldField.setForeground(this.world.getTypes().contains(WorldType.MEMBERS) ? MEMBERS_WORLD : FREE_WORLD);
    }

    private JPanel buildHitsField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.hitsField = new JLabel(WorldTableRow.hitsCountString(this.worldData.getHits()));
        this.hitsField.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.hitsField, "West");
        return column;
    }

    private JPanel buildStreamOrderField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        String streamOrder = this.worldData.getStream_order();
        this.streamOrderField = new JLabel(streamOrder);
        this.streamOrderField.setFont(FontManager.getRunescapeSmallFont());
        if (streamOrder != null && streamOrder.length() > 16) {
            this.streamOrderField.setToolTipText(streamOrder);
            this.streamOrderField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WorldTableRow.this.dispatchEvent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    WorldTableRow.this.dispatchEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    WorldTableRow.this.dispatchEvent(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    WorldTableRow.this.dispatchEvent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WorldTableRow.this.dispatchEvent(e);
                }
            });
        }
        column.add((Component)this.streamOrderField, "West");
        return column;
    }

    private JPanel buildWorldField() {
        JPanel column = new JPanel(new BorderLayout(7, 0));
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.worldField = new JLabel("" + this.world.getId());
        ImageIcon flagIcon = WorldTableRow.getFlag(this.world.getRegion());
        if (flagIcon != null) {
            JLabel flag = new JLabel(flagIcon);
            column.add((Component)flag, "West");
        }
        column.add((Component)this.worldField, "Center");
        return column;
    }

    private static ImageIcon getFlag(WorldRegion region) {
        if (region == null) {
            return null;
        }
        switch (region) {
            case UNITED_STATES_OF_AMERICA: {
                return FLAG_US;
            }
            case UNITED_KINGDOM: {
                return FLAG_UK;
            }
            case AUSTRALIA: {
                return FLAG_AUS;
            }
            case GERMANY: {
                return FLAG_GER;
            }
        }
        return null;
    }

    public World getWorld() {
        return this.world;
    }

    public WorldData getWorldData() {
        return this.worldData;
    }

    int getUpdatedHitsCount() {
        return this.updatedHitsCount;
    }

    static {
        WORLD_COLUMN_WIDTH = WorldSwitcherPanel.getWORLD_COLUMN_WIDTH();
        HITS_COLUMN_WIDTH = WorldSwitcherPanel.getHITS_COLUMN_WIDTH();
        CURRENT_WORLD = new Color(66, 227, 17);
        DANGEROUS_WORLD = new Color(251, 62, 62);
        TOURNAMENT_WORLD = new Color(79, 145, 255);
        MEMBERS_WORLD = new Color(210, 193, 53);
        FREE_WORLD = new Color(200, 200, 200);
        SEASONAL_WORLD = new Color(133, 177, 178);
        GGGBBB_WORLD = new Color(36, 195, 250);
        BBBGGG_WORLD = new Color(128, 217, 255);
        FLAG_AUS = new ImageIcon(ImageUtil.loadImageResource(WorldHopperPlugin.class, (String)"flag_aus.png"));
        FLAG_UK = new ImageIcon(ImageUtil.loadImageResource(WorldHopperPlugin.class, (String)"flag_uk.png"));
        FLAG_US = new ImageIcon(ImageUtil.loadImageResource(WorldHopperPlugin.class, (String)"flag_us.png"));
        FLAG_GER = new ImageIcon(ImageUtil.loadImageResource(WorldHopperPlugin.class, (String)"flag_ger.png"));
    }
}

