/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing.ui;

import com.google.common.collect.Ordering;
import com.togcrowdsourcing.ToGCrowdsourcingConfig;
import com.togcrowdsourcing.WorldData;
import com.togcrowdsourcing.ui.WorldHopper;
import com.togcrowdsourcing.ui.WorldTableHeader;
import com.togcrowdsourcing.ui.WorldTableRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import net.runelite.http.api.worlds.WorldType;

class WorldSwitcherPanel
extends PluginPanel {
    private static final Color ODD_ROW = new Color(44, 44, 44);
    private static final int WORLD_COLUMN_WIDTH = 60;
    private static final int HITS_COLUMN_WIDTH = 50;
    private final JPanel listContainer = new JPanel();
    private WorldTableHeader worldHeader;
    private WorldTableHeader hitsHeader;
    private WorldTableHeader activityHeader;
    private WorldOrder orderIndex = WorldOrder.STREAM_ORDER;
    private boolean ascendingOrder = false;
    private final ArrayList<WorldTableRow> rows = new ArrayList();
    private final WorldHopper worldHopper;

    WorldSwitcherPanel(WorldHopper worldHopper) {
        this.worldHopper = worldHopper;
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel headerContainer = this.buildHeader();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(headerContainer);
        this.add(this.listContainer);
    }

    void switchCurrentHighlight(int newWorld, int lastWorld) {
        for (WorldTableRow row : this.rows) {
            if (row.getWorld().getId() == newWorld) {
                row.recolour(true);
                continue;
            }
            if (row.getWorld().getId() != lastWorld) continue;
            row.recolour(false);
        }
    }

    void updateList() {
        this.rows.sort((r1, r2) -> {
            switch (this.orderIndex) {
                case WORLD: {
                    return this.getCompareValue((WorldTableRow)r1, (WorldTableRow)r2, row -> Integer.valueOf(row.getWorld().getId()));
                }
                case HITS: {
                    return this.getCompareValue((WorldTableRow)r1, (WorldTableRow)r2, WorldTableRow::getUpdatedHitsCount);
                }
                case STREAM_ORDER: {
                    return this.getCompareValueStreamOrder((WorldTableRow)r1, (WorldTableRow)r2);
                }
            }
            return 0;
        });
        this.listContainer.removeAll();
        for (int i = 0; i < this.rows.size(); ++i) {
            WorldTableRow row = this.rows.get(i);
            row.setBackground(i % 2 == 0 ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
            this.listContainer.add(row);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    private int getCompareValueStreamOrder(WorldTableRow r1, WorldTableRow r2) {
        int order;
        int n = order = !this.ascendingOrder ? 1 : -1;
        if (r1.getWorldData().getStream_order().equals("gggbbb")) {
            if (r2.getWorldData().getStream_order().equals("gggbbb")) {
                return this.getCompareHits(r1, r2) * order;
            }
            return -1 * order;
        }
        if (r1.getWorldData().getStream_order().equals("bbbggg")) {
            if (r2.getWorldData().getStream_order().equals("gggbbb")) {
                return 1 * order;
            }
            if (r2.getWorldData().getStream_order().equals("bbbggg")) {
                return this.getCompareHits(r1, r2) * order;
            }
            return -1 * order;
        }
        if (r2.getWorldData().getStream_order().equals("gggbbb")) {
            if (r1.getWorldData().getStream_order().equals("gggbbb")) {
                return this.getCompareHits(r1, r2) * order;
            }
            return 1 * order;
        }
        if (r2.getWorldData().getStream_order().equals("bbbggg")) {
            if (r1.getWorldData().getStream_order().equals("gggbbb")) {
                return -1 * order;
            }
            if (r1.getWorldData().getStream_order().equals("bbbggg")) {
                return this.getCompareHits(r1, r2) * order;
            }
            return 1 * order;
        }
        return r1.getWorldData().getWorld_number() - r2.getWorldData().getWorld_number();
    }

    private int getCompareHits(WorldTableRow r1, WorldTableRow r2) {
        int c = r2.getWorldData().getHits() - r1.getWorldData().getHits();
        if (c == 0) {
            return r1.getWorldData().getWorld_number() - r2.getWorldData().getWorld_number();
        }
        return c;
    }

    private int getCompareValue(WorldTableRow row1, WorldTableRow row2, Function<WorldTableRow, Comparable> compareByFn) {
        Ordering ordering = Ordering.natural();
        if (!this.ascendingOrder) {
            ordering = ordering.reverse();
        }
        ordering = ordering.nullsLast();
        return ordering.compare((Object)compareByFn.apply(row1), (Object)compareByFn.apply(row2));
    }

    void addNoDataMessage() {
        String[] messages;
        GridBagConstraints c = new GridBagConstraints();
        for (String message : messages = new String[]{" ", "    Worlds have reset!", " ", "    Please help to gather data", "    by hopping worlds :)"}) {
            this.listContainer.add((Component)new JLabel(message), c);
        }
    }

    void addGetErrorMessage() {
        String[] messages;
        GridBagConstraints c = new GridBagConstraints();
        for (String message : messages = new String[]{" ", "    Error getting world data", " ", "    Server may be down,", "    Please try again later.", "    Sorry for the inconvenience!"}) {
            this.listContainer.add((Component)new JLabel(message), c);
        }
    }

    void populate(List<WorldData> worldDataList, ToGCrowdsourcingConfig config) {
        this.rows.clear();
        if (this.worldHopper.isGetError()) {
            this.listContainer.removeAll();
            this.addGetErrorMessage();
            return;
        }
        if (worldDataList.size() == 0) {
            this.listContainer.removeAll();
            this.addNoDataMessage();
            return;
        }
        WorldResult worldResult = this.worldHopper.getWorldService().getWorlds();
        if (worldResult == null) {
            return;
        }
        for (int i = 0; i < worldDataList.size(); ++i) {
            WorldData worldData = worldDataList.get(i);
            World world = worldResult.findWorld(worldData.getWorld_number());
            if (world == null) {
                return;
            }
            if (this.shouldWorldBeSkipped(world, worldData, config)) continue;
            boolean isCurrentWorld = worldData.getWorld_number() == this.worldHopper.getCurrentWorld() && this.worldHopper.getLastWorld() != 0;
            this.rows.add(this.buildRow(worldData, i % 2 == 0, isCurrentWorld));
        }
        this.updateList();
    }

    private boolean shouldWorldBeSkipped(World world, WorldData worldData, ToGCrowdsourcingConfig config) {
        if (world == null) {
            return true;
        }
        if (world.getTypes().contains(WorldType.PVP) && config.hidePVPWorlds()) {
            return true;
        }
        if (world.getTypes().contains(WorldType.HIGH_RISK) && config.hideHighRiskWorlds()) {
            return true;
        }
        if (!world.getTypes().contains(WorldType.MEMBERS)) {
            return true;
        }
        if (world.getTypes().contains(WorldType.NOSAVE_MODE)) {
            return true;
        }
        if (world.getTypes().contains(WorldType.DEADMAN)) {
            return true;
        }
        if (world.getTypes().contains(WorldType.TOURNAMENT)) {
            return true;
        }
        if (world.getTypes().contains(WorldType.SEASONAL)) {
            return true;
        }
        return config.onlyShowOptimalWorlds() && !worldData.getStream_order().equals("gggbbb") && !worldData.getStream_order().equals("bbbggg");
    }

    private void orderBy(WorldOrder order) {
        this.worldHeader.highlight(false, this.ascendingOrder);
        this.hitsHeader.highlight(false, this.ascendingOrder);
        this.activityHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case WORLD: {
                this.worldHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case HITS: {
                this.hitsHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case STREAM_ORDER: {
                this.activityHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderIndex = order;
        this.updateList();
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel(new BorderLayout());
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        this.worldHeader = new WorldTableHeader("World", this.orderIndex == WorldOrder.WORLD, this.ascendingOrder, this.worldHopper::refresh);
        this.worldHeader.setPreferredSize(new Dimension(60, 0));
        this.worldHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.WORLD || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.WORLD);
            }
        });
        this.hitsHeader = new WorldTableHeader("Hits", this.orderIndex == WorldOrder.HITS, this.ascendingOrder, this.worldHopper::refresh);
        this.hitsHeader.setPreferredSize(new Dimension(50, 0));
        this.hitsHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.HITS || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.HITS);
            }
        });
        this.activityHeader = new WorldTableHeader("Stream Order", this.orderIndex == WorldOrder.STREAM_ORDER, this.ascendingOrder, this.worldHopper::refresh);
        this.activityHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                WorldSwitcherPanel.this.ascendingOrder = WorldSwitcherPanel.this.orderIndex != WorldOrder.STREAM_ORDER || !WorldSwitcherPanel.this.ascendingOrder;
                WorldSwitcherPanel.this.orderBy(WorldOrder.STREAM_ORDER);
            }
        });
        leftSide.add((Component)this.worldHeader, "West");
        leftSide.add((Component)this.hitsHeader, "Center");
        rightSide.add((Component)this.activityHeader, "Center");
        header.add((Component)leftSide, "West");
        header.add((Component)rightSide, "Center");
        return header;
    }

    private WorldTableRow buildRow(WorldData worldData, boolean stripe, boolean current) {
        World world = this.worldHopper.getWorldService().getWorlds().findWorld(worldData.getWorld_number());
        WorldTableRow row = new WorldTableRow(world, worldData, current, this.worldHopper::hopTo);
        row.setBackground(stripe ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
        return row;
    }

    public static int getWORLD_COLUMN_WIDTH() {
        return 60;
    }

    public static int getHITS_COLUMN_WIDTH() {
        return 50;
    }

    private static enum WorldOrder {
        WORLD,
        HITS,
        STREAM_ORDER;

    }
}

