/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing.ui;

import com.togcrowdsourcing.CrowdsourcingManager;
import com.togcrowdsourcing.ToGCrowdsourcingConfig;
import com.togcrowdsourcing.ToGCrowdsourcingPlugin;
import com.togcrowdsourcing.WorldData;
import com.togcrowdsourcing.ui.WorldSwitcherPanel;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.WorldsFetch;
import net.runelite.client.game.WorldService;
import net.runelite.client.input.KeyManager;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldHopper {
    private static final Logger log = LoggerFactory.getLogger(WorldHopper.class);
    private static final int REFRESH_THROTTLE = 60000;
    private static final int MAX_PLAYER_COUNT = 1950;
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private ToGCrowdsourcingConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WorldService worldService;
    @Inject
    private CrowdsourcingManager crowdsourcingManager;
    private ScheduledExecutorService hopperExecutorService;
    private NavigationButton navButton;
    private WorldSwitcherPanel panel;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;
    private int lastWorld;
    private int currentWorld;
    private Instant lastFetch;
    private boolean getError;
    private ArrayList<WorldData> worldData = new ArrayList();

    @Inject
    private WorldHopper() {
    }

    public void startUpWorldHopper(ToGCrowdsourcingConfig config) {
        this.panel = new WorldSwitcherPanel(this);
        this.config = config;
        BufferedImage icon = ImageUtil.loadImageResource(ToGCrowdsourcingPlugin.class, (String)"/tog-icon.png");
        this.navButton = NavigationButton.builder().tooltip("ToG Crowdsourcing").icon(icon).priority(10).panel((PluginPanel)this.panel).build();
        if (config.showSidebar()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
        this.updateList();
        this.crowdsourcingManager.makeGetRequest(this);
    }

    public void shutDownWorldHopper() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("togcrowdsourcing")) {
            switch (event.getKey()) {
                case "showSidebar": {
                    if (this.config.showSidebar()) {
                        this.clientToolbar.addNavigation(this.navButton);
                        break;
                    }
                    this.clientToolbar.removeNavigation(this.navButton);
                }
            }
            if (event.getKey().equals("showOverlay")) {
                return;
            }
            this.updateList();
        }
    }

    int getCurrentWorld() {
        return this.client.getWorld();
    }

    void hopTo(net.runelite.http.api.worlds.World world) {
        this.clientThread.invoke(() -> this.hop(world.getId()));
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.config.showSidebar() && gameStateChanged.getGameState() == GameState.LOGGED_IN && this.lastWorld != this.client.getWorld()) {
            int newWorld = this.client.getWorld();
            this.panel.switchCurrentHighlight(newWorld, this.lastWorld);
            this.lastWorld = newWorld;
        }
    }

    void refresh() {
        Instant now = Instant.now();
        if (this.lastFetch != null && now.toEpochMilli() - this.lastFetch.toEpochMilli() < 60000L) {
            log.debug("Throttling world refresh");
            return;
        }
        this.lastFetch = now;
        this.worldService.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onWorldsFetch(WorldsFetch worldsFetch) {
        WorldHopper worldHopper = this;
        synchronized (worldHopper) {
            this.crowdsourcingManager.makeGetRequest(this);
            this.updateList();
        }
    }

    public void updateList() {
        SwingUtilities.invokeLater(() -> this.panel.populate(this.worldData, this.config));
    }

    private void hop(int worldId) {
        assert (this.client.isClientThread());
        WorldResult worldResult = this.worldService.getWorlds();
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        if (this.config.showWorldHopMessage()) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quick-hopping to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        }
        this.quickHopTargetWorld = rsWorld;
        this.displaySwitcherAttempts = 0;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.resetQuickHopper();
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.resetQuickHopper();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("Please finish what you're doing before using the World Switcher.")) {
            this.resetQuickHopper();
        }
    }

    private void resetQuickHopper() {
        this.displaySwitcherAttempts = 0;
        this.quickHopTargetWorld = null;
    }

    public WorldService getWorldService() {
        return this.worldService;
    }

    public CrowdsourcingManager getCrowdsourcingManager() {
        return this.crowdsourcingManager;
    }

    public int getLastWorld() {
        return this.lastWorld;
    }

    public boolean isGetError() {
        return this.getError;
    }

    public void setGetError(boolean getError) {
        this.getError = getError;
    }

    public ArrayList<WorldData> getWorldData() {
        return this.worldData;
    }

    public void setWorldData(ArrayList<WorldData> worldData) {
        this.worldData = worldData;
    }
}

