/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.Text;

public class TripleLineComponent
implements LayoutableRenderableEntity {
    private String left;
    private String right;
    private String middle;
    private Color leftColor;
    private Color rightColor;
    private Color middleColor;
    private Font leftFont;
    private Font rightFont;
    private Font middleFont;
    private Point preferredLocation;
    private Dimension preferredSize;
    private final Rectangle bounds;

    public Dimension render(Graphics2D graphics) {
        String left = (String)MoreObjects.firstNonNull((Object)this.left, (Object)"");
        String right = (String)MoreObjects.firstNonNull((Object)this.right, (Object)"");
        String middle = (String)MoreObjects.firstNonNull((Object)this.middle, (Object)"");
        Font leftFont = (Font)MoreObjects.firstNonNull((Object)this.leftFont, (Object)graphics.getFont());
        Font rightFont = (Font)MoreObjects.firstNonNull((Object)this.rightFont, (Object)graphics.getFont());
        Font middleFont = (Font)MoreObjects.firstNonNull((Object)this.middleFont, (Object)graphics.getFont());
        FontMetrics lfm = graphics.getFontMetrics(leftFont);
        FontMetrics rfm = graphics.getFontMetrics(rightFont);
        FontMetrics mfm = graphics.getFontMetrics(middleFont);
        int fmHeight = Math.max(lfm.getHeight(), Math.max(rfm.getHeight(), mfm.getHeight()));
        int baseX = this.preferredLocation.x;
        int baseY = this.preferredLocation.y + fmHeight;
        int x = baseX;
        int y = baseY;
        int leftFullWidth = TripleLineComponent.getLineWidth(left, lfm);
        int rightFullWidth = TripleLineComponent.getLineWidth(right, rfm);
        int middleFullWidth = TripleLineComponent.getLineWidth(middle, rfm);
        TextComponent textComponent = new TextComponent();
        if (this.preferredSize.width < leftFullWidth + rightFullWidth + middleFullWidth) {
            int leftSmallWidth = this.preferredSize.width;
            int rightSmallWidth = 0;
            int middleSmallWidth = 0;
            if (!Strings.isNullOrEmpty((String)right)) {
                rightSmallWidth = this.preferredSize.width / 3;
                leftSmallWidth -= rightSmallWidth;
            }
            if (!Strings.isNullOrEmpty((String)middle)) {
                middleSmallWidth = this.preferredSize.width / 3;
                leftSmallWidth -= middleSmallWidth;
            }
            String[] leftSplitLines = TripleLineComponent.lineBreakText(left, leftSmallWidth, lfm);
            String[] rightSplitLines = TripleLineComponent.lineBreakText(right, rightSmallWidth, rfm);
            String[] middleSplitLines = TripleLineComponent.lineBreakText(middle, middleSmallWidth, mfm);
            int lineCount = Math.max(leftSplitLines.length, Math.max(rightSplitLines.length, middleSplitLines.length));
            for (int i = 0; i < lineCount; ++i) {
                if (i < leftSplitLines.length) {
                    String leftText = leftSplitLines[i];
                    textComponent.setPosition(new Point(x, y));
                    textComponent.setText(leftText);
                    textComponent.setColor(this.leftColor);
                    textComponent.setFont(leftFont);
                    textComponent.render(graphics);
                }
                if (i < rightSplitLines.length) {
                    String rightText = rightSplitLines[i];
                    textComponent.setPosition(new Point(x + this.preferredSize.width - TripleLineComponent.getLineWidth(rightText, rfm), y));
                    textComponent.setText(rightText);
                    textComponent.setColor(this.rightColor);
                    textComponent.setFont(rightFont);
                    textComponent.render(graphics);
                }
                if (i < middleSplitLines.length) {
                    String middleText = middleSplitLines[i];
                    textComponent.setPosition(new Point(x + (this.preferredSize.width - TripleLineComponent.getLineWidth(middleText, mfm) / 2), y));
                    textComponent.setText(middleText);
                    textComponent.setColor(this.middleColor);
                    textComponent.setFont(middleFont);
                    textComponent.render(graphics);
                }
                y += fmHeight;
            }
            Dimension dimension = new Dimension(this.preferredSize.width, y - baseY);
            this.bounds.setLocation(this.preferredLocation);
            this.bounds.setSize(dimension);
            return dimension;
        }
        if (!left.isEmpty()) {
            textComponent.setPosition(new Point(x, y));
            textComponent.setText(left);
            textComponent.setColor(this.leftColor);
            textComponent.setFont(leftFont);
            textComponent.render(graphics);
        }
        if (!right.isEmpty()) {
            textComponent.setPosition(new Point(x + this.preferredSize.width - rightFullWidth, y));
            textComponent.setText(right);
            textComponent.setColor(this.rightColor);
            textComponent.setFont(rightFont);
            textComponent.render(graphics);
        }
        if (!middle.isEmpty()) {
            textComponent.setPosition(new Point(x + (this.preferredSize.width - middleFullWidth) / 2, y));
            textComponent.setText(middle);
            textComponent.setColor(this.middleColor);
            textComponent.setFont(middleFont);
            textComponent.render(graphics);
        }
        Dimension dimension = new Dimension(this.preferredSize.width, (y += fmHeight) - baseY);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    private static int getLineWidth(String line, FontMetrics metrics) {
        return metrics.stringWidth(Text.removeTags((String)line));
    }

    private static String[] lineBreakText(String text, int maxWidth, FontMetrics metrics) {
        String[] words = text.split(" ");
        if (words.length == 0) {
            return new String[0];
        }
        StringBuilder wrapped = new StringBuilder(words[0]);
        int spaceLeft = maxWidth - metrics.stringWidth(wrapped.toString());
        for (int i = 1; i < words.length; ++i) {
            int spaceWidth;
            String word = words[i];
            int wordLen = metrics.stringWidth(word);
            if (wordLen + (spaceWidth = metrics.stringWidth(" ")) > spaceLeft) {
                wrapped.append("\n").append(word);
                spaceLeft = maxWidth - wordLen;
                continue;
            }
            wrapped.append(" ").append(word);
            spaceLeft -= spaceWidth + wordLen;
        }
        return wrapped.toString().split("\n");
    }

    private static Color $default$leftColor() {
        return Color.WHITE;
    }

    private static Color $default$rightColor() {
        return Color.WHITE;
    }

    private static Color $default$middleColor() {
        return Color.WHITE;
    }

    private static Point $default$preferredLocation() {
        return new Point();
    }

    private static Dimension $default$preferredSize() {
        return new Dimension(129, 0);
    }

    private static Rectangle $default$bounds() {
        return new Rectangle();
    }

    TripleLineComponent(String left, String right, String middle, Color leftColor, Color rightColor, Color middleColor, Font leftFont, Font rightFont, Font middleFont, Point preferredLocation, Dimension preferredSize, Rectangle bounds) {
        this.left = left;
        this.right = right;
        this.middle = middle;
        this.leftColor = leftColor;
        this.rightColor = rightColor;
        this.middleColor = middleColor;
        this.leftFont = leftFont;
        this.rightFont = rightFont;
        this.middleFont = middleFont;
        this.preferredLocation = preferredLocation;
        this.preferredSize = preferredSize;
        this.bounds = bounds;
    }

    public static TripleLineComponentBuilder builder() {
        return new TripleLineComponentBuilder();
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public void setMiddle(String middle) {
        this.middle = middle;
    }

    public void setLeftColor(Color leftColor) {
        this.leftColor = leftColor;
    }

    public void setRightColor(Color rightColor) {
        this.rightColor = rightColor;
    }

    public void setMiddleColor(Color middleColor) {
        this.middleColor = middleColor;
    }

    public void setLeftFont(Font leftFont) {
        this.leftFont = leftFont;
    }

    public void setRightFont(Font rightFont) {
        this.rightFont = rightFont;
    }

    public void setMiddleFont(Font middleFont) {
        this.middleFont = middleFont;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public static class TripleLineComponentBuilder {
        private String left;
        private String right;
        private String middle;
        private boolean leftColor$set;
        private Color leftColor$value;
        private boolean rightColor$set;
        private Color rightColor$value;
        private boolean middleColor$set;
        private Color middleColor$value;
        private Font leftFont;
        private Font rightFont;
        private Font middleFont;
        private boolean preferredLocation$set;
        private Point preferredLocation$value;
        private boolean preferredSize$set;
        private Dimension preferredSize$value;
        private boolean bounds$set;
        private Rectangle bounds$value;

        TripleLineComponentBuilder() {
        }

        public TripleLineComponentBuilder left(String left) {
            this.left = left;
            return this;
        }

        public TripleLineComponentBuilder right(String right) {
            this.right = right;
            return this;
        }

        public TripleLineComponentBuilder middle(String middle) {
            this.middle = middle;
            return this;
        }

        public TripleLineComponentBuilder leftColor(Color leftColor) {
            this.leftColor$value = leftColor;
            this.leftColor$set = true;
            return this;
        }

        public TripleLineComponentBuilder rightColor(Color rightColor) {
            this.rightColor$value = rightColor;
            this.rightColor$set = true;
            return this;
        }

        public TripleLineComponentBuilder middleColor(Color middleColor) {
            this.middleColor$value = middleColor;
            this.middleColor$set = true;
            return this;
        }

        public TripleLineComponentBuilder leftFont(Font leftFont) {
            this.leftFont = leftFont;
            return this;
        }

        public TripleLineComponentBuilder rightFont(Font rightFont) {
            this.rightFont = rightFont;
            return this;
        }

        public TripleLineComponentBuilder middleFont(Font middleFont) {
            this.middleFont = middleFont;
            return this;
        }

        public TripleLineComponentBuilder preferredLocation(Point preferredLocation) {
            this.preferredLocation$value = preferredLocation;
            this.preferredLocation$set = true;
            return this;
        }

        public TripleLineComponentBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize$value = preferredSize;
            this.preferredSize$set = true;
            return this;
        }

        public TripleLineComponentBuilder bounds(Rectangle bounds) {
            this.bounds$value = bounds;
            this.bounds$set = true;
            return this;
        }

        public TripleLineComponent build() {
            Color leftColor$value = this.leftColor$value;
            if (!this.leftColor$set) {
                leftColor$value = TripleLineComponent.$default$leftColor();
            }
            Color rightColor$value = this.rightColor$value;
            if (!this.rightColor$set) {
                rightColor$value = TripleLineComponent.$default$rightColor();
            }
            Color middleColor$value = this.middleColor$value;
            if (!this.middleColor$set) {
                middleColor$value = TripleLineComponent.$default$middleColor();
            }
            Point preferredLocation$value = this.preferredLocation$value;
            if (!this.preferredLocation$set) {
                preferredLocation$value = TripleLineComponent.$default$preferredLocation();
            }
            Dimension preferredSize$value = this.preferredSize$value;
            if (!this.preferredSize$set) {
                preferredSize$value = TripleLineComponent.$default$preferredSize();
            }
            Rectangle bounds$value = this.bounds$value;
            if (!this.bounds$set) {
                bounds$value = TripleLineComponent.$default$bounds();
            }
            return new TripleLineComponent(this.left, this.right, this.middle, leftColor$value, rightColor$value, middleColor$value, this.leftFont, this.rightFont, this.middleFont, preferredLocation$value, preferredSize$value, bounds$value);
        }

        public String toString() {
            return "TripleLineComponent.TripleLineComponentBuilder(left=" + this.left + ", right=" + this.right + ", middle=" + this.middle + ", leftColor$value=" + this.leftColor$value + ", rightColor$value=" + this.rightColor$value + ", middleColor$value=" + this.middleColor$value + ", leftFont=" + this.leftFont + ", rightFont=" + this.rightFont + ", middleFont=" + this.middleFont + ", preferredLocation$value=" + this.preferredLocation$value + ", preferredSize$value=" + this.preferredSize$value + ", bounds$value=" + this.bounds$value + ")";
        }
    }
}

