/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing;

import com.google.inject.Provides;
import com.togcrowdsourcing.StreamOrderDetector;
import com.togcrowdsourcing.ToGCrowdsourcingConfig;
import com.togcrowdsourcing.ui.WorldHopper;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;

@PluginDescriptor(name="Tears of Guthix Crowdsourcing", description="Crowdsource ToG stream orders to help players find the optimal world for the week.")
public class ToGCrowdsourcingPlugin
extends Plugin {
    private static final int REFRESH_INTERVAL_ON_ERROR = 10;
    @Inject
    private EventBus eventBus;
    @Inject
    private ToGCrowdsourcingConfig config;
    @Inject
    private StreamOrderDetector streamOrderDetector;
    @Inject
    private WorldHopper worldHopper;

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this.streamOrderDetector);
        this.streamOrderDetector.startUpStreamOrderDetector(this.config, this.worldHopper);
        this.eventBus.register((Object)this.worldHopper);
        this.worldHopper.startUpWorldHopper(this.config);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this.streamOrderDetector);
        this.streamOrderDetector.shutDownStreamOrderDetector();
        this.eventBus.unregister((Object)this.worldHopper);
        this.worldHopper.shutDownWorldHopper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Schedule(period=10L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void refreshOnError() {
        if (this.worldHopper.isGetError()) {
            WorldHopper worldHopper = this.worldHopper;
            synchronized (worldHopper) {
                this.worldHopper.getCrowdsourcingManager().makeGetRequest(this.worldHopper);
                this.worldHopper.updateList();
            }
        }
    }

    @Provides
    ToGCrowdsourcingConfig provideConfig(ConfigManager configManager) {
        return (ToGCrowdsourcingConfig)configManager.getConfig(ToGCrowdsourcingConfig.class);
    }
}

