/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing;

import com.togcrowdsourcing.StreamOrderDetector;
import com.togcrowdsourcing.TearStream;
import com.togcrowdsourcing.ToGCrowdsourcingConfig;
import com.togcrowdsourcing.TripleLineComponent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.DecorativeObject;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.SplitComponent;

class ToGCrowdsourcingOverlay
extends OverlayPanel {
    private final StreamOrderDetector streamOrderDetector;
    private final ToGCrowdsourcingConfig config;
    private static final int OVERLAY_SPLIT_GAP = 20;
    @Inject
    SpriteManager spriteManager;

    @Inject
    private ToGCrowdsourcingOverlay(StreamOrderDetector streamOrderDetector, ToGCrowdsourcingConfig config) {
        this.config = config;
        this.streamOrderDetector = streamOrderDetector;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showOverlay()) {
            return null;
        }
        if (this.streamOrderDetector.getClient().getLocalPlayer().getWorldLocation().getRegionID() != 12948) {
            return null;
        }
        ArrayList<TearStream> paddedList = this.padWithNull(this.streamOrderDetector.getStreamList());
        TripleLineComponent topLine = TripleLineComponent.builder().left(this.streamToString(paddedList.get(0))).middle(this.streamToString(paddedList.get(1))).right(this.streamToString(paddedList.get(2))).leftColor(paddedList.get(0).getColor()).middleColor(paddedList.get(1).getColor()).rightColor(paddedList.get(2).getColor()).build();
        TripleLineComponent bottomLine = TripleLineComponent.builder().left(this.streamToString(paddedList.get(3))).middle(this.streamToString(paddedList.get(4))).right(this.streamToString(paddedList.get(5))).leftColor(paddedList.get(3).getColor()).middleColor(paddedList.get(4).getColor()).rightColor(paddedList.get(5).getColor()).build();
        SplitComponent tearColorsSplitComponent = SplitComponent.builder().first((LayoutableRenderableEntity)topLine).second((LayoutableRenderableEntity)bottomLine).orientation(ComponentOrientation.VERTICAL).build();
        ImageComponent checkboxImageComponent = new ImageComponent(this.getCheckBoxImage());
        SplitComponent tearColorsAndCheckboxSplitComponent = SplitComponent.builder().first((LayoutableRenderableEntity)tearColorsSplitComponent).second((LayoutableRenderableEntity)checkboxImageComponent).orientation(ComponentOrientation.HORIZONTAL).gap(new Point(20, 0)).build();
        this.panelComponent.getChildren().add(tearColorsAndCheckboxSplitComponent);
        return super.render(graphics);
    }

    public String streamToString(TearStream object) {
        DecorativeObject tearStreamObject = object.getTearStreamObject();
        if (tearStreamObject == null) {
            return "-";
        }
        if (tearStreamObject.getId() == 6661 || tearStreamObject.getId() == 6665) {
            return "Blue";
        }
        if (tearStreamObject.getId() == 6662 || tearStreamObject.getId() == 6666) {
            return "Green";
        }
        return "Error";
    }

    public ArrayList<TearStream> padWithNull(ArrayList<TearStream> streamList) {
        int i;
        ArrayList<TearStream> paddedList = new ArrayList<TearStream>();
        for (i = 0; i < streamList.size(); ++i) {
            paddedList.add(streamList.get(i));
        }
        for (i = 0; i < 6 - streamList.size(); ++i) {
            paddedList.add(new TearStream(null, 0L, Instant.now()));
        }
        return paddedList;
    }

    private BufferedImage getCheckBoxImage() {
        int spriteID = this.streamOrderDetector.isDataValid() ? 699 : 698;
        return this.spriteManager.getSprite(spriteID, 0);
    }
}

