/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing;

import java.awt.Color;
import java.time.Instant;
import net.runelite.api.DecorativeObject;
import net.runelite.client.util.ColorUtil;

public class TearStream {
    private final Color BLUE_TEARS_COLOR = ColorUtil.colorWithAlpha((Color)Color.CYAN, (int)100);
    private final Color GREEN_TEARS_COLOR = ColorUtil.colorWithAlpha((Color)Color.GREEN, (int)100);
    private DecorativeObject tearStreamObject;
    private long timeSinceLastSpawn;
    private Color color;
    private Instant spawnInstant;

    TearStream(DecorativeObject tearStreamObject, long timeSinceLastChange, Instant spawnInstant) {
        this.tearStreamObject = tearStreamObject;
        this.timeSinceLastSpawn = timeSinceLastChange;
        this.spawnInstant = spawnInstant;
        this.color = this.determineColor(tearStreamObject);
    }

    private Color determineColor(DecorativeObject object) {
        if (object == null) {
            return Color.RED;
        }
        if (object.getId() == 6661 || object.getId() == 6665) {
            return this.BLUE_TEARS_COLOR;
        }
        if (object.getId() == 6662 || object.getId() == 6666) {
            return this.GREEN_TEARS_COLOR;
        }
        return Color.RED;
    }

    public DecorativeObject getTearStreamObject() {
        return this.tearStreamObject;
    }

    public long getTimeSinceLastSpawn() {
        return this.timeSinceLastSpawn;
    }

    public Color getColor() {
        return this.color;
    }

    public Instant getSpawnInstant() {
        return this.spawnInstant;
    }
}

