/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing;

import com.togcrowdsourcing.CrowdsourcingManager;
import com.togcrowdsourcing.TearStream;
import com.togcrowdsourcing.ToGCrowdsourcingConfig;
import com.togcrowdsourcing.ToGCrowdsourcingOverlay;
import com.togcrowdsourcing.WorldData;
import com.togcrowdsourcing.ui.WorldHopper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameState;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOrderDetector {
    private static final Logger log = LoggerFactory.getLogger(StreamOrderDetector.class);
    public static final int TOG_REGION = 12948;
    private static final int STREAM_SHORT_INTERVAL = 600;
    private static final int STREAM_LONG_INTERVAL = 6600;
    private static final double STREAM_INTERVAL_TOLERANCE = 0.2;
    public static final int NUMBER_OF_TEAR_STREAMS = 6;
    private boolean dataValid;
    private Instant lastSpawnInstant = Instant.now();
    @Inject
    private Client client;
    private ToGCrowdsourcingConfig config;
    private WorldHopper worldHopper;
    @Inject
    private ToGCrowdsourcingOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CrowdsourcingManager crowdsourcingManager;
    private ArrayList<TearStream> streamList = new ArrayList();

    @Inject
    private StreamOrderDetector() {
    }

    public void startUpStreamOrderDetector(ToGCrowdsourcingConfig config, WorldHopper worldHopper) {
        log.info("ToG Started");
        this.dataValid = false;
        this.config = config;
        this.worldHopper = worldHopper;
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDownStreamOrderDetector() {
        log.info("ToG Started");
        this.overlayManager.remove((Overlay)this.overlay);
        this.streamList.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            default: 
        }
        this.dataValid = false;
        this.streamList.clear();
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        if (this.dataValid) {
            return;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.client.getLocalPlayer().getWorldLocation().getRegionID() != 12948) {
            return;
        }
        DecorativeObject object = event.getDecorativeObject();
        if (object.getId() == 6661 || object.getId() == 6665 || object.getId() == 6662 || object.getId() == 6666) {
            Instant spawnInstant = Instant.now();
            long timeSinceLastSpawn = ChronoUnit.MILLIS.between(this.lastSpawnInstant, spawnInstant);
            TearStream tearStream = new TearStream(object, timeSinceLastSpawn, spawnInstant);
            this.lastSpawnInstant = spawnInstant;
            if ((double)timeSinceLastSpawn < 480.0) {
                this.streamList.clear();
                return;
            }
            this.streamList.add(tearStream);
        }
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        if (this.dataValid) {
            return;
        }
        this.verifyDataIsValid();
    }

    private void verifyDataIsValid() {
        if (this.streamList.size() == 0) {
            return;
        }
        if (this.streamList.size() > 6) {
            this.streamList.clear();
        } else if (this.streamList.size() < 6) {
            Instant currentInstant = Instant.now();
            Instant lastSpawnInstant = this.streamList.get(this.streamList.size() - 1).getSpawnInstant();
            long timeSinceLastSpawn = ChronoUnit.MILLIS.between(lastSpawnInstant, currentInstant);
            long timeBetweenSpawnForLatestTear = this.streamList.get(this.streamList.size() - 1).getTimeSinceLastSpawn();
            if ((double)timeBetweenSpawnForLatestTear < 480.0 || (double)timeSinceLastSpawn > 480.0) {
                this.streamList.clear();
            }
        } else if (this.streamList.size() == 6) {
            this.dataValid = true;
            this.submitToAPI();
            return;
        }
    }

    public ArrayList<String> streamListToStringArray(ArrayList<TearStream> tearStreamArrayList) {
        ArrayList<String> streamListStringArray = new ArrayList<String>();
        for (TearStream tearStream : tearStreamArrayList) {
            streamListStringArray.add(this.overlay.streamToString(tearStream));
        }
        return streamListStringArray;
    }

    private String streamListToStringForAPI(ArrayList<TearStream> tearStreamArrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TearStream tearStream : tearStreamArrayList) {
            stringBuilder.append(this.streamToStringForAPI(tearStream));
        }
        return stringBuilder.toString();
    }

    private String streamToStringForAPI(TearStream object) {
        DecorativeObject tearStreamObject = object.getTearStreamObject();
        if (tearStreamObject == null) {
            return "-";
        }
        if (tearStreamObject.getId() == 6661 || tearStreamObject.getId() == 6665) {
            return "b";
        }
        if (tearStreamObject.getId() == 6662 || tearStreamObject.getId() == 6666) {
            return "g";
        }
        return "Error";
    }

    private void submitToAPI() {
        int currentWorld = this.client.getWorld();
        String streamOrder = this.streamListToStringForAPI(this.streamList);
        WorldData worldData = new WorldData(currentWorld, streamOrder, 1);
        this.crowdsourcingManager.submitToAPI(worldData, this.worldHopper);
    }

    public boolean isDataValid() {
        return this.dataValid;
    }

    public Client getClient() {
        return this.client;
    }

    public ArrayList<TearStream> getStreamList() {
        return this.streamList;
    }
}

