/*
 * Decompiled with CFR 0.152.
 */
package com.togcrowdsourcing;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.togcrowdsourcing.WorldData;
import com.togcrowdsourcing.ui.WorldHopper;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CrowdsourcingManager {
    private static final Logger log = LoggerFactory.getLogger(CrowdsourcingManager.class);
    private static final String CROWDSOURCING_BASE = "https://togcrowdsourcing.com/worldinfo";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;

    protected void submitToAPI(WorldData worldData, final WorldHopper worldHopper) {
        Request r = new Request.Builder().url(CROWDSOURCING_BASE).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)worldData))).build();
        this.okHttpClient.newCall(r).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Failure sending to crowdsourcing server.");
            }

            public void onResponse(Call call, Response response) {
                CrowdsourcingManager.this.makeGetRequest(worldHopper);
                response.close();
            }
        });
    }

    public void makeGetRequest(final WorldHopper worldHopper) {
        try {
            Request r = new Request.Builder().url(CROWDSOURCING_BASE).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error retrieving tog crowdsourcing data", (Throwable)e);
                    worldHopper.setGetError(true);
                    worldHopper.updateList();
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        try {
                            worldHopper.setGetError(false);
                            JsonArray j = (JsonArray)CrowdsourcingManager.this.gson.newBuilder().create().fromJson(response.body().string(), JsonArray.class);
                            worldHopper.setWorldData(CrowdsourcingManager.this.parseData(j));
                            worldHopper.updateList();
                        }
                        catch (JsonSyntaxException | IOException e) {
                            log.error(e.getMessage());
                        }
                    } else {
                        log.error("Get request unsuccessful");
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
        }
    }

    private ArrayList<WorldData> parseData(JsonArray j) {
        ArrayList<WorldData> l = new ArrayList<WorldData>();
        if (j == null) {
            return l;
        }
        for (JsonElement jsonElement : j) {
            JsonObject jObj = jsonElement.getAsJsonObject();
            WorldData d = new WorldData(jObj.get("world_number").getAsInt(), jObj.get("stream_order").getAsString(), jObj.get("hits").getAsInt());
            l.add(d);
        }
        return l;
    }
}

