/*
 * Decompiled with CFR 0.152.
 */
package com.BetterGodwarsOverlay;

import com.BetterGodwarsOverlay.Operation;
import java.math.BigInteger;
import java.util.Locale;
import net.runelite.api.Client;

public class VarbitRequirement {
    private final int varbitID;
    private final int requiredValue;
    private final Operation operation;
    private final String displayText;
    private boolean bitIsSet = false;
    private int bitPosition = -1;

    public VarbitRequirement(int varbitID, Operation operation, int requiredValue, String displayText) {
        this.varbitID = varbitID;
        this.operation = operation;
        this.requiredValue = requiredValue;
        this.displayText = displayText;
    }

    public VarbitRequirement(int varbitID, int value) {
        this(varbitID, Operation.EQUAL, value, null);
    }

    public VarbitRequirement(int varbitID, int value, Operation operation) {
        this(varbitID, operation, value, null);
    }

    public VarbitRequirement(int varbitID, boolean bitIsSet, int bitPosition) {
        this.varbitID = varbitID;
        this.requiredValue = -1;
        this.operation = Operation.EQUAL;
        this.bitPosition = bitPosition;
        this.bitIsSet = bitIsSet;
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        Object text = String.valueOf(bitPosition);
        switch (bitPosition % 100) {
            case 11: 
            case 12: 
            case 13: {
                text = (String)text + "th";
            }
        }
        text = bitPosition + suffixes[bitPosition % 10];
        this.displayText = varbitID + " must have the " + (String)text + " bit set.";
    }

    public boolean check(Client client) {
        if (this.bitPosition >= 0) {
            return this.bitIsSet == BigInteger.valueOf(client.getVarbitValue(this.varbitID)).testBit(this.bitPosition);
        }
        return this.operation.check(client.getVarbitValue(this.varbitID), this.requiredValue);
    }

    public String getDisplayText() {
        if (this.displayText != null) {
            return this.displayText;
        }
        if (this.bitPosition >= 0) {
            return this.varbitID + " must have the " + this.bitPosition + " bit set.";
        }
        return this.varbitID + " must be + " + this.operation.name().toLowerCase(Locale.ROOT) + " " + this.requiredValue;
    }

    public int getVarbitID() {
        return this.varbitID;
    }

    public int getRequiredValue() {
        return this.requiredValue;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isBitIsSet() {
        return this.bitIsSet;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }
}

