/*
 * Decompiled with CFR 0.152.
 */
package com.maplexpbar;

import com.google.inject.Provides;
import com.maplexpbar.MapleXPBarConfig;
import com.maplexpbar.XPBarOverlay;
import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Maple XP Bar")
public class MapleXPBarPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MapleXPBarPlugin.class);
    @Inject
    private XPBarOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    public Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private MapleXPBarConfig config;
    private boolean barsDisplayed;
    private Skill currentSkill;
    private final Map<Skill, Integer> skillList = new EnumMap<Skill, Integer>(Skill.class);

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.barsDisplayed = true;
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.barsDisplayed = false;
    }

    @Provides
    MapleXPBarConfig provideConfig(ConfigManager configManager) {
        return (MapleXPBarConfig)configManager.getConfig(MapleXPBarConfig.class);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Integer lastXP = this.skillList.put(statChanged.getSkill(), statChanged.getXp());
        if (lastXP != null && lastXP.intValue() != statChanged.getXp()) {
            boolean exceedsThreshold;
            Integer xpThreshold = this.config.maxedThreshold();
            boolean bl = exceedsThreshold = lastXP >= xpThreshold;
            if (!exceedsThreshold || exceedsThreshold && this.config.showMaxedSkills()) {
                this.currentSkill = statChanged.getSkill();
            }
        }
        log.info("State CHANGED: " + statChanged.getSkill());
    }

    boolean isBarsDisplayed() {
        return this.barsDisplayed;
    }

    Skill getCurrentSkill() {
        return this.currentSkill;
    }
}

