/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.turaelskipping;

import com.brastasauce.turaelskipping.Task;
import com.brastasauce.turaelskipping.TaskWorldMapPoint;
import com.brastasauce.turaelskipping.TuraelSkippingConfig;
import com.brastasauce.turaelskipping.TuraelSkippingOverlay;
import com.google.inject.Provides;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Turael Skipping")
public class TuraelSkippingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TuraelSkippingPlugin.class);
    private static final String TURAEL = "Turael";
    private static final String SPRIA = "Spria";
    private static final Pattern SLAYER_ASSIGN_MESSAGE = Pattern.compile(".*(?:Your new task is to kill \\d+) (?<name>.+)(?:.)");
    private static final Pattern SLAYER_CURRENT_MESSAGE = Pattern.compile(".*(?:You're still hunting) (?<name>.+)(?:[,;] you have \\d+ to go.)");
    private boolean worldPointSet = false;
    private Task task;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private TuraelSkippingOverlay overlay;
    @Inject
    private TuraelSkippingConfig config;

    private void setTask(String taskName) {
        this.task = Task.getTask(taskName);
        this.createWorldPoint();
    }

    private void completeTask() {
        this.task = null;
        this.worldMapPointManager.removeIf(TaskWorldMapPoint.class::isInstance);
        this.worldPointSet = false;
    }

    private void createWorldPoint() {
        if (this.task != null && this.config.displayMapIcon() && !this.worldPointSet) {
            for (WorldPoint worldPoint : this.task.getWorldPoints()) {
                this.worldMapPointManager.add((WorldMapPoint)new TaskWorldMapPoint(worldPoint));
            }
            this.worldPointSet = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        Widget npcName = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME);
        Widget npcDialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (npcDialog != null && npcName != null && (npcName.getText().equals(TURAEL) || npcName.getText().equals(SPRIA))) {
            String name;
            String npcText = Text.sanitizeMultilineText((String)npcDialog.getText());
            Matcher mAssign = SLAYER_ASSIGN_MESSAGE.matcher(npcText);
            Matcher mCurrent = SLAYER_CURRENT_MESSAGE.matcher(npcText);
            if (mAssign.find()) {
                name = mAssign.group("name");
                this.setTask(name);
            }
            if (mCurrent.find()) {
                name = mCurrent.group("name");
                this.setTask(name);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String chatMessage = Text.removeTags((String)event.getMessage());
        if (chatMessage.startsWith("You've completed") && (chatMessage.contains("Slayer master") || chatMessage.contains("Slayer Master"))) {
            this.completeTask();
        }
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.task = null;
        this.worldMapPointManager.removeIf(TaskWorldMapPoint.class::isInstance);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("turaelskipping")) {
            this.worldMapPointManager.removeIf(TaskWorldMapPoint.class::isInstance);
            this.worldPointSet = false;
            this.createWorldPoint();
        }
    }

    @Provides
    TuraelSkippingConfig provideConfig(ConfigManager configManager) {
        return (TuraelSkippingConfig)configManager.getConfig(TuraelSkippingConfig.class);
    }

    public Task getTask() {
        return this.task;
    }
}

