/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.turaelskipping;

import com.brastasauce.turaelskipping.TuraelSkippingConfig;
import com.brastasauce.turaelskipping.TuraelSkippingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class TuraelSkippingOverlay
extends OverlayPanel {
    private final TuraelSkippingPlugin plugin;
    private final TuraelSkippingConfig config;

    @Inject
    public TuraelSkippingOverlay(TuraelSkippingPlugin plugin, TuraelSkippingConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setPreferredSize(new Dimension(25, 350));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.displayInfo() || this.plugin.getTask() == null) {
            return null;
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left(this.plugin.getTask().getLocation()).build());
        for (String teleport : this.plugin.getTask().getTeleports()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("- " + teleport).leftColor(Color.LIGHT_GRAY).build());
        }
        if (!this.plugin.getTask().getInfo().isEmpty()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(this.plugin.getTask().getInfo()).leftColor(Color.LIGHT_GRAY).build());
        }
        return super.render(graphics);
    }
}

