/*
 * Decompiled with CFR 0.152.
 */
package com.tickcounter;

import com.google.inject.Provides;
import com.tickcounter.TickCounterConfig;
import com.tickcounter.TickCounterOverlay;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tick Counter")
public class TickCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TickCounterPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TickCounterConfig config;
    @Inject
    private Client client;
    @Inject
    private TickCounterOverlay overlay;
    Map<String, Integer> activity = new HashMap<String, Integer>();
    private HashMap<Player, Boolean> blowpiping = new HashMap();
    boolean instanced = false;
    boolean prevInstance = false;

    @Provides
    TickCounterConfig provideConfig(ConfigManager configManager) {
        return (TickCounterConfig)configManager.getConfig(TickCounterConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.activity.clear();
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        if (!(e.getActor() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getActor();
        int weapon = -1;
        if (p.getPlayerComposition() != null) {
            weapon = p.getPlayerComposition().getEquipmentId(KitType.WEAPON);
        }
        int delta = 0;
        switch (p.getAnimation()) {
            case 5061: 
            case 7617: 
            case 8194: 
            case 8291: {
                if (weapon == 12926) {
                    this.blowpiping.put(p, Boolean.FALSE);
                    break;
                }
                delta = 2;
                break;
            }
            case 2323: 
            case 7618: {
                delta = 3;
                break;
            }
            case 426: {
                if (weapon == 20997) {
                    delta = 5;
                    break;
                }
                if (weapon == 25865 || weapon == 25867 || weapon == 25869 || weapon == 25884 || weapon == 25884 || weapon == 25886 || weapon == 25888 || weapon == 25890 || weapon == 25892 || weapon == 25894 || weapon == 25896) {
                    delta = 4;
                    break;
                }
                delta = 3;
                break;
            }
            case 376: 
            case 377: 
            case 386: 
            case 390: 
            case 422: 
            case 423: {
                if (weapon == 24219) {
                    delta = 3;
                    break;
                }
                if (weapon == 26219) {
                    delta = 5;
                    break;
                }
            }
            case 1062: 
            case 1067: 
            case 1074: 
            case 1167: 
            case 1658: 
            case 2890: 
            case 3294: 
            case 3297: 
            case 3298: 
            case 3299: 
            case 3300: 
            case 7514: 
            case 7515: 
            case 8145: 
            case 8288: {
                if (weapon == 24219) {
                    delta = 3;
                    break;
                }
            }
            case 1711: 
            case 4503: 
            case 8289: 
            case 8290: {
                if (this.config.showZamorakianSpear()) {
                    delta = 4;
                    break;
                }
                delta = 0;
                break;
            }
            case 393: {
                if (weapon == 13652) {
                    delta = 4;
                    break;
                }
            }
            case 395: 
            case 400: {
                if (weapon == 24417) {
                    delta = 4;
                    break;
                }
            }
            case 1162: 
            case 1379: 
            case 7855: {
                if (weapon == 24423) {
                    delta = 4;
                    break;
                }
            }
            case 1979: 
            case 7552: 
            case 8056: {
                delta = 5;
                break;
            }
            case 401: {
                if (weapon == 13576) {
                    delta = 6;
                    break;
                }
                if (weapon == 23360) {
                    delta = 3;
                    break;
                }
                delta = 5;
                break;
            }
            case 1378: {
                if (weapon == 27690) {
                    delta = 4;
                    break;
                }
                delta = 6;
                break;
            }
            case 7045: 
            case 7054: 
            case 7055: {
                if (weapon == 12809 || weapon == 11838) {
                    delta = 4;
                    break;
                }
                delta = 6;
                break;
            }
            case 1132: 
            case 1133: {
                delta = 4;
                break;
            }
            case 7511: 
            case 7516: 
            case 7555: 
            case 7638: 
            case 7640: 
            case 7642: 
            case 7643: 
            case 7644: {
                delta = 6;
                break;
            }
            case 428: 
            case 440: 
            case 1203: {
                delta = 7;
                break;
            }
            case 9471: {
                delta = 5;
                break;
            }
            case 6118: {
                delta = 5;
                break;
            }
            case 9493: {
                delta = 5;
            }
            case 9168: {
                delta = 5;
            }
            case -1: {
                this.blowpiping.remove(p);
            }
        }
        if (delta > 0) {
            String name = p.getName();
            this.activity.put(name, this.activity.getOrDefault(name, 0) + delta);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        for (Map.Entry<Player, Boolean> entry : this.blowpiping.entrySet()) {
            if (entry.getValue().booleanValue()) {
                String name = entry.getKey().getName();
                int activity = this.activity.getOrDefault(name, 0);
                this.activity.put(name, activity + 2);
                this.blowpiping.put(entry.getKey(), Boolean.FALSE);
                continue;
            }
            this.blowpiping.put(entry.getKey(), Boolean.TRUE);
        }
        if (!this.config.instance()) {
            return;
        }
        this.prevInstance = this.instanced;
        this.instanced = this.client.isInInstancedRegion();
        if (!this.prevInstance && this.instanced) {
            this.activity.clear();
            this.blowpiping.clear();
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry().getMenuAction() == MenuAction.RUNELITE_OVERLAY && event.getEntry().getTarget().equals("Tick counter") && event.getEntry().getOption().equals("Reset")) {
            this.activity.clear();
            this.blowpiping.clear();
        }
    }
}

