/*
 * Decompiled with CFR 0.152.
 */
package com.tickcounter;

import com.tickcounter.TickCounterConfig;
import com.tickcounter.TickCounterPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class TickCounterOverlay
extends OverlayPanel {
    private TickCounterPlugin plugin;
    private TickCounterConfig config;
    private Client client;

    @Inject
    public TickCounterOverlay(TickCounterPlugin plugin, Client client, TickCounterConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPosition(OverlayPosition.DETACHED);
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Reset", "Tick counter"));
    }

    public Dimension render(Graphics2D g) {
        List elems = this.panelComponent.getChildren();
        elems.clear();
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.plugin.activity.entrySet());
        list.sort(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                int value = -Integer.compare(o1.getValue(), o2.getValue());
                if (value == 0) {
                    value = o1.getKey().compareTo(o2.getKey());
                }
                return value;
            }
        });
        if (list.size() != 0) {
            elems.add(TitleComponent.builder().text("Tick counter").color(this.config.titleColor()).build());
        }
        int total = 0;
        for (Map.Entry entry : list) {
            total += ((Integer)entry.getValue()).intValue();
            if (((String)entry.getKey()).equals(this.client.getLocalPlayer().getName())) {
                elems.add(LineComponent.builder().leftColor(this.config.selfColor()).rightColor(this.config.selfColor()).left((String)entry.getKey()).right(((Integer)entry.getValue()).toString()).build());
                continue;
            }
            elems.add(LineComponent.builder().left((String)entry.getKey()).right(((Integer)entry.getValue()).toString()).leftColor(this.config.otherColor()).rightColor(this.config.otherColor()).build());
        }
        if (this.config.totalEnabled() && list.size() != 0) {
            elems.add(LineComponent.builder().left("Total").leftColor(this.config.totalColor()).rightColor(this.config.totalColor()).right(String.valueOf(total)).build());
        }
        return super.render(g);
    }
}

