/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import com.creativetechguy.MuteAllConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Mute All", description="Mute all sounds from playing, while still enabling sound events for other plugins", configName="mute-all")
public class MuteAllPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MuteAllPlugin.class);
    @Inject
    private Client client;
    @Inject
    private MuteAllConfig config;

    @Provides
    MuteAllConfig provideConfig(ConfigManager configManager) {
        return (MuteAllConfig)configManager.getConfig(MuteAllConfig.class);
    }

    protected void startUp() throws Exception {
        if (this.client.getGameState() == GameState.LOGGED_IN && !this.config.seenAlert()) {
            this.showAlert();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && !this.config.seenAlert()) {
            this.showAlert();
        }
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffectPlayed) {
        soundEffectPlayed.consume();
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed areaSoundEffectPlayed) {
        areaSoundEffectPlayed.consume();
    }

    private void showAlert() {
        SwingUtilities.invokeLater(() -> {
            JOptionPane.showMessageDialog(null, "For the 'Mute All' plugin to work, you must manually unmute your in-game Sound Effects and Area Sounds.", "Mute All", 1);
            this.config.seenAlert(true);
        });
    }
}

