/*
 * Decompiled with CFR 0.152.
 */
package com.sirarchlinux.runelite.polybar;

import com.google.inject.Provides;
import com.sirarchlinux.runelite.polybar.PolybarIntegrationConfig;
import com.sirarchlinux.runelite.polybar.State;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Polybar Integration")
public class PolybarIntegrationPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PolybarIntegrationPlugin.class);
    private State globalState = State.IDLE;
    @Inject
    private Client client;
    @Inject
    private PolybarIntegrationConfig config;
    @Inject
    private ScheduledExecutorService executorService;

    protected void startUp() {
        this.writeState(State.IDLE);
        this.notifyPolybar();
    }

    protected void shutDown() {
        this.writeState(State.IDLE);
        this.notifyPolybar();
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        State newState;
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null || event.getActor() != localPlayer) {
            return;
        }
        int animation = localPlayer.getAnimation();
        if (this.config.isIdleOnly()) {
            newState = animation == -1 ? State.IDLE : State.ANY;
        } else {
            switch (animation) {
                case 867: 
                case 869: 
                case 871: 
                case 873: 
                case 875: 
                case 877: 
                case 879: 
                case 2117: 
                case 2846: 
                case 7264: 
                case 8324: {
                    newState = State.WCING;
                    break;
                }
                case 335: 
                case 624: 
                case 625: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 642: 
                case 643: 
                case 3866: 
                case 3873: 
                case 4481: 
                case 4482: 
                case 6752: 
                case 6753: 
                case 6754: 
                case 6755: 
                case 6756: 
                case 6757: 
                case 6758: 
                case 7139: 
                case 7282: 
                case 7283: 
                case 8344: 
                case 8345: 
                case 8346: 
                case 8347: {
                    newState = State.MINING;
                    break;
                }
                case 712: 
                case 713: {
                    newState = State.ALCH;
                    break;
                }
                case 828: 
                case 833: {
                    newState = State.CLIMB;
                    break;
                }
                case 898: {
                    newState = State.SMITH;
                    break;
                }
                case 827: 
                case 899: {
                    newState = State.SMELT;
                    break;
                }
                case 3705: {
                    newState = State.PRAY;
                    break;
                }
                case 1248: 
                case 6678: 
                case 6679: 
                case 6680: 
                case 6681: 
                case 6682: 
                case 6683: 
                case 6684: 
                case 6685: 
                case 6686: 
                case 6687: 
                case 6688: 
                case 6689: 
                case 8480: 
                case 8481: {
                    newState = State.FLETCH;
                    break;
                }
                case 896: 
                case 897: 
                case 7529: {
                    newState = State.COOK;
                    break;
                }
                case 397: {
                    newState = State.STUN;
                    break;
                }
                case 886: 
                case 887: 
                case 888: 
                case 889: 
                case 890: 
                case 891: 
                case 892: 
                case 6295: {
                    newState = State.GEM;
                    break;
                }
                case 618: 
                case 619: 
                case 620: 
                case 621: 
                case 622: 
                case 623: 
                case 1193: 
                case 5108: 
                case 6709: 
                case 7401: 
                case 7402: 
                case 8336: {
                    newState = State.FISH;
                    break;
                }
                case 1696: 
                case 1697: 
                case 1698: 
                case 1699: 
                case 1700: 
                case 1701: 
                case 4847: 
                case 4850: 
                case 4853: 
                case 4855: 
                case 4857: {
                    newState = State.TELE;
                    break;
                }
                case 733: {
                    newState = State.FIRE;
                    break;
                }
                case 832: 
                case 881: {
                    newState = State.STEAL;
                    break;
                }
                case 714: {
                    newState = State.MTELE;
                    break;
                }
                case 830: 
                case 2280: 
                case 2281: 
                case 2282: 
                case 2283: 
                case 2288: 
                case 2291: 
                case 2292: 
                case 7699: {
                    newState = State.FARM;
                    break;
                }
                case 363: 
                case 364: 
                case 5249: {
                    newState = State.HERB;
                    break;
                }
                case 5207: 
                case 5212: {
                    newState = State.CHUNT;
                    break;
                }
                case 5208: 
                case 5215: 
                case 7259: {
                    newState = State.LHUNT;
                    break;
                }
                case 895: {
                    newState = State.SAND;
                    break;
                }
                case 4067: 
                case 4068: {
                    newState = State.TABMK;
                    break;
                }
                case 3676: {
                    newState = State.CONSTR;
                    break;
                }
                case 7531: {
                    newState = State.CRFTBS;
                    break;
                }
                case 883: 
                case 884: 
                case 894: 
                case 1249: 
                case 24975: {
                    newState = State.CRAFT;
                    break;
                }
                case 726: {
                    newState = State.CHORB;
                    break;
                }
                case 4432: 
                case 7118: {
                    newState = State.BCRPS;
                    break;
                }
                case 6298: {
                    newState = State.PLANK;
                    break;
                }
                case 4412: {
                    newState = State.STRNG;
                    break;
                }
                case 719: 
                case 720: 
                case 721: 
                case 931: {
                    newState = State.ENCHJWL;
                    break;
                }
                default: {
                    newState = State.IDLE;
                }
            }
        }
        if (this.globalState != newState) {
            this.globalState = newState;
            this.writeState(newState);
            this.notifyPolybar();
        }
    }

    private void writeState(State state) {
        try {
            PrintWriter writer = new PrintWriter("/tmp/rl_state", "UTF-8");
            writer.println(state.getMessage());
            writer.close();
        }
        catch (IOException e) {
            log.error("Failed to write to file /tmp/rl_state");
        }
    }

    private void notifyPolybar() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("polybar-msg");
        commands.add("hook");
        commands.add(this.config.module());
        commands.add(String.valueOf(this.config.hook()));
        this.executorService.submit(() -> {
            try {
                Process notificationProcess = new ProcessBuilder(commands.toArray(new String[0])).redirectErrorStream(true).start();
                boolean exited = notificationProcess.waitFor(500L, TimeUnit.MILLISECONDS);
                if (exited && notificationProcess.exitValue() == 0) {
                    log.debug("polybar-msg command executed successfully");
                    return;
                }
            }
            catch (IOException | InterruptedException ex) {
                log.error("Execution of polybar-msg command threw exception", (Throwable)ex);
            }
            log.debug("polybar-msg returned with error");
        });
    }

    @Provides
    PolybarIntegrationConfig provideConfig(ConfigManager configManager) {
        return (PolybarIntegrationConfig)configManager.getConfig(PolybarIntegrationConfig.class);
    }

    public State getGlobalState() {
        return this.globalState;
    }
}

