/*
 * Decompiled with CFR 0.152.
 */
package sky.twoStepZoom;

import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import sky.twoStepZoom.TwoStepZoomConfig;

@PluginDescriptor(name="Two step zoom", description="Adjusts the zoom between two levels", tags={"zoom"})
public class TwoStepZoomPlugin
extends Plugin
implements KeyListener {
    boolean standardDown = false;
    boolean zoomedDown = false;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TwoStepZoomConfig config;
    @Inject
    private KeyManager keyManager;

    @Provides
    TwoStepZoomConfig provideConfig(ConfigManager configManager) {
        return (TwoStepZoomConfig)configManager.getConfig(TwoStepZoomConfig.class);
    }

    protected void startUp() {
        this.keyManager.registerKeyListener((KeyListener)this);
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == this.config.standardZoomKey().getKeyCode()) {
            this.standardDown = true;
        } else if (e.getKeyCode() == this.config.zoomedZoomKey().getKeyCode()) {
            this.zoomedDown = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == this.config.standardZoomKey().getKeyCode()) {
            this.standardDown = false;
            int zoomValue = this.config.standardZoomValue();
            this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{42, zoomValue, zoomValue}));
        } else if (e.getKeyCode() == this.config.zoomedZoomKey().getKeyCode()) {
            this.zoomedDown = false;
            int zoomValue = this.config.zoomedZoomValue();
            this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{42, zoomValue, zoomValue}));
        }
    }
}

