/*
 * Decompiled with CFR 0.152.
 */
package com.code;

import com.code.OefConfig;
import com.code.OefOverlay;
import com.google.inject.Provides;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Oof Sound")
public class OefPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OefPlugin.class);
    String soundFilePath = "MinecraftOefSound.wav";
    public static int oofCount = 0;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private OefConfig config;
    @Inject
    private OefOverlay overlay;
    public Clip clip;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        Object c = null;
        AudioInputStream soundFileAudioInputStream = null;
        try {
            URL url = OefPlugin.class.getClassLoader().getResource(this.soundFilePath);
            soundFileAudioInputStream = AudioSystem.getAudioInputStream(url);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        if (soundFileAudioInputStream == null) {
            return;
        }
        try {
            this.clip = AudioSystem.getClip();
            this.clip.open(soundFileAudioInputStream);
        }
        catch (IOException | LineUnavailableException e) {
            log.warn("Could not load the file: ", (Throwable)e);
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clip.stop();
        this.clip.close();
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.client.getLocalPlayer().getHealthRatio() != 0) {
            return;
        }
        if (this.client.getLocalPlayer().getAnimation() != 836) {
            return;
        }
        if (this.client.getGameState() == GameState.LOGGED_IN && this.config.death()) {
            System.out.println("Death");
            this.playSound();
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Actor actor = hitsplatApplied.getActor();
        if (actor == this.client.getLocalPlayer() && this.client.getGameState() == GameState.LOGGED_IN && this.config.damage()) {
            this.playSound();
        }
    }

    private void playSound() {
        if (this.clip.isActive()) {
            this.clip.stop();
        }
        ++oofCount;
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float volumeValue = this.config.volume() - 100;
        volume.setValue(volumeValue);
        this.clip.setFramePosition(0);
        this.clip.start();
    }

    @Provides
    OefConfig provideConfig(ConfigManager configManager) {
        return (OefConfig)configManager.getConfig(OefConfig.class);
    }
}

