/*
 * Decompiled with CFR 0.152.
 */
package com.beaglebreath;

import com.beaglebreath.ChatNameColorsConfig;
import com.beaglebreath.UserColor;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Panel;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chat Name Colors", description="Differentiate players in your chat with custom colors!", tags={"chat", "name", "color", "message"})
public class ChatNameColorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChatNameColorsPlugin.class);
    private static final String CONFIG_GROUP = "chatNameColors";
    private static final String USER_PREFIX = "USER~";
    private static final String MESSAGE_OPTION = "Message";
    private static final String ADD_FRIEND_OPTION = "Add friend";
    private static final String SET_COLOR_OPTION = "Set Color";
    @Inject
    private Client client;
    @Inject
    private ChatNameColorsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ColorPickerManager colorPickerManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private Gson gson;
    private Map<String, UserColor> userToColorMap;

    protected void startUp() throws Exception {
        log.info("ChatNameColors started!");
        this.userToColorMap = new HashMap<String, UserColor>();
        this.loadUserColors();
        this.eventBus.register((Object)this);
    }

    protected void shutDown() throws Exception {
        this.saveUserColors();
        log.info("ChatNameColors stopped!");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("chatnamecolors")) {
            return;
        }
        if (configChanged.getKey().equals("yournamecolor")) {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Chat color config reloaded", null));
        }
    }

    @Provides
    ChatNameColorsConfig provideConfig(ConfigManager configManager) {
        return (ChatNameColorsConfig)configManager.getConfig(ChatNameColorsConfig.class);
    }

    private void writeChatColors() {
        String[] stringStack = this.client.getStringStack();
        int size = this.client.getStringStackSize();
        if (size < 3) {
            log.error("Attempted to write chat colors with a small stack: " + size);
            return;
        }
        String username = stringStack[size - 3];
        if (username == null || username.isEmpty()) {
            return;
        }
        String sanitizedUsername = this.sanitizeUsername(username);
        UserColor userColor = this.getOrCreateUserColor(sanitizedUsername);
        if (userColor == null || userColor.getColor() == null) {
            return;
        }
        stringStack[size - 3] = ColorUtil.wrapWithColorTag((String)username, (Color)userColor.getColor());
    }

    private UserColor getOrCreateUserColor(String username) {
        boolean isThisPlayer = username.equals(this.client.getLocalPlayer().getName());
        if (isThisPlayer) {
            if (!this.config.colorYourName() || this.config.yourNameColor() == null) {
                return null;
            }
            return new UserColor(this.config.yourNameColor(), username, new Date());
        }
        UserColor existingColor = this.userToColorMap.get(username);
        if (existingColor != null) {
            existingColor = existingColor.touch();
            this.userToColorMap.put(username, existingColor);
            return existingColor;
        }
        if (!this.config.randomlyGenerate()) {
            return null;
        }
        Random rand = new Random();
        Color userColor = new Color(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
        UserColor newUserColor = new UserColor(userColor, username, new Date());
        this.userToColorMap.put(username, newUserColor);
        return newUserColor;
    }

    private String sanitizeUsername(String username) {
        String sanitized = username;
        if (sanitized.contains("<img")) {
            sanitized = sanitized.replaceAll("<img=\\d*>", "");
        }
        if (sanitized.contains("<col")) {
            sanitized = sanitized.replaceAll("<col=[\\w\\d]*>", "");
        }
        if (sanitized.contains("</col>")) {
            sanitized = sanitized.replaceAll("</col>", "");
        }
        return sanitized;
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        String eventName = scriptCallbackEvent.getEventName();
        if ("chatMessageBuilding".equals(eventName)) {
            this.writeChatColors();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        boolean hotKeyPressed = this.client.isKeyPressed(81);
        if (hotKeyPressed && (event.getOption().equals(MESSAGE_OPTION) || event.getOption().equals(ADD_FRIEND_OPTION))) {
            MenuEntry menuEntry = event.getMenuEntry();
            String target = this.sanitizeUsername(menuEntry.getTarget());
            boolean alreadyExists = Arrays.stream(this.client.getMenuEntries()).anyMatch(me -> me.getOption().equals(SET_COLOR_OPTION));
            if (alreadyExists) {
                return;
            }
            if (Strings.isNullOrEmpty((String)target)) {
                log.error("Error detecting player for menu");
                return;
            }
            this.client.createMenuEntry(-1).setOption(SET_COLOR_OPTION).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> SwingUtilities.invokeLater(() -> {
                Color colorToStart = null;
                if (this.userToColorMap.containsKey(target)) {
                    colorToStart = this.userToColorMap.get(target).getColor();
                }
                if (colorToStart == null) {
                    colorToStart = Color.WHITE;
                }
                RuneliteColorPicker colorPicker = this.colorPickerManager.create(SwingUtilities.windowForComponent((Panel)this.client), colorToStart, "Set Color for User", false);
                colorPicker.setOnClose(c -> {
                    this.setUserColor(target, (Color)c);
                    this.clientThread.invokeLater(this::messageUpdate);
                });
                colorPicker.setVisible(true);
            }));
        }
    }

    private void messageUpdate() {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Updated user's color", null);
    }

    private void setUserColor(String username, Color color) {
        UserColor userColor = new UserColor(color, username, new Date());
        this.userToColorMap.put(username, userColor);
        String json = this.gson.toJson((Object)userColor);
        this.configManager.setConfiguration(CONFIG_GROUP, USER_PREFIX + username, json);
    }

    private void saveUserColors() {
        this.userToColorMap.keySet().forEach(username -> {
            UserColor userColor = this.userToColorMap.get(username);
            String json = this.gson.toJson((Object)userColor);
            this.configManager.setConfiguration(CONFIG_GROUP, USER_PREFIX + username, json);
        });
    }

    private void loadUserColors() {
        String KEY_PREFIX = "chatNameColors.USER~";
        List keys = this.configManager.getConfigurationKeys(CONFIG_GROUP);
        for (String key : keys) {
            if (!key.startsWith(KEY_PREFIX)) {
                log.error("Unexpected config key: " + key);
                continue;
            }
            String username = key.replace(KEY_PREFIX, "");
            String userKey = USER_PREFIX + username;
            String json = this.configManager.getConfiguration(CONFIG_GROUP, userKey);
            if (Strings.isNullOrEmpty((String)json)) {
                log.error("Couldn't find color for key: " + userKey);
                continue;
            }
            UserColor userColor = (UserColor)this.gson.fromJson(json, UserColor.class);
            this.userToColorMap.put(username, userColor);
        }
    }
}

