/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.wildernesslines;

import at.nightfirec.wildernesslines.WildernessLinesConfig;
import at.nightfirec.wildernesslines.WildernessLinesOverlay;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.geometry.Geometry;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Wilderness Lines", description="Show wilderness multicombat areas, the dragon spear range to those areas, and level 20 and 30 lines.", tags={"dragon spear", "multicombat", "wildy", "20", "30", "wilderness level"})
public class WildernessLinesPlugin
extends Plugin {
    private static final List<Rectangle> WILDERNESS_MULTI_AREAS = ImmutableList.of((Object)new Rectangle(3008, 3600, 64, 112), (Object)new Rectangle(2946, 3816, 14, 16), (Object)new Rectangle(2984, 3912, 24, 16), (Object)new Rectangle(3008, 3856, 40, 48), (Object)new Rectangle(3021, 3855, 2, 1), (Object)new Rectangle(3048, 3896, 24, 8), (Object)new Rectangle(3072, 3880, 64, 24), (Object)new Rectangle(3112, 3872, 24, 8), (Object)new Rectangle(3136, 3840, 256, 64), (Object)new Rectangle(3200, 3904, 192, 64), (Object)new Rectangle(3152, 3752, 176, 88), (Object)new Rectangle(3192, 3523, 136, 229), (Object[])new Rectangle[]{new Rectangle(3191, 3689, 1, 1), new Rectangle(3136, 3525, 56, 59), new Rectangle(3152, 3584, 40, 36), new Rectangle(3146, 3598, 6, 22), new Rectangle(3147, 3596, 5, 2), new Rectangle(3149, 3595, 3, 1), new Rectangle(3150, 3594, 2, 1), new Rectangle(3151, 3593, 1, 1), new Rectangle(3152, 3620, 10, 6), new Rectangle(3187, 3620, 5, 28), new Rectangle(3176, 3636, 11, 12), new Rectangle(3175, 3647, 1, 1)});
    private static final int SPEAR_RANGE = 4;
    private static final Line2D[] TWENTY_LINES = new Line2D[]{new Line2D.Float(2946.0f, 3680.0f, 3384.0f, 3680.0f), new Line2D.Float(3202.0f, 10080.0f, 3205.0f, 10080.0f), new Line2D.Float(3216.0f, 10080.0f, 3224.0f, 10080.0f), new Line2D.Float(3228.0f, 10080.0f, 3230.0f, 10080.0f), new Line2D.Float(3234.0f, 10080.0f, 3245.0f, 10080.0f), new Line2D.Float(3335.0f, 10080.0f, 3344.0f, 10080.0f), new Line2D.Float(3349.0f, 10080.0f, 3367.0f, 10080.0f), new Line2D.Float(3381.0f, 10080.0f, 3385.0f, 10080.0f), new Line2D.Float(3394.0f, 10080.0f, 3397.0f, 10080.0f), new Line2D.Float(3410.0f, 10080.0f, 3416.0f, 10080.0f), new Line2D.Float(3436.0f, 10080.0f, 3449.0f, 10080.0f)};
    private static final Line2D[] THIRTY_LINES = new Line2D[]{new Line2D.Float(2946.0f, 3760.0f, 3375.0f, 3760.0f), new Line2D.Float(3164.0f, 10160.0f, 3185.0f, 10160.0f), new Line2D.Float(3194.0f, 10160.0f, 3221.0f, 10160.0f), new Line2D.Float(3235.0f, 10160.0f, 3255.0f, 10160.0f), new Line2D.Float(3333.0f, 10160.0f, 3349.0f, 10160.0f), new Line2D.Float(3356.0f, 10160.0f, 3368.0f, 10160.0f), new Line2D.Float(3421.0f, 10160.0f, 3428.0f, 10160.0f)};
    private static final Area MULTI_AREA = new Area();
    private static final Area SPEAR_MULTI_AREA = new Area();
    @Inject
    private WildernessLinesOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;

    @Provides
    WildernessLinesConfig getConfig(ConfigManager configManager) {
        return (WildernessLinesConfig)configManager.getConfig(WildernessLinesConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private void transformWorldToLocal(float[] coords) {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (int)((int)coords[0]), (int)((int)coords[1]));
        coords[0] = (float)lp.getX() - 64.0f;
        coords[1] = (float)lp.getY() - 64.0f;
    }

    GeneralPath getMultiLinesToDisplay() {
        return this.getLinesToDisplay(MULTI_AREA);
    }

    GeneralPath getSpearLinesToDisplay() {
        return this.getLinesToDisplay(SPEAR_MULTI_AREA);
    }

    GeneralPath get20LineToDisplay() {
        return this.getLinesToDisplay(TWENTY_LINES);
    }

    GeneralPath get30LineToDisplay() {
        return this.getLinesToDisplay(THIRTY_LINES);
    }

    private GeneralPath getLinesToDisplay(Shape ... shapes) {
        Rectangle sceneRect = new Rectangle(this.client.getBaseX() + 1, this.client.getBaseY() + 1, 102, 102);
        GeneralPath paths = new GeneralPath();
        for (Shape shape : shapes) {
            GeneralPath lines = new GeneralPath(shape);
            lines = Geometry.clipPath((GeneralPath)lines, (Shape)sceneRect);
            lines = Geometry.splitIntoSegments((GeneralPath)lines, (float)1.0f);
            lines = Geometry.transformPath((GeneralPath)lines, this::transformWorldToLocal);
            paths.append(lines, false);
        }
        return paths;
    }

    static {
        for (Rectangle multiArea : WILDERNESS_MULTI_AREAS) {
            MULTI_AREA.add(new Area(multiArea));
            for (int i = 0; i <= 4; ++i) {
                Rectangle spearArea = new Rectangle(multiArea);
                spearArea.grow(4 - i, i);
                SPEAR_MULTI_AREA.add(new Area(spearArea));
            }
        }
    }
}

