/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.wildernesslines;

import at.nightfirec.wildernesslines.WildernessLinesConfig;
import at.nightfirec.wildernesslines.WildernessLinesPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.geometry.Geometry;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

class WildernessLinesOverlay
extends Overlay {
    private final WildernessLinesPlugin plugin;
    private final WildernessLinesConfig config;
    private final Client client;

    @Inject
    private WildernessLinesOverlay(WildernessLinesPlugin plugin, WildernessLinesConfig config, Client client) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        boolean inWilderness;
        boolean bl = inWilderness = this.client.getVarbitValue(5963) == 1;
        if (!inWilderness && this.config.onlyShowInWilderness()) {
            return null;
        }
        if (this.config.showSpearLines()) {
            this.renderPath(graphics, this.plugin.getSpearLinesToDisplay(), this.config.spearLinesColor());
        }
        this.renderPath(graphics, this.plugin.getMultiLinesToDisplay(), this.config.multiLinesColor());
        if (this.config.show20Line()) {
            this.renderPath(graphics, this.plugin.get20LineToDisplay(), this.config.twentyLineColor());
        }
        if (this.config.show30Line()) {
            this.renderPath(graphics, this.plugin.get30LineToDisplay(), this.config.thirtyLineColor());
        }
        return null;
    }

    private void renderPath(Graphics2D graphics, GeneralPath path, Color color) {
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(1.0f));
        path = Geometry.filterPath((GeneralPath)path, (p1, p2) -> Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint((int)p1[0], (int)p1[1]), (int)this.client.getPlane()) != null && Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint((int)p2[0], (int)p2[1]), (int)this.client.getPlane()) != null);
        path = Geometry.transformPath((GeneralPath)path, coords -> {
            Point point = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint((int)coords[0], (int)coords[1]), (int)this.client.getPlane());
            coords[0] = point.getX();
            coords[1] = point.getY();
        });
        graphics.draw(path);
    }
}

