/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.detachedcamera;

import com.google.inject.Provides;
import info.sigterm.plugins.detachedcamera.DetachedCameraConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Detached Camera", description="Allows free roaming the camera", enabledByDefault=false)
public class DetachedCameraPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DetachedCameraPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DetachedCameraConfig config;
    @Inject
    private KeyManager keyManager;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.detachedCameraHotkey()){

        public void hotkeyPressed() {
            boolean cameraDetached;
            boolean bl = cameraDetached = DetachedCameraPlugin.this.client.getOculusOrbState() == 1;
            if (cameraDetached) {
                DetachedCameraPlugin.this.attachCamera();
            } else {
                DetachedCameraPlugin.this.detachCamera();
            }
        }
    };

    protected void startUp() {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.detachCamera();
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.attachCamera();
    }

    private void detachCamera() {
        this.client.setOculusOrbState(1);
        this.client.setOculusOrbNormalSpeed(36);
    }

    private void attachCamera() {
        this.client.setOculusOrbState(0);
        this.client.setOculusOrbNormalSpeed(12);
    }

    @Provides
    DetachedCameraConfig provideConfig(ConfigManager configManager) {
        return (DetachedCameraConfig)configManager.getConfig(DetachedCameraConfig.class);
    }
}

