/*
 * Decompiled with CFR 0.152.
 */
package com.playercoder1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class SwampOverlay
extends Overlay {
    private final Client client;
    private final Set<Tile> tilesToMark = new HashSet<Tile>();

    @Inject
    SwampOverlay(Client client) {
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public void addTileToMark(Tile tile) {
        this.tilesToMark.add(tile);
    }

    public void removeTileToMark(Tile tile) {
        this.tilesToMark.remove(tile);
    }

    public void clearAllTiles() {
        this.tilesToMark.clear();
    }

    public Dimension render(Graphics2D graphics) {
        for (Tile tile : this.tilesToMark) {
            Polygon polygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)tile.getLocalLocation());
            if (polygon == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)Color.RED);
        }
        return null;
    }
}

