/*
 * Decompiled with CFR 0.152.
 */
package hjdarnel.emojipalette;

import hjdarnel.emojipalette.EmojiPalettePlugin;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmojiPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(EmojiPanel.class);

    EmojiPanel() {
    }

    void init() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setBorder((Border)new EmptyBorder(10, 25, 10, 25));
        errorPanel.setContent("Emoji Palette", "Hover over an emoji to view the text trigger");
        this.add((Component)errorPanel, "North");
        JPanel emojiPanel = new JPanel();
        emojiPanel.setLayout(new GridLayout(0, 7));
        emojiPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        emojiPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        Class<?> emojisClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("net.runelite.client.plugins.emojis.Emoji");
        Method valuesMethod = emojisClass.getDeclaredMethod("values", new Class[0]);
        valuesMethod.setAccessible(true);
        Field triggerField = emojisClass.getDeclaredField("trigger");
        triggerField.setAccessible(true);
        Method loadImageMethod = emojisClass.getDeclaredMethod("loadImage", new Class[0]);
        loadImageMethod.setAccessible(true);
        for (Enum emoji : (Enum[])valuesMethod.invoke(null, new Object[0])) {
            JPanel panel = this.makeEmojiPanel(emoji, triggerField, loadImageMethod);
            emojiPanel.add(panel);
        }
        this.add(emojiPanel);
    }

    private JPanel makeEmojiPanel(Enum<?> emoji, Field triggerField, Method loadImageMethod) throws IllegalAccessException, InvocationTargetException {
        JLabel label = new JLabel();
        label.setToolTipText(EmojiPalettePlugin.unescapeTags((String)triggerField.get(emoji)));
        label.setIcon(new ImageIcon((Image)loadImageMethod.invoke(emoji, new Object[0])));
        JPanel emojiPanel = new JPanel();
        emojiPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        emojiPanel.setBorder(new EmptyBorder(2, 0, 2, 0));
        emojiPanel.add(label);
        return emojiPanel;
    }
}

