/*
 * Decompiled with CFR 0.152.
 */
package hjdarnel.emojipalette;

import hjdarnel.emojipalette.EmojiPanel;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Emoji Palette")
public class EmojiPalettePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EmojiPalettePlugin.class);
    @Inject
    private ClientToolbar clientToolbar;
    private EmojiPanel emojiPanel;
    private NavigationButton navButton;
    private static final Pattern TAG_REGEXP = Pattern.compile("<[^>]*>");

    protected void startUp() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        this.createEmojiPanel();
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    private void createEmojiPanel() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        this.emojiPanel = (EmojiPanel)((Object)this.injector.getInstance(EmojiPanel.class));
        this.emojiPanel.init();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.navButton = NavigationButton.builder().tooltip("Emoji Picker").icon(icon).priority(10).panel((PluginPanel)this.emojiPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    public static String unescapeTags(String str) {
        StringBuffer out = new StringBuffer();
        Matcher matcher = TAG_REGEXP.matcher(str);
        block10: while (matcher.find()) {
            String match;
            matcher.appendReplacement(out, "");
            switch (match = matcher.group(0)) {
                case "<lt>": {
                    out.append("<");
                    continue block10;
                }
                case "<gt>": {
                    out.append(">");
                    continue block10;
                }
                case "<br>": {
                    out.append("\n");
                    continue block10;
                }
            }
            out.append(match);
        }
        matcher.appendTail(out);
        return out.toString();
    }
}

