/*
 * Decompiled with CFR 0.152.
 */
package com.TrayIndicators;

import com.TrayIndicators.Icon;
import com.TrayIndicators.IconType;
import com.TrayIndicators.TrayIndicatorsConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tray Indicators", description="Displays your hitpoints, prayer or absorption in the system tray.", tags={"notifications"})
public class TrayIndicatorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TrayIndicatorsPlugin.class);
    private static final int[] NMZ_MAP_REGION = new int[]{9033};
    private final Map<IconType, Icon> trayIcons = new HashMap<IconType, Icon>();
    @Inject
    private Client client;
    @Inject
    private TrayIndicatorsConfig config;

    @Provides
    TrayIndicatorsConfig getConfig(ConfigManager configManager) {
        return (TrayIndicatorsConfig)configManager.getConfig(TrayIndicatorsConfig.class);
    }

    protected void startUp() throws Exception {
        if (this.trayIcons.isEmpty()) {
            for (IconType type : IconType.values()) {
                this.trayIcons.put(type, new Icon());
            }
        }
    }

    protected void shutDown() throws Exception {
        this.trayIcons.forEach((iconType, icon) -> icon.removeIcon());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateAllTrayIcons();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.updateAllTrayIcons();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("Tray Indicators")) {
            return;
        }
        this.updateAllTrayIcons();
    }

    public void updateAllTrayIcons() {
        this.trayIcons.forEach((iconType, icon) -> {
            if (this.shouldRemoveIcon((IconType)((Object)iconType))) {
                icon.removeIcon();
                return;
            }
            icon.updateIcon(iconType.getTxt(this.client), iconType.getBgColor(this.config), iconType.getTxtColor(this.config));
        });
    }

    private boolean shouldRemoveIcon(IconType iconType) {
        return this.client.getGameState() != GameState.LOGGED_IN || iconType.isActive(this.config) == false || iconType == IconType.Absorption && !this.isInNightmareZone();
    }

    private boolean isInNightmareZone() {
        return Arrays.equals(this.client.getMapRegions(), NMZ_MAP_REGION);
    }
}

