/*
 * Decompiled with CFR 0.152.
 */
package com.TrayIndicators;

import com.TrayIndicators.TrayIndicatorsConfig;
import java.awt.Color;
import net.runelite.api.Client;
import net.runelite.api.Skill;

public enum IconType {
    Health(TrayIndicatorsConfig::healthColor, TrayIndicatorsConfig::healthTxtColor, client -> Integer.toString(client.getBoostedSkillLevel(Skill.HITPOINTS)), TrayIndicatorsConfig::health),
    Prayer(TrayIndicatorsConfig::prayerColor, TrayIndicatorsConfig::prayerTxtColor, client -> Integer.toString(client.getBoostedSkillLevel(Skill.PRAYER)), TrayIndicatorsConfig::prayer),
    Absorption(TrayIndicatorsConfig::absorptionColor, TrayIndicatorsConfig::absorptionTxtColor, client -> Integer.toString(client.getVarbitValue(3956)), TrayIndicatorsConfig::absorption);

    private final ColorSupplier bgColorSupplier;
    private final ColorSupplier txtColorSupplier;
    private final TextSupplier textSupplier;
    private final VisibilitySupplier visibilitySupplier;

    public Color getBgColor(TrayIndicatorsConfig config) {
        return this.bgColorSupplier.getColor(config);
    }

    public Color getTxtColor(TrayIndicatorsConfig config) {
        return this.txtColorSupplier.getColor(config);
    }

    public String getTxt(Client client) {
        return this.textSupplier.getText(client);
    }

    public Boolean isActive(TrayIndicatorsConfig config) {
        return this.visibilitySupplier.isActive(config);
    }

    public ColorSupplier getBgColorSupplier() {
        return this.bgColorSupplier;
    }

    public ColorSupplier getTxtColorSupplier() {
        return this.txtColorSupplier;
    }

    public TextSupplier getTextSupplier() {
        return this.textSupplier;
    }

    public VisibilitySupplier getVisibilitySupplier() {
        return this.visibilitySupplier;
    }

    private IconType(ColorSupplier bgColorSupplier, ColorSupplier txtColorSupplier, TextSupplier textSupplier, VisibilitySupplier visibilitySupplier) {
        this.bgColorSupplier = bgColorSupplier;
        this.txtColorSupplier = txtColorSupplier;
        this.textSupplier = textSupplier;
        this.visibilitySupplier = visibilitySupplier;
    }

    private static interface VisibilitySupplier {
        public Boolean isActive(TrayIndicatorsConfig var1);
    }

    private static interface TextSupplier {
        public String getText(Client var1);
    }

    private static interface ColorSupplier {
        public Color getColor(TrayIndicatorsConfig var1);
    }
}

