/*
 * Decompiled with CFR 0.152.
 */
package com.TrayIndicators;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Icon {
    private static final Logger log = LoggerFactory.getLogger(Icon.class);
    private TrayIcon trayIcon;

    public Icon() {
        if (!SystemTray.isSupported()) {
            log.error("System tray is not supported");
        }
    }

    private void createIcon(String text, Color bgColor, Color txtColor) {
        if (this.trayIcon != null) {
            this.removeIcon();
        }
        this.trayIcon = new TrayIcon(this.createImage(text, bgColor, txtColor));
        this.trayIcon.setImageAutoSize(true);
        try {
            SystemTray.getSystemTray().add(this.trayIcon);
        }
        catch (AWTException ex) {
            log.error("Unable to add system tray icon.", (Throwable)ex);
        }
    }

    public void updateIcon(String text, Color bgColor, Color txtColor) {
        if (this.trayIcon == null) {
            this.createIcon(text, bgColor, txtColor);
            return;
        }
        this.trayIcon.getImage().flush();
        this.trayIcon.setImage(this.createImage(text, bgColor, txtColor));
    }

    public void removeIcon() {
        if (this.trayIcon == null) {
            return;
        }
        SystemTray.getSystemTray().remove(this.trayIcon);
        this.trayIcon = null;
    }

    private BufferedImage createImage(String text, Color bgColor, Color txtColor) {
        int size = 16;
        BufferedImage image = new BufferedImage(size, size, 6);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(bgColor);
        graphics.fillRect(0, 0, size, size);
        graphics.setColor(txtColor);
        int fontSize = text.length() >= 4 ? 8 : (text.length() == 3 ? 9 : 12);
        graphics.setFont(new Font(graphics.getFont().getName(), 0, fontSize));
        FontMetrics metrics = graphics.getFontMetrics();
        int x = (size - metrics.stringWidth(text)) / 2;
        int y = (size - metrics.getHeight()) / 2 + metrics.getAscent();
        graphics.drawString(text, x, y);
        graphics.dispose();
        return image;
    }
}

