/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.skeldoor.MiniBarsConfig;
import com.skeldoor.MiniBarsPlugin;
import com.skeldoor.MiniBarsUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class MiniBarsSpecOverlay
extends OverlayPanel {
    @Inject
    private MiniBarsConfig config;
    @Inject
    private Client client;

    @Inject
    MiniBarsSpecOverlay(Client client, MiniBarsPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPriority(OverlayPriority.LOW);
        this.setMovable(true);
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.renderSpec()) {
            this.renderSpec();
        }
        return super.render(graphics);
    }

    void renderSpec() {
        this.setPreferredSize(new Dimension(this.config.specSize().width, 0));
        MiniBarsUtils.buildPanel(this.panelComponent, 0, 100, (float)this.client.getVarpValue(300) / 10.0f, this.config.specColour(), this.config.specSize(), this.config.totalLabels(), this.config.showLabels());
    }
}

