/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor;

import com.skeldoor.MiniBarsConfig;
import com.skeldoor.MiniBarsPlugin;
import com.skeldoor.MiniBarsUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class MiniBarsHealthOverlay
extends OverlayPanel {
    @Inject
    private Client client;
    @Inject
    private MiniBarsConfig config;

    @Inject
    MiniBarsHealthOverlay(Client client, MiniBarsPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPriority(OverlayPriority.LOW);
        this.setMovable(true);
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.renderHealth()) {
            this.renderHealth();
        }
        return super.render(graphics);
    }

    void renderHealth() {
        this.setPreferredSize(new Dimension(this.config.healthSize().width, 0));
        MiniBarsUtils.buildPanel(this.panelComponent, 0, this.client.getRealSkillLevel(Skill.HITPOINTS), this.client.getBoostedSkillLevel(Skill.HITPOINTS), this.config.healthColour(), this.config.healthSize(), this.config.totalLabels(), this.config.showLabels());
    }
}

